#!/usr/bin/env node
"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
/*********************************************************************
 * Copyright (c) 2023 Renesas Electronics Corporation and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
const logger_1 = require("@vscode/debugadapter/lib/logger");
const GDBBackend_1 = require("../../../GDBBackend");
const GDBTargetDebugSession_1 = require("../../../GDBTargetDebugSession");
process.on('uncaughtException', (err) => {
    logger_1.logger.error(JSON.stringify(err));
});
// Breakpoint options to override
const hardwareBreakpointTrue = process.argv.includes('--hardware-breakpoint-true');
const hardwareBreakpointFalse = process.argv.includes('--hardware-breakpoint-false');
const throwError = process.argv.includes('--throw-error');
class DynamicBreakpointOptionsGDBBackend extends GDBBackend_1.GDBBackend {
    getBreakpointOptions(_, initialOptions) {
        return __awaiter(this, void 0, void 0, function* () {
            if (throwError) {
                throw new Error('Some error message providing information that the breakpoint is not valid!');
            }
            const hardware = hardwareBreakpointTrue
                ? true
                : hardwareBreakpointFalse
                    ? false
                    : initialOptions.hardware;
            return Object.assign(Object.assign({}, initialOptions), { hardware });
        });
    }
}
class DynamicBreakpointOptionsGDBDebugSession extends GDBTargetDebugSession_1.GDBTargetDebugSession {
    constructor() {
        super(...arguments);
        this.gdb = this.createBackend();
    }
    createBackend() {
        return new DynamicBreakpointOptionsGDBBackend();
    }
}
DynamicBreakpointOptionsGDBDebugSession.run(DynamicBreakpointOptionsGDBDebugSession);
//# sourceMappingURL=dynamicBreakpointOptions.js.map