"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactTimeRangeDataWidget = void 0;
const React = __importStar(require("react"));
const signal_manager_1 = require("traceviewer-base/lib/signals/signal-manager");
const time_range_1 = require("traceviewer-base/lib/utils/time-range");
class ReactTimeRangeDataWidget extends React.Component {
    constructor(props) {
        super(props);
        this.subscribeToEvents = () => {
            (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.VIEW_RANGE_UPDATED, this.onViewRangeUpdated);
            (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.SELECTION_RANGE_UPDATED, this.onSelectionRangeUpdated);
            (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.EXPERIMENT_SELECTED, this.onExperimentSelected);
            (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.EXPERIMENT_UPDATED, this.onExperimentUpdated);
            (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.EXPERIMENT_CLOSED, this.onExperimentClosed);
        };
        this.componentWillUnmount = () => {
            (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.VIEW_RANGE_UPDATED, this.onViewRangeUpdated);
            (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.SELECTION_RANGE_UPDATED, this.onSelectionRangeUpdated);
            (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.EXPERIMENT_SELECTED, this.onExperimentSelected);
            (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.EXPERIMENT_UPDATED, this.onExperimentUpdated);
            (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.EXPERIMENT_CLOSED, this.onExperimentClosed);
        };
        this.onViewRangeUpdated = (payload) => {
            const { experimentUUID: UUID, timeRange } = payload;
            const update = {
                UUID,
                viewRange: timeRange
            };
            this.updateExperimentTimeRangeData(update);
        };
        this.onSelectionRangeUpdated = (payload) => {
            const { experimentUUID: UUID, timeRange } = payload;
            const update = {
                UUID,
                selectionRange: timeRange
            };
            this.updateExperimentTimeRangeData(update);
        };
        this.onAbsoluteRangeUpdate = (experiment) => {
            if (!experiment) {
                return;
            }
            const { UUID, start, end } = experiment;
            const update = {
                UUID,
                absoluteRange: {
                    start,
                    end
                }
            };
            this.updateExperimentTimeRangeData(update);
        };
        /**
         * Updates the data stored in experimentDataMap.  Works similar to setState() where
         * you only input the data to change and the existing values persist.
         * @param data Partial data of Experiment Time Range Data.
         */
        this.updateExperimentTimeRangeData = (data) => {
            var _a;
            const map = this.experimentDataMap;
            const id = data.UUID;
            const existingData = map.get(id) || {};
            const newData = Object.assign(Object.assign({}, existingData), data);
            map.set(id, newData);
            // If the experiment is currently displayed, we need to render it
            if (id === ((_a = this.state.activeData) === null || _a === void 0 ? void 0 : _a.UUID)) {
                this.setState({ activeData: newData });
            }
        };
        this.onExperimentUpdated = (experiment) => {
            if (experiment) {
                this.onAbsoluteRangeUpdate(experiment);
            }
        };
        this.onExperimentSelected = (experiment) => {
            if (experiment) {
                this.onAbsoluteRangeUpdate(experiment);
                const newActiveData = this.experimentDataMap.get(experiment.UUID);
                this.setState({ activeData: newActiveData });
            }
        };
        this.onExperimentClosed = (experiment) => {
            var _a;
            const id = experiment.UUID;
            this.experimentDataMap.delete(id);
            if (id === ((_a = this.state.activeData) === null || _a === void 0 ? void 0 : _a.UUID)) {
                this.setState({ activeData: undefined });
            }
        };
        this.reset = () => {
            this.setState({
                userInputSelectionEndIsValid: true,
                userInputSelectionStartIsValid: true,
                userInputSelectionEnd: undefined,
                userInputSelectionStart: undefined,
                inputting: false
            });
        };
        this.onChange = (event, inputIndex) => {
            event.preventDefault();
            if (!this.state.inputting) {
                this.setState({ inputting: true });
            }
            // BigInt("") => 0 but we want that to be undefined.
            const value = event.currentTarget.value === '' ? undefined : BigInt(event.currentTarget.value);
            switch (inputIndex) {
                case 0:
                    this.setState({ userInputSelectionStart: value });
                    return;
                case 1:
                    this.setState({ userInputSelectionEnd: value });
                    return;
                default:
                    throw Error('Input index is invalid!');
            }
        };
        this.onSubmit = (event) => {
            event.preventDefault();
            this.verifyUserInput();
        };
        /**
         *
         * Sometimes the unitController's selection range has a start that's larger than the end (they're reversed).
         * This always sets the lesser number as the start.
         * @param value1
         * @param value2
         * @returns { start: string, end: string }
         */
        this.getStartAndEnd = (v1, v2) => {
            var _a, _b;
            if (v1 === undefined || v2 === undefined) {
                return { start: '', end: '' };
            }
            v1 = BigInt(v1);
            v2 = BigInt(v2);
            const offset = ((_b = (_a = this.state.activeData) === null || _a === void 0 ? void 0 : _a.absoluteRange) === null || _b === void 0 ? void 0 : _b.start) || BigInt(0);
            const reverse = v1 > v2;
            const start = reverse ? v2 : v1;
            const end = reverse ? v1 : v2;
            // We display values in absolute time with the offset.
            return {
                start: (start + offset).toString(),
                end: (end + offset).toString()
            };
        };
        this.verifyUserInput = () => {
            let { activeData, userInputSelectionStart, userInputSelectionEnd } = this.state;
            // We need at least one value to change: start or end.
            const noUserInput = typeof userInputSelectionStart === 'undefined' && typeof userInputSelectionEnd === 'undefined';
            if (!activeData || noUserInput) {
                this.reset();
                return;
            }
            const { absoluteRange, selectionRange } = activeData;
            // We have to use default values for data from "activeData" because of the (TimeRange | undefined) type definition
            // but these are only to satisfy the compiler.  Most of the time these are defined.
            const offset = (absoluteRange === null || absoluteRange === void 0 ? void 0 : absoluteRange.start) || BigInt('0');
            const traceEndTime = (absoluteRange === null || absoluteRange === void 0 ? void 0 : absoluteRange.end) || BigInt('0');
            // If there is no pre-existing selection range and the user only inputs one value
            // That one value needs to be both the start and end value.
            if (!selectionRange && (!userInputSelectionEnd || !userInputSelectionStart)) {
                userInputSelectionStart = userInputSelectionStart || userInputSelectionEnd;
                userInputSelectionEnd = userInputSelectionEnd || userInputSelectionStart;
            }
            // If there is no user input for start or end, set that value to the current selectionRange value.
            const { start: currentStart, end: currentEnd } = this.getStartAndEnd(selectionRange === null || selectionRange === void 0 ? void 0 : selectionRange.start, selectionRange === null || selectionRange === void 0 ? void 0 : selectionRange.end);
            userInputSelectionStart =
                typeof userInputSelectionStart === 'bigint' ? userInputSelectionStart : BigInt(currentStart);
            userInputSelectionEnd = typeof userInputSelectionEnd === 'bigint' ? userInputSelectionEnd : BigInt(currentEnd);
            // Now we can validate
            const isValid = (n) => n >= offset && n <= traceEndTime;
            const startValid = isValid(userInputSelectionStart);
            const endValid = isValid(userInputSelectionEnd);
            if (startValid && endValid) {
                this.reset();
                const start = userInputSelectionStart - offset;
                const end = userInputSelectionEnd - offset;
                (0, signal_manager_1.signalManager)().fireRequestSelectionRangeChange({
                    experimentUUID: activeData.UUID,
                    timeRange: new time_range_1.TimeRange(start, end)
                });
            }
            else {
                this.setState({
                    userInputSelectionStartIsValid: startValid,
                    userInputSelectionEndIsValid: endValid
                });
            }
        };
        this.experimentDataMap = new Map();
        this.state = {
            inputting: false,
            userInputSelectionStartIsValid: true,
            userInputSelectionEndIsValid: true
        };
        this.subscribeToEvents();
    }
    render() {
        const { activeData, inputting, userInputSelectionStartIsValid, userInputSelectionEndIsValid, userInputSelectionStart, userInputSelectionEnd } = this.state;
        const viewRange = activeData === null || activeData === void 0 ? void 0 : activeData.viewRange;
        const selectionRange = activeData === null || activeData === void 0 ? void 0 : activeData.selectionRange;
        const sectionClassName = 'view-range-widget-section';
        const errorClassName = `${sectionClassName} invalid-input`;
        const { start: viewRangeStart, end: viewRangeEnd } = this.getStartAndEnd(viewRange === null || viewRange === void 0 ? void 0 : viewRange.start, viewRange === null || viewRange === void 0 ? void 0 : viewRange.end);
        const { start: selectionRangeStart, end: selectionRangeEnd } = this.getStartAndEnd(selectionRange === null || selectionRange === void 0 ? void 0 : selectionRange.start, selectionRange === null || selectionRange === void 0 ? void 0 : selectionRange.end);
        const startValid = inputting ? userInputSelectionStartIsValid : true;
        const endValid = inputting ? userInputSelectionEndIsValid : true;
        return (React.createElement("div", { className: "trace-explorer-item-properties" },
            React.createElement("div", { className: "trace-explorer-panel-content" },
                React.createElement("form", { onSubmit: this.onSubmit },
                    (!startValid || !endValid) && (React.createElement("div", { className: errorClassName },
                        React.createElement("label", { htmlFor: "errorMessage" },
                            React.createElement("h4", { className: "outputs-element-name" },
                                React.createElement("i", null, "Invalid Values"))))),
                    React.createElement("div", { className: sectionClassName },
                        React.createElement("label", { htmlFor: "viewRangeStart" },
                            React.createElement("h4", { className: "outputs-element-name" }, "View Range Start:"),
                            viewRangeStart)),
                    React.createElement("div", { className: sectionClassName },
                        React.createElement("label", { htmlFor: "viewRangeEnd" },
                            React.createElement("h4", { className: "outputs-element-name" }, "View Range End:"),
                            viewRangeEnd)),
                    React.createElement("div", { className: startValid ? sectionClassName : errorClassName },
                        React.createElement("label", { htmlFor: "selectionRangeStart" },
                            React.createElement("h4", { className: "outputs-element-name" }, userInputSelectionStartIsValid
                                ? 'Selection Range Start:'
                                : '* Selection Range Start:')),
                        React.createElement("input", { type: "number", value: (userInputSelectionStart === null || userInputSelectionStart === void 0 ? void 0 : userInputSelectionStart.toString()) || selectionRangeStart, onChange: e => this.onChange(e, 0) })),
                    React.createElement("div", { className: endValid ? sectionClassName : errorClassName },
                        React.createElement("label", { htmlFor: "selectionRangeEnd" },
                            React.createElement("h4", { className: "outputs-element-name" }, endValid ? 'Selection Range End:' : '* Selection Range End:')),
                        React.createElement("input", { type: "number", value: (userInputSelectionEnd === null || userInputSelectionEnd === void 0 ? void 0 : userInputSelectionEnd.toString()) || selectionRangeEnd, onChange: e => this.onChange(e, 1) })),
                    inputting && (React.createElement("div", { className: sectionClassName },
                        React.createElement("input", { className: "input-button", type: "submit", value: "Submit" }),
                        React.createElement("input", { className: "input-button", type: "button", onClick: this.reset, value: "Cancel" })))))));
    }
}
exports.ReactTimeRangeDataWidget = ReactTimeRangeDataWidget;
//# sourceMappingURL=trace-explorer-time-range-data-widget.js.map