"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeAxisComponent = void 0;
const React = __importStar(require("react"));
const time_graph_axis_1 = require("timeline-chart/lib/layer/time-graph-axis");
const time_graph_axis_cursors_1 = require("timeline-chart/lib/layer/time-graph-axis-cursors");
const timegraph_container_component_1 = require("./timegraph-container-component");
class TimeAxisComponent extends React.Component {
    render() {
        return (React.createElement(timegraph_container_component_1.ReactTimeGraphContainer, { id: "timegraph-axis", options: {
                id: 'timegraph-axis',
                width: this.props.style.width,
                height: 30,
                backgroundColor: this.props.style.chartBackgroundColor,
                lineColor: this.props.style.lineColor,
                classNames: 'horizontal-canvas'
            }, addWidgetResizeHandler: this.props.addWidgetResizeHandler, removeWidgetResizeHandler: this.props.removeWidgetResizeHandler, unitController: this.props.unitController, layers: [this.getAxisLayer(), this.getAxisCursors()] }));
    }
    getAxisLayer() {
        const timeAxisLayer = new time_graph_axis_1.TimeGraphAxis('timeGraphAxis', {
            color: this.props.style.chartBackgroundColor,
            lineColor: this.props.style.lineColor,
            verticalAlign: this.props.style.verticalAlign
        });
        return timeAxisLayer;
    }
    getAxisCursors() {
        return new time_graph_axis_cursors_1.TimeGraphAxisCursors('timeGraphAxisCursors', { color: this.props.style.cursorColor });
    }
}
exports.TimeAxisComponent = TimeAxisComponent;
//# sourceMappingURL=time-axis-component.js.map