"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateNumArray = exports.getIndexOfNode = exports.getAllExpandedNodeIds = exports.listToTree = void 0;
const entryToTreeNode = (entry, headers) => {
    // TODO Instead of padding the labels, ColumnHeader should use a getter function  instead of just assuming strings, this will allow to get the legend for XY charts
    const labels = entry.labels && entry.labels.length > 0 ? entry.labels : [''];
    // Pad the labels to match the header count
    for (let i = labels.length; i <= headers.length - 1; i++) {
        labels[i] = '';
    }
    return {
        labels: labels,
        isRoot: false,
        id: entry.id,
        parentId: entry.parentId,
        children: []
    };
};
const listToTree = (list, headers) => {
    const rootNodes = [];
    const lookup = {};
    // Fill-in the lookup table
    list.forEach(entry => {
        lookup[entry.id] = entryToTreeNode(entry, headers);
    });
    // Create the tree in the order it has been received
    list.forEach(entry => {
        const node = lookup[entry.id];
        if (entry.parentId !== undefined && entry.parentId !== -1) {
            const parent = lookup[entry.parentId];
            if (parent) {
                if (parent.id !== node.id) {
                    parent.children.push(node);
                }
            }
            else {
                // no parent available, treat is as root node
                node.isRoot = true;
                rootNodes.push(node);
            }
        }
        else {
            node.isRoot = true;
            rootNodes.push(node);
        }
    });
    return rootNodes;
};
exports.listToTree = listToTree;
const getAllExpandedNodeIds = (nodes, collapsedNodes) => {
    const visibleIds = [];
    nodes.forEach((node) => {
        visibleIds.push(node.id);
        if (node.children.length && !collapsedNodes.includes(node.id)) {
            visibleIds.push(...(0, exports.getAllExpandedNodeIds)(node.children, collapsedNodes));
        }
    });
    return visibleIds;
};
exports.getAllExpandedNodeIds = getAllExpandedNodeIds;
const getIndexOfNode = (id, nodes, collapsedNodes) => {
    const ids = (0, exports.getAllExpandedNodeIds)(nodes, collapsedNodes);
    return ids.findIndex(eId => eId === id);
};
exports.getIndexOfNode = getIndexOfNode;
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const validateNumArray = (arr) => {
    if (arr && Array.isArray(arr)) {
        return arr.length > 0 && arr.every(value => typeof value === 'number');
    }
    return false;
};
exports.validateNumArray = validateNumArray;
//# sourceMappingURL=utils.js.map