"use strict";
/***************************************************************************************
 * Copyright (c) 2023 BlackBerry Limited and contributors.
 *
 * Licensed under the MIT license. See LICENSE file in the project root for details.
 ***************************************************************************************/
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DropDownComponent = exports.DropDownOptionCheckBox = exports.DropDownOption = exports.OptionType = void 0;
const react_1 = __importDefault(require("react"));
var OptionType;
(function (OptionType) {
    OptionType[OptionType["DEFAULT"] = 0] = "DEFAULT";
    OptionType[OptionType["CHECKBOX"] = 1] = "CHECKBOX";
})(OptionType = exports.OptionType || (exports.OptionType = {}));
class AbstractDropDownOption extends react_1.default.Component {
    constructor(props) {
        super(props);
    }
}
class DropDownOption extends AbstractDropDownOption {
    constructor(props) {
        var _a, _b, _c;
        super(props);
        this.state = {
            type: OptionType.DEFAULT,
            label: props.label,
            onClick: (_a = props.onClick) !== null && _a !== void 0 ? _a : undefined,
            arg: (_b = props.arg) !== null && _b !== void 0 ? _b : undefined,
            condition: (_c = props.condition) !== null && _c !== void 0 ? _c : (() => true)
        };
    }
    render() {
        var _a, _b;
        return (react_1.default.createElement(react_1.default.Fragment, null, ((_b = (_a = this.state).condition) === null || _b === void 0 ? void 0 : _b.call(_a)) && (react_1.default.createElement("li", { className: "drop-down-list-item", onClick: () => { var _a, _b, _c, _d; return (_b = (_a = this.state).onClick) === null || _b === void 0 ? void 0 : _b.call(_a, (_d = (_c = this.state).arg) === null || _d === void 0 ? void 0 : _d.call(_c)); } },
            react_1.default.createElement("div", { className: "drop-down-list-item-text" }, this.state.label)))));
    }
}
exports.DropDownOption = DropDownOption;
class DropDownOptionCheckBox extends AbstractDropDownOption {
    constructor(props) {
        var _a, _b, _c;
        super(props);
        this.state = {
            type: OptionType.CHECKBOX,
            label: props.label,
            checked: props.checked,
            onClick: (_a = props.onClick) !== null && _a !== void 0 ? _a : undefined,
            arg: (_b = props.arg) !== null && _b !== void 0 ? _b : undefined,
            condition: (_c = props.condition) !== null && _c !== void 0 ? _c : (() => true)
        };
    }
    render() {
        var _a, _b;
        return (react_1.default.createElement(react_1.default.Fragment, null, ((_b = (_a = this.state).condition) === null || _b === void 0 ? void 0 : _b.call(_a)) && (react_1.default.createElement("li", { className: "drop-down-list-item", onClick: () => { var _a, _b, _c, _d; return (_b = (_a = this.state).onClick) === null || _b === void 0 ? void 0 : _b.call(_a, (_d = (_c = this.state).arg) === null || _d === void 0 ? void 0 : _d.call(_c)); } },
            react_1.default.createElement("div", { className: "drop-down-list-item-checkbox" },
                react_1.default.createElement("input", { type: "checkbox", checked: this.state.checked(), readOnly: true })),
            react_1.default.createElement("div", { className: "drop-down-list-item-checkbox-label" }, this.state.label)))));
    }
}
exports.DropDownOptionCheckBox = DropDownOptionCheckBox;
class DropDownComponent extends react_1.default.Component {
    constructor(props) {
        super(props);
        this.optionsMenuRef = react_1.default.createRef();
    }
    render() {
        var _a;
        return (react_1.default.createElement(react_1.default.Fragment, null, this.props.dropDownOpen && (react_1.default.createElement("div", { className: "options-menu-drop-down", ref: this.optionsMenuRef },
            react_1.default.createElement("ul", null, (_a = this.props.dropDownOptions) === null || _a === void 0 ? void 0 : _a.map((option, index) => this.renderSection(option)))))));
    }
    renderSection(option) {
        var _a, _b;
        if (option.subSection && option.subSection.options.length > 0) {
            return (react_1.default.createElement(react_1.default.Fragment, { key: option.label + '_subsection' },
                // Rendering the upper level option label
                this.renderOption(option),
                ((_b = (_a = option.subSection).condition) === null || _b === void 0 ? void 0 : _b.call(_a)) && (react_1.default.createElement("ul", { className: "drop-down-sub-section", style: { height: option.subSection.height ? option.subSection.height + 'px' : 'auto' } }, 
                // Rendering the sub section
                option.subSection.options.map(subOption => this.renderOption(subOption))))));
        }
        else {
            return this.renderOption(option);
        }
    }
    renderOption(option) {
        if (option.type === OptionType.CHECKBOX) {
            const checkboxOptions = option;
            return react_1.default.createElement(DropDownOptionCheckBox, Object.assign({}, this.props, { key: option.label }, checkboxOptions));
        }
        else {
            return react_1.default.createElement(DropDownOption, Object.assign({}, this.props, { key: option.label }, option));
        }
    }
}
exports.DropDownComponent = DropDownComponent;
//# sourceMappingURL=drop-down-component.js.map