"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbstractTreeOutputComponent = void 0;
const abstract_output_component_1 = require("./abstract-output-component");
const React = __importStar(require("react"));
const responses_1 = require("tsp-typescript-client/lib/models/response/responses");
class AbstractTreeOutputComponent extends abstract_output_component_1.AbstractOutputComponent {
    constructor(props) {
        super(props);
        this.DEFAULT_Y_AXIS_WIDTH = 40;
        this.DEFAULT_SASH_WIDTH = 4;
        this.sashDownX = -1;
        this.sashDownOffset = -1;
        this.treeRef = React.createRef();
        this.onSashDown = this.onSashDown.bind(this);
        this.onSashMove = this.onSashMove.bind(this);
        this.onSashUp = this.onSashUp.bind(this);
    }
    renderMainArea() {
        return (React.createElement(React.Fragment, null,
            this.state.showTree && (React.createElement("div", { ref: this.treeRef, className: "output-component-tree disable-select", style: { width: this.getTreeWidth(), height: this.props.style.height } }, this.renderTree())),
            React.createElement("div", { className: "output-component-y-axis", style: {
                    height: this.props.style.height,
                    backgroundColor: '#' + this.props.style.chartBackgroundColor.toString(16)
                } }, this.renderYAxis()),
            React.createElement("div", { className: "output-component-sash", onMouseDown: event => this.onSashDown(event), style: {
                    width: this.getSashWidth(),
                    height: this.props.style.height
                } }),
            React.createElement("div", { className: "output-component-chart", style: {
                    width: this.getChartWidth(),
                    height: this.props.style.height,
                    backgroundColor: '#' + this.props.style.chartBackgroundColor.toString(16)
                } }, this.renderChart())));
    }
    onSashDown(event) {
        this.sashDownX = event.clientX;
        this.sashDownOffset = this.props.style.chartOffset;
        window.addEventListener('mousemove', this.onSashMove);
        window.addEventListener('mouseup', this.onSashUp);
    }
    onSashMove(ev) {
        var _a;
        if (this.sashDownX !== -1 && ((_a = this.props) === null || _a === void 0 ? void 0 : _a.setChartOffset)) {
            const chartOffset = Math.max(this.sashDownOffset + (ev.clientX - this.sashDownX), this.getHandleWidth() + this.getYAxisWidth() + this.getSashWidth());
            this.props.setChartOffset(chartOffset);
            ev.preventDefault();
        }
    }
    onSashUp(_ev) {
        this.sashDownX = -1;
        this.sashDownOffset = -1;
        window.removeEventListener('mousemove', this.onSashMove);
        window.removeEventListener('mouseup', this.onSashUp);
    }
    async waitAnalysisCompletion() {
        let outputStatus = this.state.outputStatus;
        let factor = 1.0;
        const maxFactor = 10;
        while (this.state && outputStatus === responses_1.ResponseStatus.RUNNING) {
            outputStatus = await this.fetchTree();
            const timeout = 500 * factor;
            await new Promise(resolve => setTimeout(resolve, timeout));
            factor = factor > maxFactor ? factor : factor + 1;
        }
    }
    componentWillUnmount() {
        // fix Warning: Can't perform a React state update on an unmounted component
        this.setState = (_state, _callback) => undefined;
    }
    getYAxisWidth() {
        return this.props.style.yAxisWidth || this.DEFAULT_Y_AXIS_WIDTH;
    }
    getSashWidth() {
        return this.props.style.sashWidth || this.DEFAULT_SASH_WIDTH;
    }
    getTreeWidth() {
        // Make tree thinner when chart has a y-axis
        const yAxisWidth = this.props.outputDescriptor.type === 'TREE_TIME_XY' ? this.getYAxisWidth() : 0;
        return Math.max(0, this.props.style.chartOffset - this.getHandleWidth() - yAxisWidth - this.getSashWidth());
    }
    getChartWidth() {
        if (this.state.showTree) {
            return Math.max(0, this.props.outputWidth - this.props.style.chartOffset);
        }
        else {
            return Math.max(0, this.props.outputWidth);
        }
    }
}
exports.AbstractTreeOutputComponent = AbstractTreeOutputComponent;
//# sourceMappingURL=abstract-tree-output-component.js.map