"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FontController = void 0;
var PIXI = require("pixi.js-legacy");
var DEFAULT_FONT_SIZE = 8;
var DEFAULT_FONT_NAME = "LabelFont8White";
var DEFAULT_FONT_STYLE = {
    fontFamily: "monospace",
    fontSize: 8,
    fill: "white",
    fontWeight: "bold"
};
var FontController = /** @class */ (function () {
    function FontController(fontFamily) {
        if (fontFamily === void 0) { fontFamily = "monospace"; }
        this.fontFamily = fontFamily;
        this.fontStyleMap = new Map();
        this.fontNameMap = new Map();
        this.fontColorMap = new Map();
        this.updateFontNameMapAndFontStyleMap(DEFAULT_FONT_SIZE);
    }
    FontController.prototype.getDefaultFont = function () {
        return {
            fontName: DEFAULT_FONT_NAME,
            fontStyle: new PIXI.TextStyle(DEFAULT_FONT_STYLE)
        };
    };
    FontController.prototype.createFont = function (fontColor, fontSize) {
        var fontName = "LabelFont" + fontSize.toString() + fontColor;
        var fontStyle = {
            fontFamily: this.fontFamily,
            fontSize: fontSize,
            fill: fontColor === "White" ? "white" : "black",
            fontWeight: "bold"
        };
        PIXI.BitmapFont.from(fontName, fontStyle, { chars: this.getCharacterSet() });
        return {
            fontName: fontName,
            fontStyle: new PIXI.TextStyle(fontStyle)
        };
    };
    FontController.prototype.updateFontNameMapAndFontStyleMap = function (size) {
        var color2FontMap = new Map();
        var style2FontMap = new Map();
        var blackFont = this.createFont("Black", size);
        color2FontMap.set("black", blackFont.fontName);
        style2FontMap.set("black", blackFont.fontStyle);
        var whiteFont = this.createFont("White", size);
        color2FontMap.set("white", whiteFont.fontName);
        style2FontMap.set("white", blackFont.fontStyle);
        this.fontNameMap.set(size, color2FontMap);
        this.fontStyleMap.set(size, style2FontMap);
    };
    FontController.prototype.getFont = function (color, size) {
        var fontColor = this.fontColorMap.get(color);
        if (!fontColor) {
            var colorInHex = color.toString(16);
            var numZeros = 6 - colorInHex.length;
            for (var i = 0; i < numZeros; ++i) {
                colorInHex = "0" + colorInHex;
            }
            var result = /([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(colorInHex);
            var r = (parseInt(result ? result[1] : "ff", 16)) / 255;
            var g = (parseInt(result ? result[2] : "ff", 16)) / 255;
            var b = (parseInt(result ? result[3] : "ff", 16)) / 255;
            if ((0.2126 * Math.pow(r, 2.2) + 0.7152 * Math.pow(g, 2.2) + 0.0722 * Math.pow(b, 2.2)) <= Math.pow(0.5, 2.2)) {
                fontColor = "white";
            }
            else {
                fontColor = "black";
            }
            this.fontColorMap.set(color, fontColor);
        }
        var fontName;
        var fontStyle;
        if (size) {
            var MIN_FONT_SIZE = 6;
            size = Math.max(size, MIN_FONT_SIZE);
            if (!this.fontNameMap.has(size)) {
                this.updateFontNameMapAndFontStyleMap(size);
            }
            var size2FontMap = this.fontNameMap.get(size);
            fontName = size2FontMap ? size2FontMap.get(fontColor) : undefined;
            var size2StyleMap = this.fontStyleMap.get(size);
            fontStyle = size2StyleMap ? size2StyleMap.get(fontColor) : undefined;
        }
        return {
            fontName: fontName ? fontName : "",
            fontStyle: fontStyle
        };
    };
    FontController.prototype.getCharacterSet = function () {
        var letters = [];
        letters.push(PIXI.BitmapFont.ASCII[0]);
        letters.push(['★', '★']);
        letters.push(['…', '…']);
        return letters;
    };
    return FontController;
}());
exports.FontController = FontController;
//# sourceMappingURL=time-graph-font-controller.js.map