"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TestDataProvider = exports.TimeGraphPerformanceTestDataStubJsonImp = void 0;
var TimeGraphPerformanceTestDataStubJsonImp = /** @class */ (function () {
    function TimeGraphPerformanceTestDataStubJsonImp(data) {
        this.data = data;
        this.index = 0;
        this.currentModel = this.data[this.index];
    }
    TimeGraphPerformanceTestDataStubJsonImp.prototype.toNextStub = function () {
        if (this.index + 1 < this.data.length) {
            this.index++;
            this.currentModel = this.data[this.index];
        }
    };
    TimeGraphPerformanceTestDataStubJsonImp.prototype.getEntries = function () {
        return this.currentModel.timeGraphEntries.model.entries;
    };
    TimeGraphPerformanceTestDataStubJsonImp.prototype.getRows = function () {
        return this.currentModel.timeGraphStates.model.rows;
    };
    TimeGraphPerformanceTestDataStubJsonImp.prototype.getIds = function () {
        return this.currentModel.timeGraphRowIds.ids;
    };
    return TimeGraphPerformanceTestDataStubJsonImp;
}());
exports.TimeGraphPerformanceTestDataStubJsonImp = TimeGraphPerformanceTestDataStubJsonImp;
var TestDataProvider = /** @class */ (function () {
    function TestDataProvider(canvasDisplayWidth, dataStub) {
        var _this = this;
        this.canvasDisplayWidth = canvasDisplayWidth;
        this.dataStub = dataStub;
        this.timeGraphEntries = dataStub.getEntries();
        this.timeGraphRows = dataStub.getRows();
        this.totalLength = BigInt(0);
        this.timeGraphEntries.forEach(function (entry, rowIndex) {
            // @ts-ignore
            var row = dataStub.getRows().find(function (row) { return row.entryId === entry.id; });
            if (!_this.absoluteStart) {
                _this.absoluteStart = BigInt(entry.start);
            }
            else if (BigInt(entry.start) < _this.absoluteStart) {
                _this.absoluteStart = BigInt(entry.start);
            }
            // Calculate the total length
            if (row) {
                // @ts-ignore
                row.states.forEach(function (state, stateIndex) {
                    var end = BigInt(state.end - entry.start);
                    _this.totalLength = end > _this.totalLength ? end : _this.totalLength;
                });
            }
        });
    }
    TestDataProvider.prototype.getRowIds = function () {
        var rowIds = [];
        this.dataStub.getEntries().forEach(function (entry) {
            rowIds.push(entry.id);
        });
        return rowIds;
    };
    TestDataProvider.prototype.fetchTimeGraphData = function (opts) {
        var _this = this;
        var rows = [];
        var rangeEvents = [];
        var chartStart = this.absoluteStart;
        var rowIds = this.dataStub.getIds();
        var orderedRows = this.timeGraphRowsOrdering(rowIds);
        this.dataStub.getEntries().forEach(function (entry, rowIndex) {
            var gapStyle;
            if (!entry.style) {
                gapStyle = _this.getDefaultForGapStyle();
            }
            else {
                gapStyle = entry.style;
            }
            var states = [];
            var annotations = [];
            var row = orderedRows.find(function (row) { return row.entryId === entry.id; });
            var prevPossibleState = entry.start;
            var nextPossibleState = entry.end;
            if (row) {
                row.states.forEach(function (state, stateIndex) {
                    var end = BigInt(state.end) - chartStart;
                    states.push({
                        id: row.entryId + '-' + stateIndex,
                        label: state.label,
                        range: {
                            start: BigInt(state.start) - chartStart,
                            end: end
                        },
                        data: {
                            style: state.style
                        }
                    });
                    if (stateIndex === 0) {
                        prevPossibleState = BigInt(state.start) - chartStart;
                    }
                    if (stateIndex === row.states.length - 1) {
                        nextPossibleState = BigInt(state.end) - chartStart;
                    }
                });
                if (states.length > 0) {
                    rows.push({
                        id: entry.id,
                        name: entry.labels[0],
                        range: {
                            start: BigInt(entry.start) - chartStart,
                            end: BigInt(entry.end) - chartStart
                        },
                        states: states,
                        annotations: annotations,
                        data: {
                            type: entry.type
                        },
                        prevPossibleState: prevPossibleState,
                        nextPossibleState: nextPossibleState,
                        gapStyle: gapStyle
                    });
                }
            }
        });
        // No tests with arrows for now
        var arrows = [];
        return {
            id: "",
            arrows: arrows,
            rows: rows,
            rangeEvents: rangeEvents,
            totalLength: this.totalLength
        };
    };
    TestDataProvider.prototype.timeGraphRowsOrdering = function (orderedIds) {
        var _this = this;
        var newTimeGraphRows = [];
        orderedIds.forEach(function (id) {
            // @ts-ignore
            var timeGraphRow = _this.dataStub.getRows().find(function (row) { return row.entryId === id; });
            if (timeGraphRow) {
                var newRow = timeGraphRow;
                newTimeGraphRows.push(newRow);
            }
            else {
                var emptyRow = { states: [{ start: 0, end: 0, label: '' }], entryId: id, annotations: [] };
                newTimeGraphRows.push(emptyRow);
            }
        });
        return newTimeGraphRows;
    };
    TestDataProvider.prototype.getDefaultForGapStyle = function () {
        // Default color and height for the GAP state
        return {
            parentKey: '',
            values: {
                'background-color': '#CACACA',
                height: 1.0
            }
        };
    };
    TestDataProvider.prototype.toNextDataSet = function () {
        this.dataStub.toNextStub();
    };
    return TestDataProvider;
}());
exports.TestDataProvider = TestDataProvider;
//# sourceMappingURL=test-data-provider.js.map