"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphViewportLayer = void 0;
var time_graph_layer_1 = require("./time-graph-layer");
var bigint_utils_1 = require("../bigint-utils");
var TimeGraphViewportLayer = /** @class */ (function (_super) {
    __extends(TimeGraphViewportLayer, _super);
    function TimeGraphViewportLayer(id) {
        var _this = _super.call(this, id) || this;
        // By default, scale this layer
        _this.isScalable = true;
        /**
         * Conveniently finds the pixel relative to the worldRangeStart.  Also clamps
         * so components don't render past the world range.
         *
         * @param {bigint} time the time to get the world pixel for
         * @param {boolean} clamp if you want to clamp.  Default = false.
         * @return pixel relative to world range
         */
        _this.getWorldPixel = function (time, clamp) {
            if (!_this.unitController) {
                throw 'No unit controller to calculate world pixel.';
            }
            var _a = _this.unitController.worldRange, start = _a.start, end = _a.end;
            time = clamp ? bigint_utils_1.BIMath.clamp(time, start, end) : time;
            var diff = time - start;
            return _this.getPixel(diff);
        };
        _this.shiftStage = function () {
            if (_this.layer.position === undefined || _this.layer.position === null) {
                return;
            }
            _this.layer.position.x = _this.stateController.positionOffset.x;
        };
        _this.scaleStage = function () {
            if (!_this.isScalable || _this.layer.scale === undefined || _this.layer.scale === null) {
                return;
            }
            _this.layer.scale.x = _this.stateController.scaleFactor;
        };
        return _this;
    }
    TimeGraphViewportLayer.prototype.initializeLayer = function (canvas, stage, stateController, unitController) {
        _super.prototype.initializeLayer.call(this, canvas, stage, stateController, unitController);
        this.stateController.onPositionChanged(this.shiftStage);
        this.stateController.onScaleFactorChange(this.scaleStage);
    };
    return TimeGraphViewportLayer;
}(time_graph_layer_1.TimeGraphLayer));
exports.TimeGraphViewportLayer = TimeGraphViewportLayer;
//# sourceMappingURL=time-graph-viewport-layer.js.map