"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var time_graph_performance_test_1 = require("../unitTest/time-graph-performance-test");
var settings_1 = require("../unitTest/data/noLabels/settings");
describe('TImeGraphChart performance test without labels', function () {
    var timeGraph;
    beforeEach(function () {
        // Initiating the test
        timeGraph = new time_graph_performance_test_1.TimeGraphPerformanceTest(settings_1.NoLabelTestData.data, settings_1.NoLabelTestData.viewRange);
    });
    it('onScaleFactorChanged test', function () {
        var start = performance.now();
        // Set the view range so that the on view range handlers are triggered
        timeGraph.scaleChart(1.2); // Zoom in
        var end = performance.now();
        var time = end - start;
        console.log("onScaleFactorChanged - without labels running time", time, "ms");
        expect(time).toBeGreaterThan(0);
    });
    it('addOrUpdateRow() test', function () {
        var timeGraphChart = timeGraph.getTimeGraphChart();
        var data = timeGraph.getData();
        var start = performance.now();
        // We don't need to fetch any new data at all, the function should wipe out all existing rows
        // and rerender them.
        // @ts-ignore
        timeGraphChart.addOrUpdateRows(data);
        var end = performance.now();
        var time = end - start;
        console.log("addOrUpdateRow() - without labels running time", time, "ms");
        expect(time).toBeGreaterThan(0);
    });
});
//# sourceMappingURL=time-graph-chart-without-labels.test.js.map