"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var TraceServerConnectionStatusService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TraceServerConnectionStatusService = void 0;
/* eslint-disable @typescript-eslint/no-non-null-assertion */
const inversify_1 = require("inversify");
const rest_client_1 = require("tsp-typescript-client/lib/protocol/rest-client");
let TraceServerConnectionStatusService = TraceServerConnectionStatusService_1 = class TraceServerConnectionStatusService {
    constructor() {
        this.connectionStatusListener = (status) => {
            TraceServerConnectionStatusService_1.renderStatus(status);
        };
    }
    addConnectionStatusListener() {
        rest_client_1.RestClient.addConnectionStatusListener(this.connectionStatusListener);
    }
    removeConnectionStatusListener() {
        rest_client_1.RestClient.removeConnectionStatusListener(this.connectionStatusListener);
    }
    static renderStatus(status) {
        if (document.getElementById('server-status-id')) {
            document.getElementById('server-status-id').className = status
                ? 'fa fa-check-circle-o fa-lg'
                : 'fa fa-times-circle-o fa-lg';
            document.getElementById('server-status-id').title = status
                ? 'Server health and latency are good. No known issues'
                : 'Trace Viewer Critical Error: Trace Server Offline';
            document.getElementById('server-status-id').style.color = status ? 'green' : 'red';
        }
    }
};
TraceServerConnectionStatusService = TraceServerConnectionStatusService_1 = __decorate([
    (0, inversify_1.injectable)(),
    __metadata("design:paramtypes", [])
], TraceServerConnectionStatusService);
exports.TraceServerConnectionStatusService = TraceServerConnectionStatusService;
//# sourceMappingURL=trace-server-status.js.map