"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFileNamesMessage = exports.IFileDialogService = exports.IDialogService = void 0;
const resources_1 = require("../../../base/common/resources");
const nls_1 = require("../../../nls");
const instantiation_1 = require("../../instantiation/common/instantiation");
exports.IDialogService = (0, instantiation_1.createDecorator)('dialogService');
exports.IFileDialogService = (0, instantiation_1.createDecorator)('fileDialogService');
const MAX_CONFIRM_FILES = 10;
function getFileNamesMessage(fileNamesOrResources) {
    const message = [];
    message.push(...fileNamesOrResources.slice(0, MAX_CONFIRM_FILES).map(fileNameOrResource => typeof fileNameOrResource === 'string' ? fileNameOrResource : (0, resources_1.basename)(fileNameOrResource)));
    if (fileNamesOrResources.length > MAX_CONFIRM_FILES) {
        if (fileNamesOrResources.length - MAX_CONFIRM_FILES === 1) {
            message.push((0, nls_1.localize)('moreFile', "...1 additional file not shown"));
        }
        else {
            message.push((0, nls_1.localize)('moreFiles', "...{0} additional files not shown", fileNamesOrResources.length - MAX_CONFIRM_FILES));
        }
    }
    message.push('');
    return message.join('\n');
}
exports.getFileNamesMessage = getFileNamesMessage;
//# sourceMappingURL=dialogs.js.map