"use strict";
/********************************************************************************
 * Copyright (C) 2022 STMicroelectronics and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExampleGeneratorCommandContribution = exports.GenerateExampleCommandHandler = exports.GenerateExampleCommand = void 0;
const browser_1 = require("@eclipse-cdt-cloud/blueprint-example-generator/lib/browser");
const core_1 = require("@theia/core");
const browser_2 = require("@theia/core/lib/browser");
const browser_3 = require("@theia/editor/lib/browser");
const file_service_1 = require("@theia/filesystem/lib/browser/file-service");
const navigator_contribution_1 = require("@theia/navigator/lib/browser/navigator-contribution");
const workspace_service_1 = require("@theia/workspace/lib/browser/workspace-service");
const inversify_1 = require("inversify");
exports.GenerateExampleCommand = {
    id: 'eclipse-cdt-cloud.example-generator.generate-example',
    label: 'Generate CDT Cloud Blueprint Example'
};
let GenerateExampleCommandHandler = class GenerateExampleCommandHandler {
    async execute(...args) {
        const example = await this.selectExample(args);
        if (!example) {
            return;
        }
        const workspaceFolder = await this.getWorkspaceRoot();
        if (!workspaceFolder) {
            this.messageService.error('Cannot resolve workspace root, please open a workspace');
            return;
        }
        const targetFolder = await this.specifyTargetFolder(example, workspaceFolder);
        if (!targetFolder) {
            return;
        }
        const targetFolderName = targetFolder.path.name;
        if (await this.validateFolderName(targetFolderName, workspaceFolder)) {
            throw new Error('Target folder is invalid, probably it already exists.');
        }
        const progress = await this.messageService.showProgress({
            text: `Generating example ${example.label} to ${targetFolderName}`
        });
        try {
            await this.exampleGeneratorService.generateExample(example, targetFolder.toString(), targetFolderName);
            await this.refreshAndReveal(targetFolder);
            if (example.welcomeFile) {
                const fileUri = targetFolder.resolve(example.welcomeFile);
                await this.editorManager.open(fileUri);
            }
        }
        catch (error) {
            console.error('Uncaught Exception: ', error.toString());
        }
        finally {
            progress.cancel();
        }
    }
    async selectExample(args) {
        if (args.length < 1 || typeof args[0] !== 'string') {
            return this.askUserToChooseExample();
        }
        const examples = await this.exampleGeneratorService.getExamples();
        const matchedExample = examples.filter((e) => args[0] === e.id);
        if (matchedExample.length > 0) {
            return matchedExample[0];
        }
        return undefined;
    }
    async askUserToChooseExample() {
        const examples = await this.exampleGeneratorService.getExamples();
        const items = examples.map((e) => ({ label: e.label, value: e }));
        const selection = await this.quickPickService.show(items, {
            placeholder: 'Select type of example to generate'
        });
        return selection === null || selection === void 0 ? void 0 : selection.value;
    }
    async getWorkspaceRoot() {
        const workspaceRoot = await this.selectWorkspaceRoot();
        if (!workspaceRoot) {
            return;
        }
        return workspaceRoot;
    }
    async selectWorkspaceRoot() {
        const workspaceRoots = this.workspaceService.tryGetRoots();
        if (workspaceRoots.length === 0) {
            return;
        }
        if (workspaceRoots.length === 1) {
            return workspaceRoots[0].resource;
        }
        const items = [];
        for (const workspaceRoot of workspaceRoots) {
            items.push({
                label: this.labelProvider.getName(workspaceRoot.resource),
                description: this.labelProvider.getLongName(workspaceRoot.resource),
                value: workspaceRoot.resource
            });
        }
        const root = await this.quickPickService.show(items, {
            placeholder: core_1.nls.localize('theia/debug/addConfigurationPlaceholder', 'Select workspace root to add example to')
        });
        return root === null || root === void 0 ? void 0 : root.value;
    }
    async refreshAndReveal(fileUri) {
        await this.commandService.executeCommand(navigator_contribution_1.FileNavigatorCommands.REFRESH_NAVIGATOR.id);
        await this.commandService.executeCommand(navigator_contribution_1.FileNavigatorCommands.REVEAL_IN_NAVIGATOR.id, fileUri);
    }
    async specifyTargetFolder(example, workspaceFolder) {
        var _a;
        const targetFolder = (_a = await this.quickInputService.input({
            placeHolder: example.id,
            value: example.id,
            prompt: 'Specify the name of the target folder',
            validateInput: input => this.validateFolderName(input, workspaceFolder)
        })) !== null && _a !== void 0 ? _a : '';
        return workspaceFolder.resolve(targetFolder.length > 0 ? targetFolder : example.id);
    }
    async validateFolderName(input, workspaceFolder) {
        const inputIsNotEmpty = input.length !== 0;
        const validFolderNameRegExp = /^[^\s^\x00-\x1f\\?*:"";<>|\/.][^\x00-\x1f\\?*:"";<>|\/]*[^\s^\x00-\x1f\\?*:"";<>|\/.]+$/;
        if (inputIsNotEmpty && !validFolderNameRegExp.test(input)) {
            return {
                content: 'Invalid folder name',
                severity: 3 // Error
            };
        }
        if (inputIsNotEmpty && await this.fileService.exists(workspaceFolder.resolve(input))) {
            return {
                content: 'Folder already exists',
                severity: 3 // Error
            };
        }
        return undefined;
    }
};
__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    __metadata("design:type", workspace_service_1.WorkspaceService)
], GenerateExampleCommandHandler.prototype, "workspaceService", void 0);
__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], GenerateExampleCommandHandler.prototype, "fileService", void 0);
__decorate([
    (0, inversify_1.inject)(browser_2.LabelProvider),
    __metadata("design:type", browser_2.LabelProvider)
], GenerateExampleCommandHandler.prototype, "labelProvider", void 0);
__decorate([
    (0, inversify_1.inject)(browser_2.QuickPickService),
    __metadata("design:type", Object)
], GenerateExampleCommandHandler.prototype, "quickPickService", void 0);
__decorate([
    (0, inversify_1.inject)(browser_2.QuickInputService),
    __metadata("design:type", Object)
], GenerateExampleCommandHandler.prototype, "quickInputService", void 0);
__decorate([
    (0, inversify_1.inject)(core_1.MessageService),
    __metadata("design:type", core_1.MessageService)
], GenerateExampleCommandHandler.prototype, "messageService", void 0);
__decorate([
    (0, inversify_1.inject)(browser_1.ExampleGeneratorService),
    __metadata("design:type", Object)
], GenerateExampleCommandHandler.prototype, "exampleGeneratorService", void 0);
__decorate([
    (0, inversify_1.inject)(browser_3.EditorManager),
    __metadata("design:type", browser_3.EditorManager)
], GenerateExampleCommandHandler.prototype, "editorManager", void 0);
__decorate([
    (0, inversify_1.inject)(core_1.CommandService),
    __metadata("design:type", Object)
], GenerateExampleCommandHandler.prototype, "commandService", void 0);
GenerateExampleCommandHandler = __decorate([
    (0, inversify_1.injectable)()
], GenerateExampleCommandHandler);
exports.GenerateExampleCommandHandler = GenerateExampleCommandHandler;
let ExampleGeneratorCommandContribution = class ExampleGeneratorCommandContribution {
    registerCommands(commands) {
        commands.registerCommand(exports.GenerateExampleCommand, this.generateExampleCommandHandler);
    }
};
__decorate([
    (0, inversify_1.inject)(GenerateExampleCommandHandler),
    __metadata("design:type", GenerateExampleCommandHandler)
], ExampleGeneratorCommandContribution.prototype, "generateExampleCommandHandler", void 0);
ExampleGeneratorCommandContribution = __decorate([
    (0, inversify_1.injectable)()
], ExampleGeneratorCommandContribution);
exports.ExampleGeneratorCommandContribution = ExampleGeneratorCommandContribution;
//# sourceMappingURL=blueprint-examples-frontend-contribution.js.map