"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TableRow = void 0;
const React = __importStar(require("react"));
const table_cell_1 = require("./table-cell");
const checkbox_component_1 = require("./checkbox-component");
const icons_1 = __importDefault(require("./icons"));
class TableRow extends React.Component {
    constructor(props) {
        super(props);
        this.isCollapsed = () => this.props.collapsedNodes.includes(this.props.node.id);
        this.handleCollapse = () => {
            this.props.onToggleCollapse(this.props.node.id);
        };
        this.handleClose = () => {
            this.props.onClose(this.props.node.id);
        };
        this.renderToggleCollapse = () => {
            const width = (this.props.level + 1) * 12;
            return ((this.props.node.children.length === 0)
                ? React.createElement("div", { style: { width, paddingRight: 5, display: 'inline-block' } })
                : React.createElement("div", { style: { width, paddingRight: 5, textAlign: 'right', display: 'inline-block' }, onClick: this.handleCollapse }, (this.isCollapsed() ? icons_1.default.expand : icons_1.default.collapse)));
        };
        this.renderCheckbox = () => {
            const checkedStatus = this.props.getCheckedStatus(this.props.node.id);
            return this.props.isCheckable
                ? React.createElement(checkbox_component_1.CheckboxComponent, { key: this.props.node.id, id: this.props.node.id, checkedStatus: checkedStatus, onToggleCheck: this.props.onToggleCheck })
                : undefined;
        };
        this.renderCloseButton = () => (this.props.isClosable && this.props.node.id)
            ? React.createElement("div", { style: { paddingRight: 5, display: 'inline' }, onClick: this.handleClose }, icons_1.default.close)
            : undefined;
        this.renderRow = () => {
            const { node } = this.props;
            const row = node.labels.map((_label, index) => React.createElement(table_cell_1.TableCell, { key: node.id + '-' + index, index: index, node: node },
                (index === 0) ? this.renderToggleCollapse() : undefined,
                (index === 0) ? this.renderCheckbox() : undefined,
                (index === 0) ? this.renderCloseButton() : undefined));
            row.push(React.createElement("td", { key: node.id + '-filler', className: 'filler' }));
            return row;
        };
        this.renderChildren = () => {
            if (this.props.node.children.length && !this.isCollapsed()) {
                return this.props.node.children.map((child) => React.createElement(TableRow, Object.assign({}, this.props, { key: child.id, node: child, level: this.props.level + 1 })));
            }
            return undefined;
        };
        this.onClick = () => {
            const { node, onRowClick } = this.props;
            if (onRowClick) {
                onRowClick(node.id);
            }
        };
        this.onContextMenu = (event) => {
            const { node, onContextMenu } = this.props;
            if (onContextMenu) {
                onContextMenu(event, node.id);
            }
        };
    }
    render() {
        if (!this.props.node) {
            return undefined;
        }
        const children = this.renderChildren();
        const { node, selectedRow } = this.props;
        const className = selectedRow === node.id ? 'selected' : '';
        return (React.createElement(React.Fragment, null,
            React.createElement("tr", { className: className, onClick: this.onClick, onContextMenu: this.onContextMenu }, this.renderRow()),
            children));
    }
}
exports.TableRow = TableRow;
//# sourceMappingURL=table-row.js.map