"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphChart = exports.keyBoardNavs = void 0;
var time_graph_annotation_1 = require("../components/time-graph-annotation");
var time_graph_rectangle_1 = require("../components/time-graph-rectangle");
var time_graph_row_1 = require("../components/time-graph-row");
var time_graph_state_1 = require("../components/time-graph-state");
var time_graph_chart_layer_1 = require("./time-graph-chart-layer");
var bigint_utils_1 = require("../bigint-utils");
var lodash_1 = require("lodash");
exports.keyBoardNavs = {
    "zoomin": ['w', 'i'],
    "zoomout": ['s', 'k'],
    "panleft": ['a', 'j'],
    "panright": ['d', 'l']
};
var VISIBLE_ROW_BUFFER = 3; // number of buffer rows above and below visible range
var FINE_RESOLUTION_FACTOR = 1; // fine resolution factor or default to disable coarse update
var TimeGraphChart = /** @class */ (function (_super) {
    __extends(TimeGraphChart, _super);
    function TimeGraphChart(id, providers, rowController, _coarseResolutionFactor) {
        if (_coarseResolutionFactor === void 0) { _coarseResolutionFactor = FINE_RESOLUTION_FACTOR; }
        var _this = _super.call(this, id, rowController) || this;
        _this.providers = providers;
        _this.rowController = rowController;
        _this._coarseResolutionFactor = _coarseResolutionFactor;
        _this.rowComponents = new Map(); // map of rowId to row component
        _this.selectedStateChangedHandler = [];
        _this.mousePanning = false;
        _this.mouseZooming = false;
        _this.mouseButtons = 0;
        _this._debouncedMaybeFetchNewData = (0, lodash_1.debounce)(function () { return _this.maybeFetchNewData(false); }, 400);
        _this._debouncedMaybeFetchNewDataFine = (0, lodash_1.debounce)(function () { return _this.maybeFetchNewData(false, true); }, 400);
        // Keep track of the most recently clicked point.
        // If clicked again during _multiClickTime duration (milliseconds) record multi-click
        _this._recentlyClickedGlobal = null;
        _this._multiClickTime = 500;
        _this._mouseClicks = 0;
        /**
         * Ensures that we always see the row lines.
         * This is a hacky solution that triggers every view range change.
         */
        _this.ensureRowLinesFitViewWidth = function () {
            _this.rowComponents.forEach(function (rowComponent) {
                rowComponent.update({
                    height: _this.rowController.rowHeight,
                    position: {
                        x: -_this.stateController.positionOffset.x,
                        y: rowComponent.position.y
                    },
                    width: _this.stateController.canvasDisplayWidth,
                });
            });
        };
        _this.isNavigating = false;
        return _this;
    }
    TimeGraphChart.prototype.adjustZoom = function (zoomPosition, hasZoomedIn) {
        if (this.unitController.viewRangeLength <= 0) {
            return;
        }
        if (zoomPosition === undefined) {
            var start_1 = this.getWorldPixel(this.unitController.selectionRange ? this.unitController.selectionRange.start : BigInt(0));
            var end_1 = this.getWorldPixel(this.unitController.selectionRange ? this.unitController.selectionRange.end : this.unitController.worldRangeLength);
            zoomPosition = (start_1 + end_1) / 2;
        }
        var zoomTime = zoomPosition / this.stateController.zoomFactor;
        var zoomMagnitude = hasZoomedIn ? 0.8 : 1.25;
        var newViewRangeLength = bigint_utils_1.BIMath.clamp(Number(this.unitController.viewRangeLength) * zoomMagnitude, BigInt(2), this.unitController.absoluteRange);
        var center = this.unitController.viewRange.start + bigint_utils_1.BIMath.round(zoomTime);
        var start = bigint_utils_1.BIMath.clamp(Number(center) - zoomTime * Number(newViewRangeLength) / Number(this.unitController.viewRangeLength), BigInt(0), this.unitController.absoluteRange - newViewRangeLength);
        var end = start + newViewRangeLength;
        if (start !== end) {
            this.unitController.viewRange = {
                start: start,
                end: end
            };
        }
    };
    TimeGraphChart.prototype.afterAddToContainer = function () {
        var _this = this;
        this.stage.cursor = 'default';
        var mousePositionX = 1;
        var horizontalDelta = 3;
        var triggerKeyEvent = false;
        var moveHorizontally = function (magnitude) {
            if (magnitude === 0) {
                return;
            }
            // move by at least one nanosecond
            var absOffset = bigint_utils_1.BIMath.max(1, Math.abs(magnitude / _this.stateController.zoomFactor));
            var timeOffset = magnitude > 0 ? absOffset : -absOffset;
            var start = bigint_utils_1.BIMath.clamp(_this.unitController.viewRange.start + timeOffset, BigInt(0), _this.unitController.absoluteRange - _this.unitController.viewRangeLength);
            var end = start + _this.unitController.viewRangeLength;
            _this.unitController.viewRange = {
                start: start,
                end: end
            };
        };
        var panHorizontally = function (magnitude) {
            var timeOffset = bigint_utils_1.BIMath.round(magnitude / _this.stateController.zoomFactor);
            var start = bigint_utils_1.BIMath.clamp(_this.mousePanningStart - timeOffset, BigInt(0), _this.unitController.absoluteRange - _this.unitController.viewRangeLength);
            var end = start + _this.unitController.viewRangeLength;
            _this.unitController.viewRange = {
                start: start,
                end: end
            };
        };
        var moveVertically = function (magnitude) {
            if (_this.rowController.totalHeight <= _this.stateController.canvasDisplayHeight) {
                return;
            }
            var verticalOffset = Math.max(0, _this.rowController.verticalOffset + magnitude);
            if (_this.rowController.totalHeight - verticalOffset <= _this.stateController.canvasDisplayHeight) {
                verticalOffset = _this.rowController.totalHeight - _this.stateController.canvasDisplayHeight;
            }
            _this.rowController.verticalOffset = verticalOffset;
        };
        this._mouseMoveHandler = function (event) {
            mousePositionX = event.offsetX;
        };
        this._keyDownHandler = function (event) {
            var keyPressed = event.key;
            if (triggerKeyEvent) {
                if (keyPressed === 'Control' && _this.mouseButtons === 0 && !event.shiftKey && !event.altKey) {
                    _this.stage.cursor = 'grabbing';
                }
                else if (_this.stage.cursor === 'grabbing' && !_this.mousePanning &&
                    (keyPressed === 'Shift' || keyPressed === 'Alt')) {
                    _this.stage.cursor = 'default';
                }
                if (exports.keyBoardNavs['zoomin'].indexOf(keyPressed) >= 0) {
                    _this.adjustZoom(mousePositionX, true);
                }
                else if (exports.keyBoardNavs['zoomout'].indexOf(keyPressed) >= 0) {
                    _this.adjustZoom(mousePositionX, false);
                }
                else if (exports.keyBoardNavs['panleft'].indexOf(keyPressed) >= 0) {
                    moveHorizontally(-horizontalDelta);
                }
                else if (exports.keyBoardNavs['panright'].indexOf(keyPressed) >= 0) {
                    moveHorizontally(horizontalDelta);
                }
                else if (keyPressed === 'ArrowUp') {
                    _this.navigateUp();
                }
                else if (keyPressed === 'ArrowDown') {
                    _this.navigateDown();
                }
                event.preventDefault();
            }
            if (keyPressed === 'Escape' && _this.mouseZooming) {
                _this.mouseZooming = false;
                _this.stage.cursor = 'default';
                _this.updateZoomingSelection();
            }
        };
        this._keyUpHandler = function (event) {
            var keyPressed = event.key;
            if (triggerKeyEvent) {
                if (_this.stage.cursor === 'grabbing' && !_this.mousePanning && keyPressed === 'Control') {
                    _this.stage.cursor = 'default';
                }
            }
        };
        this.stage.addListener('mouseover', function (event) {
            triggerKeyEvent = true;
        });
        this.stage.addListener('mouseout', function (event) {
            triggerKeyEvent = false;
            if (_this.stage.cursor === 'grabbing' && !_this.mousePanning) {
                _this.stage.cursor = 'default';
            }
        });
        this._stageMouseDownHandler = function (event) {
            _this.mouseButtons = event.data.buttons;
            // if only middle button or only Ctrl+left button is pressed
            if ((event.data.button !== 1 || event.data.buttons !== 4) &&
                (event.data.button !== 0 || event.data.buttons !== 1 ||
                    !event.data.originalEvent.ctrlKey ||
                    event.data.originalEvent.shiftKey ||
                    event.data.originalEvent.altKey ||
                    _this.stage.cursor !== 'grabbing')) {
                return;
            }
            _this.mousePanning = true;
            _this.mouseDownButton = event.data.button;
            _this.mouseStartX = event.data.global.x;
            _this.mousePanningStart = _this.unitController.viewRange.start;
            _this.stage.cursor = 'grabbing';
        };
        this.stage.on('mousedown', this._stageMouseDownHandler);
        this._stageMouseMoveHandler = function (event) {
            _this.mouseButtons = event.data.buttons;
            if (_this.mousePanning) {
                if ((_this.mouseDownButton == 1 && (_this.mouseButtons & 4) === 0) ||
                    (_this.mouseDownButton == 0 && (_this.mouseButtons & 1) === 0)) {
                    // handle missed button mouseup event
                    _this.mousePanning = false;
                    var orig = event.data.originalEvent;
                    if (!orig.ctrlKey || orig.shiftKey || orig.altKey) {
                        _this.stage.cursor = 'default';
                    }
                    return;
                }
                var horizontalDelta_1 = event.data.global.x - _this.mouseStartX;
                panHorizontally(horizontalDelta_1);
            }
            if (_this.mouseZooming) {
                _this.mouseEndX = event.data.global.x;
                _this.updateZoomingSelection();
            }
        };
        this.stage.on('mousemove', this._stageMouseMoveHandler);
        this._stageMouseUpHandler = function (event) {
            _this.mouseButtons = event.data.buttons;
            if (event.data.button === _this.mouseDownButton && _this.mousePanning) {
                _this.mousePanning = false;
                var orig = event.data.originalEvent;
                if (!orig.ctrlKey || orig.shiftKey || orig.altKey) {
                    _this.stage.cursor = 'default';
                }
            }
        };
        this.stage.on('mouseup', this._stageMouseUpHandler);
        this.stage.on('mouseupoutside', this._stageMouseUpHandler);
        this._mouseWheelHandler = function (ev) {
            if (ev.ctrlKey) {
                var hasZoomedIn = ev.deltaY < 0;
                _this.adjustZoom(ev.offsetX, hasZoomedIn);
            }
            else if (ev.shiftKey) {
                moveHorizontally(ev.deltaY);
            }
            else {
                if (Math.abs(ev.deltaY) > Math.abs(ev.deltaX)) {
                    moveVertically(ev.deltaY);
                }
                else {
                    moveHorizontally(ev.deltaX);
                }
            }
            ev.preventDefault();
        };
        this._contextMenuHandler = function (e) {
            e.preventDefault();
        };
        this._mouseDownHandler = function (e) {
            _this.mouseButtons = e.buttons;
            // if only right button is pressed
            if (e.button === 2 && e.buttons === 2 && _this.stage.cursor === 'default') {
                _this.mouseZooming = true;
                _this.mouseDownButton = e.button;
                _this.mouseStartX = e.offsetX;
                _this.mouseEndX = e.offsetX;
                _this.mouseZoomingStart = _this.unitController.viewRange.start + bigint_utils_1.BIMath.round(_this.mouseStartX / _this.stateController.zoomFactor);
                _this.stage.cursor = 'col-resize';
                // this is the only way to detect mouseup outside of right button
                document.addEventListener('mouseup', mouseUpListener);
                _this.updateZoomingSelection();
            }
        };
        var mouseUpListener = function (e) {
            _this.mouseButtons = e.buttons;
            if (e.button === _this.mouseDownButton && _this.mouseZooming) {
                _this.mouseZooming = false;
                var start = _this.mouseZoomingStart;
                var end = _this.unitController.viewRange.start + bigint_utils_1.BIMath.round(_this.mouseEndX / _this.stateController.zoomFactor);
                if (bigint_utils_1.BIMath.abs(end - start) > 1 && _this.unitController.viewRangeLength > 1) {
                    var newViewStart = bigint_utils_1.BIMath.clamp(start, _this.unitController.viewRange.start, end);
                    var newViewEnd = bigint_utils_1.BIMath.clamp(end, start, _this.unitController.viewRange.end);
                    _this.unitController.viewRange = {
                        start: newViewStart,
                        end: newViewEnd
                    };
                }
                _this.stage.cursor = 'default';
                document.removeEventListener('mouseup', mouseUpListener);
                _this.updateZoomingSelection();
            }
        };
        this.onCanvasEvent('mousemove', this._mouseMoveHandler);
        this.onCanvasEvent('keydown', this._keyDownHandler);
        this.onCanvasEvent('keyup', this._keyUpHandler);
        this.onCanvasEvent('mousedown', this._mouseDownHandler);
        this.onCanvasEvent('mousewheel', this._mouseWheelHandler);
        this.onCanvasEvent('wheel', this._mouseWheelHandler);
        this.onCanvasEvent('contextmenu', this._contextMenuHandler);
        this.rowController.onVerticalOffsetChangedHandler(function (verticalOffset) {
            _this.layer.position.y = -verticalOffset;
            _this._debouncedMaybeFetchNewData();
        });
        this._viewRangeChangedHandler = function () {
            _this.updateZoomingSelection();
            _this.ensureRowLinesFitViewWidth();
        };
        this.unitController.onViewRangeChanged(this._viewRangeChangedHandler);
        this.unitController.onViewRangeChanged(this._debouncedMaybeFetchNewData);
        /**
         * We need to explicitly re-render every zoom change because of edge case:
         *   WorldRange = Absolute Range && ViewRange < WorldRange
         * When we are at above state, and reset view to home, nothing happens.
         *   We already rendered the world and don't rerender (WorldRange doesn't change)
         *   this.maybeFetchNewData is called and we don't fetch or trigger viewport.handleOnWorldRange.
         *   This is because don't re-render the world since it's we already have the entire trace rendered.
         *   We don't currently have any logic for scaling the world down.
         * UpdatingScaleAndPosition also scales everything down nicely when zooming out :)
         * Side effect - stage.width is always reset to renderer.width when this is called.
         */
        this._zoomRangeChangedHandler = function (zoomFactor) {
            _this.updateScaleAndPosition();
            _this.ensureRowLinesFitViewWidth();
            _this.stateController.handleOnWorldRender();
        };
        this.stateController.onZoomChanged(this._zoomRangeChangedHandler);
        if (this.unitController.viewRangeLength && this.stateController.canvasDisplayWidth) {
            this.maybeFetchNewData();
        }
    };
    TimeGraphChart.prototype.updateChart = function () {
        var update = true;
        if (this.unitController && this.stateController) {
            this.maybeFetchNewData(update);
        }
    };
    TimeGraphChart.prototype.update = function () {
        this.updateScaleAndPosition();
        this._debouncedMaybeFetchNewData();
    };
    TimeGraphChart.prototype.updateZoomingSelection = function () {
        if (!this.mouseZooming && this.zoomingSelection) {
            this.removeChild(this.zoomingSelection);
            delete this.zoomingSelection;
        }
        else if (this.mouseZooming) {
            var x = this.getWorldPixel(this.mouseZoomingStart);
            var options = {
                color: 0xbbbbbb,
                opacity: 0.2,
                position: {
                    x: x,
                    y: 0
                },
                height: Math.max(this.stateController.canvasDisplayHeight, this.rowController.totalHeight),
                width: this.mouseEndX - this.mouseStartX
            };
            if (!this.zoomingSelection) {
                // Add the rectangle if we don't have one
                this.zoomingSelection = new time_graph_rectangle_1.TimeGraphRectangle(options);
                this.addChild(this.zoomingSelection);
            }
            else {
                // Update the rectangle if we do
                this.zoomingSelection.update(options);
            }
        }
    };
    TimeGraphChart.prototype.removeChildren = function () {
        this.rowComponents.clear();
        _super.prototype.removeChildren.call(this);
    };
    TimeGraphChart.prototype.destroy = function () {
        this.stateController.removeOnZoomChanged(this._zoomRangeChangedHandler);
        this.unitController.removeViewRangeChangedHandler(this._debouncedMaybeFetchNewData);
        this.unitController.removeViewRangeChangedHandler(this._viewRangeChangedHandler);
        if (this._viewRangeChangedHandler) {
            this.unitController.removeViewRangeChangedHandler(this._viewRangeChangedHandler);
        }
        if (this._mouseMoveHandler) {
            this.removeOnCanvasEvent('mousemove', this._mouseMoveHandler);
        }
        if (this._mouseDownHandler) {
            this.removeOnCanvasEvent('mousedown', this._mouseDownHandler);
        }
        if (this._keyDownHandler) {
            this.removeOnCanvasEvent('keydown', this._keyDownHandler);
        }
        if (this._keyUpHandler) {
            this.removeOnCanvasEvent('keyup', this._keyUpHandler);
        }
        if (this._mouseWheelHandler) {
            this.removeOnCanvasEvent('mousewheel', this._mouseWheelHandler);
            this.removeOnCanvasEvent('wheel', this._mouseWheelHandler);
        }
        if (this._contextMenuHandler) {
            this.removeOnCanvasEvent('contextmenu', this._contextMenuHandler);
        }
        if (this.stage) {
            this.stage.off('mousedown', this._stageMouseDownHandler);
            this.stage.off('mousemove', this._stageMouseMoveHandler);
            this.stage.off('mouseup', this._stageMouseUpHandler);
            this.stage.off('mouseupoutside', this._stageMouseUpHandler);
        }
        this.rowComponents.clear();
        _super.prototype.destroy.call(this);
    };
    TimeGraphChart.prototype.maybeFetchNewData = function (update, fine) {
        return __awaiter(this, void 0, void 0, function () {
            var visibleRowIds, viewRange, resolutionFactor, resolution, rowIds, allRowsUpdated, worldRange, request, rowData;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.rowIds = this.providers.rowProvider().rowIds;
                        if (update) {
                            // update position of existing rows and remove deleted rows
                            this.rowComponents.forEach(function (rowComponent, rowId) {
                                var index = _this.rowIds.indexOf(rowId);
                                if (index == -1) {
                                    _this.rowComponents.delete(rowId);
                                    _this.removeChild(rowComponent);
                                }
                                else {
                                    rowComponent.position.y = _this.rowController.rowHeight * index;
                                    rowComponent.providedModel = undefined;
                                }
                            });
                            // update selected row
                            if (this.rowController.selectedRow) {
                                this.rowController.selectedRowIndex = this.rowIds.indexOf(this.rowController.selectedRow.id);
                                if (this.rowController.selectedRowIndex === -1) {
                                    this.rowController.selectedRow = undefined;
                                }
                            }
                            // create placeholder rows
                            this.rowIds.forEach(function (rowId) {
                                if (!_this.rowComponents.get(rowId)) {
                                    _this.addRow(rowId);
                                }
                            });
                        }
                        visibleRowIds = this.getVisibleRowIds(VISIBLE_ROW_BUFFER);
                        viewRange = this.unitController.viewRange;
                        resolutionFactor = fine ? FINE_RESOLUTION_FACTOR : this._coarseResolutionFactor;
                        resolution = (resolutionFactor * Number(this.unitController.viewRangeLength)) / this.stateController.canvasDisplayWidth;
                        rowIds = visibleRowIds.filter(function (rowId) {
                            var rowComponent = _this.rowComponents.get(rowId);
                            return (update ||
                                !rowComponent ||
                                !rowComponent.providedModel ||
                                viewRange.start < rowComponent.providedModel.range.start || // This logic can be updated for pre-rendering before we reach the end.
                                viewRange.end > rowComponent.providedModel.range.end || // This logic can be updated for pre-rendering before we reach the end.
                                resolution < rowComponent.providedModel.resolution);
                        });
                        if (!(rowIds.length > 0)) return [3 /*break*/, 5];
                        allRowsUpdated = rowIds.length === visibleRowIds.length;
                        worldRange = allRowsUpdated ? this.unitController.updateWorldRangeFromViewRange() : this.unitController.worldRange;
                        request = { worldRange: worldRange, resolution: resolution, rowIds: rowIds };
                        if ((0, lodash_1.isEqual)(request, this.ongoingRequest)) {
                            // request ignored because equal to ongoing request
                            return [2 /*return*/];
                        }
                        this._debouncedMaybeFetchNewDataFine.cancel();
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, , 3, 4]);
                        this.ongoingRequest = request;
                        return [4 /*yield*/, this.providers.dataProvider(worldRange, resolution, rowIds)];
                    case 2:
                        rowData = _a.sent();
                        if (!(0, lodash_1.isEqual)(request, this.ongoingRequest)) {
                            // response discarded because not equal to ongoing request
                            return [2 /*return*/];
                        }
                        if (rowData) {
                            this.addOrUpdateRows(rowData);
                            if (this.isNavigating) {
                                this.selectStateInNavigation();
                            }
                            if (this.mouseZooming) {
                                if (this.zoomingSelection) {
                                    this.removeChild(this.zoomingSelection);
                                }
                                delete this.zoomingSelection;
                                this.updateZoomingSelection();
                            }
                        }
                        return [3 /*break*/, 4];
                    case 3:
                        if ((0, lodash_1.isEqual)(request, this.ongoingRequest)) {
                            this.ongoingRequest = undefined;
                        }
                        this.isNavigating = false;
                        if (!fine && this._coarseResolutionFactor !== FINE_RESOLUTION_FACTOR) {
                            this._debouncedMaybeFetchNewDataFine();
                        }
                        return [7 /*endfinally*/];
                    case 4:
                        // After we build the new world from new data, execute render handlers.
                        // Only execute after first, coarse render.  Don't need to repeat after second, fine render.
                        this.stateController.handleOnWorldRender();
                        return [3 /*break*/, 6];
                    case 5:
                        if (!fine && this._coarseResolutionFactor !== FINE_RESOLUTION_FACTOR) {
                            // no row to update for coarse resolution, try fine resolution
                            this.maybeFetchNewData(update, true);
                        }
                        _a.label = 6;
                    case 6: return [2 /*return*/];
                }
            });
        });
    };
    TimeGraphChart.prototype.updateScaleAndPosition = function () {
        var _this = this;
        this.rowComponents.forEach(function (rowComponent) {
            var row = rowComponent.model;
            if (rowComponent) {
                var opts = {
                    height: _this.rowController.rowHeight,
                    position: {
                        x: 0,
                        y: rowComponent.position.y
                    },
                    width: _this.stateController.canvasDisplayWidth
                };
                rowComponent.update(opts);
            }
            var lastX;
            var lastTime;
            var lastBlank = false;
            row === null || row === void 0 ? void 0 : row.states.forEach(function (state, elementIndex) {
                var _a;
                var el = rowComponent.getStateById(state.id);
                var start = state.range.start;
                var xStart = _this.getWorldPixel(start, true);
                if (el) {
                    var end = state.range.end;
                    var xEnd = _this.getWorldPixel(end, true);
                    var width = Math.max(1, xEnd - xStart);
                    var opts = {
                        height: el.height,
                        position: {
                            x: xStart,
                            y: el.position.y
                        },
                        width: width,
                        displayWidth: width
                    };
                    el.update(opts);
                }
                if (rowComponent && row.gapStyle) {
                    _this.updateGap(state, rowComponent, row.gapStyle, xStart, lastX, lastTime, lastBlank);
                }
                // Does clamping xEnd effect lastX calculation in some way?
                lastX = Math.max(xStart + 1, _this.getWorldPixel(state.range.end));
                lastTime = state.range.end;
                lastBlank = (((_a = state.data) === null || _a === void 0 ? void 0 : _a.style) === undefined);
            });
            row === null || row === void 0 ? void 0 : row.annotations.forEach(function (annotation, elementIndex) {
                var el = rowComponent.getAnnotationById(annotation.id);
                if (el) {
                    // only handle ticks for now
                    var start = annotation.range.start;
                    var opts = {
                        position: {
                            x: _this.getWorldPixel(start),
                            y: el.displayObject.y
                        }
                    };
                    el.update(opts);
                }
            });
        });
    };
    TimeGraphChart.prototype.handleSelectedStateChange = function () {
        var _this = this;
        this.selectedStateChangedHandler.forEach(function (handler) { return handler(_this.selectedStateModel); });
    };
    TimeGraphChart.prototype.addOrUpdateRows = function (rowData) {
        var _this = this;
        if (!this.stateController) {
            throw 'Add this TimeGraphChart to a container before adding rows.';
        }
        var providedModel = { range: rowData.range, resolution: rowData.resolution };
        rowData.rows.forEach(function (row) {
            var rowComponent = _this.rowComponents.get(row.id);
            if (rowComponent) {
                _this.removeChild(rowComponent);
            }
            _this.addRow(row.id, row, providedModel);
        });
    };
    TimeGraphChart.prototype.addRow = function (rowId, row, providedModel) {
        var _this = this;
        var id = 'row_' + rowId;
        var rowIndex = this.rowIds.indexOf(rowId);
        var rowStyle = this.providers.rowStyleProvider ? this.providers.rowStyleProvider(row) : undefined;
        var rowComponent = new time_graph_row_1.TimeGraphRow(id, {
            position: {
                x: 0,
                y: this.rowController.rowHeight * rowIndex
            },
            width: this.rowWidth,
            height: this.rowController.rowHeight
        }, rowIndex, row, rowStyle);
        rowComponent.displayObject.interactive = true;
        rowComponent.displayObject.on('click', (function (e) {
            _this.selectRow(row);
        }).bind(this));
        this.addChild(rowComponent);
        this.rowComponents.set(rowId, rowComponent);
        if (this.rowController.selectedRowIndex == rowIndex) {
            this.selectRow(row);
        }
        if (row && providedModel) {
            this.updateRow(rowComponent, row, providedModel);
        }
    };
    TimeGraphChart.prototype.updateRow = function (rowComponent, row, providedModel) {
        var _this = this;
        var lastX;
        var lastTime;
        var lastBlank = false;
        row.states.forEach(function (stateModel) {
            var _a, _b;
            var x = _this.getWorldPixel(stateModel.range.start);
            if ((_a = stateModel.data) === null || _a === void 0 ? void 0 : _a.style) {
                var el = _this.createNewState(stateModel, rowComponent);
                if (el) {
                    _this.addElementInteractions(el);
                    rowComponent.addState(el);
                }
            }
            if (row.gapStyle) {
                _this.updateGap(stateModel, rowComponent, row.gapStyle, x, lastX, lastTime, lastBlank);
            }
            lastX = Math.max(x + 1, _this.getWorldPixel(stateModel.range.end));
            lastTime = stateModel.range.end;
            lastBlank = (((_b = stateModel.data) === null || _b === void 0 ? void 0 : _b.style) === undefined);
        });
        if (this.rowController.selectedRow && this.unitController.selectionRange && this.rowController.selectedRow.id === row.id) {
            var state = row.states.find(function (state) {
                return _this.unitController.selectionRange && state.range.start <= _this.unitController.selectionRange.start && state.range.end > _this.unitController.selectionRange.start;
            });
            this.selectState(state);
        }
        row.annotations.forEach(function (annotation) {
            var el = _this.createNewAnnotation(annotation, rowComponent);
            if (el) {
                _this.addElementInteractions(el);
                rowComponent.addAnnotation(el);
            }
        });
        rowComponent.providedModel = providedModel;
    };
    TimeGraphChart.prototype.updateGap = function (state, rowComponent, gapStyle, x, lastX, lastTime, lastBlank) {
        var _a, _b, _c, _d;
        /* add gap if there is visible space between states or if there is a time gap between two blank states */
        if (lastX && lastTime && (x > lastX || (lastBlank && !((_a = state.data) === null || _a === void 0 ? void 0 : _a.style) && state.range.start > lastTime))) {
            var gap = (_b = state.data) === null || _b === void 0 ? void 0 : _b.gap;
            if (gap) {
                var width = Math.max(1, x - lastX);
                var opts = {
                    height: gap.height,
                    position: {
                        x: lastX,
                        y: gap.position.y
                    },
                    width: width,
                    displayWidth: width
                };
                gap.update(opts);
            }
            else {
                var stateModel = {
                    id: rowComponent.id + '-gap',
                    range: {
                        start: lastTime,
                        end: state.range.start
                    },
                    data: {
                        style: gapStyle
                    }
                };
                var gap_1 = this.createNewState(stateModel, rowComponent);
                if (gap_1) {
                    rowComponent.addChild(gap_1);
                    if (state.data) {
                        state.data['gap'] = gap_1;
                    }
                    this.addElementInteractions(gap_1);
                }
            }
        }
        else {
            if (state.data && ((_c = state.data) === null || _c === void 0 ? void 0 : _c.gap)) {
                rowComponent.removeChild((_d = state.data) === null || _d === void 0 ? void 0 : _d.gap);
                state.data.gap = undefined;
            }
        }
    };
    TimeGraphChart.prototype.createNewAnnotation = function (annotation, rowComponent) {
        var start = this.getWorldPixel(annotation.range.start);
        var el;
        var elementStyle = this.providers.rowAnnotationStyleProvider ? this.providers.rowAnnotationStyleProvider(annotation) : undefined;
        el = new time_graph_annotation_1.TimeGraphAnnotationComponent(annotation.id, annotation, { position: { x: start, y: rowComponent.position.y + (rowComponent.height * 0.5) } }, elementStyle, rowComponent);
        return el;
    };
    TimeGraphChart.prototype.createNewState = function (stateModel, rowComponent) {
        var xStart = this.getWorldPixel(stateModel.range.start, true);
        var xEnd = this.getWorldPixel(stateModel.range.end, true);
        var el;
        var displayWidth = xEnd - xStart;
        var elementStyle = this.providers.stateStyleProvider ? this.providers.stateStyleProvider(stateModel) : undefined;
        el = new time_graph_state_1.TimeGraphStateComponent(stateModel.id, stateModel, xStart, xEnd, rowComponent, elementStyle, displayWidth);
        return el;
    };
    TimeGraphChart.prototype.addElementInteractions = function (el) {
        var _this = this;
        el.displayObject.interactive = true;
        var self = this;
        this._multiClickTimer = (0, lodash_1.debounce)(function () {
            self._mouseClicks = 0;
            self._recentlyClickedGlobal = null;
        }, this._multiClickTime);
        el.displayObject.on('click', (function (e) {
            if (el instanceof time_graph_state_1.TimeGraphStateComponent && !_this.mousePanning && !_this.mouseZooming) {
                _this.selectState(el.model);
            }
            // Mouse clicks count keeps increasing without limit as long as we keep clicking on the same coordinate.
            if (_this._recentlyClickedGlobal && _this._recentlyClickedGlobal.equals(e.data.global)) {
                _this._mouseClicks++;
            }
            else {
                // Only clear the timer and reset the click count if the global position is NOT 
                // the same one as click 1.
                _this._multiClickTimer.cancel();
                _this._mouseClicks = 1;
                // Store the global position on first click
                _this._recentlyClickedGlobal = (0, lodash_1.cloneDeep)(e.data.global);
            }
            // We can use a debouncer to reset the count when no click occurs for a certain period.
            _this._multiClickTimer();
            // Click callback includes count parameter to record subsequent clicks on the same point
            if (_this.mouseInteractions && _this.mouseInteractions.click) {
                _this.mouseInteractions.click(el, e, _this._mouseClicks);
            }
        }).bind(this));
        el.displayObject.on('mouseover', (function (e) {
            if (_this.mouseInteractions && _this.mouseInteractions.mouseover) {
                _this.mouseInteractions.mouseover(el, e);
            }
        }).bind(this));
        el.displayObject.on('mouseout', (function (e) {
            if (_this.mouseInteractions && _this.mouseInteractions.mouseout) {
                _this.mouseInteractions.mouseout(el, e);
            }
        }).bind(this));
        el.displayObject.on('mousedown', (function (e) {
            if (_this.mouseInteractions && _this.mouseInteractions.mousedown) {
                _this.mouseInteractions.mousedown(el, e);
            }
        }).bind(this));
        el.displayObject.on('mouseup', (function (e) {
            if (_this.mouseInteractions && _this.mouseInteractions.mouseup) {
                _this.mouseInteractions.mouseup(el, e);
            }
        }).bind(this));
    };
    TimeGraphChart.prototype.updateStateStyle = function (model) {
        var style = this.providers.stateStyleProvider && this.providers.stateStyleProvider(model);
        var component = this.getStateById(model.id);
        component && style && (component.style = style);
    };
    TimeGraphChart.prototype.updateRowStyle = function (model) {
        var style = this.providers.rowStyleProvider && this.providers.rowStyleProvider(model);
        var component = this.rowComponents.get(model.id);
        component && style && (component.style = style);
    };
    TimeGraphChart.prototype.registerMouseInteractions = function (interactions) {
        this.mouseInteractions = interactions;
    };
    TimeGraphChart.prototype.onSelectedStateChanged = function (handler) {
        this.selectedStateChangedHandler.push(handler);
    };
    TimeGraphChart.prototype.getRowModel = function (index) {
        var _a;
        if (index >= this.rowIds.length) {
            return undefined;
        }
        return (_a = this.rowComponents.get(this.rowIds[index])) === null || _a === void 0 ? void 0 : _a.model;
    };
    TimeGraphChart.prototype.getStateById = function (id) {
        var e_1, _a;
        var state = undefined;
        try {
            for (var _b = __values(this.rowComponents.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var rowComponent = _c.value;
                state = rowComponent.getStateById(id);
                if (state) {
                    break;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return state;
    };
    TimeGraphChart.prototype.selectRow = function (row) {
        if (this.rowController.selectedRow) {
            delete this.rowController.selectedRow.selected;
            this.updateRowStyle(this.rowController.selectedRow);
        }
        this.rowController.selectedRow = row;
        if (row) {
            this.rowController.selectedRowIndex = this.rowIds.indexOf(row.id);
            row.selected = true;
            this.updateRowStyle(row);
        }
    };
    TimeGraphChart.prototype.getSelectedState = function () {
        return this.selectedStateModel;
    };
    TimeGraphChart.prototype.selectState = function (model) {
        if (this.selectedStateModel === model) {
            return;
        }
        if (this.selectedStateModel) {
            delete this.selectedStateModel.selected;
            this.updateStateStyle(this.selectedStateModel);
        }
        if (model) {
            var state = this.getStateById(model.id);
            if (state) {
                var row = state.row;
                if (row) {
                    state.model.selected = true;
                    this.updateStateStyle(state.model);
                    this.selectRow(row.model);
                }
            }
        }
        this.selectedStateModel = model;
        this.handleSelectedStateChange();
    };
    TimeGraphChart.prototype.setNavigationFlag = function (flag) {
        this.isNavigating = flag;
    };
    TimeGraphChart.prototype.selectAndReveal = function (rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.rowIds.length) {
            this.rowController.selectedRowIndex = rowIndex;
            this.navigate(rowIndex, true);
        }
    };
    TimeGraphChart.prototype.selectStateInNavigation = function () {
        var row = this.rowController.selectedRow;
        if (row && this.unitController.selectionRange) {
            var cursorPosition_1 = this.unitController.selectionRange.end;
            var state = row.states.find(function (stateModel) { return stateModel.range.start === cursorPosition_1 || stateModel.range.end === cursorPosition_1; });
            this.selectState(state);
        }
        this.setNavigationFlag(false);
    };
    TimeGraphChart.prototype.navigateDown = function () {
        if (this.rowIds.length > 0) {
            this.rowController.selectedRowIndex = Math.min(this.rowController.selectedRowIndex + 1, this.rowIds.length - 1);
            this.navigate(this.rowController.selectedRowIndex);
        }
    };
    TimeGraphChart.prototype.navigateUp = function () {
        if (this.rowIds.length > 0) {
            this.rowController.selectedRowIndex = Math.max(this.rowController.selectedRowIndex - 1, 0);
            this.navigate(this.rowController.selectedRowIndex);
        }
    };
    TimeGraphChart.prototype.navigate = function (rowIndex, center) {
        var _this = this;
        this.ensureVisible(rowIndex, center);
        var selectedRowId = this.rowIds[rowIndex];
        var selectedRowComponent = this.rowComponents.get(selectedRowId);
        if (!selectedRowComponent) {
            this.selectRow(undefined);
            this.selectState(undefined);
            return;
        }
        var selectedRow = selectedRowComponent.model;
        this.selectRow(selectedRow);
        var state = selectedRow === null || selectedRow === void 0 ? void 0 : selectedRow.states.find(function (state) {
            return _this.unitController.selectionRange && state.range.start <= _this.unitController.selectionRange.start && state.range.end > _this.unitController.selectionRange.start;
        });
        this.selectState(state);
    };
    TimeGraphChart.prototype.getVisibleRowIds = function (buffer) {
        var visibleRowIds = [];
        var rowHeight = this.rowController.rowHeight;
        // return all rows that intersect the visible height range with a number of buffer rows
        var minY = this.rowController.verticalOffset - buffer * rowHeight;
        var maxY = this.rowController.verticalOffset + this.stateController.canvasDisplayHeight + buffer * rowHeight;
        this.rowIds.forEach(function (rowId, index) {
            var y = rowHeight * index;
            if (y + rowHeight >= minY && y <= maxY) {
                visibleRowIds.push(rowId);
            }
        });
        return visibleRowIds;
    };
    TimeGraphChart.prototype.ensureVisible = function (rowIndex, center) {
        if (rowIndex === -1) {
            return;
        }
        if (rowIndex * this.rowController.rowHeight < this.rowController.verticalOffset) {
            center ? this.centerRow(rowIndex) : this.rowController.verticalOffset = rowIndex * this.rowController.rowHeight;
        }
        else if ((rowIndex + 1) * this.rowController.rowHeight > this.rowController.verticalOffset + this.stateController.canvasDisplayHeight) {
            center ? this.centerRow(rowIndex) : this.rowController.verticalOffset = (rowIndex + 1) * this.rowController.rowHeight - this.stateController.canvasDisplayHeight;
        }
    };
    TimeGraphChart.prototype.centerRow = function (rowIndex) {
        if (rowIndex === -1) {
            return;
        }
        var rowHeight = this.rowController.rowHeight;
        var canvasDisplayHeight = this.stateController.canvasDisplayHeight;
        var numberOfVisibleRows = Math.floor(canvasDisplayHeight / rowHeight);
        var halfVizRows = Math.floor(numberOfVisibleRows / 2);
        var numberOfRows = this.rowComponents.size;
        if (rowIndex < halfVizRows) {
            // Index too low to center.
            this.rowController.verticalOffset = 0;
        }
        else if (rowIndex > (numberOfRows - halfVizRows - 1)) {
            // Index too high to center.
            this.rowController.verticalOffset = (numberOfRows - numberOfVisibleRows) * rowHeight;
        }
        else {
            // Can be centered.
            var numberOfHiddenRows = rowIndex - halfVizRows;
            this.rowController.verticalOffset = numberOfHiddenRows * rowHeight;
        }
    };
    Object.defineProperty(TimeGraphChart.prototype, "rowWidth", {
        get: function () {
            return Number(this.unitController.worldRangeLength) * this.stateController.zoomFactor;
        },
        enumerable: false,
        configurable: true
    });
    return TimeGraphChart;
}(time_graph_chart_layer_1.TimeGraphChartLayer));
exports.TimeGraphChart = TimeGraphChart;
//# sourceMappingURL=time-graph-chart.js.map