"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var TraceExplorerItemPropertiesWidget_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TraceExplorerItemPropertiesWidget = void 0;
const inversify_1 = require("inversify");
const browser_1 = require("@theia/core/lib/browser");
const React = __importStar(require("react"));
const browser_2 = require("@theia/editor/lib/browser");
const uri_1 = __importDefault(require("@theia/core/lib/common/uri"));
const trace_explorer_properties_widget_1 = require("traceviewer-react-components/lib/trace-explorer/trace-explorer-properties-widget");
let TraceExplorerItemPropertiesWidget = TraceExplorerItemPropertiesWidget_1 = class TraceExplorerItemPropertiesWidget extends browser_1.ReactWidget {
    constructor() {
        super(...arguments);
        this.handleSourcecodeLookup = (e) => this.doHandleSourcecodeLookup(e);
    }
    init() {
        this.id = TraceExplorerItemPropertiesWidget_1.ID;
        this.title.label = TraceExplorerItemPropertiesWidget_1.LABEL;
        this.update();
    }
    dispose() {
        super.dispose();
    }
    render() {
        return (React.createElement("div", null,
            React.createElement(trace_explorer_properties_widget_1.ReactItemPropertiesWidget, { id: this.id, title: this.title.label, handleSourcecodeLookup: this.handleSourcecodeLookup })));
    }
    onResize(msg) {
        super.onResize(msg);
        this.update();
    }
    onAfterShow(msg) {
        super.onAfterShow(msg);
        this.update();
    }
    doHandleSourcecodeLookup(e) {
        const { fileLocation, line } = JSON.parse(`${e.currentTarget.getAttribute('data-id')}`);
        if (fileLocation) {
            const modeOpt = {
                mode: 'open'
            };
            let slectionOpt = {
                selection: {
                    start: {
                        line: 0,
                        character: 0
                    },
                    end: {
                        line: 0,
                        character: 0
                    }
                }
            };
            if (line) {
                const lineNumber = parseInt(line);
                slectionOpt = {
                    selection: {
                        start: {
                            line: lineNumber,
                            character: 0
                        },
                        end: {
                            line: lineNumber,
                            character: 0
                        }
                    }
                };
            }
            const opts = Object.assign(Object.assign({}, modeOpt), slectionOpt);
            this.editorManager.open(new uri_1.default(fileLocation), opts);
        }
    }
};
TraceExplorerItemPropertiesWidget.ID = 'trace-explorer-item-properties-widget';
TraceExplorerItemPropertiesWidget.LABEL = 'Item Properties';
__decorate([
    (0, inversify_1.inject)(browser_2.EditorManager),
    __metadata("design:type", browser_2.EditorManager)
], TraceExplorerItemPropertiesWidget.prototype, "editorManager", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TraceExplorerItemPropertiesWidget.prototype, "init", null);
TraceExplorerItemPropertiesWidget = TraceExplorerItemPropertiesWidget_1 = __decorate([
    (0, inversify_1.injectable)()
], TraceExplorerItemPropertiesWidget);
exports.TraceExplorerItemPropertiesWidget = TraceExplorerItemPropertiesWidget;
//# sourceMappingURL=theia-trace-explorer-properties-widget.js.map