"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AvailableViewsComponent = void 0;
const react_virtualized_1 = require("react-virtualized");
const react_1 = __importDefault(require("react"));
const signal_manager_1 = require("traceviewer-base/lib/signals/signal-manager");
class AvailableViewsComponent extends react_1.default.Component {
    constructor(props) {
        super(props);
        this._forceUpdateKey = false;
        this.handleOutputClicked = (e) => this.doHandleOutputClicked(e);
        this._onExperimentSelected = (experiment) => this.doHandleExperimentSelectedSignal(experiment);
        this.renderRowOutputs = (props) => this.doRenderRowOutputs(props);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.EXPERIMENT_SELECTED, this._onExperimentSelected);
        this.state = { lastSelectedOutputIndex: -1 };
    }
    componentWillUnmount() {
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.EXPERIMENT_SELECTED, this._onExperimentSelected);
    }
    render() {
        this._forceUpdateKey = !this._forceUpdateKey;
        const key = Number(this._forceUpdateKey);
        let outputsRowCount = 0;
        const outputs = this.props.outputDescriptors;
        if (outputs) {
            outputsRowCount = outputs.length;
        }
        const totalHeight = this.getTotalHeight();
        return (react_1.default.createElement("div", { className: 'trace-explorer-panel-content disable-select', style: { height: totalHeight } },
            react_1.default.createElement(react_virtualized_1.AutoSizer, null, ({ width }) => react_1.default.createElement(react_virtualized_1.List, { key: key, height: totalHeight, width: width, rowCount: outputsRowCount, rowHeight: AvailableViewsComponent.ROW_HEIGHT, rowRenderer: this.renderRowOutputs }))));
    }
    doRenderRowOutputs(props) {
        let outputName = '';
        let outputDescription = '';
        let output;
        const outputDescriptors = this.props.outputDescriptors;
        if (outputDescriptors && outputDescriptors.length && props.index < outputDescriptors.length) {
            output = outputDescriptors[props.index];
            outputName = output.name;
            outputDescription = output.description;
        }
        let traceContainerClassName = 'outputs-list-container';
        if (this.props.highlightAfterSelection && props.index === this.state.lastSelectedOutputIndex) {
            traceContainerClassName = traceContainerClassName + ' theia-mod-selected';
        }
        if (this.props.listRowWidth) {
            props.style.width = this.props.listRowWidth;
        }
        if (this.props.listRowPadding) {
            props.style.paddingLeft = this.props.listRowPadding;
            props.style.paddingRight = this.props.listRowPadding;
        }
        return react_1.default.createElement("div", { className: traceContainerClassName, title: outputName + ':\n' + outputDescription, id: `${traceContainerClassName}-${props.index}`, key: props.key, style: props.style, onClick: this.handleOutputClicked, onContextMenu: event => { this.doHandleContextMenuEvent(event, output); }, "data-id": `${props.index}` },
            react_1.default.createElement("div", { style: { width: '100%' } },
                react_1.default.createElement("h4", { className: 'outputs-element-name' }, outputName),
                react_1.default.createElement("div", { className: 'outputs-element-description child-element' }, outputDescription)));
    }
    doHandleContextMenuEvent(event, output) {
        if (this.props.onContextMenuEvent) {
            this.props.onContextMenuEvent(event, output);
        }
    }
    doHandleExperimentSelectedSignal(experiment) {
        if ((this.props.traceID !== (experiment === null || experiment === void 0 ? void 0 : experiment.UUID)) || this.props.outputDescriptors.length === 0) {
            this.setState({ lastSelectedOutputIndex: -1 });
        }
    }
    doHandleOutputClicked(e) {
        const index = Number(e.currentTarget.getAttribute('data-id'));
        this.setState({ lastSelectedOutputIndex: index });
        const selectedOutput = this.props.outputDescriptors[index];
        this.props.onOutputClicked(selectedOutput);
    }
    getTotalHeight() {
        let totalHeight = 0;
        const outputDescriptors = this.props.outputDescriptors;
        outputDescriptors === null || outputDescriptors === void 0 ? void 0 : outputDescriptors.forEach(() => totalHeight += AvailableViewsComponent.ROW_HEIGHT);
        return totalHeight;
    }
}
exports.AvailableViewsComponent = AvailableViewsComponent;
AvailableViewsComponent.LIST_MARGIN = 2;
AvailableViewsComponent.LINE_HEIGHT = 16;
AvailableViewsComponent.ROW_HEIGHT = (2 * AvailableViewsComponent.LINE_HEIGHT) + AvailableViewsComponent.LIST_MARGIN;
//# sourceMappingURL=available-views-component.js.map