"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.signalManager = exports.setSignalManagerInstance = exports.SignalManager = exports.Signals = void 0;
const events_1 = require("events");
exports.Signals = {
    TRACE_OPENED: 'trace opened',
    TRACE_DELETED: 'trace deleted',
    EXPERIMENT_OPENED: 'experiment opened',
    EXPERIMENT_CLOSED: 'experiment closed',
    EXPERIMENT_DELETED: 'experiment deleted',
    EXPERIMENT_SELECTED: 'experiment selected',
    OPENED_TRACES_UPDATED: 'opened traces updated',
    AVAILABLE_OUTPUTS_CHANGED: 'available outputs changed',
    OUTPUT_ADDED: 'output added',
    TOOLTIP_UPDATED: 'tooltip updated',
    THEME_CHANGED: 'theme changed',
    SELECTION_CHANGED: 'selection changed',
    CLOSE_TRACEVIEWERTAB: 'tab closed',
    TRACEVIEWERTAB_ACTIVATED: 'widget activated',
    UPDATE_ZOOM: 'update zoom',
    RESET_ZOOM: 'reset zoom',
    UNDO: 'undo',
    REDO: 'redo',
    MARKER_CATEGORIES_FETCHED: 'marker categories fetched',
    MARKERSETS_FETCHED: 'markersets fetched',
    MARKER_CATEGORY_CLOSED: 'marker category closed',
    TRACE_SERVER_STARTED: 'trace server started',
    PIN_VIEW: 'view pinned',
    UNPIN_VIEW: 'view unpinned',
    OPEN_OVERVIEW_OUTPUT: 'open overview output',
    OVERVIEW_OUTPUT_SELECTED: 'overview output selected'
};
class SignalManager extends events_1.EventEmitter {
    fireTraceOpenedSignal(trace) {
        this.emit(exports.Signals.TRACE_OPENED, trace);
    }
    fireTraceDeletedSignal(trace) {
        this.emit(exports.Signals.TRACE_DELETED, { trace });
    }
    fireExperimentOpenedSignal(experiment) {
        this.emit(exports.Signals.EXPERIMENT_OPENED, experiment);
    }
    fireExperimentClosedSignal(experiment) {
        this.emit(exports.Signals.EXPERIMENT_CLOSED, experiment);
    }
    fireExperimentDeletedSignal(experiment) {
        this.emit(exports.Signals.EXPERIMENT_DELETED, experiment);
    }
    fireExperimentSelectedSignal(experiment) {
        this.emit(exports.Signals.EXPERIMENT_SELECTED, experiment);
    }
    fireOpenedTracesChangedSignal(payload) {
        this.emit(exports.Signals.OPENED_TRACES_UPDATED, payload);
    }
    fireOutputAddedSignal(payload) {
        this.emit(exports.Signals.OUTPUT_ADDED, payload);
    }
    fireTooltipSignal(tooltip) {
        this.emit(exports.Signals.TOOLTIP_UPDATED, tooltip);
    }
    fireThemeChangedSignal(theme) {
        this.emit(exports.Signals.THEME_CHANGED, theme);
    }
    fireSelectionChangedSignal(payload) {
        this.emit(exports.Signals.SELECTION_CHANGED, payload);
    }
    fireCloseTraceViewerTabSignal(traceUUID) {
        this.emit(exports.Signals.CLOSE_TRACEVIEWERTAB, traceUUID);
    }
    fireTraceViewerTabActivatedSignal(experiment) {
        this.emit(exports.Signals.TRACEVIEWERTAB_ACTIVATED, experiment);
    }
    fireUpdateZoomSignal(hasZoomedIn) {
        this.emit(exports.Signals.UPDATE_ZOOM, hasZoomedIn);
    }
    fireResetZoomSignal() {
        this.emit(exports.Signals.RESET_ZOOM);
    }
    fireMarkerCategoriesFetchedSignal() {
        this.emit(exports.Signals.MARKER_CATEGORIES_FETCHED);
    }
    fireMarkerSetsFetchedSignal() {
        this.emit(exports.Signals.MARKERSETS_FETCHED);
    }
    fireMarkerCategoryClosedSignal(payload) {
        this.emit(exports.Signals.MARKER_CATEGORY_CLOSED, payload);
    }
    fireTraceServerStartedSignal() {
        this.emit(exports.Signals.TRACE_SERVER_STARTED);
    }
    fireUndoSignal() {
        this.emit(exports.Signals.UNDO);
    }
    fireRedoSignal() {
        this.emit(exports.Signals.REDO);
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any, @typescript-eslint/explicit-module-boundary-types
    firePinView(output, payload) {
        this.emit(exports.Signals.PIN_VIEW, output, payload);
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any, @typescript-eslint/explicit-module-boundary-types
    fireUnPinView(output, payload) {
        this.emit(exports.Signals.UNPIN_VIEW, output, payload);
    }
    fireOpenOverviewOutputSignal() {
        this.emit(exports.Signals.OPEN_OVERVIEW_OUTPUT);
    }
    fireOverviewOutputSelectedSignal(payload) {
        this.emit(exports.Signals.OVERVIEW_OUTPUT_SELECTED, payload);
    }
}
exports.SignalManager = SignalManager;
let instance = new SignalManager();
const setSignalManagerInstance = (sm) => {
    instance = sm;
};
exports.setSignalManagerInstance = setSignalManagerInstance;
const signalManager = () => instance;
exports.signalManager = signalManager;
//# sourceMappingURL=signal-manager.js.map