"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var TraceExplorerTooltipWidget_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TraceExplorerTooltipWidget = void 0;
const inversify_1 = require("inversify");
const browser_1 = require("@theia/core/lib/browser");
const React = __importStar(require("react"));
const browser_2 = require("@theia/editor/lib/browser");
const uri_1 = __importDefault(require("@theia/core/lib/common/uri"));
const signal_manager_1 = require("traceviewer-base/lib/signals/signal-manager");
let TraceExplorerTooltipWidget = TraceExplorerTooltipWidget_1 = class TraceExplorerTooltipWidget extends browser_1.ReactWidget {
    constructor() {
        super(...arguments);
        this.tooltip = undefined;
        this.onTooltip = (tooltip) => this.doHandleTooltipSignal(tooltip);
        this.handleSourcecodeLookup = (e) => this.doHandleSourcecodeLookup(e);
    }
    init() {
        this.id = TraceExplorerTooltipWidget_1.ID;
        this.title.label = TraceExplorerTooltipWidget_1.LABEL;
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.TOOLTIP_UPDATED, this.onTooltip);
        this.update();
    }
    dispose() {
        super.dispose();
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.TOOLTIP_UPDATED, this.onTooltip);
    }
    renderTooltip() {
        const tooltipArray = [];
        if (this.tooltip) {
            Object.entries(this.tooltip).forEach(([key, value]) => {
                if (key === 'Source') {
                    const sourceCodeInfo = value;
                    const matches = sourceCodeInfo.match('(.*):(\\d+)');
                    let fileLocation;
                    let line;
                    if (matches && matches.length === 3) {
                        fileLocation = matches[1];
                        line = matches[2];
                    }
                    tooltipArray.push(React.createElement("p", { className: 'source-code-tooltip', key: key, onClick: this.handleSourcecodeLookup, "data-id": JSON.stringify({ fileLocation, line }) }, key + ': ' + sourceCodeInfo));
                }
                else {
                    tooltipArray.push(React.createElement("p", { key: key }, key + ': ' + value));
                }
            });
        }
        else {
            tooltipArray.push(React.createElement("p", { key: "-1" },
                React.createElement("i", null, "Select item to view properties")));
        }
        return (React.createElement(React.Fragment, null, tooltipArray.map(element => element)));
    }
    doHandleSourcecodeLookup(e) {
        const { fileLocation, line } = JSON.parse(`${e.currentTarget.getAttribute('data-id')}`);
        if (fileLocation) {
            const modeOpt = {
                mode: 'open'
            };
            let slectionOpt = {
                selection: {
                    start: {
                        line: 0,
                        character: 0
                    },
                    end: {
                        line: 0,
                        character: 0
                    }
                }
            };
            if (line) {
                const lineNumber = parseInt(line);
                slectionOpt = {
                    selection: {
                        start: {
                            line: lineNumber,
                            character: 0
                        },
                        end: {
                            line: lineNumber,
                            character: 0
                        }
                    }
                };
            }
            const opts = Object.assign(Object.assign({}, modeOpt), slectionOpt);
            this.editorManager.open(new uri_1.default(fileLocation), opts);
        }
    }
    render() {
        return (React.createElement("div", { className: 'trace-explorer-tooltip' },
            React.createElement("div", { className: 'trace-explorer-panel-content' }, this.renderTooltip())));
    }
    doHandleTooltipSignal(tooltip) {
        this.tooltip = tooltip;
        this.update();
    }
    onAfterShow(msg) {
        super.onAfterShow(msg);
        this.update();
    }
};
TraceExplorerTooltipWidget.ID = 'trace-explorer-tooltip-widget';
TraceExplorerTooltipWidget.LABEL = 'Item Properties';
__decorate([
    (0, inversify_1.inject)(browser_2.EditorManager),
    __metadata("design:type", browser_2.EditorManager)
], TraceExplorerTooltipWidget.prototype, "editorManager", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], TraceExplorerTooltipWidget.prototype, "init", null);
TraceExplorerTooltipWidget = TraceExplorerTooltipWidget_1 = __decorate([
    (0, inversify_1.injectable)()
], TraceExplorerTooltipWidget);
exports.TraceExplorerTooltipWidget = TraceExplorerTooltipWidget;
//# sourceMappingURL=trace-explorer-tooltip-widget.js.map