"use strict";
/********************************************************************************
 * Copyright (C) 2020 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderDownloads = exports.renderDocumentation = exports.renderSourceCode = exports.renderTickets = exports.renderSupport = exports.renderWhatIsNot = exports.renderWhatIs = void 0;
const browser_1 = require("@theia/core/lib/browser");
const core_1 = require("@theia/core");
const browser_2 = require("@eclipse-cdt-cloud/blueprint-example-generator/lib/browser");
const React = require("react");
function ExternalBrowserLink(props) {
    return React.createElement("a", { role: 'button', tabIndex: 0, onClick: () => openExternalLink(props.url, props.windowService), onKeyDown: (e) => {
            var _a;
            if (browser_1.Key.ENTER.keyCode === ((_a = browser_1.KeyCode.createKeyCode(e.nativeEvent).key) === null || _a === void 0 ? void 0 : _a.keyCode)) {
                openExternalLink(props.url, props.windowService);
            }
        } }, props.text);
}
function openExternalLink(url, windowService) {
    windowService.openNewWindow(url, { external: true });
}
function renderWhatIs(windowService, commandService) {
    return React.createElement("div", { className: 'gs-section' },
        React.createElement("h3", { className: 'gs-section-header' }, "Welcome to CDT.cloud Blueprint"),
        React.createElement("div", null,
            "CDT.cloud Blueprint is a ",
            React.createElement("span", { className: 'gs-text-bold' }, "template"),
            " tool for building custom, web-based C/C++ tools. Purely based on extensible open source components, it offers a modern and feature-rich C/C++ development experience, including language editing and debugging support, memory debugging and a tracing view. It is meant to serve as a starting point for the implementation of your own domain-specific custom C/C++ tool."),
        React.createElement("h3", { className: 'gs-section-header' }, "Start playing around!"),
        React.createElement("div", null,
            "Select and generate an ",
            React.createElement("a", { role: 'button', tabIndex: 0, onClick: () => generateExample(commandService), onKeyDown: (e) => generateExample(commandService) }, 'example project'),
            "."),
        React.createElement("div", null, "Explore the features, such as code editing, building, build configurations, debugging, etc."),
        React.createElement("div", null,
            React.createElement("a", { role: 'button', tabIndex: 0, onClick: () => generateExample(commandService, browser_2.Examples.EXAMPLE_TRACES) }, core_1.nls.localizeByDefault('Generate example traces')),
            " ",
            ' ',
            " and open them with Trace Compass Cloud."));
}
exports.renderWhatIs = renderWhatIs;
function generateExample(commandService, exampleId) {
    commandService.executeCommand(browser_2.GenerateExampleCommand.id, exampleId);
}
function renderWhatIsNot() {
    return React.createElement("div", { className: 'gs-section' },
        React.createElement("h3", { className: 'gs-section-header' }, "What CDT.cloud Blueprint isn't"),
        React.createElement("div", null,
            "CDT.cloud Blueprint is ",
            React.createElement("span", { className: 'gs-text-bold' }, "not meant to be used as a production-ready product"),
            ". However, feel free to use it a template for building your own custom C/C++ tool based on this blueprint, as well as for testing the integrated CDT.cloud components."));
}
exports.renderWhatIsNot = renderWhatIsNot;
function renderSupport(windowService) {
    return React.createElement("div", { className: 'gs-section' },
        React.createElement("h3", { className: 'gs-section-header' }, "Professional Support"),
        React.createElement("div", null,
            "Professional support, implementation services, consulting and training for building tools like this instance of CDT.cloud Blueprint and for building other tools based on Eclipse Theia is available by selected companies as listed on the ",
            React.createElement(ExternalBrowserLink, { text: "CDT.cloud support page", url: "https://cdt-cloud.io/support/", windowService: windowService }),
            "."));
}
exports.renderSupport = renderSupport;
function renderTickets(windowService) {
    return React.createElement("div", { className: 'gs-section' },
        React.createElement("h3", { className: 'gs-section-header' }, "Get involved with CDT.cloud"),
        React.createElement("div", null,
            "CDT.cloud Blueprint is part of the CDT.cloud project, which hosts components and best practices for building customizable web-based C/C++ tools. For more information on CDT.cloud visit us on ",
            React.createElement(ExternalBrowserLink, { text: "our webpage", url: "https://cdt-cloud.io", windowService: windowService }),
            " or on ",
            React.createElement(ExternalBrowserLink, { text: "Github", url: "https://github.com/eclipse-cdt-cloud/cdt-cloud", windowService: windowService }),
            " and ",
            React.createElement(ExternalBrowserLink, { text: "get in touch", url: "https://cdt-cloud.io/contact", windowService: windowService }),
            " to discuss ideas, request features, report bugs, or to get support for building your custom C/C++ tool."));
}
exports.renderTickets = renderTickets;
function renderSourceCode(windowService) {
    return React.createElement("div", { className: 'gs-section' },
        React.createElement("h3", { className: 'gs-section-header' }, "Source Code and CDT.cloud components"),
        React.createElement("div", null,
            "The source code of CDT.cloud Blueprint is available on ",
            React.createElement(ExternalBrowserLink, { text: "Github", url: "https://github.com/eclipse-cdt-cloud/cdt-cloud-blueprint", windowService: windowService }),
            "."),
        React.createElement("div", null,
            "CDT.cloud Blueprint bundles the following CDT.cloud open-source components:",
            React.createElement("ul", null,
                React.createElement("li", null,
                    React.createElement(ExternalBrowserLink, { text: "CDT GDB Debug Adapter", url: "https://github.com/eclipse-cdt-cloud/cdt-gdb-adapter", windowService: windowService })),
                React.createElement("li", null,
                    React.createElement(ExternalBrowserLink, { text: "Clangd Contexts", url: "https://github.com/eclipse-cdt-cloud/clangd-contexts", windowService: windowService })),
                React.createElement("li", null,
                    React.createElement(ExternalBrowserLink, { text: "Trace Compass Cloud", url: "https://github.com/eclipse-cdt-cloud/theia-trace-extension", windowService: windowService })))));
}
exports.renderSourceCode = renderSourceCode;
function renderDocumentation(windowService) {
    return React.createElement("div", { className: 'gs-section' });
}
exports.renderDocumentation = renderDocumentation;
function renderDownloads() {
    return React.createElement("div", { className: 'gs-section' },
        React.createElement("h3", { className: 'gs-section-header' }, "Updates and Downloads"),
        React.createElement("div", { className: 'gs-action-container' },
            "You can update CDT.cloud Blueprint directly in this application by navigating to File ",
            '>',
            " Settings ",
            '>',
            " Check for Updates. Moreover the application will check for Updates after each launch automatically. Alternatively you can download the most recent version from our webpage."));
}
exports.renderDownloads = renderDownloads;
//# sourceMappingURL=branding-util.js.map