import { AbortController } from 'abort-controller';
declare type UI = {
    readonly storagePath: string;
    clangdPath: string;
    info(s: string): void;
    error(s: string): void;
    showHelp(message: string, url: string): void;
    promptReload(message: string): void;
    promptUpdate(oldVersion: string, newVersion: string): void;
    promptInstall(version: string): void;
    shouldReuse(path: string): Promise<boolean | undefined>;
    slow<T>(title: string, work: Promise<T>): Promise<T>;
    progress<T>(title: string, cancel: AbortController | null, work: (progress: (fraction: number) => void) => Promise<T>): Promise<T>;
};
declare type InstallStatus = {
    clangdPath: string | null;
    background: Promise<void>;
};
export declare function prepare(ui: UI, checkUpdate: boolean): Promise<InstallStatus>;
export declare function installLatest(ui: UI): Promise<void>;
export declare function checkUpdates(requested: boolean, ui: UI): Promise<void>;
export declare function fakeGitHubReleaseURL(u: string): void;
export declare function fakeLddCommand(l: string): void;
export {};
