"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactAvailableViewsWidget = void 0;
const React = __importStar(require("react"));
const react_virtualized_1 = require("react-virtualized");
const output_added_signal_payload_1 = require("traceviewer-base/lib/signals/output-added-signal-payload");
const signal_manager_1 = require("traceviewer-base/lib/signals/signal-manager");
class ReactAvailableViewsWidget extends React.Component {
    constructor(props) {
        super(props);
        this._forceUpdateKey = false;
        this._onExperimentSelected = (experiment) => this.doHandleExperimentSelectedSignal(experiment);
        this._onExperimentClosed = (experiment) => this.doHandleExperimentClosedSignal(experiment);
        this.renderRowOutputs = (props) => this.doRenderRowOutputs(props);
        this.handleOutputClicked = (e) => this.doHandleOutputClicked(e);
        this.handleContextMenuEvent = (e, output) => this.doHandleContextMenuEvent(e, output);
        this.updateAvailableViews = async () => this.doUpdateAvailableViews();
        this._experimentManager = this.props.tspClientProvider.getExperimentManager();
        this.props.tspClientProvider.addTspClientChangeListener(() => {
            this._experimentManager = this.props.tspClientProvider.getExperimentManager();
        });
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.EXPERIMENT_SELECTED, this._onExperimentSelected);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.EXPERIMENT_CLOSED, this._onExperimentClosed);
        this.state = { availableOutputDescriptors: [], lastSelectedOutputIndex: -1 };
    }
    componentWillUnmount() {
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.EXPERIMENT_SELECTED, this._onExperimentSelected);
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.EXPERIMENT_CLOSED, this._onExperimentClosed);
    }
    render() {
        this._forceUpdateKey = !this._forceUpdateKey;
        const key = Number(this._forceUpdateKey);
        let outputsRowCount = 0;
        const outputs = this.state.availableOutputDescriptors;
        if (outputs) {
            outputsRowCount = outputs.length;
        }
        const totalHeight = this.getTotalHeight();
        return (React.createElement("div", { className: 'trace-explorer-views' },
            React.createElement("div", { className: 'trace-explorer-panel-content disable-select' },
                React.createElement(react_virtualized_1.AutoSizer, null, ({ width }) => React.createElement(react_virtualized_1.List, { key: key, height: totalHeight, width: width, rowCount: outputsRowCount, rowHeight: ReactAvailableViewsWidget.ROW_HEIGHT, rowRenderer: this.renderRowOutputs })))));
    }
    doRenderRowOutputs(props) {
        let outputName = '';
        let outputDescription = '';
        let output;
        const outputDescriptors = this.state.availableOutputDescriptors;
        if (outputDescriptors && outputDescriptors.length && props.index < outputDescriptors.length) {
            output = outputDescriptors[props.index];
            outputName = output.name;
            outputDescription = output.description;
        }
        let traceContainerClassName = 'outputs-list-container';
        if (props.index === this.state.lastSelectedOutputIndex) {
            traceContainerClassName = traceContainerClassName + ' theia-mod-selected';
        }
        return React.createElement("div", { className: traceContainerClassName, title: outputName + ':\n' + outputDescription, id: `${traceContainerClassName}-${props.index}`, key: props.key, style: props.style, onClick: this.handleOutputClicked, onContextMenu: event => { this.handleContextMenuEvent(event, output); }, "data-id": `${props.index}` },
            React.createElement("h4", { className: 'outputs-element-name' }, outputName),
            React.createElement("div", { className: 'outputs-element-description child-element' }, outputDescription));
    }
    getTotalHeight() {
        let totalHeight = 0;
        const outputDescriptors = this.state.availableOutputDescriptors;
        outputDescriptors === null || outputDescriptors === void 0 ? void 0 : outputDescriptors.forEach(() => totalHeight += ReactAvailableViewsWidget.ROW_HEIGHT);
        return totalHeight;
    }
    doHandleOutputClicked(e) {
        const index = Number(e.currentTarget.getAttribute('data-id'));
        this.setState({ lastSelectedOutputIndex: index });
        const outputs = this.state.availableOutputDescriptors;
        if (outputs && this._selectedExperiment) {
            (0, signal_manager_1.signalManager)().fireOutputAddedSignal(new output_added_signal_payload_1.OutputAddedSignalPayload(outputs[index], this._selectedExperiment));
        }
    }
    doHandleContextMenuEvent(event, output) {
        if (this.props.contextMenuRenderer && output) {
            this.props.contextMenuRenderer(event, output);
        }
        event.preventDefault();
        event.stopPropagation();
    }
    doHandleExperimentSelectedSignal(experiment) {
        var _a;
        if ((((_a = this._selectedExperiment) === null || _a === void 0 ? void 0 : _a.UUID) !== (experiment === null || experiment === void 0 ? void 0 : experiment.UUID)) || this.state.availableOutputDescriptors.length === 0) {
            this._selectedExperiment = experiment;
            this.setState({ availableOutputDescriptors: [], lastSelectedOutputIndex: -1 });
            this.updateAvailableViews();
        }
    }
    doHandleExperimentClosedSignal(experiment) {
        var _a;
        if (((_a = this._selectedExperiment) === null || _a === void 0 ? void 0 : _a.UUID) === (experiment === null || experiment === void 0 ? void 0 : experiment.UUID)) {
            this.setState({ availableOutputDescriptors: [] });
        }
    }
    async doUpdateAvailableViews() {
        let outputs;
        const signalExperiment = this._selectedExperiment;
        if (signalExperiment) {
            outputs = await this.getOutputDescriptors(signalExperiment);
            this.setState({ availableOutputDescriptors: outputs });
        }
        else {
            this.setState({ availableOutputDescriptors: [] });
        }
    }
    async getOutputDescriptors(experiment) {
        const outputDescriptors = [];
        const descriptors = await this._experimentManager.getAvailableOutputs(experiment.UUID);
        if (descriptors && descriptors.length) {
            outputDescriptors.push(...descriptors);
        }
        return outputDescriptors;
    }
}
exports.ReactAvailableViewsWidget = ReactAvailableViewsWidget;
ReactAvailableViewsWidget.LIST_MARGIN = 2;
ReactAvailableViewsWidget.LINE_HEIGHT = 16;
ReactAvailableViewsWidget.ROW_HEIGHT = (2 * ReactAvailableViewsWidget.LINE_HEIGHT) + ReactAvailableViewsWidget.LIST_MARGIN;
//# sourceMappingURL=trace-explorer-views-widget.js.map