"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimegraphOutputComponent = void 0;
const React = __importStar(require("react"));
const time_graph_state_1 = require("timeline-chart/lib/components/time-graph-state");
const time_graph_chart_1 = require("timeline-chart/lib/layer/time-graph-chart");
const time_graph_chart_arrows_1 = require("timeline-chart/lib/layer/time-graph-chart-arrows");
const time_graph_range_events_layer_1 = require("timeline-chart/lib/layer/time-graph-range-events-layer");
const time_graph_chart_cursors_1 = require("timeline-chart/lib/layer/time-graph-chart-cursors");
const time_graph_chart_grid_1 = require("timeline-chart/lib/layer/time-graph-chart-grid");
const time_graph_chart_selection_range_1 = require("timeline-chart/lib/layer/time-graph-chart-selection-range");
const time_graph_vertical_scrollbar_1 = require("timeline-chart/lib/layer/time-graph-vertical-scrollbar");
const time_graph_row_controller_1 = require("timeline-chart/lib/time-graph-row-controller");
const query_helper_1 = require("tsp-typescript-client/lib/models/query/query-helper");
const responses_1 = require("tsp-typescript-client/lib/models/response/responses");
const signal_manager_1 = require("traceviewer-base/lib/signals/signal-manager");
const abstract_tree_output_component_1 = require("./abstract-tree-output-component");
const style_properties_1 = require("./data-providers/style-properties");
const style_provider_1 = require("./data-providers/style-provider");
const tsp_data_provider_1 = require("./data-providers/tsp-data-provider");
const timegraph_container_component_1 = require("./utils/timegraph-container-component");
const entry_tree_1 = require("./utils/filter-tree/entry-tree");
const utils_1 = require("./utils/filter-tree/utils");
const value_hash_1 = __importDefault(require("traceviewer-base/lib/utils/value-hash"));
const time_graph_annotation_1 = require("timeline-chart/lib/components/time-graph-annotation");
class TimegraphOutputComponent extends abstract_tree_output_component_1.AbstractTreeOutputComponent {
    constructor(props) {
        super(props);
        this.totalHeight = 0;
        this.styleMap = new Map();
        this.markerCategoriesLayerData = undefined;
        this.selectedMarkerCategories = undefined;
        this.onSelectionChanged = (payload) => this.doHandleSelectionChangedSignal(payload);
        this.state = {
            outputStatus: responses_1.ResponseStatus.RUNNING,
            timegraphTree: [],
            markerCategoryEntries: [],
            collapsedNodes: [],
            columns: [],
            collapsedMarkerNodes: []
        };
        this.selectedMarkerCategories = this.props.markerCategories;
        this.onToggleCollapse = this.onToggleCollapse.bind(this);
        this.onMarkerCategoryRowClose = this.onMarkerCategoryRowClose.bind(this);
        this.onToggleAnnotationCollapse = this.onToggleAnnotationCollapse.bind(this);
        this.tspDataProvider = new tsp_data_provider_1.TspDataProvider(this.props.tspClient, this.props.traceId, this.props.outputDescriptor.id);
        this.styleProvider = new style_provider_1.StyleProvider(this.props.outputDescriptor.id, this.props.traceId, this.props.tspClient);
        this.rowController = new time_graph_row_controller_1.TimeGraphRowController(this.props.style.rowHeight, this.totalHeight);
        this.markerRowController = new time_graph_row_controller_1.TimeGraphRowController(this.props.style.rowHeight, this.totalHeight);
        this.horizontalContainer = React.createRef();
        this.timeGraphTreeRef = React.createRef();
        this.markerTreeRef = React.createRef();
        const providers = {
            /**
             * @param range requested time range
             * @param resolution requested time interval between samples
             * @returns row models with the actual range and resolution
             */
            dataProvider: async (range, resolution) => this.fetchTimegraphData(range, resolution),
            stateStyleProvider: (state) => this.getStateStyle(state),
            rowAnnotationStyleProvider: (annotation) => this.getAnnotationStyle(annotation),
            rowStyleProvider: (row) => this.getRowStyle(row)
        };
        const markersProvider = {
            dataProvider: async (range, resolution) => this.fetchMarkersData(range, resolution),
            stateStyleProvider: (state) => this.getMarkerStateStyle(state),
            rowStyleProvider: (row) => this.getRowStyle(row)
        };
        this.rangeEventsLayer = new time_graph_range_events_layer_1.TimeGraphRangeEventsLayer('timeGraphRangeEvents', providers);
        this.chartLayer = new time_graph_chart_1.TimeGraphChart('timeGraphChart', providers, this.rowController);
        this.arrowLayer = new time_graph_chart_arrows_1.TimeGraphChartArrows('timeGraphChartArrows', this.rowController);
        this.vscrollLayer = new time_graph_vertical_scrollbar_1.TimeGraphVerticalScrollbar('timeGraphVerticalScrollbar', this.rowController);
        this.chartCursors = new time_graph_chart_cursors_1.TimeGraphChartCursors('chart-cursors', this.chartLayer, this.rowController, { color: this.props.style.cursorColor });
        this.rowController.onVerticalOffsetChangedHandler(() => {
            if (this.timeGraphTreeRef.current) {
                this.timeGraphTreeRef.current.scrollTop = this.rowController.verticalOffset;
            }
        });
        this.markersChartLayer = new time_graph_chart_1.TimeGraphChart('timeGraphChart', markersProvider, this.markerRowController);
        this.chartLayer.onSelectedStateChanged(model => {
            if (model) {
                const el = this.chartLayer.getElementById(model.id);
                if (el) {
                    this.selectedElement = el;
                }
            }
            else {
                this.selectedElement = undefined;
            }
            this.onElementSelected(this.selectedElement);
        });
        this.chartLayer.registerMouseInteractions({
            mouseover: el => {
                var _a;
                (_a = this.props.tooltipComponent) === null || _a === void 0 ? void 0 : _a.setElement(el, () => this.fetchTooltip(el));
            },
            mouseout: () => {
                var _a;
                (_a = this.props.tooltipComponent) === null || _a === void 0 ? void 0 : _a.setElement(undefined);
            },
            click: (el, ev, clickCount) => {
                if (clickCount === 2) {
                    const start = el.model.range.start;
                    const end = el.model.range.end;
                    if (start !== end) {
                        this.props.unitController.viewRange = {
                            start,
                            end
                        };
                    }
                }
            }
        });
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.SELECTION_CHANGED, this.onSelectionChanged);
    }
    synchronizeTreeScroll() {
        if (this.timeGraphTreeRef.current) {
            this.rowController.verticalOffset = this.timeGraphTreeRef.current.scrollTop;
        }
    }
    async componentDidMount() {
        this.setState({
            styleModel: await this.styleProvider.getStyleModel()
        });
        this.waitAnalysisCompletion();
    }
    componentWillUnmount() {
        super.componentWillUnmount();
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.SELECTION_CHANGED, this.onSelectionChanged);
    }
    async fetchTree() {
        const parameters = query_helper_1.QueryHelper.timeQuery([this.props.range.getStart(), this.props.range.getEnd()]);
        const tspClientResponse = await this.props.tspClient.fetchTimeGraphTree(this.props.traceId, this.props.outputDescriptor.id, parameters);
        const treeResponse = tspClientResponse.getModel();
        if (tspClientResponse.isOk() && treeResponse) {
            if (treeResponse.model) {
                const headers = treeResponse.model.headers;
                const columns = [];
                if (headers && headers.length > 0) {
                    headers.forEach(header => {
                        columns.push({ title: header.name, sortable: true, resizable: true, tooltip: header.tooltip });
                    });
                }
                else {
                    columns.push({ title: 'Name', sortable: true });
                }
                this.setState({
                    outputStatus: treeResponse.status,
                    timegraphTree: treeResponse.model.entries,
                    columns
                }, this.updateTotalHeight);
            }
            else {
                this.setState({
                    outputStatus: treeResponse.status
                });
            }
            return treeResponse.status;
        }
        this.setState({
            outputStatus: responses_1.ResponseStatus.FAILED
        });
        return responses_1.ResponseStatus.FAILED;
    }
    async componentDidUpdate(prevProps, prevState) {
        if (prevState.outputStatus === responses_1.ResponseStatus.RUNNING ||
            this.state.collapsedNodes !== prevState.collapsedNodes ||
            prevProps.markerCategories !== this.props.markerCategories ||
            prevProps.markerSetId !== this.props.markerSetId) {
            this.selectedMarkerCategories = this.props.markerCategories;
            this.chartLayer.updateChart();
            this.markersChartLayer.updateChart();
            this.arrowLayer.update();
            this.rangeEventsLayer.update();
        }
        if (this.state.markerCategoryEntries !== prevState.markerCategoryEntries ||
            this.state.collapsedMarkerNodes !== prevState.collapsedMarkerNodes) {
            this.markersChartLayer.updateChart();
        }
    }
    onToggleCollapse(id) {
        let newList = [...this.state.collapsedNodes];
        const exist = this.state.collapsedNodes.find(expandId => expandId === id);
        if (exist !== undefined) {
            newList = newList.filter(collapsed => id !== collapsed);
        }
        else {
            newList = newList.concat(id);
        }
        this.setState({ collapsedNodes: newList }, this.updateTotalHeight);
    }
    onToggleAnnotationCollapse() {
        if (this.state.collapsedMarkerNodes.length === 0) {
            const annotationNodes = this.state.markerCategoryEntries.map(annotation => annotation.id);
            this.setState({ collapsedMarkerNodes: annotationNodes });
        }
        else {
            this.setState({ collapsedMarkerNodes: [] });
        }
    }
    onMarkerCategoryRowClose(id) {
        var _a;
        const annotation = this.state.markerCategoryEntries.find(entry => entry.id === id);
        if (annotation && this.selectedMarkerCategories) {
            this.setState({
                markerCategoryEntries: this.state.markerCategoryEntries.filter(item => item !== annotation)
            });
            const removedIndex = this.selectedMarkerCategories.findIndex(annotationMarker => annotation.labels[0] === annotationMarker);
            if (removedIndex !== -1) {
                const annotationLabel = this.selectedMarkerCategories[removedIndex];
                this.selectedMarkerCategories = this.selectedMarkerCategories.filter(item => item !== annotationLabel);
                (_a = this.markerCategoriesLayerData) === null || _a === void 0 ? void 0 : _a.rows.splice(removedIndex, 1);
                (0, signal_manager_1.signalManager)().fireMarkerCategoryClosedSignal({ traceViewerId: this.props.traceId, markerCategory: annotationLabel });
            }
            this.markersChartLayer.updateChart();
        }
    }
    updateTotalHeight() {
        const visibleEntries = [...this.state.timegraphTree].filter(entry => this.isVisible(entry));
        this.totalHeight = visibleEntries.length * this.props.style.rowHeight;
        this.rowController.totalHeight = this.totalHeight;
    }
    isVisible(entry) {
        let parentId = entry.parentId;
        while (parentId !== undefined && parentId !== -1) {
            if (this.state.collapsedNodes.includes(parentId)) {
                return false;
            }
            const parent = this.state.timegraphTree.find(e => e.id === parentId);
            parentId = parent ? parent.parentId : undefined;
        }
        return true;
    }
    doHandleSelectionChangedSignal(payload) {
        const offset = this.props.viewRange.getOffset() || BigInt(0);
        const startTimestamp = payload['startTimestamp'];
        const endTimestamp = payload['endTimestamp'];
        if (startTimestamp !== undefined && endTimestamp !== undefined) {
            const selectionRangeStart = BigInt(startTimestamp) - offset;
            const selectionRangeEnd = BigInt(endTimestamp) - offset;
            this.props.unitController.selectionRange = {
                start: selectionRangeStart,
                end: selectionRangeEnd
            };
            this.chartCursors.maybeCenterCursor();
        }
    }
    getMarkersLayerHeight() {
        const rowHeight = 20;
        const scrollbarHeight = 10;
        return this.state.markerCategoryEntries.length <= 1 ? 0 :
            this.state.collapsedMarkerNodes.length ? rowHeight :
                this.state.markerCategoryEntries.length * rowHeight + scrollbarHeight;
    }
    renderTree() {
        // TODO Show header, when we can have entries in-line with timeline-chart
        return React.createElement(React.Fragment, null,
            React.createElement("div", { ref: this.timeGraphTreeRef, className: 'scrollable', onScroll: () => this.synchronizeTreeScroll(), style: { height: parseInt(this.props.style.height.toString()) - this.getMarkersLayerHeight() }, tabIndex: 0 },
                React.createElement(entry_tree_1.EntryTree, { collapsedNodes: this.state.collapsedNodes, showFilter: false, entries: this.state.timegraphTree, showCheckboxes: false, onToggleCollapse: this.onToggleCollapse, showHeader: false, className: "table-tree timegraph-tree" })),
            React.createElement("div", { ref: this.markerTreeRef, className: 'scrollable', style: { height: this.getMarkersLayerHeight() } },
                React.createElement(entry_tree_1.EntryTree, { collapsedNodes: this.state.collapsedMarkerNodes, showFilter: false, entries: this.state.markerCategoryEntries, showCheckboxes: false, showCloseIcons: true, onToggleCollapse: this.onToggleAnnotationCollapse, onClose: this.onMarkerCategoryRowClose, showHeader: false, className: "table-tree timegraph-tree" })));
    }
    renderYAxis() {
        return undefined;
    }
    renderChart() {
        return React.createElement(React.Fragment, null, this.state.outputStatus === responses_1.ResponseStatus.COMPLETED ?
            React.createElement("div", { id: 'timegraph-main', className: 'ps__child--consume', onWheel: ev => { ev.preventDefault(); ev.stopPropagation(); }, style: { height: this.props.style.height } }, this.renderTimeGraphContent()) :
            React.createElement("div", { className: 'analysis-running' },
                (React.createElement("i", { className: 'fa fa-refresh fa-spin', style: { marginRight: '5px' } })),
                'Analysis running'));
    }
    resultsAreEmpty() {
        return this.state.timegraphTree.length === 0;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    async fetchTooltip(element) {
        if (element instanceof time_graph_state_1.TimeGraphStateComponent) {
            const label = element.model.label ? element.model.label : '';
            const elementRange = element.model.range;
            const offset = this.props.viewRange.getOffset();
            let start;
            let end;
            if (this.props.unitController.numberTranslator) {
                start = this.props.unitController.numberTranslator(elementRange.start);
                end = this.props.unitController.numberTranslator(elementRange.end);
            }
            start = start ? start : (elementRange.start + (offset ? offset : BigInt(0))).toString();
            end = end ? end : (elementRange.end + (offset ? offset : BigInt(0))).toString();
            const tooltip = await this.tspDataProvider.fetchStateTooltip(element, this.props.viewRange);
            return Object.assign({ 'Label': label, 'Start time': start, 'End time': end, 'Row': element.row.model.name }, tooltip);
        }
        else if (element instanceof time_graph_annotation_1.TimeGraphAnnotationComponent) {
            const category = element.model.category ? element.model.category : 'Label';
            const label = element.model.label ? element.model.label : '';
            const elementRange = element.model.range;
            const offset = this.props.viewRange.getOffset();
            let start;
            let end;
            if (this.props.unitController.numberTranslator) {
                start = this.props.unitController.numberTranslator(elementRange.start);
                end = this.props.unitController.numberTranslator(elementRange.end);
            }
            start = start ? start : (elementRange.start + (offset ? offset : BigInt(0))).toString();
            end = end ? end : (elementRange.end + (offset ? offset : BigInt(0))).toString();
            const tooltip = await this.tspDataProvider.fetchAnnotationTooltip(element, this.props.viewRange);
            if (start === end) {
                return Object.assign({ [category]: label, 'Timestamp': start, 'Row': element.row.model.name }, tooltip);
            }
            else {
                return Object.assign({ [category]: label, 'Start time': start, 'End time': end, 'Row': element.row.model.name }, tooltip);
            }
        }
    }
    renderTimeGraphContent() {
        return React.createElement("div", { id: 'main-timegraph-content', ref: this.horizontalContainer, style: { height: this.props.style.height } },
            this.getChartContainer(),
            this.getMarkersContainer());
    }
    getMarkersContainer() {
        return React.createElement(timegraph_container_component_1.ReactTimeGraphContainer, { options: {
                id: 'timegraph-chart-1',
                height: this.getMarkersLayerHeight(),
                width: this.getChartWidth(),
                backgroundColor: this.props.style.chartBackgroundColor,
                lineColor: this.props.style.lineColor,
                classNames: 'horizontal-canvas'
            }, addWidgetResizeHandler: this.props.addWidgetResizeHandler, removeWidgetResizeHandler: this.props.removeWidgetResizeHandler, unitController: this.props.unitController, id: 'timegraph-chart-1', layers: [this.markersChartLayer] });
    }
    getChartContainer() {
        const grid = new time_graph_chart_grid_1.TimeGraphChartGrid('timeGraphGrid', this.props.style.rowHeight, this.props.backgroundTheme === 'light' ? 0xdddddd : 0x34383C);
        const selectionRange = new time_graph_chart_selection_range_1.TimeGraphChartSelectionRange('chart-selection-range', { color: this.props.style.cursorColor });
        return React.createElement(timegraph_container_component_1.ReactTimeGraphContainer, { options: {
                id: this.props.traceId + this.props.outputDescriptor.id + 'focusContainer',
                height: parseInt(this.props.style.height.toString()) - this.getMarkersLayerHeight(),
                width: this.getChartWidth(),
                backgroundColor: this.props.style.chartBackgroundColor,
                lineColor: this.props.backgroundTheme === 'light' ? 0xdddddd : 0x34383C,
                classNames: 'horizontal-canvas'
            }, addWidgetResizeHandler: this.props.addWidgetResizeHandler, removeWidgetResizeHandler: this.props.removeWidgetResizeHandler, unitController: this.props.unitController, id: this.props.traceId + this.props.outputDescriptor.id + 'focusContainer', layers: [
                grid, this.chartLayer, selectionRange, this.chartCursors, this.arrowLayer, this.rangeEventsLayer
            ] });
    }
    setFocus() {
        var _a, _b;
        if (document.getElementById(this.props.traceId + this.props.outputDescriptor.id + 'focusContainer')) {
            (_a = document.getElementById(this.props.traceId + this.props.outputDescriptor.id + 'focusContainer')) === null || _a === void 0 ? void 0 : _a.focus();
        }
        else {
            (_b = document.getElementById(this.props.traceId + this.props.outputDescriptor.id)) === null || _b === void 0 ? void 0 : _b.focus();
        }
    }
    getVerticalScrollbar() {
        return React.createElement(timegraph_container_component_1.ReactTimeGraphContainer, { id: 'vscroll', options: {
                id: 'vscroll',
                width: 10,
                height: parseInt(this.props.style.height.toString()),
                backgroundColor: this.props.style.naviBackgroundColor
            }, addWidgetResizeHandler: this.props.addWidgetResizeHandler, removeWidgetResizeHandler: this.props.removeWidgetResizeHandler, unitController: this.props.unitController, layers: [this.vscrollLayer] });
    }
    async onElementSelected(element) {
        let tooltipObject = undefined;
        if (element && this.props.viewRange) {
            tooltipObject = await this.fetchTooltip(element);
        }
        (0, signal_manager_1.signalManager)().fireTooltipSignal(tooltipObject);
    }
    async fetchTimegraphData(range, resolution) {
        if (document.getElementById(this.props.traceId + this.props.outputDescriptor.id + 'handleSpinner')) {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            document.getElementById(this.props.traceId + this.props.outputDescriptor.id + 'handleSpinner').style.visibility = 'visible';
        }
        const treeNodes = (0, utils_1.listToTree)(this.state.timegraphTree, this.state.columns);
        const orderedTreeIds = (0, utils_1.getAllExpandedNodeIds)(treeNodes, this.state.collapsedNodes);
        const overlap = range.end - range.start;
        const start = range.start - overlap > 0 ? range.start - overlap : BigInt(0);
        const end = range.end + overlap < this.props.unitController.absoluteRange ? range.end + overlap : this.props.unitController.absoluteRange;
        const newRange = { start, end };
        const nbTimes = Math.ceil(Number(end - start) / resolution) + 1;
        const timeGraphData = await this.tspDataProvider.getData(orderedTreeIds, this.state.timegraphTree, this.props.range, newRange, nbTimes, this.props.markerCategories, this.props.markerSetId);
        this.updateMarkersData(timeGraphData.rangeEvents, newRange, nbTimes);
        this.arrowLayer.addArrows(timeGraphData.arrows);
        this.rangeEventsLayer.addRangeEvents(timeGraphData.rangeEvents);
        if (document.getElementById(this.props.traceId + this.props.outputDescriptor.id + 'handleSpinner')) {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            document.getElementById(this.props.traceId + this.props.outputDescriptor.id + 'handleSpinner').style.visibility = 'hidden';
        }
        return {
            rows: timeGraphData ? timeGraphData.rows : [],
            range: newRange,
            resolution: resolution
        };
    }
    updateMarkersData(rangeEvents, newRange, newResolution) {
        const annotationEntries = [];
        const markers = new Map();
        const rows = [];
        const filteredEvents = rangeEvents.filter(event => { var _a; return (_a = this.selectedMarkerCategories) === null || _a === void 0 ? void 0 : _a.includes(event.category); });
        filteredEvents.forEach(event => {
            var _a;
            const categoryName = event.category;
            if (!markers.has(categoryName)) {
                markers.set(categoryName, []);
            }
            const states = markers.get(categoryName) || [];
            const state = {
                id: '1',
                range: {
                    start: event.range.start,
                    end: event.range.end
                },
                label: event.label,
                data: {
                    style: (_a = event.data) === null || _a === void 0 ? void 0 : _a.style,
                    annotation: event
                }
            };
            states.push(state);
        });
        if (markers.size > 0) {
            const defaultRow = {
                id: 1,
                name: '',
                range: {
                    start: this.props.viewRange.getStart(),
                    end: this.props.viewRange.getStart() + this.props.unitController.absoluteRange
                },
                states: [],
                annotations: [],
                prevPossibleState: BigInt(Number.MIN_SAFE_INTEGER),
                nextPossibleState: BigInt(Number.MAX_SAFE_INTEGER)
            };
            rows.push(defaultRow);
            annotationEntries.push({
                id: 0,
                labels: [''],
                parentId: -1
            });
        }
        Array.from(markers.entries()).forEach((value, index) => {
            annotationEntries.push({
                id: index + 1,
                labels: [value[0]],
                parentId: 0
            });
            const row = {
                id: 1,
                name: '',
                range: {
                    start: this.props.viewRange.getStart(),
                    end: this.props.viewRange.getStart() + this.props.unitController.absoluteRange
                },
                states: value[1],
                annotations: [],
                prevPossibleState: BigInt(Number.MIN_SAFE_INTEGER),
                nextPossibleState: BigInt(Number.MAX_SAFE_INTEGER)
            };
            rows.push(row);
        });
        this.markerCategoriesLayerData = {
            rows,
            range: newRange,
            resolution: newResolution
        };
        this.setState({ markerCategoryEntries: annotationEntries });
    }
    async fetchMarkersData(range, resolution) {
        const rows = (this.state.collapsedMarkerNodes.length !== 0 || !!!this.markerCategoriesLayerData) ? [] : this.markerCategoriesLayerData.rows;
        return {
            rows,
            range: this.markerCategoriesLayerData ? this.markerCategoriesLayerData.range : range,
            resolution: this.markerCategoriesLayerData ? this.markerCategoriesLayerData.resolution : resolution
        };
    }
    getRowStyle(row) {
        return {
            backgroundColor: 0x979797,
            backgroundOpacity: row.selected ? 0.1 : 0,
            lineColor: this.props.backgroundTheme === 'light' ? 0xD3D3D3 : 0x3F4146,
            lineThickness: 1, // hasStates ? 1 : 3 // row.data && row.data.hasStates
        };
    }
    getMarkerStateStyle(state) {
        if (state.data && state.data.annotation) {
            const annotation = state.data.annotation;
            const style = this.getAnnotationStyle(annotation);
            return {
                color: style ? style.color : 0x000000,
                height: this.markerRowController.rowHeight,
                borderWidth: 1,
                borderColor: 0x000000
            };
        }
        return this.getStateStyle(state);
    }
    getStateStyle(state) {
        const styleModel = this.state.styleModel;
        if (styleModel) {
            const metadata = state.data;
            if (metadata && metadata.style) {
                const elementStyle = metadata.style;
                const backgroundColor = this.styleProvider.getColorStyle(elementStyle, style_properties_1.StyleProperties.BACKGROUND_COLOR);
                const heightFactor = this.styleProvider.getNumberStyle(elementStyle, style_properties_1.StyleProperties.HEIGHT);
                let height = this.props.style.rowHeight * 0.8;
                if (heightFactor) {
                    height = heightFactor * height;
                }
                const borderStyle = this.styleProvider.getStyle(elementStyle, style_properties_1.StyleProperties.BORDER_STYLE);
                let borderColor = undefined;
                let borderWidth = undefined;
                if (borderStyle && borderStyle !== 'none') {
                    borderColor = this.styleProvider.getColorStyle(elementStyle, style_properties_1.StyleProperties.BORDER_COLOR);
                    if (borderColor === undefined) {
                        borderColor = { color: 0x000000, alpha: 1 };
                    }
                    borderWidth = this.styleProvider.getNumberStyle(elementStyle, style_properties_1.StyleProperties.BORDER_WIDTH);
                    if (borderWidth === undefined) {
                        borderWidth = 1;
                    }
                }
                return {
                    color: backgroundColor ? backgroundColor.color : 0x000000,
                    opacity: backgroundColor ? backgroundColor.alpha : 1.0,
                    height: height,
                    borderWidth: state.selected ? 2 : (borderWidth ? borderWidth : 0),
                    borderColor: state.selected ? 0xeef20c : (borderColor ? borderColor.color : 0x000000)
                };
            }
            return undefined;
        }
        return this.getDefaultStateStyle(state);
    }
    getDefaultStateStyle(state) {
        var _a;
        const styleProvider = new style_provider_1.StyleProvider(this.props.outputDescriptor.id, this.props.traceId, this.props.tspClient);
        const styles = styleProvider.getStylesTmp();
        const backupStyles = [
            {
                color: 0x3891A6,
                height: this.props.style.rowHeight * 0.8
            }, {
                color: 0x4C5B5C,
                height: this.props.style.rowHeight * 0.7
            }, {
                color: 0xFDE74C,
                height: this.props.style.rowHeight * 0.6
            }, {
                color: 0xDB5461,
                height: this.props.style.rowHeight * 0.5
            }, {
                color: 0xE3655B,
                height: this.props.style.rowHeight * 0.4
            }, {
                color: 0xEA8F87,
                height: this.props.style.rowHeight * 0.9
            }, {
                color: 0xDE636F,
                height: this.props.style.rowHeight * 0.3
            },
        ];
        let style = backupStyles[0];
        const val = (_a = state.label) !== null && _a !== void 0 ? _a : '';
        const modelData = state.data;
        if (modelData) {
            const outputStyle = modelData.style;
            if (!outputStyle) {
                return {
                    color: 0xCACACA,
                    height: this.props.style.rowHeight * 0.5,
                    borderWidth: state.selected ? 2 : 0,
                    borderColor: 0xeef20c
                };
            }
            const stateStyle = outputStyle;
            const elementStyle = styles[stateStyle.parentKey];
            if (elementStyle) {
                return {
                    color: parseInt(elementStyle.color, 16),
                    height: this.props.style.rowHeight * elementStyle.height,
                    borderWidth: state.selected ? 2 : 0,
                    borderColor: 0xeef20c
                };
            }
            style = this.styleMap.get(stateStyle.parentKey);
            if (style === undefined) {
                style = backupStyles[(Math.abs((0, value_hash_1.default)(stateStyle.parentKey)) % backupStyles.length)];
                this.styleMap.set(stateStyle.parentKey, style);
            }
            return {
                color: style.color,
                height: style.height,
                borderWidth: state.selected ? 2 : 0,
                borderColor: 0xeef20c
            };
        }
        style = this.styleMap.get(val);
        if (!style) {
            style = backupStyles[(this.styleMap.size % backupStyles.length)];
            this.styleMap.set(val, style);
        }
        return {
            color: style.color,
            height: style.height,
            borderWidth: state.selected ? 2 : 0,
            borderColor: 0xeef20c
        };
    }
    getAnnotationStyle(annotation) {
        const styleModel = this.state.styleModel;
        if (styleModel) {
            const metadata = annotation.data;
            if (metadata && metadata.style) {
                const elementStyle = metadata.style;
                const symbolType = this.styleProvider.getStyle(elementStyle, style_properties_1.StyleProperties.SYMBOL_TYPE);
                const color = this.styleProvider.getColorStyle(elementStyle, style_properties_1.StyleProperties.COLOR);
                const heightFactor = this.styleProvider.getNumberStyle(elementStyle, style_properties_1.StyleProperties.HEIGHT);
                let symbolSize = this.props.style.rowHeight * 0.8 / 2;
                if (heightFactor) {
                    symbolSize = heightFactor * symbolSize;
                }
                const vAlign = this.styleProvider.getStyle(elementStyle, style_properties_1.StyleProperties.VERTICAL_ALIGN);
                return {
                    symbol: symbolType ? symbolType : 'none',
                    size: symbolSize,
                    color: color ? color.color : 0x000000,
                    opacity: color ? color.alpha : 1.0,
                    verticalAlign: vAlign ? vAlign : 'middle'
                };
            }
        }
        return undefined;
    }
}
exports.TimegraphOutputComponent = TimegraphOutputComponent;
//# sourceMappingURL=timegraph-output-component.js.map