"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphRowController = void 0;
var TimeGraphRowController = /** @class */ (function () {
    function TimeGraphRowController(rowHeight, _totalHeight) {
        this.rowHeight = rowHeight;
        this._totalHeight = _totalHeight;
        this.selectedRowChangedHandlers = [];
        this.verticalOffsetChangedHandlers = [];
        this.totalHeightChangedHandlers = [];
        this._verticalOffset = 0;
    }
    TimeGraphRowController.prototype.handleVerticalOffsetChanged = function () {
        var _this = this;
        this.verticalOffsetChangedHandlers.forEach(function (h) { return h(_this._verticalOffset); });
    };
    TimeGraphRowController.prototype.handleSelectedRowChanged = function () {
        var _this = this;
        this.selectedRowChangedHandlers.forEach(function (h) { return h(_this._selectedRow); });
    };
    TimeGraphRowController.prototype.handleTotalHeightChanged = function () {
        var _this = this;
        this.totalHeightChangedHandlers.forEach(function (h) { return h(_this._totalHeight); });
    };
    TimeGraphRowController.prototype.onSelectedRowChangedHandler = function (handler) {
        this.selectedRowChangedHandlers.push(handler);
    };
    TimeGraphRowController.prototype.onVerticalOffsetChangedHandler = function (handler) {
        this.verticalOffsetChangedHandlers.push(handler);
    };
    TimeGraphRowController.prototype.onTotalHeightChangedHandler = function (handler) {
        this.totalHeightChangedHandlers.push(handler);
    };
    Object.defineProperty(TimeGraphRowController.prototype, "totalHeight", {
        get: function () {
            return this._totalHeight;
        },
        set: function (height) {
            this._totalHeight = height;
            this.handleTotalHeightChanged();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphRowController.prototype, "verticalOffset", {
        get: function () {
            return this._verticalOffset;
        },
        set: function (value) {
            this._verticalOffset = value;
            this.handleVerticalOffsetChanged();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TimeGraphRowController.prototype, "selectedRow", {
        get: function () {
            return this._selectedRow;
        },
        set: function (value) {
            this._selectedRow = value;
            this.handleSelectedRowChanged();
        },
        enumerable: false,
        configurable: true
    });
    return TimeGraphRowController;
}());
exports.TimeGraphRowController = TimeGraphRowController;
//# sourceMappingURL=time-graph-row-controller.js.map