"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphAnnotationComponent = void 0;
var time_graph_component_1 = require("./time-graph-component");
/*
 * This is only implementing a subset of the tick elements so far
 */
var TimeGraphAnnotationComponent = /** @class */ (function (_super) {
    __extends(TimeGraphAnnotationComponent, _super);
    function TimeGraphAnnotationComponent(id, model, _options, _style, _row, displayObject) {
        if (_style === void 0) { _style = { color: 0, size: 7, symbol: 'cross', verticalAlign: 'middle' }; }
        var _this = _super.call(this, id, displayObject, model) || this;
        _this._options = _options;
        _this._style = _style;
        _this._row = _row;
        _this._size = _style.size || 7;
        // called to ensure consistency. Only the X component is used from options.
        _this.update(_options);
        return _this;
    }
    TimeGraphAnnotationComponent.prototype.update = function (opts) {
        if (opts) {
            this._options.position.x = opts.position.x;
            this.updateYPosition();
        }
        _super.prototype.update.call(this);
    };
    Object.defineProperty(TimeGraphAnnotationComponent.prototype, "row", {
        get: function () {
            return this._row;
        },
        enumerable: false,
        configurable: true
    });
    TimeGraphAnnotationComponent.prototype.updateYPosition = function () {
        var align = this._style.verticalAlign;
        var size = this._style.size;
        if (!!size) {
            var offset = align == 'top' ? size : align == 'bottom' ? this._row.height - size : this._row.height / 2;
            this._options.position.y = this._row.position.y + (offset);
        }
    };
    TimeGraphAnnotationComponent.prototype.render = function () {
        var symbol = this._style.symbol;
        var size = this._size;
        var x = this._options.position.x;
        var y = this._options.position.y;
        if (symbol === undefined || symbol == 'none') {
            return;
        }
        if (symbol == 'circle') {
            this.drawCircle(x, y, size);
        }
        else if (symbol == 'cross') {
            this.drawCross(x, y, size);
        }
        else if (symbol == 'plus') {
            this.drawPlus(x, y, size);
        }
        else if (symbol == 'diamond') {
            this.drawDiamond(x, y, size);
        }
        else if (symbol == 'triangle') {
            this.drawTriangle(x, y, size);
        }
        else if (symbol == 'inverted-triangle') {
            this.drawInvertedTriangle(x, y, size);
        }
        else {
            this.drawPlus(x, y, size);
        }
    };
    TimeGraphAnnotationComponent.prototype.drawCircle = function (x, y, radius) {
        this._displayObject.clear();
        this._displayObject.beginFill(this._style.color, this.getPIXIOpacity(this._style.opacity));
        this._displayObject.lineStyle(0);
        this._displayObject.drawCircle(x, y, radius);
        this._displayObject.endFill();
        //this._displayObject.cacheAsBitmap = true;
    };
    // thickness = 20
    TimeGraphAnnotationComponent.prototype.drawCross = function (x, y, size) {
        this._displayObject.clear();
        this._displayObject.beginFill(this._style.color, this.getPIXIOpacity(this._style.opacity));
        this._displayObject.lineStyle(0);
        // Root of two thickness
        var thickness = 0.14 * size;
        this._displayObject.drawPolygon([
            x - size, y - size + thickness,
            x - thickness, y,
            x - size, y + size - thickness,
            x - size + thickness, y + size,
            x, y + thickness,
            x + size - thickness, y + size,
            x + size, y + size - thickness,
            x + thickness, y,
            x + size, y - size + thickness,
            x + size - thickness, y - size,
            x, y - thickness,
            x - size + thickness, y - size,
            x - size, y - size + thickness,
        ]);
        this._displayObject.endFill();
        //this._displayObject.cacheAsBitmap = true;
    };
    // thickness = 20%
    TimeGraphAnnotationComponent.prototype.drawPlus = function (x, y, size) {
        this._displayObject.clear();
        this._displayObject.beginFill(this._style.color, this.getPIXIOpacity(this._style.opacity));
        this._displayObject.lineStyle(0);
        // half thickness
        var thickness = 0.1 * size;
        this._displayObject.drawPolygon([
            x - thickness, y - size,
            x - thickness, y - thickness,
            x - size, y - thickness,
            x - size, y + thickness,
            x - thickness, y + thickness,
            x - thickness, y + size,
            x + thickness, y + size,
            x + thickness, y + thickness,
            x + size, y + thickness,
            x + size, y - thickness,
            x + thickness, y - thickness,
            x + thickness, y - size,
            x - thickness, y - size,
        ]);
        this._displayObject.endFill();
        //this._displayObject.cacheAsBitmap = true;
    };
    TimeGraphAnnotationComponent.prototype.drawDiamond = function (x, y, size) {
        this._displayObject.clear();
        this._displayObject.beginFill(this._style.color, this.getPIXIOpacity(this._style.opacity));
        this._displayObject.lineStyle(0);
        this._displayObject.drawPolygon([
            x - size, y,
            x, y - size,
            x + size, y,
            x, y + size,
            x - size, y
        ]);
        this._displayObject.endFill();
        //this._displayObject.cacheAsBitmap = true;
    };
    TimeGraphAnnotationComponent.prototype.drawTriangle = function (x, y, size) {
        this._displayObject.clear();
        this._displayObject.beginFill(this._style.color, this.getPIXIOpacity(this._style.opacity));
        this._displayObject.lineStyle(0);
        this._displayObject.drawPolygon([
            x - size, y + size,
            x, y - size,
            x + size, y + size
        ]);
        this._displayObject.endFill();
        //this._displayObject.cacheAsBitmap = true;
    };
    TimeGraphAnnotationComponent.prototype.drawInvertedTriangle = function (x, y, size) {
        this._displayObject.clear();
        this._displayObject.beginFill(this._style.color, this.getPIXIOpacity(this._style.opacity));
        this._displayObject.lineStyle(0);
        this._displayObject.drawPolygon([
            x + size, y - size,
            x, y + size,
            x - size, y - size
        ]);
        this._displayObject.endFill();
        //this._displayObject.cacheAsBitmap = true;
    };
    return TimeGraphAnnotationComponent;
}(time_graph_component_1.TimeGraphComponent));
exports.TimeGraphAnnotationComponent = TimeGraphAnnotationComponent;
//# sourceMappingURL=time-graph-annotation.js.map