"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MemoryWidgetManager = void 0;
/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
const core_1 = require("@theia/core");
const browser_1 = require("@theia/core/lib/browser");
const inversify_1 = require("@theia/core/shared/inversify");
const memory_diff_table_widget_1 = require("../diff-widget/memory-diff-table-widget");
const memory_widget_1 = require("../memory-widget/memory-widget");
const register_widget_types_1 = require("../register-widget/register-widget-types");
let MemoryWidgetManager = class MemoryWidgetManager {
    constructor() {
        this.createdWidgetCount = 0;
        this.widgetDisplayId = 0;
        this.toDispose = new core_1.DisposableCollection();
        this.onNewWidgetCreated = new core_1.Emitter();
        this.onDidCreateNewWidget = this.onNewWidgetCreated.event;
        this.onSelectedWidgetChanged = new core_1.Emitter();
        this.onDidChangeSelectedWidget = this.onSelectedWidgetChanged.event;
        this.onChangedEmitter = new core_1.Emitter();
        this.onChanged = this.onChangedEmitter.event;
        this._availableWidgets = new Map();
        this._canCompare = false;
    }
    get availableWidgets() {
        return Array.from(this._availableWidgets.values());
    }
    get canCompare() {
        return this._canCompare;
    }
    init() {
        this.toDispose.pushAll([
            this.shell.onDidChangeActiveWidget(({ newValue }) => {
                if (newValue instanceof memory_widget_1.MemoryWidget) {
                    this._focusedWidget = newValue;
                }
            }),
            this.widgetManager.onDidCreateWidget(e => {
                const { widget } = e;
                if (widget instanceof memory_widget_1.MemoryWidget) {
                    this._availableWidgets.set(widget.id, widget);
                    this.toDispose.push(widget.onDidDispose(() => {
                        this._availableWidgets.delete(widget.id);
                        if (widget === this._focusedWidget) {
                            this.focusedWidget = undefined;
                        }
                        this.onChangedEmitter.fire();
                    }));
                }
            }),
            this.onChanged(() => this.setCanCompare()),
            this.onNewWidgetCreated,
            this.onChangedEmitter,
            this.onSelectedWidgetChanged,
        ]);
    }
    get focusedWidget() {
        var _a;
        return (_a = this._focusedWidget) !== null && _a !== void 0 ? _a : this._availableWidgets.values().next().value;
    }
    set focusedWidget(title) {
        this._focusedWidget = title;
        this.onSelectedWidgetChanged.fire(title);
    }
    setCanCompare() {
        this._canCompare = this.availableWidgets.filter(widget => !register_widget_types_1.RegisterWidget.is(widget) && !memory_diff_table_widget_1.MemoryDiffWidget.is(widget)).length > 1;
    }
    async createNewMemoryWidget(kind = 'memory') {
        this.widgetDisplayId = this._availableWidgets.size !== 0 ? this.widgetDisplayId + 1 : 1;
        const options = { identifier: this.createdWidgetCount += 1, displayId: this.widgetDisplayId };
        const widgetId = kind === 'memory'
            ? memory_widget_1.MemoryWidget.ID
            : register_widget_types_1.RegisterWidget.ID;
        const widget = await this.widgetManager.getOrCreateWidget(widgetId, options);
        this._availableWidgets.set(widget.id, widget);
        widget.title.changed.connect(() => this.onChangedEmitter.fire());
        widget.activate();
        this.fireNewWidget(widget);
        return widget;
    }
    dispose() {
        this.toDispose.dispose();
    }
    fireNewWidget(widget) {
        this.onNewWidgetCreated.fire(widget);
        this.onChangedEmitter.fire();
    }
    async doDiff(options) {
        if (options.beforeBytes.length === 0) {
            this.messageService.warn(`You must load memory in both widgets you would like to compare. ${options.titles[0]} has no memory loaded.`);
            return undefined;
        }
        else if (options.afterBytes.length === 0) {
            this.messageService.warn(`You must load memory in both widgets you would like to compare. ${options.titles[1]} has no memory loaded.`);
            return undefined;
        }
        const fullOptions = Object.assign(Object.assign({}, options), { dynamic: false, identifier: options.titles.join('-') });
        const existingWidget = this._availableWidgets.get(memory_widget_1.MemoryWidget.getIdentifier(fullOptions.identifier.toString()));
        if (existingWidget && existingWidget.tableWidget instanceof memory_diff_table_widget_1.MemoryDiffTableWidget) {
            existingWidget.tableWidget.updateDiffData(options);
        }
        const widget = existingWidget !== null && existingWidget !== void 0 ? existingWidget : await this.widgetManager
            .getOrCreateWidget(memory_diff_table_widget_1.MemoryDiffWidget.ID, Object.assign(Object.assign({}, options), { dynamic: false, identifier: options.titles.join('-') }));
        const tabBar = this.shell.getTabBarFor(widget);
        if (!tabBar) {
            // The widget is not attached yet, so add it to the shell
            const widgetArgs = {
                area: 'main',
            };
            await this.shell.addWidget(widget, widgetArgs);
        }
        await this.shell.activateWidget(widget.id);
        return widget;
    }
};
__decorate([
    inversify_1.inject(browser_1.WidgetManager),
    __metadata("design:type", browser_1.WidgetManager)
], MemoryWidgetManager.prototype, "widgetManager", void 0);
__decorate([
    inversify_1.inject(browser_1.ApplicationShell),
    __metadata("design:type", browser_1.ApplicationShell)
], MemoryWidgetManager.prototype, "shell", void 0);
__decorate([
    inversify_1.inject(core_1.MessageService),
    __metadata("design:type", core_1.MessageService)
], MemoryWidgetManager.prototype, "messageService", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], MemoryWidgetManager.prototype, "init", null);
MemoryWidgetManager = __decorate([
    inversify_1.injectable()
], MemoryWidgetManager);
exports.MemoryWidgetManager = MemoryWidgetManager;
//# sourceMappingURL=memory-widget-manager.js.map