"use strict";
// *****************************************************************************
// Copyright (C) 2022 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ValidatedPreferenceProxy = void 0;
const inversify_1 = require("inversify");
const injectable_preference_proxy_1 = require("./injectable-preference-proxy");
const preference_language_override_service_1 = require("./preference-language-override-service");
const preference_provider_1 = require("./preference-provider");
const preference_validation_service_1 = require("./preference-validation-service");
let ValidatedPreferenceProxy = class ValidatedPreferenceProxy extends injectable_preference_proxy_1.InjectablePreferenceProxy {
    handlePreferenceChanges(changes) {
        var _a, _b;
        if (this.schema) {
            ;
            const overrideTracker = new Map();
            for (const change of Object.values(changes)) {
                const overridden = this.preferences.overriddenPreferenceName(change.preferenceName);
                if (this.isRelevantChange(change, overridden)) {
                    let doSet = false;
                    const baseName = (_a = overridden === null || overridden === void 0 ? void 0 : overridden.preferenceName) !== null && _a !== void 0 ? _a : change.preferenceName;
                    const tracker = (_b = overrideTracker.get(baseName)) !== null && _b !== void 0 ? _b : (doSet = true, { overrides: [] });
                    if (overridden) {
                        tracker.overrides.push(overridden);
                    }
                    if (doSet) {
                        overrideTracker.set(baseName, tracker);
                    }
                }
            }
            for (const [baseName, tracker] of overrideTracker.entries()) {
                const validated = [];
                // This could go wrong if someone sets a lot of different, complex values for different language overrides simultaneously.
                // In the normal case, we'll just be doing strict equal checks on primitives.
                const getValidValue = (name) => {
                    var _a;
                    const configuredForCurrent = changes[name].newValue;
                    const existingValue = validated.find(([configuredForValid]) => preference_provider_1.PreferenceProvider.deepEqual(configuredForValid, configuredForCurrent));
                    if (existingValue) {
                        (_a = this.validPreferences) === null || _a === void 0 ? void 0 : _a.set(name, existingValue[1]);
                        return existingValue[1];
                    }
                    const validValue = this.ensureValid(name, () => configuredForCurrent, true);
                    validated.push([configuredForCurrent, validValue]);
                    return validValue;
                };
                if (baseName in changes && this.isRelevantChange(changes[baseName])) {
                    const newValue = getValidValue(baseName);
                    const { domain, oldValue, preferenceName, scope } = changes[baseName];
                    this.fireChangeEvent(this.buildNewChangeEvent({ domain, oldValue, preferenceName, scope, newValue }));
                }
                for (const override of tracker.overrides) {
                    const name = this.preferences.overridePreferenceName(override);
                    const { domain, oldValue, preferenceName, scope } = changes[name];
                    const newValue = getValidValue(name);
                    this.fireChangeEvent(this.buildNewChangeEvent({ domain, oldValue, preferenceName, scope, newValue }, override));
                }
            }
        }
    }
    getValue(preferenceIdentifier, defaultValue, resourceUri = this.resourceUri) {
        const preferenceName = preference_language_override_service_1.OverridePreferenceName.is(preferenceIdentifier) ? this.preferences.overridePreferenceName(preferenceIdentifier) : preferenceIdentifier;
        return this.ensureValid(preferenceName, () => { var _a; return ((_a = super.getValue(preferenceIdentifier, defaultValue, resourceUri)) !== null && _a !== void 0 ? _a : defaultValue); }, false);
    }
    ensureValid(preferenceName, getCandidate, isChange) {
        var _a, _b;
        if (!isChange && ((_a = this.validPreferences) === null || _a === void 0 ? void 0 : _a.has(preferenceName))) {
            return this.validPreferences.get(preferenceName);
        }
        const candidate = getCandidate();
        const valid = this.validator.validateByName(preferenceName, candidate);
        (_b = this.validPreferences) === null || _b === void 0 ? void 0 : _b.set(preferenceName, valid);
        return valid;
    }
    subscribeToChangeEvents() {
        var _a;
        (_a = this.validPreferences) !== null && _a !== void 0 ? _a : (this.validPreferences = new Map());
        super.subscribeToChangeEvents();
    }
    dispose() {
        var _a;
        super.dispose();
        if (this.options.isDisposable) {
            (_a = this.validPreferences) === null || _a === void 0 ? void 0 : _a.clear();
        }
    }
};
__decorate([
    (0, inversify_1.inject)(preference_validation_service_1.PreferenceValidationService),
    __metadata("design:type", preference_validation_service_1.PreferenceValidationService)
], ValidatedPreferenceProxy.prototype, "validator", void 0);
ValidatedPreferenceProxy = __decorate([
    (0, inversify_1.injectable)()
], ValidatedPreferenceProxy);
exports.ValidatedPreferenceProxy = ValidatedPreferenceProxy;
//# sourceMappingURL=validated-preference-proxy.js.map