/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.surround;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.util.SurroundWithAnalyzer;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.surround.ExceptionAnalyzer;

public class SurroundWithTryCatchAnalyzer
extends SurroundWithAnalyzer {
    private ITypeBinding[] fExceptions;

    public SurroundWithTryCatchAnalyzer(ICompilationUnit unit, Selection selection) throws CoreException {
        super(unit, selection, true);
    }

    public ITypeBinding[] getExceptions() {
        return this.fExceptions;
    }

    public void endVisit(CompilationUnit node) {
        ASTNode enclosingNode = null;
        if (!this.getStatus().hasFatalError() && this.hasSelectedNodes()) {
            enclosingNode = SurroundWithTryCatchAnalyzer.getEnclosingNode((ASTNode)this.getFirstSelectedNode());
        }
        super.endVisit(node);
        if (enclosingNode != null && !this.getStatus().hasFatalError()) {
            this.fExceptions = ExceptionAnalyzer.perform(enclosingNode, this.getSelection());
            if (this.fExceptions == null || this.fExceptions.length == 0) {
                if (enclosingNode instanceof MethodReference) {
                    this.invalidSelection(RefactoringCoreMessages.SurroundWithTryCatchAnalyzer_doesNotContain);
                } else {
                    this.fExceptions = new ITypeBinding[]{node.getAST().resolveWellKnownType("java.lang.Exception")};
                }
            }
        }
    }
}

