/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.StatusFactory;

public final class ResourceUtils {
    public static final String FILE_UNC_PREFIX = "file:////";

    private ResourceUtils() {
    }

    public static List<IMarker> findMarkers(IResource resource, Integer ... severities) throws CoreException {
        if (resource == null) {
            return null;
        }
        HashSet<Integer> targetSeverities = severities == null ? Collections.emptySet() : new HashSet<Integer>(Arrays.asList(severities));
        IMarker[] allmarkers = resource.findMarkers(null, true, 2);
        List<IMarker> markers = Stream.of(allmarkers).filter(m -> targetSeverities.isEmpty() || targetSeverities.contains(m.getAttribute("severity", 0))).collect(Collectors.toList());
        return markers;
    }

    public static List<IMarker> getErrorMarkers(IResource resource) throws CoreException {
        return ResourceUtils.findMarkers(resource, 2);
    }

    public static List<IMarker> getWarningMarkers(IResource resource) throws CoreException {
        return ResourceUtils.findMarkers(resource, 1);
    }

    public static String toString(List<IMarker> markers) {
        if (markers == null || markers.isEmpty()) {
            return "";
        }
        String s = markers.stream().map(m -> ResourceUtils.toString(m)).collect(Collectors.joining(", "));
        return s;
    }

    public static String getMessage(IMarker marker) {
        if (marker == null) {
            return null;
        }
        return marker.getAttribute("message", null);
    }

    public static String toString(IMarker marker) {
        if (marker == null) {
            return null;
        }
        try {
            StringBuilder sb = new StringBuilder("Type=").append(marker.getType()).append(":Message=").append(marker.getAttribute("message")).append(":LineNumber=").append(marker.getAttribute("lineNumber"));
            return sb.toString();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return "Unknown marker";
        }
    }

    public static String getContent(URI fileURI) throws CoreException {
        String content;
        if (fileURI == null) {
            return null;
        }
        try {
            content = Files.readString(ResourceUtils.toFile(fileURI).toPath());
        }
        catch (IOException e) {
            throw new CoreException(StatusFactory.newErrorStatus("Can not get " + String.valueOf(fileURI) + " content", e));
        }
        return content;
    }

    public static void setContent(URI fileURI, String content) throws CoreException {
        if (content == null) {
            content = "";
        }
        try {
            Files.writeString(ResourceUtils.toFile(fileURI).toPath(), (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new CoreException(StatusFactory.newErrorStatus("Can not write to " + String.valueOf(fileURI), e));
        }
    }

    public static String getContent(IFile file) throws CoreException {
        String content;
        if (file == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStreamReader reader = new InputStreamReader(file.getContents());){
                content = CharStreams.toString((Readable)reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(StatusFactory.newErrorStatus("Can not get " + String.valueOf(file.getRawLocation()) + " content", e));
        }
        return content;
    }

    public static void setContent(IFile file, String content) throws CoreException {
        Assert.isNotNull((Object)file, (String)"file can not be null");
        if (content == null) {
            content = "";
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayInputStream newContent = new ByteArrayInputStream(content.getBytes());){
                file.setContents((InputStream)newContent, 1, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(StatusFactory.newErrorStatus("Can not write to " + String.valueOf(file.getRawLocation()), e));
        }
    }

    public static String fixURI(URI uri) {
        if (uri == null) {
            return null;
        }
        if ("win32".equals(Platform.getOS()) && URIUtil.isFileURI((URI)uri)) {
            uri = URIUtil.toFile((URI)uri).toURI();
        }
        String uriString = uri.toString();
        return uriString.replaceFirst("file:/([^/])", "file:///$1");
    }

    public static File toFile(URI uri) {
        if ("win32".equals(Platform.getOS())) {
            return URIUtil.toFile((URI)uri);
        }
        return new File(uri);
    }

    public static String toClientUri(String uri) {
        if (uri != null && "win32".equals(Platform.getOS()) && uri.startsWith(FILE_UNC_PREFIX)) {
            uri = uri.replace(FILE_UNC_PREFIX, "file://");
        }
        return uri;
    }

    public static IPath filePathFromURI(String uriStr) {
        URI uri = URI.create(uriStr);
        if ("file".equals(uri.getScheme())) {
            return Path.fromOSString((String)Paths.get(uri).toString());
        }
        return null;
    }

    public static IPath canonicalFilePathFromURI(String uriStr) {
        URI uri = URI.create(uriStr);
        if ("file".equals(uri.getScheme())) {
            try {
                uri = new URI(uri.getScheme(), null, uri.getPath(), null, null);
            }
            catch (URISyntaxException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
            return FileUtil.canonicalPath((IPath)Path.fromOSString((String)Paths.get(uri).toString()));
        }
        return null;
    }

    public static boolean isContainedIn(IPath location, Collection<IPath> paths) {
        if (location == null || paths == null || paths.isEmpty()) {
            return false;
        }
        for (IPath path : paths) {
            if (!path.isPrefixOf(location)) continue;
            return true;
        }
        return false;
    }

    public static String expandPath(String path) {
        if (path != null) {
            if (((String)path).startsWith("~" + File.separator)) {
                path = System.getProperty("user.home") + ((String)path).substring(1);
            }
            StrLookup<String> variableResolver = new StrLookup<String>(){

                public String lookup(String key) {
                    if (key.length() > 0) {
                        try {
                            String prop = System.getProperty(key);
                            if (prop != null) {
                                return prop;
                            }
                            return System.getenv(key);
                        }
                        catch (SecurityException scex) {
                            return null;
                        }
                    }
                    return null;
                }
            };
            StrSubstitutor strSubstitutor = new StrSubstitutor((StrLookup)variableResolver);
            return strSubstitutor.replace((String)path);
        }
        return path;
    }

    public static String toGlobPattern(IPath path) {
        if (path == null) {
            return null;
        }
        String baseName = path.lastSegment();
        return ResourceUtils.toGlobPattern(path, !baseName.endsWith(".jar") && !baseName.endsWith(".zip"));
    }

    public static String toGlobPattern(IPath path, boolean recursive) {
        File file;
        if (path == null) {
            return null;
        }
        Object globPattern = path.toPortableString();
        if (path.getDevice() != null) {
            globPattern = ((String)globPattern).replace(path.getDevice(), "**");
        }
        if (recursive && !(file = path.toFile()).isFile()) {
            if (!((String)globPattern).endsWith("/")) {
                globPattern = (String)globPattern + "/";
            }
            globPattern = (String)globPattern + "**";
        }
        return globPattern;
    }

    public static String dos2Unix(String str) {
        if (str != null && "win32".equals(Platform.getOS())) {
            str = str.replaceAll("\\r", "");
        }
        return str;
    }

    public static IPath getLongestCommonPath(IPath[] paths) {
        if (paths == null || paths.length == 0) {
            return null;
        }
        int common = paths[0].segmentCount() - 1;
        int i = 1;
        while (i < paths.length) {
            common = Math.min(paths[i].segmentCount() - 1, common);
            if (common <= 0 || !Objects.equals(paths[0].getDevice(), paths[i].getDevice())) {
                return null;
            }
            int j = 0;
            while (j < common) {
                if (!Objects.equals(paths[i].segment(j), paths[0].segment(j))) {
                    common = j;
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (common <= 0) {
            return null;
        }
        return paths[0].uptoSegment(common);
    }

    public static void createErrorMarker(IResource resource, IStatus status, String id) throws CoreException {
        IMarker marker = resource.createMarker(id);
        marker.setAttribute("lineNumber", 1);
        marker.setAttribute("message", (Object)status.getMessage());
        marker.setAttribute("severity", 2);
    }

    public static IMarker createWarningMarker(String type, IResource resource, String message, int id, int line) throws CoreException {
        IMarker marker = resource.createMarker(type);
        marker.setAttribute("id", id);
        marker.setAttribute("lineNumber", line);
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("severity", 1);
        return marker;
    }

    public static boolean isUnresolvedImportError(IMarker marker) {
        return marker.getAttribute("severity", 0) == 2 && marker.getAttribute("id", 0) == 268435846;
    }
}

