/**
 * Copyright (c) 2016-2018 TypeFox and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j;

import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.lsp4j.util.Preconditions;
import org.eclipse.lsp4j.util.ToStringBuilder;

/**
 * Since 3.17.0
 */
@SuppressWarnings("all")
public class InsertReplaceRange {
  /**
   * The range if the insert is requested
   */
  @NonNull
  private Range insert;

  /**
   * The range if the replace is requested.
   */
  @NonNull
  private Range replace;

  public InsertReplaceRange() {
  }

  public InsertReplaceRange(@NonNull final Range insert, @NonNull final Range replace) {
    this.insert = Preconditions.<Range>checkNotNull(insert, "insert");
    this.replace = Preconditions.<Range>checkNotNull(replace, "replace");
  }

  /**
   * The range if the insert is requested
   */
  @NonNull
  public Range getInsert() {
    return this.insert;
  }

  /**
   * The range if the insert is requested
   */
  public void setInsert(@NonNull final Range insert) {
    this.insert = Preconditions.checkNotNull(insert, "insert");
  }

  /**
   * The range if the replace is requested.
   */
  @NonNull
  public Range getReplace() {
    return this.replace;
  }

  /**
   * The range if the replace is requested.
   */
  public void setReplace(@NonNull final Range replace) {
    this.replace = Preconditions.checkNotNull(replace, "replace");
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("insert", this.insert);
    b.add("replace", this.replace);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    InsertReplaceRange other = (InsertReplaceRange) obj;
    if (this.insert == null) {
      if (other.insert != null)
        return false;
    } else if (!this.insert.equals(other.insert))
      return false;
    if (this.replace == null) {
      if (other.replace != null)
        return false;
    } else if (!this.replace.equals(other.replace))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.insert== null) ? 0 : this.insert.hashCode());
    return prime * result + ((this.replace== null) ? 0 : this.replace.hashCode());
  }
}
