/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditUtil;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileVersionerCore;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class FormatterHandler {
    private static final char CLOSING_BRACE = '}';
    private static final char NEW_LINE = '\n';
    private PreferenceManager preferenceManager;

    public FormatterHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<? extends org.eclipse.lsp4j.TextEdit> formatting(DocumentFormattingParams params, IProgressMonitor monitor) {
        return this.format(params.getTextDocument().getUri(), params.getOptions(), null, monitor);
    }

    public List<? extends org.eclipse.lsp4j.TextEdit> rangeFormatting(DocumentRangeFormattingParams params, IProgressMonitor monitor) {
        return this.format(params.getTextDocument().getUri(), params.getOptions(), params.getRange(), monitor);
    }

    private List<org.eclipse.lsp4j.TextEdit> format(String uri, FormattingOptions options, Range range, IProgressMonitor monitor) {
        if (!this.preferenceManager.getPreferences().isJavaFormatEnabled()) {
            return Collections.emptyList();
        }
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit(uri);
        if (cu == null) {
            return Collections.emptyList();
        }
        Region region = null;
        IDocument document = null;
        try {
            document = JsonRpcHelpers.toDocument(cu.getBuffer());
            if (document != null) {
                region = range == null ? new Region(0, document.getLength()) : this.getRegion(range, document);
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        if (region == null) {
            return Collections.emptyList();
        }
        return this.format(cu, document, (IRegion)region, options, this.preferenceManager.getPreferences().isJavaFormatComments(), monitor);
    }

    private List<org.eclipse.lsp4j.TextEdit> format(ICompilationUnit cu, IDocument document, IRegion region, FormattingOptions options, boolean includeComments, IProgressMonitor monitor) {
        if (cu == null || document == null || region == null || monitor.isCanceled()) {
            return Collections.emptyList();
        }
        CodeFormatter formatter = ToolFactory.createCodeFormatter(FormatterHandler.getOptions(options, cu));
        String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        String sourceToFormat = document.get();
        int kind = this.getFormattingKind(cu, includeComments);
        TextEdit format = formatter.format(kind, sourceToFormat, region.getOffset(), region.getLength(), 0, lineDelimiter);
        if (format == null || format.getChildren().length == 0 || monitor.isCanceled()) {
            return Collections.emptyList();
        }
        MultiTextEdit flatEdit = TextEditUtil.flatten((TextEdit)format);
        return FormatterHandler.convertEdits(flatEdit.getChildren(), document);
    }

    private int getFormattingKind(ICompilationUnit cu, boolean includeComments) {
        int kind;
        int n = kind = includeComments ? 4096 : 0;
        kind = cu.getResource() != null && cu.getResource().getName().equals("module-info.java") ? (kind |= 0x80) : (kind |= 8);
        return kind;
    }

    private IRegion getRegion(Range range, IDocument document) {
        try {
            int offset = document.getLineOffset(range.getStart().getLine()) + range.getStart().getCharacter();
            int endOffset = document.getLineOffset(range.getEnd().getLine()) + range.getEnd().getCharacter();
            int length = endOffset - offset;
            return new Region(offset, length);
        }
        catch (BadLocationException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return null;
        }
    }

    public static Map<String, String> getOptions(FormattingOptions options, ICompilationUnit cu) {
        boolean insertSpaces;
        int tSize;
        Map eclipseOptions = cu.getOptions(true);
        Map<String, String> customOptions = options.entrySet().stream().filter(map -> FormatterHandler.chekIfValueIsNotNull((Either3<String, Number, Boolean>)((Either3)map.getValue()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> FormatterHandler.getOptionValue((Either3<String, Number, Boolean>)((Either3)e.getValue()))));
        eclipseOptions.putAll(customOptions);
        Integer tabSize = options.getTabSize();
        if (tabSize != null && (tSize = tabSize.intValue()) > 0) {
            eclipseOptions.put("org.eclipse.jdt.core.formatter.tabulation.size", Integer.toString(tSize));
        }
        eclipseOptions.put("org.eclipse.jdt.core.formatter.tabulation.char", (insertSpaces = options.isInsertSpaces()) ? "space" : "tab");
        return eclipseOptions;
    }

    private static boolean chekIfValueIsNotNull(Either3<String, Number, Boolean> value) {
        return value.getFirst() != null || value.getSecond() != null || value.getThird() != null;
    }

    private static String getOptionValue(Either3<String, Number, Boolean> option) {
        if (option.isFirst()) {
            return (String)option.getFirst();
        }
        if (option.isSecond()) {
            return ((Number)option.getSecond()).toString();
        }
        return ((Boolean)option.getThird()).toString();
    }

    private static List<org.eclipse.lsp4j.TextEdit> convertEdits(TextEdit[] edits, IDocument document) {
        return Arrays.stream(edits).map(t -> FormatterHandler.convertEdit(t, document)).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    private static org.eclipse.lsp4j.TextEdit convertEdit(TextEdit edit, IDocument document) {
        org.eclipse.lsp4j.TextEdit textEdit = new org.eclipse.lsp4j.TextEdit();
        TextEdit textEdit2 = edit;
        if (textEdit2 instanceof ReplaceEdit) {
            void replaceEdit;
            ReplaceEdit replaceEdit2 = (ReplaceEdit)textEdit2;
            ReplaceEdit cfr_ignored_0 = (ReplaceEdit)textEdit2;
            textEdit.setNewText(replaceEdit.getText());
            int offset = edit.getOffset();
            textEdit.setRange(new Range(FormatterHandler.createPosition(document, offset), FormatterHandler.createPosition(document, offset + edit.getLength())));
        }
        return textEdit;
    }

    private static Position createPosition(IDocument document, int offset) {
        Position start = new Position();
        try {
            int lineOfOffset = document.getLineOfOffset(offset);
            start.setLine(Integer.valueOf(lineOfOffset).intValue());
            start.setCharacter(Integer.valueOf(offset - document.getLineOffset(lineOfOffset)).intValue());
        }
        catch (BadLocationException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        return start;
    }

    public List<? extends org.eclipse.lsp4j.TextEdit> onTypeFormatting(DocumentOnTypeFormattingParams params, IProgressMonitor monitor) {
        return this.format(params.getTextDocument().getUri(), params.getOptions(), params.getPosition(), params.getCh(), monitor);
    }

    private List<? extends org.eclipse.lsp4j.TextEdit> format(String uri, FormattingOptions options, Position position, String triggerChar, IProgressMonitor monitor) {
        if (!this.preferenceManager.getPreferences().isJavaFormatOnTypeEnabled()) {
            return Collections.emptyList();
        }
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit(uri);
        if (cu == null) {
            return Collections.emptyList();
        }
        IRegion region = null;
        IDocument document = null;
        try {
            document = JsonRpcHelpers.toDocument(cu.getBuffer());
            if (document != null && position != null) {
                region = this.getRegion(cu, document, position, triggerChar);
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        if (region == null) {
            return Collections.emptyList();
        }
        return this.format(cu, document, region, options, false, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRegion getRegion(ICompilationUnit cu, IDocument document, Position position, String trigger) {
        try {
            int endLineLength;
            int lineOffset;
            int line = position.getLine();
            int offset = document.getLineOffset(line);
            int length = position.getCharacter();
            char triggerChar = '\u0000';
            if (trigger != null && !trigger.isEmpty()) {
                triggerChar = trigger.charAt(0);
                if ('\n' == triggerChar && (document.getChar(offset + length) != triggerChar || length == 0) && line > 0) {
                    int prevLine = line - 1;
                    offset = document.getLineOffset(prevLine);
                    length = document.getLineLength(prevLine);
                    line = prevLine;
                }
            } else {
                triggerChar = document.getChar(offset + length);
            }
            boolean emptyLine = false;
            if ('\n' == triggerChar) {
                int[] lines;
                int[] nArray;
                if (line > 0) {
                    int[] nArray2 = new int[2];
                    nArray2[0] = line;
                    nArray = nArray2;
                    nArray2[1] = line - 1;
                } else {
                    int[] nArray3 = new int[1];
                    nArray = nArray3;
                    nArray3[0] = line;
                }
                int[] nArray4 = lines = nArray;
                int n = lines.length;
                int n2 = 0;
                block2: while (n2 < n) {
                    char ch;
                    int l = nArray4[n2];
                    lineOffset = document.getLineOffset(l);
                    int maxPosition = document.getLineLength(l) - 1;
                    emptyLine = false;
                    int pos = maxPosition;
                    while (true) {
                        if (pos < 0) {
                            emptyLine = true;
                            ++n2;
                            continue block2;
                        }
                        ch = document.getChar(lineOffset + pos);
                        if (!Character.isWhitespace(ch)) break;
                        --pos;
                    }
                    length = ch == '}' ? pos + 1 : maxPosition;
                    offset = lineOffset;
                    triggerChar = ch;
                    break;
                }
            }
            if (triggerChar != '}') {
                if (emptyLine) return null;
                return new Region(offset, length);
            }
            CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)cu, CoreASTProvider.WAIT_YES, null);
            if (astRoot == null) {
                return null;
            }
            NodeFinder finder = new NodeFinder((ASTNode)astRoot, offset, length);
            ASTNode block = finder.getCoveredNode();
            if (block == null) {
                block = finder.getCoveringNode();
            }
            if (block == null) return null;
            int blockStartPosition = block.getStartPosition();
            int lineOfBlock = document.getLineOfOffset(blockStartPosition);
            lineOffset = document.getLineOffset(lineOfBlock);
            int blockLength = block.getLength();
            int endLine = document.getLineOfOffset(blockStartPosition + blockLength);
            int endLineOffset = document.getLineOffset(endLine);
            if (document.getChar(endLineOffset + (endLineLength = document.getLineLength(endLine)) - 1) == '\n') {
                --endLineLength;
            }
            int lastPosition = document.getLineOffset(endLine) + endLineLength;
            int totalLength = lastPosition - lineOffset;
            return new Region(lineOffset, totalLength);
        }
        catch (BadLocationException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        return null;
    }

    public String stringFormatting(String content, Map<String, String> options, int version, IProgressMonitor monitor) {
        TextEdit edit;
        Document document = new Document();
        document.set(content);
        Map formatOptions = options == null ? FormatterHandler.getCombinedDefaultFormatterSettings() : ProfileVersionerCore.updateAndComplete(options, (int)version);
        CodeFormatter formatter = ToolFactory.createCodeFormatter((Map)formatOptions);
        Region region = new Region(0, document.getLength());
        int kind = 8;
        if (this.preferenceManager.getPreferences().isJavaFormatComments()) {
            kind |= 0x1000;
        }
        if ((edit = formatter.format(kind, content, region.getOffset(), region.getLength(), 0, TextUtilities.getDefaultLineDelimiter((IDocument)document))) != null) {
            try {
                edit.apply((IDocument)document);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return document.get();
    }

    public static Map<String, String> getCombinedDefaultFormatterSettings() {
        Map options = DefaultCodeFormatterOptions.getEclipseDefaultSettings().getMap();
        options.putAll(FormatterHandler.getJavaLSDefaultFormatterSettings());
        return options;
    }

    public static Map<String, String> getJavaLSDefaultFormatterSettings() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.jdt.core.formatter.join_wrapped_lines", "false");
        options.put("org.eclipse.jdt.core.formatter.join_lines_in_comments", "false");
        options.put("org.eclipse.jdt.core.formatter.indent_switchstatements_compare_to_switch", "true");
        options.put("org.eclipse.jdt.core.formatter.use_on_off_tags", "true");
        return options;
    }
}

