/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.sef.SelfEncapsulateFieldRefactoring;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ChangeCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.ltk.core.refactoring.Change;

public class GetterSetterCorrectionSubProcessor {
    public static boolean addGetterSetterProposal(IInvocationContext context, ASTNode coveringNode, IProblemLocationCore[] locations, ArrayList<ChangeCorrectionProposal> resultingCollections) {
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                int problemId = locations[i].getProblemId();
                if (problemId == 570425421) {
                    return false;
                }
                if (problemId == 570425423) {
                    return false;
                }
                ++i;
            }
        }
        return GetterSetterCorrectionSubProcessor.addGetterSetterProposal(context, coveringNode, resultingCollections, 7);
    }

    public static void addGetterSetterProposal(IInvocationContext context, IProblemLocationCore location, Collection<ChangeCorrectionProposal> proposals, int relevance) {
        GetterSetterCorrectionSubProcessor.addGetterSetterProposal(context, location.getCoveringNode(context.getASTRoot()), proposals, relevance);
    }

    private static boolean addGetterSetterProposal(IInvocationContext context, ASTNode coveringNode, Collection<ChangeCorrectionProposal> proposals, int relevance) {
        if (!(coveringNode instanceof SimpleName)) {
            return false;
        }
        SimpleName sn = (SimpleName)coveringNode;
        IBinding binding = sn.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding variableBinding = (IVariableBinding)binding;
        if (!variableBinding.isField()) {
            return false;
        }
        if (proposals == null) {
            return true;
        }
        ChangeCorrectionProposal proposal = GetterSetterCorrectionSubProcessor.getProposal(context.getCompilationUnit(), sn, variableBinding, relevance);
        if (proposal != null) {
            proposals.add(proposal);
        }
        return true;
    }

    private static ChangeCorrectionProposal getProposal(ICompilationUnit cu, SimpleName sn, IVariableBinding variableBinding, int relevance) {
        SimpleName accessNode = sn;
        Name qualifier = null;
        boolean useSuper = false;
        ASTNode parent = sn.getParent();
        switch (parent.getNodeType()) {
            case 40: {
                accessNode = (Expression)parent;
                qualifier = ((QualifiedName)parent).getQualifier();
                break;
            }
            case 47: {
                accessNode = (Expression)parent;
                qualifier = ((SuperFieldAccess)parent).getQualifier();
                useSuper = true;
            }
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)sn.getAST());
        ProposalParameter gspc = new ProposalParameter(useSuper, cu, rewrite, (Expression)accessNode, (Expression)qualifier, variableBinding);
        if (ASTResolving.isWriteAccess((Name)sn)) {
            return GetterSetterCorrectionSubProcessor.addSetterProposal(gspc, relevance);
        }
        return GetterSetterCorrectionSubProcessor.addGetterProposal(gspc, relevance);
    }

    /*
     * WARNING - void declaration
     */
    private static ChangeCorrectionProposal addGetterProposal(ProposalParameter context, int relevance) {
        IMethodBinding method = GetterSetterCorrectionSubProcessor.findGetter(context);
        if (method != null) {
            Expression mi = GetterSetterCorrectionSubProcessor.createMethodInvocation(context, method, null);
            context.astRewrite.replace((ASTNode)context.accessNode, (ASTNode)mi, null);
            String label = Messages.format(CorrectionMessages.GetterSetterCorrectionSubProcessor_replacewithgetter_description, BasicElementLabels.getJavaCodeString((String)ASTNodes.asString((ASTNode)context.accessNode)));
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, "quickfix", context.compilationUnit, context.astRewrite, relevance);
            return proposal;
        }
        IJavaElement element = context.variableBinding.getJavaElement();
        IJavaElement iJavaElement = element;
        if (iJavaElement instanceof IField) {
            IField label = (IField)iJavaElement;
            IField cfr_ignored_0 = (IField)iJavaElement;
            try {
                void field;
                if (RefactoringAvailabilityTester.isSelfEncapsulateAvailable((IField)field)) {
                    return new SelfEncapsulateFieldProposal(relevance, (IField)field);
                }
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.log((CoreException)((Object)e));
            }
        }
        return null;
    }

    private static IMethodBinding findGetter(ProposalParameter context) {
        ITypeBinding returnType = context.variableBinding.getType();
        String getterName = GetterSetterUtil.getGetterName((IVariableBinding)context.variableBinding, (IJavaProject)context.compilationUnit.getJavaProject(), null, (boolean)GetterSetterCorrectionSubProcessor.isBoolean(context));
        ITypeBinding declaringType = context.variableBinding.getDeclaringClass();
        if (declaringType == null) {
            return null;
        }
        IMethodBinding getter = Bindings.findMethodInHierarchy((ITypeBinding)declaringType, (String)getterName, (ITypeBinding[])new ITypeBinding[0]);
        if (getter != null && getter.getReturnType().isAssignmentCompatible(returnType) && Modifier.isStatic((int)getter.getModifiers()) == Modifier.isStatic((int)context.variableBinding.getModifiers())) {
            return getter;
        }
        return null;
    }

    private static Expression createMethodInvocation(ProposalParameter context, IMethodBinding method, Expression argument) {
        AST ast = context.astRewrite.getAST();
        Expression qualifier = context.qualifier;
        if (context.useSuper) {
            SuperMethodInvocation invocation = ast.newSuperMethodInvocation();
            invocation.setName(ast.newSimpleName(method.getName()));
            if (qualifier != null) {
                invocation.setQualifier((Name)context.astRewrite.createCopyTarget((ASTNode)qualifier));
            }
            if (argument != null) {
                invocation.arguments().add(argument);
            }
            return invocation;
        }
        MethodInvocation invocation = ast.newMethodInvocation();
        invocation.setName(ast.newSimpleName(method.getName()));
        if (qualifier != null) {
            invocation.setExpression((Expression)context.astRewrite.createCopyTarget((ASTNode)qualifier));
        }
        if (argument != null) {
            invocation.arguments().add(argument);
        }
        return invocation;
    }

    /*
     * WARNING - void declaration
     */
    private static ChangeCorrectionProposal addSetterProposal(ProposalParameter context, int relevance) {
        boolean isBoolean = GetterSetterCorrectionSubProcessor.isBoolean(context);
        String setterName = GetterSetterUtil.getSetterName((IVariableBinding)context.variableBinding, (IJavaProject)context.compilationUnit.getJavaProject(), null, (boolean)isBoolean);
        ITypeBinding declaringType = context.variableBinding.getDeclaringClass();
        if (declaringType == null) {
            return null;
        }
        IMethodBinding method = Bindings.findMethodInHierarchy((ITypeBinding)declaringType, (String)setterName, (ITypeBinding[])new ITypeBinding[]{context.variableBinding.getType()});
        if (method != null && Bindings.isVoidType((ITypeBinding)method.getReturnType()) && Modifier.isStatic((int)method.getModifiers()) == Modifier.isStatic((int)context.variableBinding.getModifiers())) {
            Expression assignedValue = GetterSetterCorrectionSubProcessor.getAssignedValue(context);
            if (assignedValue == null) {
                return null;
            }
            Expression mi = GetterSetterCorrectionSubProcessor.createMethodInvocation(context, method, assignedValue);
            context.astRewrite.replace(context.accessNode.getParent(), (ASTNode)mi, null);
            String label = Messages.format(CorrectionMessages.GetterSetterCorrectionSubProcessor_replacewithsetter_description, BasicElementLabels.getJavaCodeString((String)ASTNodes.asString((ASTNode)context.accessNode)));
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, "quickfix", context.compilationUnit, context.astRewrite, relevance);
            return proposal;
        }
        IJavaElement element = context.variableBinding.getJavaElement();
        IJavaElement iJavaElement = element;
        if (iJavaElement instanceof IField) {
            IField mi = (IField)iJavaElement;
            IField cfr_ignored_0 = (IField)iJavaElement;
            try {
                void field;
                if (RefactoringAvailabilityTester.isSelfEncapsulateAvailable((IField)field)) {
                    return new SelfEncapsulateFieldProposal(relevance, (IField)field);
                }
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.log((CoreException)((Object)e));
            }
        }
        return null;
    }

    private static boolean isBoolean(ProposalParameter context) {
        boolean isBoolean;
        AST ast = context.astRewrite.getAST();
        boolean bl = isBoolean = ast.resolveWellKnownType("boolean") == context.variableBinding.getType();
        if (!isBoolean) {
            isBoolean = ast.resolveWellKnownType("java.lang.Boolean") == context.variableBinding.getType();
        }
        return isBoolean;
    }

    private static Expression getAssignedValue(ProposalParameter context) {
        boolean is50OrHigher;
        ITypeBinding type;
        Expression result;
        ASTNode parent = context.accessNode.getParent();
        ASTRewrite astRewrite = context.astRewrite;
        IJavaProject javaProject = context.compilationUnit.getJavaProject();
        IMethodBinding getter = GetterSetterCorrectionSubProcessor.findGetter(context);
        SimpleName getterExpression = null;
        if (getter != null) {
            getterExpression = astRewrite.getAST().newSimpleName("placeholder");
        }
        if ((result = GetterSetterUtil.getAssignedValue((ASTNode)parent, (ASTRewrite)astRewrite, (Expression)getterExpression, (ITypeBinding)(type = context.variableBinding.getType()), (boolean)(is50OrHigher = JavaModelUtil.is50OrHigher((IJavaProject)javaProject)))) != null && getterExpression != null && getterExpression.getParent() != null) {
            getterExpression.getParent().setStructuralProperty(getterExpression.getLocationInParent(), (Object)GetterSetterCorrectionSubProcessor.createMethodInvocation(context, getter, null));
        }
        return result;
    }

    private static class ProposalParameter {
        public final boolean useSuper;
        public final ICompilationUnit compilationUnit;
        public final ASTRewrite astRewrite;
        public final Expression accessNode;
        public final Expression qualifier;
        public final IVariableBinding variableBinding;

        public ProposalParameter(boolean useSuper, ICompilationUnit compilationUnit, ASTRewrite rewrite, Expression accessNode, Expression qualifier, IVariableBinding variableBinding) {
            this.useSuper = useSuper;
            this.compilationUnit = compilationUnit;
            this.astRewrite = rewrite;
            this.accessNode = accessNode;
            this.qualifier = qualifier;
            this.variableBinding = variableBinding;
        }
    }

    public static class SelfEncapsulateFieldProposal
    extends ChangeCorrectionProposal {
        public SelfEncapsulateFieldProposal(int relevance, IField field) {
            super(SelfEncapsulateFieldProposal.getDescription(field), "refactor", SelfEncapsulateFieldProposal.getRefactoringChange(field), relevance);
        }

        public static Change getRefactoringChange(IField field) {
            try {
                Preferences preferences = JavaLanguageServerPlugin.getPreferencesManager().getPreferences();
                SelfEncapsulateFieldRefactoring refactoring = new SelfEncapsulateFieldRefactoring(field);
                refactoring.setGenerateJavadoc(preferences.isCodeGenerationTemplateGenerateComments());
                refactoring.setVisibility(1);
                refactoring.setConsiderVisibility(false);
                refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
                refactoring.checkFinalConditions((IProgressMonitor)new NullProgressMonitor());
                return refactoring.createChange((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.log(e);
                return null;
            }
        }

        private static String getDescription(IField field) {
            return Messages.format(CorrectionMessages.GetterSetterCorrectionSubProcessor_creategetterunsingencapsulatefield_description, BasicElementLabels.getJavaElementName((String)field.getElementName()));
        }

        public String getAdditionalProposalInfo(IProgressMonitor monitor) {
            return CorrectionMessages.GetterSetterCorrectionSubProcessor_additional_info;
        }
    }
}

