/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.OS;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class LocationValidator {
    private final Workspace workspace;

    public LocationValidator(Workspace workspace) {
        this.workspace = workspace;
    }

    private String toString(URI uri) {
        try {
            return EFS.getStore((URI)uri).toString();
        }
        catch (CoreException coreException) {
            return uri.toString();
        }
    }

    private IStatus validateAbsolute(URI location, boolean error) {
        if (!location.isAbsolute()) {
            IPath pathPart;
            String schemeSpecificPart = location.getSchemeSpecificPart();
            String message = schemeSpecificPart == null || schemeSpecificPart.isEmpty() ? Messages.links_noPath : ((pathPart = IPath.fromOSString((String)schemeSpecificPart)).segmentCount() > 0 ? NLS.bind((String)Messages.pathvar_undefined, (Object)location.toString(), (Object)pathPart.segment(0)) : Messages.links_noPath);
            int code = error ? 379 : 333;
            return new ResourceStatus(code, null, message);
        }
        return Status.OK_STATUS;
    }

    public IStatus validateLinkLocation(IResource resource, IPath unresolvedLocation) {
        IPath location = resource.getPathVariableManager().resolvePath(unresolvedLocation);
        if (location.isEmpty()) {
            return new ResourceStatus(77, resource.getFullPath(), Messages.links_noPath);
        }
        if (!location.isAbsolute()) {
            String message = NLS.bind((String)Messages.pathvar_undefined, (Object)location.toOSString(), (Object)location.segment(0));
            return new ResourceStatus(333, resource.getFullPath(), message);
        }
        if (location.getDevice() == null) {
            location = IPath.fromOSString((String)location.toFile().getAbsolutePath());
        }
        return this.validateLinkLocationURI(resource, URIUtil.toURI((IPath)location));
    }

    public IStatus validateLinkLocationURI(IResource resource, URI unresolvedLocation) {
        String schemeSpecificPart = unresolvedLocation.getSchemeSpecificPart();
        if (schemeSpecificPart == null || schemeSpecificPart.isEmpty()) {
            return new ResourceStatus(77, resource.getFullPath(), Messages.links_noPath);
        }
        if (ResourcesPlugin.getPlugin().getPluginPreferences().getBoolean("description.disableLinking")) {
            String message = NLS.bind((String)Messages.links_workspaceVeto, (Object)resource.getName());
            return new ResourceStatus(77, resource.getFullPath(), message);
        }
        int type = resource.getType();
        if (type != 2 && type != 1) {
            String message = NLS.bind((String)Messages.links_notFileFolder, (Object)resource.getName());
            return new ResourceStatus(77, resource.getFullPath(), message);
        }
        IContainer parent = resource.getParent();
        if (!parent.isAccessible()) {
            String message = NLS.bind((String)Messages.links_parentNotAccessible, (Object)resource.getFullPath());
            return new ResourceStatus(77, resource.getFullPath(), message);
        }
        URI location = resource.getPathVariableManager().resolveURI(unresolvedLocation);
        String[] natureIds = ((Project)resource.getProject()).internalGetDescription().getNatureIds();
        IStatus result = this.workspace.getNatureManager().validateLinkCreation(natureIds);
        if (!result.isOK()) {
            return result;
        }
        result = resource.getType() == 1 ? this.workspace.getTeamHook().validateCreateLink((IFile)resource, 0, location) : this.workspace.getTeamHook().validateCreateLink((IFolder)resource, 0, location);
        if (!result.isOK()) {
            return result;
        }
        result = this.validateSegments(location);
        if (!result.isOK()) {
            return result;
        }
        result = this.validateAbsolute(location, false);
        if (!result.isOK()) {
            return result;
        }
        URI testLocation = this.workspace.getMetaArea().getLocation().toFile().toURI();
        if (FileUtil.isOverlapping(location, testLocation)) {
            String message = NLS.bind((String)Messages.links_invalidLocation, (Object)this.toString(location));
            return new ResourceStatus(77, resource.getFullPath(), message);
        }
        testLocation = resource.getProject().getLocationURI();
        if (testLocation != null && FileUtil.isPrefixOf(location, testLocation)) {
            String message = NLS.bind((String)Messages.links_locationOverlapsProject, (Object)this.toString(location));
            return new ResourceStatus(77, resource.getFullPath(), message);
        }
        IProject[] iProjectArray = this.workspace.getRoot().getProjects(8);
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            ProjectDescription desc = ((Project)project).internalGetDescription();
            testLocation = desc.getLocationURI();
            if (testLocation != null && FileUtil.isOverlapping(location, testLocation)) {
                String message = NLS.bind((String)Messages.links_overlappingResource, (Object)this.toString(location));
                return new ResourceStatus(235, resource.getFullPath(), message);
            }
            if (project.isOpen()) {
                IResource[] children = null;
                try {
                    children = project.members();
                }
                catch (CoreException coreException) {}
                if (children != null) {
                    IResource[] iResourceArray = children;
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource child = iResourceArray[n4];
                        if (child.isLinked() && (testLocation = child.getLocationURI()) != null && FileUtil.isOverlapping(location, testLocation)) {
                            String message = NLS.bind((String)Messages.links_overlappingResource, (Object)this.toString(location));
                            return new ResourceStatus(235, resource.getFullPath(), message);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public IStatus validateName(String segment, int type) {
        char[] chars;
        if (segment == null) {
            String message = Messages.resources_nameNull;
            return new ResourceStatus(77, null, message);
        }
        if (segment.length() == 0) {
            String message = Messages.resources_nameEmpty;
            return new ResourceStatus(77, null, message);
        }
        char[] cArray = chars = OS.INVALID_RESOURCE_CHARACTERS;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (segment.indexOf(c) != -1) {
                String message = NLS.bind((String)Messages.resources_invalidCharInName, (Object)String.valueOf(c), (Object)segment);
                return new ResourceStatus(77, null, message);
            }
            ++n2;
        }
        if (!OS.isNameValid(segment)) {
            String message = NLS.bind((String)Messages.resources_invalidName, (Object)segment);
            return new ResourceStatus(77, null, message);
        }
        return Status.OK_STATUS;
    }

    public IStatus validatePath(IPath path, int type, boolean lastSegmentOnly) {
        if (path == null) {
            String message = Messages.resources_pathNull;
            return new ResourceStatus(77, null, message);
        }
        if (path.getDevice() != null) {
            String message = NLS.bind((String)Messages.resources_invalidCharInPath, (Object)String.valueOf(':'), (Object)path);
            return new ResourceStatus(77, null, message);
        }
        if (path.isRoot()) {
            String message = Messages.resources_invalidRoot;
            return new ResourceStatus(77, null, message);
        }
        if (!path.isAbsolute()) {
            String message = NLS.bind((String)Messages.resources_mustBeAbsolute, (Object)path);
            return new ResourceStatus(77, null, message);
        }
        int numberOfSegments = path.segmentCount();
        if ((type & 4) != 0) {
            if (numberOfSegments == 1) {
                return this.validateName(path.segment(0), 4);
            }
            if (type == 4) {
                String message = NLS.bind((String)Messages.resources_projectPath, (Object)path);
                return new ResourceStatus(77, null, message);
            }
        }
        if ((type & 3) != 0) {
            if (numberOfSegments < 2) {
                String message = NLS.bind((String)Messages.resources_resourcePath, (Object)path);
                return new ResourceStatus(77, null, message);
            }
            int fileFolderType = type &= 0xFFFFFFFB;
            int segmentCount = path.segmentCount();
            if (lastSegmentOnly) {
                return this.validateName(path.segment(segmentCount - 1), fileFolderType);
            }
            IStatus status = this.validateName(path.segment(0), 4);
            if (!status.isOK()) {
                return status;
            }
            int i = 1;
            while (i < segmentCount) {
                status = this.validateName(path.segment(i), fileFolderType);
                if (!status.isOK()) {
                    return status;
                }
                ++i;
            }
            return Status.OK_STATUS;
        }
        String message = NLS.bind((String)Messages.resources_invalidPath, (Object)path);
        return new ResourceStatus(77, null, message);
    }

    public IStatus validatePath(String path, int type) {
        if (path == null) {
            String message = Messages.resources_pathNull;
            return new ResourceStatus(77, null, message);
        }
        return this.validatePath(IPath.fromOSString((String)path), type, false);
    }

    public IStatus validateProjectLocation(IProject context, IPath unresolvedLocation) {
        if (unresolvedLocation == null) {
            return this.validateProjectLocationURI(context, null);
        }
        IPath location = context != null ? context.getPathVariableManager().resolvePath(unresolvedLocation) : this.workspace.getPathVariableManager().resolvePath(unresolvedLocation);
        if (!location.isAbsolute()) {
            String message = location.segmentCount() > 0 ? NLS.bind((String)Messages.pathvar_undefined, (Object)location.toString(), (Object)location.segment(0)) : Messages.links_noPath;
            return new ResourceStatus(379, null, message);
        }
        return this.validateProjectLocationURI(context, URIUtil.toURI((IPath)location));
    }

    public IStatus validateProjectLocationURI(IProject context, URI unresolvedLocation) {
        IProject[] projects;
        if (context == null && unresolvedLocation == null) {
            throw new IllegalArgumentException("Either a project or a location must be provided");
        }
        boolean isMetadataLocation = false;
        if (unresolvedLocation != null) {
            if (URIUtil.equals((URI)unresolvedLocation, (URI)URIUtil.toURI((IPath)Platform.getLocation().addTrailingSeparator().append(".metadata")))) {
                isMetadataLocation = true;
            }
        } else if (context != null && context.getName().equals(".metadata")) {
            isMetadataLocation = true;
        }
        if (isMetadataLocation) {
            String message = NLS.bind((String)Messages.resources_invalidPath, (Object)this.toString(URIUtil.toURI((IPath)Platform.getLocation().addTrailingSeparator().append(".metadata"))));
            return new ResourceStatus(77, null, message);
        }
        if (unresolvedLocation == null) {
            return Status.OK_STATUS;
        }
        URI location = context != null ? context.getPathVariableManager().resolveURI(unresolvedLocation) : this.workspace.getPathVariableManager().resolveURI(unresolvedLocation);
        IStatus result = this.validateSegments(location);
        if (!result.isOK()) {
            return result;
        }
        result = this.validateAbsolute(location, true);
        if (!result.isOK()) {
            return result;
        }
        try {
            EFS.getFileSystem((String)location.getScheme());
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        if (location.getScheme().equals("file")) {
            IPath defaultDefaultLocation;
            IPath locationPath = URIUtil.toPath((URI)location);
            if (FileUtil.isPrefixOf(locationPath, defaultDefaultLocation = this.workspace.getRoot().getLocation())) {
                String message = NLS.bind((String)Messages.resources_overlapWorkspace, (Object)this.toString(location), (Object)defaultDefaultLocation.toOSString());
                return new ResourceStatus(77, null, message);
            }
            IPath parentPath = locationPath.removeLastSegments(1);
            if (FileUtil.isPrefixOf(parentPath, defaultDefaultLocation) && FileUtil.isPrefixOf(defaultDefaultLocation, parentPath) && (context == null || !locationPath.equals((Object)defaultDefaultLocation.append(context.getName())))) {
                String message = NLS.bind((String)Messages.resources_overlapProject, (Object)this.toString(location), (Object)locationPath.lastSegment());
                return new ResourceStatus(77, null, message);
            }
        }
        IProject[] iProjectArray = projects = this.workspace.getRoot().getProjects(8);
        int n = projects.length;
        int parentPath = 0;
        while (parentPath < n) {
            IProject project = iProjectArray[parentPath];
            URI testLocation = project.getLocationURI();
            if (!(context != null && project.equals(context) ? URIUtil.equals((URI)testLocation, (URI)location) || !FileUtil.isPrefixOf(testLocation, location) : !URIUtil.equals((URI)testLocation, (URI)location))) {
                String message = NLS.bind((String)Messages.resources_overlapProject, (Object)this.toString(location), (Object)project.getName());
                return new ResourceStatus(77, null, message);
            }
            ++parentPath;
        }
        if (context != null && context.exists() && context.isOpen()) {
            IResource[] children = null;
            try {
                children = context.members();
            }
            catch (CoreException coreException) {}
            if (children != null) {
                IResource[] iResourceArray = children;
                int n2 = children.length;
                n = 0;
                while (n < n2) {
                    URI testLocation;
                    IResource child = iResourceArray[n];
                    if (child.isLinked() && (testLocation = child.getLocationURI()) != null && FileUtil.isPrefixOf(testLocation, location)) {
                        String message = NLS.bind((String)Messages.links_locationOverlapsLink, (Object)this.toString(location));
                        return new ResourceStatus(235, context.getFullPath(), message);
                    }
                    ++n;
                }
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus validateSegments(URI location) {
        if ("file".equals(location.getScheme())) {
            IPath pathPart = IPath.fromOSString((String)location.getSchemeSpecificPart());
            int segmentCount = pathPart.segmentCount();
            int i = 0;
            while (i < segmentCount) {
                IStatus result = this.validateName(pathPart.segment(i), 4);
                if (!result.isOK()) {
                    return result;
                }
                ++i;
            }
        }
        return Status.OK_STATUS;
    }
}

