/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IModularClassFile;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationMessages;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.internal.corext.util.ValidateEditException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.ltk.core.refactoring.resource.Resources;
import org.eclipse.text.edits.TextEdit;

public final class JavaModelUtil {
    public static final String VERSION_LATEST = "20";
    public static final int VALIDATE_EDIT_CHANGED_CONTENT = 10003;
    public static final String DEFAULT_CU_SUFFIX = ".java";
    public static final String PACKAGE_INFO_JAVA = "package-info.java";
    public static final String PACKAGE_INFO_CLASS = "package-info.class";
    public static final String PACKAGE_HTML = "package.html";
    public static final String MODULE_INFO_JAVA = "module-info.java";
    public static final String MODULE_INFO_CLASS = "module-info.class";
    public static final String ALL_UNNAMED = "ALL-UNNAMED";

    public static IJavaElement findTypeContainer(IJavaProject jproject, String typeContainerName) throws JavaModelException {
        Path path;
        IType result = jproject.findType(typeContainerName);
        if (result == null && !((result = jproject.findElement((IPath)(path = new Path(typeContainerName.replace('.', '/'))))) instanceof IPackageFragment)) {
            result = null;
        }
        return result;
    }

    public static IType findTypeInCompilationUnit(ICompilationUnit cu, String typeQualifiedName) throws JavaModelException {
        IType[] iTypeArray = cu.getAllTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            String currName = type.getTypeQualifiedName('.');
            if (typeQualifiedName.equals(currName)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public static IJavaElement findInCompilationUnit(ICompilationUnit cu, IJavaElement element) {
        IJavaElement[] elements = cu.findElements(element);
        if (elements != null && elements.length > 0) {
            return elements[0];
        }
        return null;
    }

    public static String getTypeContainerName(IType type) {
        IType outerType = type.getDeclaringType();
        if (outerType != null) {
            return outerType.getFullyQualifiedName('.');
        }
        return type.getPackageFragment().getElementName();
    }

    public static String concatenateName(String name1, String name2) {
        StringBuilder buf = new StringBuilder();
        if (name1 != null && name1.length() > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static String concatenateName(char[] name1, char[] name2) {
        StringBuilder buf = new StringBuilder();
        if (name1 != null && name1.length > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static boolean isMatchingName(String nameA, String nameB) {
        int b;
        int a = nameA.length();
        if (a == (b = nameB.length())) {
            return nameA.equals(nameB);
        }
        if (a < b - 1) {
            return nameB.endsWith(nameA) && nameB.charAt(b - a - 1) == '.';
        }
        if (b < a - 1) {
            return nameA.endsWith(nameB) && nameA.charAt(a - b - 1) == '.';
        }
        return false;
    }

    public static boolean isVisible(IMember member, IPackageFragment pack) throws JavaModelException {
        int type = member.getElementType();
        if (type == 10 || type == 9 && member.getElementName().startsWith("<")) {
            return false;
        }
        int otherflags = member.getFlags();
        IType declaringType = member.getDeclaringType();
        if (Flags.isPublic((int)otherflags) || declaringType != null && JavaModelUtil.isInterfaceOrAnnotation(declaringType)) {
            return true;
        }
        if (Flags.isPrivate((int)otherflags)) {
            return false;
        }
        IPackageFragment otherpack = (IPackageFragment)member.getAncestor(4);
        return pack != null && otherpack != null && JavaModelUtil.isSamePackage(pack, otherpack);
    }

    public static boolean isVisibleInHierarchy(IMember member, IPackageFragment pack) throws JavaModelException {
        int type = member.getElementType();
        if (type == 10 || type == 9 && member.getElementName().startsWith("<")) {
            return false;
        }
        int otherflags = member.getFlags();
        IType declaringType = member.getDeclaringType();
        if (Flags.isPublic((int)otherflags) || Flags.isProtected((int)otherflags) || declaringType != null && JavaModelUtil.isInterfaceOrAnnotation(declaringType)) {
            return true;
        }
        if (Flags.isPrivate((int)otherflags)) {
            return false;
        }
        IPackageFragment otherpack = (IPackageFragment)member.getAncestor(4);
        return pack != null && pack.equals(otherpack);
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        return (IPackageFragmentRoot)element.getAncestor(3);
    }

    public static IMethod findMethod(String name, String[] paramTypes, boolean isConstructor, IType type) throws JavaModelException {
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (JavaModelUtil.isSameMethodSignature(name, paramTypes, isConstructor, method)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public static IMethod findMethodInHierarchy(ITypeHierarchy hierarchy, IType type, String name, String[] paramTypes, boolean isConstructor) throws JavaModelException {
        IMethod res;
        IMethod method = JavaModelUtil.findMethod(name, paramTypes, isConstructor, type);
        if (method != null) {
            return method;
        }
        IType superClass = hierarchy.getSuperclass(type);
        if (superClass != null && (res = JavaModelUtil.findMethodInHierarchy(hierarchy, superClass, name, paramTypes, isConstructor)) != null) {
            return res;
        }
        if (!isConstructor) {
            IType[] iTypeArray = hierarchy.getSuperInterfaces(type);
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType superInterface = iTypeArray[n2];
                IMethod res2 = JavaModelUtil.findMethodInHierarchy(hierarchy, superInterface, name, paramTypes, false);
                if (res2 != null) {
                    return res2;
                }
                ++n2;
            }
        }
        return method;
    }

    public static boolean isSameMethodSignature(String name, String[] paramTypes, boolean isConstructor, IMethod curr) throws JavaModelException {
        String[] currParamTypes;
        if ((isConstructor || name.equals(curr.getElementName())) && isConstructor == curr.isConstructor() && paramTypes.length == (currParamTypes = curr.getParameterTypes()).length) {
            int i = 0;
            while (i < paramTypes.length) {
                String t2;
                String t1 = Signature.getSimpleName((String)Signature.toString((String)paramTypes[i]));
                if (!t1.equals(t2 = Signature.getSimpleName((String)Signature.toString((String)currParamTypes[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean isSamePackage(IPackageFragment pack1, IPackageFragment pack2) {
        return pack1.getElementName().equals(pack2.getElementName());
    }

    public static boolean hasMainMethod(IType type) throws JavaModelException {
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.isMainMethod()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isBoolean(IField field) throws JavaModelException {
        return "Z".equals(field.getTypeSignature());
    }

    public static boolean isInterfaceOrAnnotation(IType type) throws JavaModelException {
        return type.isInterface();
    }

    public static String getResolvedTypeName(String refTypeSig, IType declaringType) throws JavaModelException {
        return JavaModelUtil.getResolvedTypeName(refTypeSig, declaringType, '.');
    }

    public static String getResolvedTypeName(String refTypeSig, IType declaringType, char enclosingTypeSeparator) throws JavaModelException {
        int arrayCount = Signature.getArrayCount((String)refTypeSig);
        char type = refTypeSig.charAt(arrayCount);
        if (type == 'Q') {
            String name = "";
            int bracket = refTypeSig.indexOf(60, arrayCount + 1);
            if (bracket > 0) {
                name = refTypeSig.substring(arrayCount + 1, bracket);
            } else {
                int semi = refTypeSig.indexOf(59, arrayCount + 1);
                if (semi == -1) {
                    throw new IllegalArgumentException();
                }
                name = refTypeSig.substring(arrayCount + 1, semi);
            }
            String[][] resolvedNames = declaringType.resolveType(name);
            if (resolvedNames != null && resolvedNames.length > 0) {
                return JavaModelUtil.concatenateName(resolvedNames[0][0], resolvedNames[0][1].replace('.', enclosingTypeSeparator));
            }
            return null;
        }
        return Signature.toString((String)refTypeSig.substring(arrayCount));
    }

    public static boolean isEditable(ICompilationUnit cu) {
        Assert.isNotNull((Object)cu);
        IResource resource = cu.getPrimary().getResource();
        return resource.exists() && !resource.getResourceAttributes().isReadOnly();
    }

    public static boolean isPrimary(ICompilationUnit cu) {
        return cu.getOwner() == null;
    }

    public static boolean isPrimitive(String typeSignature) throws JavaModelException {
        return Signature.getTypeSignatureKind((String)Signature.getElementType((String)typeSignature)) == 2;
    }

    public static boolean isExceptionToBeLogged(CoreException exception) {
        if (!(exception instanceof JavaModelException)) {
            return true;
        }
        JavaModelException je = (JavaModelException)((Object)exception);
        return !je.isDoesNotExist();
    }

    public static IType[] getAllSuperTypes(IType type, IProgressMonitor pm) throws JavaModelException {
        try {
            IType objekt;
            IType[] superTypes = SuperTypeHierarchyCache.getTypeHierarchy(type).getAllSupertypes(type);
            if (type.isInterface() && (objekt = type.getJavaProject().findType("java.lang.Object")) != null) {
                IType[] superInterfacesAndObject = new IType[superTypes.length + 1];
                System.arraycopy(superTypes, 0, superInterfacesAndObject, 0, superTypes.length);
                superInterfacesAndObject[superTypes.length] = objekt;
                IType[] iTypeArray = superInterfacesAndObject;
                return iTypeArray;
            }
            IType[] iTypeArray = superTypes;
            return iTypeArray;
        }
        finally {
            if (pm != null) {
                pm.done();
            }
        }
    }

    public static boolean isSuperType(ITypeHierarchy hierarchy, IType possibleSuperType, IType type) {
        IType superClass = hierarchy.getSuperclass(type);
        if (superClass != null && (possibleSuperType.equals(superClass) || JavaModelUtil.isSuperType(hierarchy, possibleSuperType, superClass))) {
            return true;
        }
        if (Flags.isInterface((int)hierarchy.getCachedFlags(possibleSuperType))) {
            IType[] iTypeArray = hierarchy.getSuperInterfaces(type);
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType curr = iTypeArray[n2];
                if (possibleSuperType.equals(curr) || JavaModelUtil.isSuperType(hierarchy, possibleSuperType, curr)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isExcludedPath(IPath resourcePath, IPath[] exclusionPatterns) {
        char[] path = resourcePath.toString().toCharArray();
        IPath[] iPathArray = exclusionPatterns;
        int n = exclusionPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            IPath exclusionPattern = iPathArray[n2];
            char[] pattern = exclusionPattern.toString().toCharArray();
            if (CharOperation.pathMatch((char[])pattern, (char[])path, (boolean)true, (char)'/')) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isExcluded(IPath resourcePath, char[][] exclusionPatterns) {
        if (exclusionPatterns == null) {
            return false;
        }
        char[] path = resourcePath.toString().toCharArray();
        char[][] cArray = exclusionPatterns;
        int n = exclusionPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            char[] exclusionPattern = cArray[n2];
            if (CharOperation.pathMatch((char[])exclusionPattern, (char[])path, (boolean)true, (char)'/')) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void reconcile(ICompilationUnit unit) throws JavaModelException {
        unit.reconcile(0, false, null, null);
    }

    public static IClasspathEntry getClasspathEntryToEdit(IJavaProject jproject, IPath containerPath, IPath libPath) throws JavaModelException {
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)jproject);
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0));
        if (container != null && initializer != null && initializer.canUpdateClasspathContainer(containerPath, jproject)) {
            return JavaModelUtil.findEntryInContainer(container, libPath);
        }
        return null;
    }

    public static IClasspathEntry findEntryInContainer(IClasspathContainer container, IPath libPath) {
        IClasspathEntry[] iClasspathEntryArray = container.getClasspathEntries();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry curr = iClasspathEntryArray[n2];
            IClasspathEntry resolved = JavaCore.getResolvedClasspathEntry((IClasspathEntry)curr);
            if (resolved != null && libPath.equals((Object)resolved.getPath())) {
                return curr;
            }
            ++n2;
        }
        return null;
    }

    public static IClasspathEntry getClasspathEntry(IPackageFragmentRoot root) throws JavaModelException {
        IClasspathEntry rawEntry = root.getRawClasspathEntry();
        int rawEntryKind = rawEntry.getEntryKind();
        switch (rawEntryKind) {
            case 1: 
            case 4: 
            case 5: {
                if (!root.isArchive() || root.getKind() != 2) break;
                IClasspathEntry resolvedEntry = root.getResolvedClasspathEntry();
                if (resolvedEntry.getReferencingEntry() != null) {
                    return resolvedEntry;
                }
                return rawEntry;
            }
        }
        return rawEntry;
    }

    public static ICompilationUnit[] getAllCompilationUnits(IJavaElement[] javaElements) throws JavaModelException {
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>();
        IJavaElement[] iJavaElementArray = javaElements;
        int n = javaElements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement javaElement = iJavaElementArray[n2];
            JavaModelUtil.addAllCus(result, javaElement);
            ++n2;
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private static void addAllCus(HashSet<ICompilationUnit> collector, IJavaElement javaElement) throws JavaModelException {
        switch (javaElement.getElementType()) {
            case 2: {
                IJavaProject javaProject = (IJavaProject)javaElement;
                IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                    JavaModelUtil.addAllCus(collector, (IJavaElement)packageFragmentRoot);
                    ++n2;
                }
                return;
            }
            case 3: {
                IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)javaElement;
                if (packageFragmentRoot.getKind() != 1) {
                    return;
                }
                IJavaElement[] iJavaElementArray = packageFragmentRoot.getChildren();
                int n = iJavaElementArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IJavaElement packageFragment = iJavaElementArray[n3];
                    JavaModelUtil.addAllCus(collector, packageFragment);
                    ++n3;
                }
                return;
            }
            case 4: {
                IPackageFragment packageFragment = (IPackageFragment)javaElement;
                collector.addAll(Arrays.asList(packageFragment.getCompilationUnits()));
                return;
            }
            case 5: {
                collector.add((ICompilationUnit)javaElement);
                return;
            }
        }
        IJavaElement cu = javaElement.getAncestor(5);
        if (cu != null) {
            collector.add((ICompilationUnit)cu);
        }
    }

    public static void setComplianceOptions(Map<String, String> map, String compliance) {
        JavaCore.setComplianceOptions((String)compliance, map);
    }

    public static void setDefaultClassfileOptions(Map<String, String> map, String compliance) {
        map.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", JavaModelUtil.is50OrHigher(compliance) ? "enabled" : "disabled");
        map.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        map.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        map.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        map.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
    }

    public static boolean isVersionLessThan(String version1, String version2) {
        return JavaCore.compareJavaVersions((String)version1, (String)version2) < 0;
    }

    public static boolean is1d2OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "1.2");
    }

    public static boolean is40OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "1.4");
    }

    public static boolean is50OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "1.5");
    }

    public static boolean is1d6OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "1.6");
    }

    public static boolean is1d7OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "1.7");
    }

    public static boolean is1d8OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "1.8");
    }

    public static boolean is9OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "9");
    }

    public static boolean is10OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "10");
    }

    public static boolean is11OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "11");
    }

    public static boolean is12OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "12");
    }

    public static boolean is13OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "13");
    }

    public static boolean is14OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "14");
    }

    public static boolean is15OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "15");
    }

    public static boolean is16OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "16");
    }

    public static boolean is17OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "17");
    }

    public static boolean is18OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "18");
    }

    public static boolean is19OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "19");
    }

    public static boolean is20OrHigher(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, "20");
    }

    public static boolean is1d2OrHigher(IJavaProject project) {
        return JavaModelUtil.is1d2OrHigher(JavaModelUtil.getSourceCompliance(project));
    }

    public static boolean is1d4OrHigher(IJavaProject project) {
        return JavaModelUtil.is40OrHigher(JavaModelUtil.getSourceCompliance(project));
    }

    public static boolean is50OrHigher(IJavaProject project) {
        return JavaModelUtil.is50OrHigher(JavaModelUtil.getSourceCompliance(project));
    }

    public static boolean is1d7OrHigher(IJavaProject project) {
        return JavaModelUtil.is1d7OrHigher(JavaModelUtil.getSourceCompliance(project));
    }

    public static boolean is1d8OrHigher(IJavaProject project) {
        return JavaModelUtil.is1d8OrHigher(JavaModelUtil.getSourceCompliance(project));
    }

    public static boolean is9OrHigher(IJavaProject project) {
        return JavaModelUtil.is9OrHigher(JavaModelUtil.getSourceCompliance(project));
    }

    public static boolean is10OrHigher(IJavaProject project) {
        return JavaModelUtil.is10OrHigher(JavaModelUtil.getSourceCompliance(project));
    }

    public static boolean is11OrHigher(IJavaProject project) {
        return JavaModelUtil.is11OrHigher(JavaModelUtil.getSourceCompliance(project));
    }

    public static boolean is12OrHigher(IJavaProject project) {
        return JavaModelUtil.is12OrHigher(JavaModelUtil.getSourceCompliance(project));
    }

    public static boolean is13OrHigher(IJavaProject project) {
        return JavaModelUtil.is13OrHigher(JavaModelUtil.getSourceCompliance(project));
    }

    public static boolean is14OrHigher(IJavaProject project) {
        return JavaModelUtil.is14OrHigher(JavaModelUtil.getSourceCompliance(project));
    }

    public static boolean is15OrHigher(IJavaProject project) {
        return JavaModelUtil.is15OrHigher(JavaModelUtil.getSourceCompliance(project));
    }

    public static boolean is16OrHigher(IJavaProject project) {
        return JavaModelUtil.is16OrHigher(JavaModelUtil.getSourceCompliance(project));
    }

    public static boolean is17OrHigher(IJavaProject project) {
        return JavaModelUtil.is17OrHigher(JavaModelUtil.getSourceCompliance(project));
    }

    public static boolean is18OrHigher(IJavaProject project) {
        return JavaModelUtil.is18OrHigher(JavaModelUtil.getSourceCompliance(project));
    }

    public static boolean is19OrHigher(IJavaProject project) {
        return JavaModelUtil.is19OrHigher(JavaModelUtil.getSourceCompliance(project));
    }

    public static boolean is20OrHigher(IJavaProject project) {
        return JavaModelUtil.is20OrHigher(JavaModelUtil.getSourceCompliance(project));
    }

    public static String getSourceCompliance(IJavaProject project) {
        return project != null ? project.getOption("org.eclipse.jdt.core.compiler.source", true) : JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
    }

    public static boolean isLatestOrHigherJavaVersion(IJavaProject project) {
        return JavaModelUtil.isLatestOrHigherJavaVersion(JavaModelUtil.getSourceCompliance(project));
    }

    public static boolean isLatestOrHigherJavaVersion(String compliance) {
        return !JavaModelUtil.isVersionLessThan(compliance, JavaCore.latestSupportedJavaVersion());
    }

    public static boolean is50OrHigherJRE(IJavaProject project) throws CoreException {
        IVMInstall vmInstall = project == null ? JavaRuntime.getDefaultVMInstall() : JavaRuntime.getVMInstall((IJavaProject)project);
        if (!(vmInstall instanceof IVMInstall2)) {
            return true;
        }
        String compliance = JavaModelUtil.getCompilerCompliance((IVMInstall2)vmInstall, null);
        if (compliance == null) {
            return true;
        }
        return JavaModelUtil.is50OrHigher(compliance);
    }

    public static String getCompilerCompliance(IVMInstall2 vMInstall, String defaultCompliance) {
        String version = vMInstall.getJavaVersion();
        if (version == null) {
            return defaultCompliance;
        }
        if (version.startsWith("20")) {
            return "20";
        }
        if (version.startsWith("19")) {
            return "19";
        }
        if (version.startsWith("18")) {
            return "18";
        }
        if (version.startsWith("17")) {
            return "17";
        }
        if (version.startsWith("16")) {
            return "16";
        }
        if (version.startsWith("15")) {
            return "15";
        }
        if (version.startsWith("14")) {
            return "14";
        }
        if (version.startsWith("13")) {
            return "13";
        }
        if (version.startsWith("12")) {
            return "12";
        }
        if (version.startsWith("11")) {
            return "11";
        }
        if (version.startsWith("10")) {
            return "10";
        }
        if (version.startsWith("9")) {
            return "9";
        }
        if (version.startsWith("1.8")) {
            return "1.8";
        }
        if (version.startsWith("1.7")) {
            return "1.7";
        }
        if (version.startsWith("1.6")) {
            return "1.6";
        }
        if (version.startsWith("1.5")) {
            return "1.5";
        }
        if (version.startsWith("1.4")) {
            return "1.4";
        }
        if (version.startsWith("1.3") || version.startsWith("1.2") || version.startsWith("1.1")) {
            return "1.3";
        }
        return JavaCore.isSupportedJavaVersion((String)version) ? defaultCompliance : VERSION_LATEST;
    }

    public static String getExecutionEnvironmentCompliance(IExecutionEnvironment executionEnvironment) {
        String compliance;
        Map complianceOptions = executionEnvironment.getComplianceOptions();
        if (complianceOptions != null && (compliance = (String)complianceOptions.get("org.eclipse.jdt.core.compiler.compliance")) != null) {
            return compliance;
        }
        String desc = executionEnvironment.getId();
        if (desc.indexOf("20") != -1) {
            return "20";
        }
        if (desc.indexOf("19") != -1) {
            return "19";
        }
        if (desc.indexOf("18") != -1) {
            return "18";
        }
        if (desc.indexOf("17") != -1) {
            return "17";
        }
        if (desc.indexOf("16") != -1) {
            return "16";
        }
        if (desc.indexOf("15") != -1) {
            return "15";
        }
        if (desc.indexOf("14") != -1) {
            return "14";
        }
        if (desc.indexOf("13") != -1) {
            return "13";
        }
        if (desc.indexOf("12") != -1) {
            return "12";
        }
        if (desc.indexOf("11") != -1) {
            return "11";
        }
        if (desc.indexOf("10") != -1) {
            return "10";
        }
        if (desc.indexOf("9") != -1) {
            return "9";
        }
        if (desc.indexOf("1.8") != -1) {
            return "1.8";
        }
        if (desc.indexOf("1.7") != -1) {
            return "1.7";
        }
        if (desc.indexOf("1.6") != -1) {
            return "1.6";
        }
        if (desc.indexOf("1.5") != -1) {
            return "1.5";
        }
        if (desc.indexOf("1.4") != -1) {
            return "1.4";
        }
        return "1.3";
    }

    public static String getRenamedCUName(ICompilationUnit cu, String newMainName) {
        String oldName = cu.getElementName();
        int i = oldName.lastIndexOf(46);
        if (i != -1) {
            return newMainName + oldName.substring(i);
        }
        return newMainName;
    }

    public static boolean isImplicitImport(String qualifier, ICompilationUnit cu) {
        if ("java.lang".equals(qualifier)) {
            return true;
        }
        String packageName = cu.getParent().getElementName();
        if (qualifier.equals(packageName)) {
            return true;
        }
        String typeName = JavaCore.removeJavaLikeExtension((String)cu.getElementName());
        String mainTypeName = JavaModelUtil.concatenateName(packageName, typeName);
        return qualifier.equals(mainTypeName);
    }

    public static boolean isOpenableStorage(Object storage) {
        if (storage instanceof IJarEntryResource) {
            return ((IJarEntryResource)storage).isFile();
        }
        return storage instanceof IStorage;
    }

    public static boolean isPackageInfo(ICompilationUnit cu) {
        return PACKAGE_INFO_JAVA.equals(cu.getElementName());
    }

    public static boolean isModuleInfo(ICompilationUnit cu) {
        return MODULE_INFO_JAVA.equals(cu.getElementName());
    }

    public static boolean isModuleInfo(ITypeRoot typeRoot) {
        return typeRoot instanceof ICompilationUnit && JavaModelUtil.isModuleInfo((ICompilationUnit)typeRoot) || typeRoot instanceof IModularClassFile;
    }

    public static boolean isModule(IJavaElement javaElement) {
        return javaElement instanceof IModuleDescription || javaElement instanceof ITypeRoot && JavaModelUtil.isModuleInfo((ITypeRoot)javaElement);
    }

    public static boolean containsOrdinaryCompilationUnit(IPackageFragment fragment) throws JavaModelException {
        IJavaElement[] iJavaElementArray = fragment.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            if (child instanceof ITypeRoot && !JavaModelUtil.isModuleInfo((ITypeRoot)child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isPolymorphicSignature(IMethod method) {
        return method.getAnnotation("java.lang.invoke.MethodHandle$PolymorphicSignature").exists();
    }

    public static void applyEdit(ICompilationUnit cu, TextEdit edit, boolean save, IProgressMonitor monitor) throws CoreException, ValidateEditException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)JavaManipulationMessages.JavaModelUtil_applyedit_operation, (int)2);
        IFile file = (IFile)cu.getResource();
        if (!save || !file.exists()) {
            cu.applyTextEdit(edit, (IProgressMonitor)subMonitor.split(2));
        } else {
            IStatus status = Resources.makeCommittable((IResource[])new IResource[]{file}, null);
            if (!status.isOK()) {
                throw new ValidateEditException(status);
            }
            cu.applyTextEdit(edit, (IProgressMonitor)subMonitor.split(1));
            cu.save((IProgressMonitor)subMonitor.split(1), true);
        }
    }

    private JavaModelUtil() {
    }

    public static String[] getStaticImportFavorites(ICompilationUnit cu, final String elementName, boolean isMethod, String[] favorites) throws JavaModelException {
        StringBuilder dummyCU = new StringBuilder();
        String packName = cu.getParent().getElementName();
        IType type = cu.findPrimaryType();
        if (type == null) {
            return new String[0];
        }
        if (packName.length() > 0) {
            dummyCU.append("package ").append(packName).append(';');
        }
        dummyCU.append("public class ").append(type.getElementName()).append("{\n static {\n").append(elementName);
        int offset = dummyCU.length();
        dummyCU.append("\n}\n }");
        ICompilationUnit newCU = null;
        try {
            newCU = cu.getWorkingCopy(null);
            newCU.getBuffer().setContents(dummyCU.toString());
            final HashSet result = new HashSet();
            CompletionRequestor requestor = new CompletionRequestor(true){

                public void accept(CompletionProposal proposal) {
                    if (elementName.equals(new String(proposal.getName()))) {
                        CompletionProposal[] completionProposalArray = proposal.getRequiredProposals();
                        int n = completionProposalArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CompletionProposal curr = completionProposalArray[n2];
                            if (curr.getKind() == 22 || curr.getKind() == 21) {
                                result.add(JavaModelUtil.concatenateName(Signature.toCharArray((char[])curr.getDeclarationSignature()), curr.getName()));
                            }
                            ++n2;
                        }
                    }
                }
            };
            if (isMethod) {
                requestor.setIgnored(6, false);
                requestor.setAllowsRequiredProposals(6, 22, true);
            } else {
                requestor.setIgnored(2, false);
                requestor.setAllowsRequiredProposals(2, 21, true);
            }
            requestor.setFavoriteReferences(favorites);
            newCU.codeComplete(offset, requestor, (IProgressMonitor)new NullProgressMonitor());
            String[] stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
        finally {
            if (newCU != null) {
                newCU.discardWorkingCopy();
            }
        }
    }
}

