/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.BundleDefaultsScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.launching.CompositeId;
import org.eclipse.jdt.internal.launching.DefaultEntryResolver;
import org.eclipse.jdt.internal.launching.DefaultProjectClasspathEntry;
import org.eclipse.jdt.internal.launching.EEVMType;
import org.eclipse.jdt.internal.launching.JREContainerInitializer;
import org.eclipse.jdt.internal.launching.JavaSourceLookupUtil;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntryResolver;
import org.eclipse.jdt.internal.launching.RuntimeClasspathProvider;
import org.eclipse.jdt.internal.launching.SocketAttachConnector;
import org.eclipse.jdt.internal.launching.VMDefinitionsContainer;
import org.eclipse.jdt.internal.launching.VMListener;
import org.eclipse.jdt.internal.launching.VariableClasspathEntry;
import org.eclipse.jdt.internal.launching.environments.EnvironmentsManager;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry2;
import org.eclipse.jdt.launching.IRuntimeClasspathEntryResolver;
import org.eclipse.jdt.launching.IRuntimeClasspathEntryResolver2;
import org.eclipse.jdt.launching.IRuntimeClasspathProvider;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jdt.launching.StandardClasspathProvider;
import org.eclipse.jdt.launching.StandardSourcePathProvider;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.ExecutionEnvironmentDescription;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JavaRuntime {
    public static final String JRELIB_VARIABLE = "JRE_LIB";
    public static final String JRESRC_VARIABLE = "JRE_SRC";
    public static final String JRESRCROOT_VARIABLE = "JRE_SRCROOT";
    public static final String EXTENSION_POINT_RUNTIME_CLASSPATH_ENTRY_RESOLVERS = "runtimeClasspathEntryResolvers";
    public static final String EXTENSION_POINT_RUNTIME_CLASSPATH_PROVIDERS = "classpathProviders";
    public static final String EXTENSION_POINT_EXECUTION_ENVIRONMENTS = "executionEnvironments";
    public static final String EXTENSION_POINT_VM_INSTALLS = "vmInstalls";
    public static final String EXTENSION_POINT_LIBRARY_LOCATION_RESOLVERS = "libraryLocationResolvers";
    public static final String JRE_CONTAINER = LaunchingPlugin.getUniqueIdentifier() + ".JRE_CONTAINER";
    public static final String JRE_CONTAINER_MARKER = LaunchingPlugin.getUniqueIdentifier() + ".jreContainerMarker";
    public static final String JRE_COMPILER_COMPLIANCE_MARKER = LaunchingPlugin.getUniqueIdentifier() + ".jreCompilerComplianceMarker";
    public static final int ERR_UNABLE_TO_RESOLVE_JRE = 160;
    public static final String PREF_CONNECT_TIMEOUT = LaunchingPlugin.getUniqueIdentifier() + ".PREF_CONNECT_TIMEOUT";
    public static final String PREF_VM_XML = LaunchingPlugin.getUniqueIdentifier() + ".PREF_VM_XML";
    public static final String PREF_STRICTLY_COMPATIBLE_JRE_NOT_AVAILABLE = LaunchingPlugin.getUniqueIdentifier() + ".PREF_STRICTLY_COMPATIBLE_JRE_NOT_AVAILABLE";
    public static final String PREF_COMPILER_COMPLIANCE_DOES_NOT_MATCH_JRE = LaunchingPlugin.getUniqueIdentifier() + ".PREF_COMPILER_COMPLIANCE_DOES_NOT_MATCH_JRE";
    public static final String ID_PLUGIN = "org.eclipse.jdt.launching";
    public static final int DEF_CONNECT_TIMEOUT = 20000;
    @Deprecated
    public static final String ATTR_CMDLINE = LaunchingPlugin.getUniqueIdentifier() + ".launcher.cmdLine";
    public static final String PREF_ONLY_INCLUDE_EXPORTED_CLASSPATH_ENTRIES = "org.eclipse.jdt.launching.only_include_exported_classpath_entries";
    public static final String CLASSPATH_ATTR_LIBRARY_PATH_ENTRY = LaunchingPlugin.getUniqueIdentifier() + ".CLASSPATH_ATTR_LIBRARY_PATH_ENTRY";
    private static Object fgVMLock = new Object();
    private static boolean fgInitializingVMs = false;
    private static HashSet<Object> fgVMTypes = null;
    private static String fgDefaultVMId = null;
    private static String fgDefaultVMConnectorId = null;
    private static Map<String, IRuntimeClasspathEntryResolver> fgVariableResolvers = null;
    private static Map<String, IRuntimeClasspathEntryResolver> fgContainerResolvers = null;
    private static Map<String, RuntimeClasspathEntryResolver> fgRuntimeClasspathEntryResolvers = null;
    private static Map<String, RuntimeClasspathProvider> fgPathProviders = null;
    private static IRuntimeClasspathProvider fgDefaultClasspathProvider = new StandardClasspathProvider();
    private static IRuntimeClasspathProvider fgDefaultSourcePathProvider = new StandardSourcePathProvider();
    private static ListenerList<IVMInstallChangedListener> fgVMListeners = new ListenerList();
    private static ThreadLocal<List<IJavaProject>> fgProjects = new ThreadLocal();
    private static ThreadLocal<Integer> fgEntryCount = new ThreadLocal();
    private static Set<String> fgContributedVMs = new HashSet<String>();
    private static final String BLANK = " ";
    private static final String COMMA = ",";
    private static final String OPTION_START = "--";
    private static final String ADD_MODULES = "--add-modules ";
    private static final String LIMIT_MODULES = "--limit-modules ";

    private JavaRuntime() {
    }

    private static void initializeVMTypeExtensions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ID_PLUGIN, "vmInstallTypes");
        if (extensionPoint != null) {
            IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
            MultiStatus status = new MultiStatus(LaunchingPlugin.getUniqueIdentifier(), 0, "Exceptions occurred", null);
            fgVMTypes = new HashSet();
            int i = 0;
            while (i < configs.length) {
                try {
                    fgVMTypes.add(configs[i].createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                }
                ++i;
            }
            if (!status.isOK()) {
                LaunchingPlugin.log((IStatus)status);
            }
        } else {
            LaunchingPlugin.log((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), "VM Install extension point not found", null));
        }
    }

    public static IVMInstall getVMInstall(IJavaProject project) throws CoreException {
        IVMInstall vm = null;
        IClasspathEntry[] classpath = project.getRawClasspath();
        IRuntimeClasspathEntryResolver2 resolver = null;
        IClasspathEntry entry = null;
        int i = 0;
        while (i < classpath.length) {
            entry = classpath[i];
            switch (entry.getEntryKind()) {
                case 4: {
                    resolver = JavaRuntime.getVariableResolver(entry.getPath().segment(0));
                    if (resolver == null) break;
                    vm = resolver.resolveVMInstall(entry);
                    break;
                }
                case 5: {
                    resolver = JavaRuntime.getContainerResolver(entry.getPath().segment(0));
                    if (resolver == null) break;
                    vm = resolver.resolveVMInstall(entry);
                }
            }
            if (vm != null) {
                return vm;
            }
            ++i;
        }
        return null;
    }

    public static IVMInstallType getVMInstallType(String id) {
        IVMInstallType[] vmTypes = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < vmTypes.length) {
            if (vmTypes[i].getId().equals(id)) {
                return vmTypes[i];
            }
            ++i;
        }
        return null;
    }

    public static void setDefaultVMInstall(IVMInstall vm, IProgressMonitor monitor) throws CoreException {
        JavaRuntime.setDefaultVMInstall(vm, monitor, true);
    }

    public static void setDefaultVMInstall(IVMInstall vm, IProgressMonitor monitor, boolean savePreference) throws CoreException {
        IVMInstall previous = null;
        if (fgDefaultVMId != null) {
            previous = JavaRuntime.getVMFromCompositeId(fgDefaultVMId);
        }
        fgDefaultVMId = JavaRuntime.getCompositeIdFromVM(vm);
        if (savePreference) {
            JavaRuntime.saveVMConfiguration();
        }
        IVMInstall current = null;
        if (fgDefaultVMId != null) {
            current = JavaRuntime.getVMFromCompositeId(fgDefaultVMId);
        }
        if (previous != current) {
            JavaRuntime.notifyDefaultVMChanged(previous, current);
        }
    }

    public static void setDefaultVMConnector(IVMConnector connector, IProgressMonitor monitor) throws CoreException {
        fgDefaultVMConnectorId = connector.getIdentifier();
        JavaRuntime.saveVMConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IVMInstall getDefaultVMInstall() {
        File location;
        IVMInstall install = JavaRuntime.getVMFromCompositeId(JavaRuntime.getDefaultVMId());
        if (install != null && (location = install.getInstallLocation()) != null && location.exists()) {
            return install;
        }
        if (install != null) {
            install.getVMInstallType().disposeVMInstall(install.getId());
        }
        Object object = fgVMLock;
        synchronized (object) {
            fgDefaultVMId = null;
            fgVMTypes = null;
            JavaRuntime.initializeVMs();
        }
        return JavaRuntime.getVMFromCompositeId(JavaRuntime.getDefaultVMId());
    }

    public static IVMConnector getDefaultVMConnector() {
        String id = JavaRuntime.getDefaultVMConnectorId();
        IVMConnector connector = null;
        if (id != null) {
            connector = JavaRuntime.getVMConnector(id);
        }
        if (connector == null) {
            connector = new SocketAttachConnector();
        }
        return connector;
    }

    public static IVMInstallType[] getVMInstallTypes() {
        JavaRuntime.initializeVMs();
        return fgVMTypes.toArray(new IVMInstallType[fgVMTypes.size()]);
    }

    private static String getDefaultVMId() {
        JavaRuntime.initializeVMs();
        return fgDefaultVMId;
    }

    private static String getDefaultVMConnectorId() {
        JavaRuntime.initializeVMs();
        return fgDefaultVMConnectorId;
    }

    public static String getCompositeIdFromVM(IVMInstall vm) {
        if (vm == null) {
            return null;
        }
        IVMInstallType vmType = vm.getVMInstallType();
        String typeID = vmType.getId();
        CompositeId id = new CompositeId(new String[]{typeID, vm.getId()});
        return id.toString();
    }

    public static IVMInstall getVMFromCompositeId(String idString) {
        IVMInstallType vmType;
        if (idString == null || idString.length() == 0) {
            return null;
        }
        CompositeId id = CompositeId.fromString(idString);
        if (id.getPartCount() == 2 && (vmType = JavaRuntime.getVMInstallType(id.get(0))) != null) {
            return vmType.findVMInstall(id.get(1));
        }
        return null;
    }

    public static IRuntimeClasspathEntry newStringVariableClasspathEntry(String expression) {
        return new VariableClasspathEntry(expression);
    }

    public static IRuntimeClasspathEntry newDefaultProjectClasspathEntry(IJavaProject project) {
        return new DefaultProjectClasspathEntry(project);
    }

    public static IRuntimeClasspathEntry newProjectRuntimeClasspathEntry(IJavaProject project) {
        return JavaRuntime.newRuntimeClasspathEntry(JavaCore.newProjectEntry((IPath)project.getProject().getFullPath()));
    }

    public static IRuntimeClasspathEntry newProjectRuntimeClasspathEntry(IJavaProject project, int classpathProperty) {
        return JavaRuntime.newRuntimeClasspathEntry(JavaCore.newProjectEntry((IPath)project.getProject().getFullPath()), classpathProperty);
    }

    public static IRuntimeClasspathEntry newArchiveRuntimeClasspathEntry(IResource resource) {
        return JavaRuntime.newRuntimeClasspathEntry(JavaCore.newLibraryEntry((IPath)resource.getFullPath(), null, null));
    }

    public static IRuntimeClasspathEntry newArchiveRuntimeClasspathEntry(IPath path, int classpathProperty) {
        return JavaRuntime.newRuntimeClasspathEntry(JavaCore.newLibraryEntry((IPath)path, null, null), classpathProperty);
    }

    public static IRuntimeClasspathEntry newArchiveRuntimeClasspathEntry(IPath path, int classpathProperty, IJavaProject javaProject) {
        RuntimeClasspathEntry entry = new RuntimeClasspathEntry(JavaCore.newLibraryEntry((IPath)path, null, null), classpathProperty);
        entry.setJavaProject(javaProject);
        return entry;
    }

    public static IRuntimeClasspathEntry newArchiveRuntimeClasspathEntry(IPath path) {
        return JavaRuntime.newRuntimeClasspathEntry(JavaCore.newLibraryEntry((IPath)path, null, null));
    }

    public static IRuntimeClasspathEntry newArchiveRuntimeClasspathEntry(IPath path, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IAccessRule[] accessRules, IClasspathAttribute[] extraAttributes, boolean isExported) {
        return JavaRuntime.newRuntimeClasspathEntry(JavaCore.newLibraryEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, (IAccessRule[])accessRules, (IClasspathAttribute[])extraAttributes, (boolean)isExported));
    }

    public static IRuntimeClasspathEntry newVariableRuntimeClasspathEntry(IPath path) {
        return JavaRuntime.newRuntimeClasspathEntry(JavaCore.newVariableEntry((IPath)path, null, null));
    }

    public static IRuntimeClasspathEntry newRuntimeContainerClasspathEntry(IPath path, int classpathProperty) throws CoreException {
        return JavaRuntime.newRuntimeContainerClasspathEntry(path, classpathProperty, null);
    }

    public static IRuntimeClasspathEntry newRuntimeContainerClasspathEntry(IPath path, int classpathProperty, IJavaProject project) throws CoreException {
        RuntimeClasspathEntry entry = new RuntimeClasspathEntry(JavaCore.newContainerEntry((IPath)path), classpathProperty);
        entry.setJavaProject(project);
        return entry;
    }

    public static IRuntimeClasspathEntry newRuntimeClasspathEntry(String memento) throws CoreException {
        try {
            Element root = null;
            DocumentBuilder parser = LaunchingPlugin.getParser();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            String id = root.getAttribute("id");
            if (id == null || id.length() == 0) {
                return new RuntimeClasspathEntry(root);
            }
            IRuntimeClasspathEntry2 entry = LaunchingPlugin.getDefault().newRuntimeClasspathEntry(id);
            NodeList list = root.getChildNodes();
            Node node = null;
            Element element = null;
            int i = 0;
            while (i < list.getLength()) {
                node = list.item(i);
                if (node.getNodeType() == 1 && "memento".equals((element = (Element)node).getNodeName())) {
                    entry.initializeFrom(element);
                }
                ++i;
            }
            return entry;
        }
        catch (SAXException e) {
            JavaRuntime.abort(LaunchingMessages.JavaRuntime_32, e);
        }
        catch (IOException e) {
            JavaRuntime.abort(LaunchingMessages.JavaRuntime_32, e);
        }
        return null;
    }

    private static IRuntimeClasspathEntry newRuntimeClasspathEntry(IClasspathEntry entry) {
        return new RuntimeClasspathEntry(entry);
    }

    private static IRuntimeClasspathEntry newRuntimeClasspathEntry(IClasspathEntry entry, int classPathProperty) {
        return new RuntimeClasspathEntry(entry, classPathProperty);
    }

    public static IRuntimeClasspathEntry[] computeUnresolvedRuntimeClasspath(IJavaProject project) throws CoreException {
        return JavaRuntime.computeUnresolvedRuntimeClasspath(project, false);
    }

    public static IRuntimeClasspathEntry[] computeUnresolvedRuntimeClasspath(IJavaProject project, boolean excludeTestCode) throws CoreException {
        IClasspathEntry[] entries = project.getRawClasspath();
        ArrayList<IRuntimeClasspathEntry> classpathEntries = new ArrayList<IRuntimeClasspathEntry>(3);
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            switch (entry.getEntryKind()) {
                case 5: {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
                    if (container == null) break;
                    switch (container.getKind()) {
                        case 1: {
                            break;
                        }
                        case 3: {
                            classpathEntries.add(JavaRuntime.newRuntimeContainerClasspathEntry(container.getPath(), 1, project));
                            break;
                        }
                        case 2: {
                            classpathEntries.add(JavaRuntime.newRuntimeContainerClasspathEntry(container.getPath(), 2, project));
                        }
                    }
                    break;
                }
                case 4: {
                    if (!JRELIB_VARIABLE.equals(entry.getPath().segment(0))) break;
                    IRuntimeClasspathEntry jre = JavaRuntime.newVariableRuntimeClasspathEntry(entry.getPath());
                    jre.setClasspathProperty(1);
                    classpathEntries.add(jre);
                    break;
                }
            }
            ++i;
        }
        classpathEntries.add(JavaRuntime.newDefaultProjectClasspathEntry(project));
        return classpathEntries.toArray(new IRuntimeClasspathEntry[classpathEntries.size()]);
    }

    public static IRuntimeClasspathEntry[] computeUnresolvedRuntimeDependencies(IJavaProject project) throws CoreException {
        return JavaRuntime.computeUnresolvedRuntimeDependencies(project, false);
    }

    public static IRuntimeClasspathEntry[] computeUnresolvedRuntimeDependencies(IJavaProject project, boolean excludeTestCode) throws CoreException {
        IClasspathEntry entry1 = JavaCore.newProjectEntry((IPath)project.getProject().getFullPath());
        ArrayList<Object> classpathEntries = new ArrayList<Object>(5);
        ArrayList<IClasspathEntry> expanding = new ArrayList<IClasspathEntry>(5);
        boolean exportedEntriesOnly = Platform.getPreferencesService().getBoolean(ID_PLUGIN, PREF_ONLY_INCLUDE_EXPORTED_CLASSPATH_ENTRIES, false, null);
        DefaultProjectClasspathEntry.expandProject(entry1, classpathEntries, expanding, excludeTestCode, exportedEntriesOnly, project, true);
        IRuntimeClasspathEntry[] runtimeEntries = new IRuntimeClasspathEntry[classpathEntries.size()];
        int i = 0;
        while (i < runtimeEntries.length) {
            Object e = classpathEntries.get(i);
            if (e instanceof IClasspathEntry) {
                IClasspathEntry cpe = (IClasspathEntry)e;
                if (cpe == entry1) {
                    runtimeEntries[i] = JavaRuntime.isModularProject(project) ? new RuntimeClasspathEntry(entry1, 4) : new RuntimeClasspathEntry(entry1, 5);
                } else {
                    runtimeEntries[i] = new RuntimeClasspathEntry(cpe);
                    DefaultProjectClasspathEntry.adjustClasspathProperty(runtimeEntries[i], cpe);
                }
            } else {
                runtimeEntries[i] = (IRuntimeClasspathEntry)e;
            }
            ++i;
        }
        ArrayList<IRuntimeClasspathEntry> ordered = new ArrayList<IRuntimeClasspathEntry>(runtimeEntries.length);
        int i2 = 0;
        while (i2 < runtimeEntries.length) {
            if (runtimeEntries[i2].getClasspathProperty() != 1 && runtimeEntries[i2].getClasspathProperty() != 2) {
                ordered.add(runtimeEntries[i2]);
            }
            ++i2;
        }
        IRuntimeClasspathEntry jreEntry = JavaRuntime.computeModularJREEntry(project);
        if (jreEntry != null) {
            ordered.add(jreEntry);
        }
        return ordered.toArray(new IRuntimeClasspathEntry[ordered.size()]);
    }

    public static boolean isModule(IClasspathEntry entry, IJavaProject proj) {
        if (entry == null) {
            return false;
        }
        if (!JavaRuntime.isModularProject(proj)) {
            return false;
        }
        return ClasspathEntry.isModular((IClasspathEntry)entry);
    }

    public static boolean isModularConfiguration(ILaunchConfiguration configuration) {
        try {
            IVMInstall vm = JavaRuntime.computeVMInstall(configuration);
            return JavaRuntime.isModularJava(vm);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isModularJava(IVMInstall vm) {
        return JavaRuntime.compareJavaVersions(vm, "1.8") > 0;
    }

    public static int compareJavaVersions(IVMInstall vm, String ver) {
        if (vm instanceof AbstractVMInstall) {
            AbstractVMInstall install = (AbstractVMInstall)vm;
            String vmver = install.getJavaVersion();
            if (vmver == null) {
                return -1;
            }
            if (vmver.length() > 3) {
                vmver = vmver.substring(0, 3);
            }
            return JavaCore.compareJavaVersions((String)vmver, (String)ver);
        }
        return -1;
    }

    public static boolean isModularProject(IJavaProject proj) {
        try {
            String modName;
            IModuleDescription module = proj == null ? null : proj.getModuleDescription();
            String string = modName = module == null ? null : module.getElementName();
            if (modName != null && modName.length() > 0) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public static IRuntimeClasspathEntry[] computeUnresolvedSourceLookupPath(ILaunchConfiguration configuration) throws CoreException {
        return JavaRuntime.getSourceLookupPathProvider(configuration).computeUnresolvedClasspath(configuration);
    }

    public static IRuntimeClasspathEntry[] resolveSourceLookupPath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        return JavaRuntime.getSourceLookupPathProvider(configuration).resolveClasspath(entries, configuration);
    }

    public static IRuntimeClasspathProvider getClasspathProvider(ILaunchConfiguration configuration) throws CoreException {
        String providerId = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, null);
        IRuntimeClasspathProvider provider = null;
        if (providerId == null) {
            provider = fgDefaultClasspathProvider;
        } else {
            provider = JavaRuntime.getClasspathProviders().get(providerId);
            if (provider == null) {
                JavaRuntime.abort(NLS.bind((String)LaunchingMessages.JavaRuntime_26, (Object[])new String[]{providerId}), null);
            }
        }
        return provider;
    }

    public static IRuntimeClasspathProvider getSourceLookupPathProvider(ILaunchConfiguration configuration) throws CoreException {
        String providerId = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, null);
        IRuntimeClasspathProvider provider = null;
        if (providerId == null) {
            provider = fgDefaultSourcePathProvider;
        } else {
            provider = JavaRuntime.getClasspathProviders().get(providerId);
            if (provider == null) {
                JavaRuntime.abort(NLS.bind((String)LaunchingMessages.JavaRuntime_27, (Object[])new String[]{providerId}), null);
            }
        }
        return provider;
    }

    public static IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        boolean excludeTestCode = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_EXCLUDE_TEST_CODE, false);
        switch (entry.getType()) {
            case 1: {
                IResource resource = entry.getResource();
                if (resource instanceof IProject) {
                    IProject p = (IProject)resource;
                    IJavaProject project = JavaCore.create((IProject)p);
                    if (project == null || !p.isOpen() || !project.exists()) {
                        return new IRuntimeClasspathEntry[0];
                    }
                    IClasspathAttribute[] attributes = entry.getClasspathEntry().getExtraAttributes();
                    IRuntimeClasspathEntry[] entries = JavaRuntime.resolveOutputLocations(project, entry.getClasspathProperty(), attributes, excludeTestCode);
                    if (entries == null) break;
                    return entries;
                }
                if (JavaRuntime.isOptional(entry.getClasspathEntry())) {
                    return new IRuntimeClasspathEntry[0];
                }
                JavaRuntime.abort(NLS.bind((String)LaunchingMessages.JavaRuntime_Classpath_references_non_existant_project___0__3, (Object[])new String[]{entry.getPath().lastSegment()}), null);
                break;
            }
            case 3: {
                IRuntimeClasspathEntryResolver2 resolver = JavaRuntime.getVariableResolver(entry.getVariableName());
                if (resolver == null) {
                    IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveVariableEntry(entry, null, false, configuration);
                    if (resolved == null) break;
                    return resolved;
                }
                return resolver.resolveRuntimeClasspathEntry(entry, configuration);
            }
            case 4: {
                IRuntimeClasspathEntryResolver2 resolver = JavaRuntime.getContainerResolver(entry.getVariableName());
                if (resolver == null) {
                    return JavaRuntime.computeDefaultContainerEntries(entry, configuration, excludeTestCode);
                }
                return resolver.resolveRuntimeClasspathEntry(entry, configuration);
            }
            case 2: {
                File file;
                String location = entry.getLocation();
                if (location != null && (file = new File(location)).exists()) break;
                if (JavaRuntime.isOptional(entry.getClasspathEntry())) {
                    return new IRuntimeClasspathEntry[0];
                }
                JavaRuntime.abort(NLS.bind((String)LaunchingMessages.JavaRuntime_Classpath_references_non_existant_archive___0__4, (Object[])new String[]{entry.getPath().toString()}), null);
            }
            case 5: {
                IRuntimeClasspathEntryResolver resolver = JavaRuntime.getContributedResolver(((IRuntimeClasspathEntry2)entry).getTypeId());
                return resolver.resolveRuntimeClasspathEntry(entry, configuration);
            }
        }
        return new IRuntimeClasspathEntry[]{entry};
    }

    private static boolean isOptional(IClasspathEntry entry) {
        IClasspathAttribute[] extraAttributes = entry.getExtraAttributes();
        int i = 0;
        int length = extraAttributes.length;
        while (i < length) {
            IClasspathAttribute attribute = extraAttributes[i];
            if ("optional".equals(attribute.getName()) && Boolean.parseBoolean(attribute.getValue())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static IRuntimeClasspathEntry[] resolveVariableEntry(IRuntimeClasspathEntry entry, IJavaProject project, boolean excludeTestCode, ILaunchConfiguration configuration) throws CoreException {
        IPath archPath = JavaCore.getClasspathVariable((String)entry.getVariableName());
        if (archPath != null) {
            if (entry.getPath().segmentCount() > 1) {
                archPath = archPath.append(entry.getPath().removeFirstSegments(1));
            }
            IPath srcPath = null;
            IPath srcVar = entry.getSourceAttachmentPath();
            IPath srcRootPath = null;
            IPath srcRootVar = entry.getSourceAttachmentRootPath();
            if (archPath != null && !archPath.isEmpty()) {
                if (srcVar != null && !srcVar.isEmpty() && (srcPath = JavaCore.getClasspathVariable((String)srcVar.segment(0))) != null) {
                    if (srcVar.segmentCount() > 1) {
                        srcPath = srcPath.append(srcVar.removeFirstSegments(1));
                    }
                    if (srcRootVar != null && !srcRootVar.isEmpty() && (srcRootPath = JavaCore.getClasspathVariable((String)srcRootVar.segment(0))) != null && srcRootVar.segmentCount() > 1) {
                        srcRootPath = srcRootPath.append(srcRootVar.removeFirstSegments(1));
                    }
                }
                IClasspathEntry cpEntry = entry.getClasspathEntry();
                IClasspathEntry archEntry = JavaCore.newLibraryEntry((IPath)archPath, (IPath)srcPath, srcRootPath, null, (IClasspathAttribute[])cpEntry.getExtraAttributes(), (boolean)cpEntry.isExported());
                IRuntimeClasspathEntry runtimeArchEntry = JavaRuntime.newRuntimeClasspathEntry(archEntry);
                runtimeArchEntry.setClasspathProperty(entry.getClasspathProperty());
                if (configuration == null) {
                    return JavaRuntime.resolveRuntimeClasspathEntry(runtimeArchEntry, project, excludeTestCode);
                }
                return JavaRuntime.resolveRuntimeClasspathEntry(runtimeArchEntry, configuration);
            }
        }
        return null;
    }

    private static IRuntimeClasspathEntry[] resolveOutputLocations(IJavaProject project, int classpathProperty, IClasspathAttribute[] attributes, boolean excludeTestCode) throws CoreException {
        boolean isModular;
        ArrayList<IPath> nonDefault = new ArrayList<IPath>();
        boolean defaultUsedByNonTest = false;
        if (project.exists() && project.getProject().isOpen()) {
            IClasspathEntry[] entries = project.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry classpathEntry = entries[i];
                if (classpathEntry.getEntryKind() == 3) {
                    IPath path = classpathEntry.getOutputLocation();
                    if (path != null) {
                        if (!excludeTestCode || !classpathEntry.isTest()) {
                            nonDefault.add(path);
                        }
                    } else if (!classpathEntry.isTest()) {
                        defaultUsedByNonTest = true;
                    }
                }
                ++i;
            }
        }
        boolean bl = isModular = project.getOwnModuleDescription() != null;
        if (nonDefault.isEmpty() && !isModular && !excludeTestCode) {
            return null;
        }
        IPath def = project.getOutputLocation();
        if (!(excludeTestCode && !defaultUsedByNonTest || nonDefault.contains(def))) {
            nonDefault.add(def);
        }
        IRuntimeClasspathEntry[] locations = new IRuntimeClasspathEntry[nonDefault.size()];
        int i = 0;
        while (i < locations.length) {
            IClasspathEntry newEntry = JavaCore.newLibraryEntry((IPath)((IPath)nonDefault.get(i)), null, null, null, (IClasspathAttribute[])attributes, (boolean)false);
            locations[i] = new RuntimeClasspathEntry(newEntry);
            if (isModular && !JavaRuntime.containsModuleInfo(locations[i])) {
                locations[i].setClasspathProperty(6);
                ((RuntimeClasspathEntry)locations[i]).setJavaProject(project);
            } else {
                locations[i].setClasspathProperty(classpathProperty);
            }
            ++i;
        }
        return locations;
    }

    private static boolean containsModuleInfo(IRuntimeClasspathEntry entry) {
        return new File(entry.getLocation() + File.separator + "module-info.class").exists();
    }

    public static IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, IJavaProject project) throws CoreException {
        return JavaRuntime.resolveRuntimeClasspathEntry(entry, project, false);
    }

    public static IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, IJavaProject project, boolean excludeTestCode) throws CoreException {
        switch (entry.getType()) {
            case 1: {
                IResource resource = entry.getResource();
                if (!(resource instanceof IProject)) break;
                IProject p = (IProject)resource;
                IJavaProject jp = JavaCore.create((IProject)p);
                if (jp != null && p.isOpen() && jp.exists()) {
                    IClasspathAttribute[] attributes = entry.getClasspathEntry().getExtraAttributes();
                    IRuntimeClasspathEntry[] entries = JavaRuntime.resolveOutputLocations(jp, entry.getClasspathProperty(), attributes, excludeTestCode);
                    if (entries == null) break;
                    return entries;
                }
                return new IRuntimeClasspathEntry[0];
            }
            case 3: {
                IRuntimeClasspathEntryResolver2 resolver = JavaRuntime.getVariableResolver(entry.getVariableName());
                if (resolver == null) {
                    IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveVariableEntry(entry, project, excludeTestCode, null);
                    if (resolved == null) break;
                    return resolved;
                }
                return resolver.resolveRuntimeClasspathEntry(entry, project, excludeTestCode);
            }
            case 4: {
                IRuntimeClasspathEntryResolver2 resolver = JavaRuntime.getContainerResolver(entry.getVariableName());
                if (resolver == null) {
                    return JavaRuntime.computeDefaultContainerEntries(entry, project, excludeTestCode);
                }
                return resolver.resolveRuntimeClasspathEntry(entry, project, excludeTestCode);
            }
            case 5: {
                IRuntimeClasspathEntryResolver resolver = JavaRuntime.getContributedResolver(((IRuntimeClasspathEntry2)entry).getTypeId());
                return resolver.resolveRuntimeClasspathEntry(entry, project, excludeTestCode);
            }
        }
        return new IRuntimeClasspathEntry[]{entry};
    }

    private static IRuntimeClasspathEntry[] computeDefaultContainerEntries(IRuntimeClasspathEntry entry, ILaunchConfiguration config, boolean excludeTestCode) throws CoreException {
        IJavaProject project = entry.getJavaProject();
        if (project == null) {
            project = JavaRuntime.getJavaProject(config);
        }
        return JavaRuntime.computeDefaultContainerEntries(entry, project, excludeTestCode);
    }

    private static IRuntimeClasspathEntry[] computeDefaultContainerEntries(IRuntimeClasspathEntry entry, IJavaProject project, boolean excludeTestCode) throws CoreException {
        if (project == null || entry == null) {
            return new IRuntimeClasspathEntry[0];
        }
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
        if (container == null) {
            JavaRuntime.abort(NLS.bind((String)LaunchingMessages.JavaRuntime_Could_not_resolve_classpath_container___0__1, (Object[])new String[]{entry.getPath().toString()}), null);
            return null;
        }
        IClasspathEntry[] cpes = container.getClasspathEntries();
        int property = -1;
        block1 : switch (container.getKind()) {
            case 1: {
                switch (entry.getClasspathProperty()) {
                    case 4: {
                        property = 4;
                        break block1;
                    }
                    case 5: {
                        property = 5;
                        break block1;
                    }
                }
                property = 3;
                break;
            }
            case 3: {
                property = 1;
                break;
            }
            case 2: {
                property = 2;
            }
        }
        ArrayList<IRuntimeClasspathEntry> resolved = new ArrayList<IRuntimeClasspathEntry>(cpes.length);
        List<IJavaProject> projects = fgProjects.get();
        Integer count = fgEntryCount.get();
        if (projects == null) {
            projects = new ArrayList<IJavaProject>();
            fgProjects.set(projects);
            count = 0;
        }
        int intCount = count;
        fgEntryCount.set(++intCount);
        try {
            int i = 0;
            while (i < cpes.length) {
                IClasspathEntry cpe = cpes[i];
                if (cpe.getEntryKind() == 2) {
                    IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(cpe.getPath().segment(0));
                    IJavaProject jp = JavaCore.create((IProject)p);
                    if (!projects.contains(jp)) {
                        projects.add(jp);
                        IRuntimeClasspathEntry classpath = JavaRuntime.newDefaultProjectClasspathEntry(jp);
                        IRuntimeClasspathEntry[] entries = JavaRuntime.resolveRuntimeClasspathEntry(classpath, jp, excludeTestCode);
                        int j = 0;
                        while (j < entries.length) {
                            IRuntimeClasspathEntry e = entries[j];
                            if (!resolved.contains(e)) {
                                resolved.add(entries[j]);
                            }
                            ++j;
                        }
                    }
                } else {
                    IRuntimeClasspathEntry e = JavaRuntime.newRuntimeClasspathEntry(cpe);
                    if (!resolved.contains(e)) {
                        resolved.add(e);
                    }
                }
                ++i;
            }
        }
        finally {
            if (--intCount == 0) {
                fgProjects.remove();
                fgEntryCount.remove();
            } else {
                fgEntryCount.set(intCount);
            }
        }
        IRuntimeClasspathEntry[] result = new IRuntimeClasspathEntry[resolved.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (IRuntimeClasspathEntry)resolved.get(i);
            result[i].setClasspathProperty(property);
            ++i;
        }
        return result;
    }

    public static IRuntimeClasspathEntry[] computeUnresolvedRuntimeClasspath(ILaunchConfiguration configuration) throws CoreException {
        return JavaRuntime.getClasspathProvider(configuration).computeUnresolvedClasspath(configuration);
    }

    public static IRuntimeClasspathEntry[] resolveRuntimeClasspath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        IJavaProject project;
        if (!JavaRuntime.isModularConfiguration(configuration)) {
            return JavaRuntime.getClasspathProvider(configuration).resolveClasspath(entries, configuration);
        }
        IRuntimeClasspathEntry[] entries1 = JavaRuntime.getClasspathProvider(configuration).resolveClasspath(entries, configuration);
        ArrayList<IRuntimeClasspathEntry> entries2 = new ArrayList<IRuntimeClasspathEntry>(entries1.length);
        try {
            project = JavaRuntime.getJavaProject(configuration);
        }
        catch (CoreException coreException) {
            project = null;
        }
        if (project == null) {
            entries2.addAll(Arrays.asList(entries1));
        } else {
            IPackageFragmentRoot jreContainer = JavaRuntime.findJreContainer(project);
            IPath jrePath = jreContainer != null ? jreContainer.getPath() : null;
            IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = entries1;
            int n = entries1.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n2];
                switch (entry.getClasspathEntry().getEntryKind()) {
                    case 1: {
                        if (entry.getPath().lastSegment().contains("jrt-fs.jar") || jrePath != null && jrePath.equals((Object)entry.getPath())) break;
                        entries2.add(entry);
                        break;
                    }
                    default: {
                        entries2.add(entry);
                    }
                }
                ++n2;
            }
        }
        return entries2.toArray(new IRuntimeClasspathEntry[entries2.size()]);
    }

    private static IPackageFragmentRoot findJreContainer(IJavaProject project) throws JavaModelException {
        IPackageFragmentRoot[] allPackageFragmentRoots;
        IPackageFragmentRoot jreContainer = null;
        IPackageFragmentRoot[] iPackageFragmentRootArray = allPackageFragmentRoots = project.getAllPackageFragmentRoots();
        int n = allPackageFragmentRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
            if (packageFragmentRoot.getRawClasspathEntry().getPath().segment(0).contains("JRE_CONTAINER")) {
                jreContainer = packageFragmentRoot;
                break;
            }
            ++n2;
        }
        return jreContainer;
    }

    public static IJavaProject getJavaProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        if (projectName == null || projectName.trim().length() < 1) {
            return null;
        }
        IJavaProject javaProject = JavaRuntime.getJavaModel().getJavaProject(projectName);
        if (javaProject != null && javaProject.getProject().exists() && !javaProject.getProject().isOpen()) {
            JavaRuntime.abort(NLS.bind((String)LaunchingMessages.JavaRuntime_28, (Object[])new String[]{configuration.getName(), projectName}), 124, null);
        }
        if (javaProject == null || !javaProject.exists()) {
            JavaRuntime.abort(NLS.bind((String)LaunchingMessages.JavaRuntime_Launch_configuration__0__references_non_existing_project__1___1, (Object[])new String[]{configuration.getName(), projectName}), 107, null);
        }
        return javaProject;
    }

    private static IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IVMInstall computeVMInstall(ILaunchConfiguration configuration) throws CoreException {
        String jreAttr = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, null);
        if (jreAttr == null) {
            String type = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
            if (type == null) {
                IVMInstall vm;
                IJavaProject proj = JavaRuntime.getJavaProject(configuration);
                if (proj == null || (vm = JavaRuntime.getVMInstall(proj)) == null) return JavaRuntime.getDefaultVMInstall();
                return vm;
            }
            String name = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
            return JavaRuntime.resolveVM(type, name, configuration);
        }
        IPath jrePath = Path.fromPortableString((String)jreAttr);
        IClasspathEntry entry = JavaCore.newContainerEntry((IPath)jrePath);
        IRuntimeClasspathEntryResolver2 resolver = JavaRuntime.getVariableResolver(jrePath.segment(0));
        if (resolver != null) {
            return resolver.resolveVMInstall(entry);
        }
        resolver = JavaRuntime.getContainerResolver(jrePath.segment(0));
        if (resolver == null) return JavaRuntime.getDefaultVMInstall();
        return resolver.resolveVMInstall(entry);
    }

    private static IVMInstall resolveVM(String type, String name, ILaunchConfiguration configuration) throws CoreException {
        IVMInstallType vt = JavaRuntime.getVMInstallType(type);
        if (vt == null) {
            JavaRuntime.abort(NLS.bind((String)LaunchingMessages.JavaRuntime_Specified_VM_install_type_does_not_exist___0__2, (Object[])new String[]{type}), null);
        }
        IVMInstall vm = null;
        if (name == null) {
            LaunchingPlugin.log((IStatus)new Status(2, LaunchingPlugin.getUniqueIdentifier(), 103, NLS.bind((String)"VM not fully specified in launch configuration {0} - missing VM name. Reverting to default VM.", (Object[])new String[]{configuration.getName()}), null));
            return JavaRuntime.getDefaultVMInstall();
        }
        vm = vt.findVMInstallByName(name);
        if (vm != null) {
            return vm;
        }
        JavaRuntime.abort(NLS.bind((String)LaunchingMessages.JavaRuntime_Specified_VM_install_not_found__type__0___name__1__2, (Object[])new String[]{vt.getName(), name}), null);
        return null;
    }

    private static void abort(String message, Throwable exception) throws CoreException {
        JavaRuntime.abort(message, 150, exception);
    }

    private static void abort(String message, int code, Throwable exception) throws CoreException {
        throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), code, message, exception));
    }

    public static String[] computeDefaultRuntimeClassPath(IJavaProject jproject) throws CoreException {
        IRuntimeClasspathEntry[] unresolved = JavaRuntime.computeUnresolvedRuntimeClasspath(jproject);
        ArrayList<String> resolved = new ArrayList<String>(unresolved.length);
        int i = 0;
        while (i < unresolved.length) {
            IRuntimeClasspathEntry entry = unresolved[i];
            if (entry.getClasspathProperty() == 3) {
                IRuntimeClasspathEntry[] entries = JavaRuntime.resolveRuntimeClasspathEntry(entry, jproject);
                int j = 0;
                while (j < entries.length) {
                    String location = entries[j].getLocation();
                    if (location != null) {
                        resolved.add(location);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return resolved.toArray(new String[resolved.size()]);
    }

    public static void saveVMConfiguration() throws CoreException {
        if (fgVMTypes == null) {
            return;
        }
        String xml = JavaRuntime.getVMsAsXML();
        InstanceScope.INSTANCE.getNode(ID_PLUGIN).put(PREF_VM_XML, xml);
        JavaRuntime.savePreferences();
    }

    private static String getVMsAsXML() throws CoreException {
        VMDefinitionsContainer container = new VMDefinitionsContainer();
        container.setDefaultVMInstallCompositeID(JavaRuntime.getDefaultVMId());
        container.setDefaultVMInstallConnectorTypeID(JavaRuntime.getDefaultVMConnectorId());
        IVMInstallType[] vmTypes = JavaRuntime.getVMInstallTypes();
        IVMInstall[] vms = null;
        int i = 0;
        while (i < vmTypes.length) {
            vms = vmTypes[i].getVMInstalls();
            int j = 0;
            while (j < vms.length) {
                container.addVM(vms[j]);
                ++j;
            }
            ++i;
        }
        return container.getAsXML();
    }

    private static boolean addPersistedVMs(VMDefinitionsContainer vmDefs) throws IOException {
        String vmXMLString = InstanceScope.INSTANCE.getNode(ID_PLUGIN).get(PREF_VM_XML, "");
        if (vmXMLString.length() > 0) {
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(vmXMLString.getBytes("UTF8"));
                VMDefinitionsContainer.parseXMLIntoContainer(inputStream, vmDefs);
                return false;
            }
            catch (IOException ioe) {
                LaunchingPlugin.log(ioe);
            }
        } else {
            IPath stateLocation = LaunchingPlugin.getDefault().getStateLocation();
            IPath stateFile = stateLocation.append("vmConfiguration.xml");
            File file = new File(stateFile.toOSString());
            if (file.exists()) {
                BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(file));
                VMDefinitionsContainer.parseXMLIntoContainer(fileInputStream, vmDefs);
            }
        }
        return true;
    }

    private static void addVMExtensions(VMDefinitionsContainer vmDefs) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ID_PLUGIN, EXTENSION_POINT_VM_INSTALLS);
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configs.length) {
            block29: {
                IConfigurationElement element = configs[i];
                try {
                    if ("vmInstall".equals(element.getName())) {
                        IVMInstall install;
                        IVMInstallType installType;
                        String id;
                        String vmType = element.getAttribute("vmInstallType");
                        if (vmType == null) {
                            JavaRuntime.abort(NLS.bind((String)"Missing required vmInstallType attribute for vmInstall contributed by {0}", (Object[])new String[]{element.getContributor().getName()}), null);
                        }
                        if ((id = element.getAttribute("id")) == null) {
                            JavaRuntime.abort(NLS.bind((String)"Missing required id attribute for vmInstall contributed by {0}", (Object[])new String[]{element.getContributor().getName()}), null);
                        }
                        if ((installType = JavaRuntime.getVMInstallType(vmType)) == null) {
                            JavaRuntime.abort(NLS.bind((String)"vmInstall {0} contributed by {1} references undefined VM install type {2}", (Object[])new String[]{id, element.getContributor().getName(), vmType}), null);
                        }
                        if ((install = installType.findVMInstall(id)) == null) {
                            String home;
                            String name = element.getAttribute("name");
                            if (name == null) {
                                JavaRuntime.abort(NLS.bind((String)"vmInstall {0} contributed by {1} missing required attribute name", (Object[])new String[]{id, element.getContributor().getName()}), null);
                            }
                            if ((home = element.getAttribute("home")) == null) {
                                JavaRuntime.abort(NLS.bind((String)"vmInstall {0} contributed by {1} missing required attribute home", (Object[])new String[]{id, element.getContributor().getName()}), null);
                            }
                            String javadoc = element.getAttribute("javadocURL");
                            String vmArgs = element.getAttribute("vmArgs");
                            VMStandin standin = null;
                            File homeDir = new File(home = JavaRuntime.substitute(home));
                            if (homeDir.exists()) {
                                try {
                                    home = homeDir.getCanonicalPath();
                                    homeDir = new File(home);
                                }
                                catch (IOException iOException) {}
                            }
                            if ("org.eclipse.jdt.launching.EEVMType".equals(installType.getId())) {
                                standin = JavaRuntime.createVMFromDefinitionFile(homeDir, name, id);
                            } else {
                                standin = new VMStandin(installType, id);
                                standin.setName(name);
                                IStatus status = installType.validateInstallLocation(homeDir);
                                if (!status.isOK()) {
                                    JavaRuntime.abort(NLS.bind((String)"Illegal install location {0} for vmInstall {1} contributed by {2}: {3}", (Object[])new String[]{home, id, element.getContributor().getName(), status.getMessage()}), null);
                                }
                                standin.setInstallLocation(homeDir);
                                if (javadoc != null) {
                                    try {
                                        standin.setJavadocLocation(new URL(javadoc));
                                    }
                                    catch (MalformedURLException e) {
                                        JavaRuntime.abort(NLS.bind((String)"Illegal javadocURL attribute for vmInstall {0} contributed by {1}", (Object[])new String[]{id, element.getContributor().getName()}), e);
                                    }
                                }
                                if (vmArgs == null && installType instanceof AbstractVMInstallType) {
                                    AbstractVMInstallType type = (AbstractVMInstallType)installType;
                                    vmArgs = type.getDefaultVMArguments(homeDir);
                                }
                                if (vmArgs != null) {
                                    standin.setVMArgs(vmArgs);
                                }
                                IConfigurationElement[] libraries = element.getChildren("library");
                                LibraryLocation[] locations = null;
                                if (libraries.length > 0) {
                                    locations = new LibraryLocation[libraries.length];
                                    int j = 0;
                                    while (j < libraries.length) {
                                        IConfigurationElement library = libraries[j];
                                        String libPathStr = library.getAttribute("path");
                                        if (libPathStr == null) {
                                            JavaRuntime.abort(NLS.bind((String)"library for vmInstall {0} contributed by {1} missing required attribute libPath", (Object[])new String[]{id, element.getContributor().getName()}), null);
                                        }
                                        String sourcePathStr = library.getAttribute("sourcePath");
                                        String packageRootStr = library.getAttribute("packageRootPath");
                                        String javadocOverride = library.getAttribute("javadocURL");
                                        URL url = null;
                                        if (javadocOverride != null) {
                                            try {
                                                url = new URL(javadocOverride);
                                            }
                                            catch (MalformedURLException e) {
                                                JavaRuntime.abort(NLS.bind((String)"Illegal javadocURL attribute specified for library {0} for vmInstall {1} contributed by {2}", (Object[])new String[]{libPathStr, id, element.getContributor().getName()}), e);
                                            }
                                        }
                                        Path homePath = new Path(home);
                                        IPath libPath = homePath.append(JavaRuntime.substitute(libPathStr));
                                        Path sourcePath = Path.EMPTY;
                                        if (sourcePathStr != null) {
                                            sourcePath = homePath.append(JavaRuntime.substitute(sourcePathStr));
                                        }
                                        Path packageRootPath = Path.EMPTY;
                                        if (packageRootStr != null) {
                                            packageRootPath = new Path(JavaRuntime.substitute(packageRootStr));
                                        }
                                        locations[j] = new LibraryLocation(libPath, (IPath)sourcePath, (IPath)packageRootPath, url);
                                        ++j;
                                    }
                                }
                                standin.setLibraryLocations(locations);
                            }
                            vmDefs.removeVM(standin);
                            vmDefs.addVM(standin);
                        }
                        fgContributedVMs.add(id);
                        break block29;
                    }
                    JavaRuntime.abort(NLS.bind((String)"Illegal element {0} in vmInstalls extension contributed by {1}", (Object[])new String[]{element.getName(), element.getContributor().getName()}), null);
                }
                catch (CoreException e) {
                    LaunchingPlugin.log(e);
                }
            }
            ++i;
        }
    }

    private static String substitute(String expression) throws CoreException {
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(expression);
    }

    public static boolean isContributedVMInstall(String id) {
        JavaRuntime.getVMInstallTypes();
        return fgContributedVMs.contains(id);
    }

    public static LibraryLocation[] getLibraryLocations(IVMInstall vm) {
        IPath[] annotationPaths;
        URL[] indexes;
        URL[] javadocLocations;
        IPath[] sourceRootPaths;
        IPath[] sourcePaths;
        IPath[] libraryPaths;
        LibraryLocation[] locations = vm.getLibraryLocations();
        if (locations == null) {
            URL defJavaDocLocation = vm.getJavadocLocation();
            File installLocation = vm.getInstallLocation();
            if (installLocation == null) {
                return new LibraryLocation[0];
            }
            LibraryLocation[] dflts = vm.getVMInstallType().getDefaultLibraryLocations(installLocation);
            libraryPaths = new IPath[dflts.length];
            sourcePaths = new IPath[dflts.length];
            sourceRootPaths = new IPath[dflts.length];
            javadocLocations = new URL[dflts.length];
            indexes = new URL[dflts.length];
            annotationPaths = new IPath[dflts.length];
            int i = 0;
            while (i < dflts.length) {
                libraryPaths[i] = dflts[i].getSystemLibraryPath();
                javadocLocations[i] = defJavaDocLocation == null ? dflts[i].getJavadocLocation() : defJavaDocLocation;
                indexes[i] = dflts[i].getIndexLocation();
                if (!libraryPaths[i].toFile().isFile()) {
                    libraryPaths[i] = Path.EMPTY;
                }
                annotationPaths[i] = Path.EMPTY;
                sourcePaths[i] = dflts[i].getSystemLibrarySourcePath();
                if (sourcePaths[i].toFile().isFile()) {
                    sourceRootPaths[i] = dflts[i].getPackageRootPath();
                } else {
                    sourcePaths[i] = Path.EMPTY;
                    sourceRootPaths[i] = Path.EMPTY;
                }
                ++i;
            }
        } else {
            libraryPaths = new IPath[locations.length];
            sourcePaths = new IPath[locations.length];
            sourceRootPaths = new IPath[locations.length];
            javadocLocations = new URL[locations.length];
            indexes = new URL[locations.length];
            annotationPaths = new IPath[locations.length];
            int i = 0;
            while (i < locations.length) {
                libraryPaths[i] = locations[i].getSystemLibraryPath();
                sourcePaths[i] = locations[i].getSystemLibrarySourcePath();
                sourceRootPaths[i] = locations[i].getPackageRootPath();
                javadocLocations[i] = locations[i].getJavadocLocation();
                annotationPaths[i] = locations[i].getExternalAnnotationsPath();
                indexes[i] = locations[i].getIndexLocation();
                ++i;
            }
        }
        locations = new LibraryLocation[sourcePaths.length];
        int i = 0;
        while (i < sourcePaths.length) {
            locations[i] = new LibraryLocation(libraryPaths[i], sourcePaths[i], sourceRootPaths[i], javadocLocations[i], indexes[i], annotationPaths[i]);
            ++i;
        }
        return locations;
    }

    private static VMStandin detectEclipseRuntime() {
        String vmID;
        IVMInstallType[] vmTypes = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < vmTypes.length) {
            String eeFileName;
            if (vmTypes[i] instanceof EEVMType && (eeFileName = System.getProperty("ee.filename")) != null) {
                File vmFile = new File(eeFileName);
                if (vmFile.isDirectory()) {
                    vmFile = new File(vmFile, "default.ee");
                }
                if (vmFile.isFile()) {
                    long unique = System.currentTimeMillis();
                    while (vmTypes[i].findVMInstall(String.valueOf(unique)) != null) {
                        ++unique;
                    }
                    vmID = String.valueOf(unique);
                    try {
                        return JavaRuntime.createVMFromDefinitionFile(vmFile, "", vmID);
                    }
                    catch (CoreException coreException) {}
                }
            }
            ++i;
        }
        i = 0;
        while (i < vmTypes.length) {
            File detectedLocation = vmTypes[i].detectInstallLocation();
            if (detectedLocation != null) {
                long unique = System.currentTimeMillis();
                IVMInstallType vmType = vmTypes[i];
                while (vmType.findVMInstall(String.valueOf(unique)) != null) {
                    ++unique;
                }
                vmID = String.valueOf(unique);
                VMStandin detectedVMStandin = new VMStandin(vmType, vmID);
                File pluginDir = new File(detectedLocation, "plugins");
                File featuresDir = new File(detectedLocation, "features");
                if (pluginDir.exists() && featuresDir.exists() && JavaRuntime.isJREVersionAbove8(vmType, detectedLocation)) {
                    detectedLocation = new File(detectedLocation, "jre");
                }
                detectedVMStandin.setInstallLocation(detectedLocation);
                detectedVMStandin.setName(JavaRuntime.generateDetectedVMName(detectedVMStandin));
                if (vmType instanceof AbstractVMInstallType) {
                    AbstractVMInstallType abs = (AbstractVMInstallType)vmType;
                    URL url = abs.getDefaultJavadocLocation(detectedLocation);
                    detectedVMStandin.setJavadocLocation(url);
                    String arguments = abs.getDefaultVMArguments(detectedLocation);
                    if (arguments != null) {
                        detectedVMStandin.setVMArgs(arguments);
                    }
                }
                return detectedVMStandin;
            }
            ++i;
        }
        return null;
    }

    private static boolean isJREVersionAbove8(IVMInstallType vmType, File installLocation) {
        LibraryLocation[] locations = vmType.getDefaultLibraryLocations(installLocation);
        boolean exist = true;
        int i = 0;
        while (i < locations.length) {
            exist = exist && new File(locations[i].getSystemLibraryPath().toOSString()).exists();
            ++i;
        }
        if (exist) {
            return false;
        }
        exist = true;
        LibraryLocation[] newLocations = vmType.getDefaultLibraryLocations(new File(installLocation, "jre"));
        int i2 = 0;
        while (i2 < newLocations.length) {
            exist = exist && new File(newLocations[i2].getSystemLibraryPath().toOSString()).exists();
            ++i2;
        }
        return exist;
    }

    private static boolean equals(String optionName, Map<?, ?> options, org.osgi.service.prefs.Preferences prefStore) {
        String dummy = new String();
        String prefValue = prefStore.get(optionName, dummy);
        if (prefValue != null && prefValue != dummy) {
            return options.containsKey(optionName) && JavaRuntime.equals(prefValue, options.get(optionName));
        }
        return !options.containsKey(optionName);
    }

    private static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    private static String generateDetectedVMName(IVMInstall vm) {
        String name = vm.getInstallLocation().getName();
        if ((name = name.trim()).length() == 0) {
            name = LaunchingMessages.JavaRuntime_25;
        }
        return name;
    }

    public static IClasspathEntry getJREVariableEntry() {
        return JavaCore.newVariableEntry((IPath)new Path(JRELIB_VARIABLE), (IPath)new Path(JRESRC_VARIABLE), (IPath)new Path(JRESRCROOT_VARIABLE));
    }

    public static IClasspathEntry getDefaultJREContainerEntry() {
        return JavaCore.newContainerEntry((IPath)JavaRuntime.newDefaultJREContainerPath());
    }

    public static IPath newDefaultJREContainerPath() {
        return new Path(JRE_CONTAINER);
    }

    public static IPath newJREContainerPath(IVMInstall vm) {
        return JavaRuntime.newJREContainerPath(vm.getVMInstallType().getId(), vm.getName());
    }

    public static IPath newJREContainerPath(String typeId, String name) {
        IPath path = JavaRuntime.newDefaultJREContainerPath();
        path = path.append(typeId);
        path = path.append(name);
        return path;
    }

    public static IPath newJREContainerPath(IExecutionEnvironment environment) {
        IPath path = JavaRuntime.newDefaultJREContainerPath();
        path = path.append("org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
        path = path.append(JREContainerInitializer.encodeEnvironmentId(environment.getId()));
        return path;
    }

    public static IVMInstall getVMInstall(IPath jreContainerPath) {
        return JREContainerInitializer.resolveVM(jreContainerPath);
    }

    public static String getVMInstallTypeId(IPath jreContainerPath) {
        if (JREContainerInitializer.isExecutionEnvironment(jreContainerPath)) {
            return null;
        }
        return JREContainerInitializer.getVMTypeId(jreContainerPath);
    }

    public static String getVMInstallName(IPath jreContainerPath) {
        if (JREContainerInitializer.isExecutionEnvironment(jreContainerPath)) {
            return null;
        }
        return JREContainerInitializer.getVMName(jreContainerPath);
    }

    public static String getExecutionEnvironmentId(IPath jreContainerPath) {
        return JREContainerInitializer.getExecutionEnvironmentId(jreContainerPath);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static IRuntimeClasspathEntry computeJREEntry(ILaunchConfiguration configuration) throws CoreException {
        IPath containerPath;
        block9: {
            String jreAttr = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, null);
            containerPath = null;
            if (jreAttr == null) {
                String type = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
                if (type == null) {
                    IJavaProject proj = JavaRuntime.getJavaProject(configuration);
                    if (proj == null) {
                        containerPath = JavaRuntime.newDefaultJREContainerPath();
                        break block9;
                    } else {
                        if (JavaRuntime.isModularConfiguration(configuration)) {
                            return JavaRuntime.computeModularJREEntry(proj);
                        }
                        return JavaRuntime.computeJREEntry(proj);
                    }
                }
                String name = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
                if (name != null) {
                    containerPath = JavaRuntime.newDefaultJREContainerPath().append(type).append(name);
                }
            } else {
                containerPath = Path.fromPortableString((String)jreAttr);
            }
        }
        if (containerPath == null) {
            return null;
        }
        if (JavaRuntime.isModularConfiguration(configuration)) {
            return JavaRuntime.newRuntimeContainerClasspathEntry(containerPath, 4);
        }
        return JavaRuntime.newRuntimeContainerClasspathEntry(containerPath, 1);
    }

    public static IRuntimeClasspathEntry computeJREEntry(IJavaProject project) throws CoreException {
        IClasspathEntry[] rawClasspath = project.getRawClasspath();
        IRuntimeClasspathEntryResolver2 resolver = null;
        int i = 0;
        while (i < rawClasspath.length) {
            IClasspathEntry entry = rawClasspath[i];
            block0 : switch (entry.getEntryKind()) {
                case 4: {
                    resolver = JavaRuntime.getVariableResolver(entry.getPath().segment(0));
                    if (resolver == null || !resolver.isVMInstallReference(entry)) break;
                    return JavaRuntime.newRuntimeClasspathEntry(entry);
                }
                case 5: {
                    IClasspathContainer container;
                    resolver = JavaRuntime.getContainerResolver(entry.getPath().segment(0));
                    if (resolver == null || !resolver.isVMInstallReference(entry) || (container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project)) == null) break;
                    switch (container.getKind()) {
                        case 1: {
                            break block0;
                        }
                        case 3: {
                            return JavaRuntime.newRuntimeContainerClasspathEntry(entry.getPath(), 1);
                        }
                        case 2: {
                            return JavaRuntime.newRuntimeContainerClasspathEntry(entry.getPath(), 2);
                        }
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public static IRuntimeClasspathEntry computeModularJREEntry(IJavaProject project) throws CoreException {
        IClasspathEntry[] rawClasspath = project.getRawClasspath();
        IRuntimeClasspathEntryResolver2 resolver = null;
        int i = 0;
        while (i < rawClasspath.length) {
            IClasspathEntry entry = rawClasspath[i];
            block0 : switch (entry.getEntryKind()) {
                case 4: {
                    resolver = JavaRuntime.getVariableResolver(entry.getPath().segment(0));
                    if (resolver == null || !resolver.isVMInstallReference(entry)) break;
                    if (JavaRuntime.isModularProject(project)) {
                        return JavaRuntime.newRuntimeClasspathEntry(entry, 4);
                    }
                    return JavaRuntime.newRuntimeClasspathEntry(entry, 5);
                }
                case 5: {
                    IClasspathContainer container;
                    resolver = JavaRuntime.getContainerResolver(entry.getPath().segment(0));
                    if (resolver == null || !resolver.isVMInstallReference(entry) || (container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project)) == null) break;
                    switch (container.getKind()) {
                        case 1: {
                            break block0;
                        }
                        case 3: {
                            if (JavaRuntime.isModularProject(project)) {
                                return JavaRuntime.newRuntimeContainerClasspathEntry(entry.getPath(), 4);
                            }
                            return JavaRuntime.newRuntimeContainerClasspathEntry(entry.getPath(), 5);
                        }
                        case 2: {
                            if (JavaRuntime.isModularProject(project)) {
                                return JavaRuntime.newRuntimeContainerClasspathEntry(entry.getPath(), 4);
                            }
                            return JavaRuntime.newRuntimeContainerClasspathEntry(entry.getPath(), 5);
                        }
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public static boolean isVMInstallReference(IRuntimeClasspathEntry entry) {
        IClasspathEntry classpathEntry = entry.getClasspathEntry();
        if (classpathEntry != null) {
            switch (classpathEntry.getEntryKind()) {
                case 4: {
                    IRuntimeClasspathEntryResolver2 resolver = JavaRuntime.getVariableResolver(classpathEntry.getPath().segment(0));
                    if (resolver == null) break;
                    return resolver.isVMInstallReference(classpathEntry);
                }
                case 5: {
                    IRuntimeClasspathEntryResolver2 resolver = JavaRuntime.getContainerResolver(classpathEntry.getPath().segment(0));
                    if (resolver == null) break;
                    return resolver.isVMInstallReference(classpathEntry);
                }
            }
        }
        return false;
    }

    public static IVMConnector getVMConnector(String id) {
        return LaunchingPlugin.getDefault().getVMConnector(id);
    }

    public static IVMConnector[] getVMConnectors() {
        return LaunchingPlugin.getDefault().getVMConnectors();
    }

    public static Preferences getPreferences() {
        return LaunchingPlugin.getDefault().getPluginPreferences();
    }

    public static void savePreferences() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(ID_PLUGIN);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            LaunchingPlugin.log(e);
        }
    }

    public static void addVariableResolver(IRuntimeClasspathEntryResolver resolver, String variableName) {
        Map<String, IRuntimeClasspathEntryResolver> map = JavaRuntime.getVariableResolvers();
        map.put(variableName, resolver);
    }

    public static void addContainerResolver(IRuntimeClasspathEntryResolver resolver, String containerIdentifier) {
        Map<String, IRuntimeClasspathEntryResolver> map = JavaRuntime.getContainerResolvers();
        map.put(containerIdentifier, resolver);
    }

    private static Map<String, IRuntimeClasspathEntryResolver> getVariableResolvers() {
        if (fgVariableResolvers == null) {
            JavaRuntime.initializeResolvers();
        }
        return fgVariableResolvers;
    }

    private static Map<String, IRuntimeClasspathEntryResolver> getContainerResolvers() {
        if (fgContainerResolvers == null) {
            JavaRuntime.initializeResolvers();
        }
        return fgContainerResolvers;
    }

    private static Map<String, RuntimeClasspathEntryResolver> getEntryResolvers() {
        if (fgRuntimeClasspathEntryResolvers == null) {
            JavaRuntime.initializeResolvers();
        }
        return fgRuntimeClasspathEntryResolvers;
    }

    private static void initializeResolvers() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(ID_PLUGIN, EXTENSION_POINT_RUNTIME_CLASSPATH_ENTRY_RESOLVERS);
        IConfigurationElement[] extensions = point.getConfigurationElements();
        fgVariableResolvers = new HashMap<String, IRuntimeClasspathEntryResolver>(extensions.length);
        fgContainerResolvers = new HashMap<String, IRuntimeClasspathEntryResolver>(extensions.length);
        fgRuntimeClasspathEntryResolvers = new HashMap<String, RuntimeClasspathEntryResolver>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            RuntimeClasspathEntryResolver res = new RuntimeClasspathEntryResolver(extensions[i]);
            String variable = res.getVariableName();
            String container = res.getContainerId();
            String entryId = res.getRuntimeClasspathEntryId();
            if (variable != null) {
                fgVariableResolvers.put(variable, res);
            }
            if (container != null) {
                fgContainerResolvers.put(container, res);
            }
            if (entryId != null) {
                fgRuntimeClasspathEntryResolvers.put(entryId, res);
            }
            ++i;
        }
    }

    private static Map<String, RuntimeClasspathProvider> getClasspathProviders() {
        if (fgPathProviders == null) {
            JavaRuntime.initializeProviders();
        }
        return fgPathProviders;
    }

    private static void initializeProviders() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(ID_PLUGIN, EXTENSION_POINT_RUNTIME_CLASSPATH_PROVIDERS);
        IConfigurationElement[] extensions = point.getConfigurationElements();
        fgPathProviders = new HashMap<String, RuntimeClasspathProvider>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            RuntimeClasspathProvider res = new RuntimeClasspathProvider(extensions[i]);
            fgPathProviders.put(res.getIdentifier(), res);
            ++i;
        }
    }

    private static IRuntimeClasspathEntryResolver2 getVariableResolver(String variableName) {
        return (IRuntimeClasspathEntryResolver2)JavaRuntime.getVariableResolvers().get(variableName);
    }

    private static IRuntimeClasspathEntryResolver2 getContainerResolver(String containerId) {
        return (IRuntimeClasspathEntryResolver2)JavaRuntime.getContainerResolvers().get(containerId);
    }

    private static IRuntimeClasspathEntryResolver getContributedResolver(String typeId) {
        IRuntimeClasspathEntryResolver resolver = JavaRuntime.getEntryResolvers().get(typeId);
        if (resolver == null) {
            return new DefaultEntryResolver();
        }
        return resolver;
    }

    public static void addVMInstallChangedListener(IVMInstallChangedListener listener) {
        fgVMListeners.add((Object)listener);
    }

    public static void removeVMInstallChangedListener(IVMInstallChangedListener listener) {
        fgVMListeners.remove((Object)listener);
    }

    private static void notifyDefaultVMChanged(IVMInstall previous, IVMInstall current) {
        for (IVMInstallChangedListener listener : fgVMListeners) {
            listener.defaultVMInstallChanged(previous, current);
        }
    }

    public static void fireVMChanged(PropertyChangeEvent event) {
        for (IVMInstallChangedListener listener : fgVMListeners) {
            listener.vmChanged(event);
        }
    }

    public static void fireVMAdded(IVMInstall vm) {
        if (!fgInitializingVMs) {
            for (IVMInstallChangedListener listener : fgVMListeners) {
                listener.vmAdded(vm);
            }
        }
    }

    public static void fireVMRemoved(IVMInstall vm) {
        for (IVMInstallChangedListener listener : fgVMListeners) {
            listener.vmRemoved(vm);
        }
    }

    public static String getProjectOutputDirectory(ILaunchConfiguration config) {
        try {
            IPath path;
            IPath outputLocation;
            IWorkspaceRoot root;
            IResource resource;
            IJavaProject javaProject;
            if (config != null && (javaProject = JavaRuntime.getJavaProject(config)) != null && (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember(outputLocation = javaProject.getOutputLocation())) != null && (path = resource.getFullPath()) != null) {
                return path.makeRelative().toString();
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static ISourceContainer[] getSourceContainers(IRuntimeClasspathEntry[] entries) {
        return JavaSourceLookupUtil.translate(entries);
    }

    public static String[] computeJavaLibraryPath(IJavaProject project, boolean requiredProjects) throws CoreException {
        HashSet<IJavaProject> visited = new HashSet<IJavaProject>();
        ArrayList<String> entries = new ArrayList<String>();
        JavaRuntime.gatherJavaLibraryPathEntries(project, requiredProjects, visited, entries);
        ArrayList<String> resolved = new ArrayList<String>(entries.size());
        Iterator iterator = entries.iterator();
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        while (iterator.hasNext()) {
            IPath location;
            String entry = (String)iterator.next();
            String resolvedEntry = manager.performStringSubstitution(entry);
            Path path = new Path(resolvedEntry);
            if (path.isAbsolute()) {
                File file = path.toFile();
                resolved.add(file.getAbsolutePath());
                continue;
            }
            IResource resource = root.findMember((IPath)path);
            if (resource == null || (location = resource.getLocation()) == null) continue;
            resolved.add(location.toFile().getAbsolutePath());
        }
        return resolved.toArray(new String[resolved.size()]);
    }

    private static void gatherJavaLibraryPathEntries(IJavaProject project, boolean requiredProjects, Set<IJavaProject> visited, List<String> entries) throws CoreException {
        if (visited.contains(project)) {
            return;
        }
        visited.add(project);
        IClasspathEntry[] rawClasspath = project.getRawClasspath();
        IClasspathEntry[] required = JavaRuntime.processJavaLibraryPathEntries(project, requiredProjects, rawClasspath, entries);
        if (required != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < required.length) {
                IClasspathEntry entry = required[i];
                String projectName = entry.getPath().segment(0);
                IProject p = root.getProject(projectName);
                if (p.exists()) {
                    IJavaProject requiredProject = JavaCore.create((IProject)p);
                    if (requiredProject.isOpen()) {
                        JavaRuntime.gatherJavaLibraryPathEntries(requiredProject, requiredProjects, visited, entries);
                    } else if (!JavaRuntime.isOptional(entry)) {
                        JavaRuntime.gatherJavaLibraryPathEntries(requiredProject, requiredProjects, visited, entries);
                    }
                }
                ++i;
            }
        }
    }

    private static IClasspathEntry[] processJavaLibraryPathEntries(IJavaProject project, boolean collectRequired, IClasspathEntry[] classpathEntries, List<String> entries) throws CoreException {
        ArrayList<IClasspathEntry> req = null;
        int i = 0;
        while (i < classpathEntries.length) {
            IClasspathEntry entry = classpathEntries[i];
            IClasspathAttribute[] extraAttributes = entry.getExtraAttributes();
            int j = 0;
            while (j < extraAttributes.length) {
                String[] paths = JavaRuntime.getLibraryPaths(extraAttributes[j]);
                if (paths != null) {
                    int k = 0;
                    while (k < paths.length) {
                        entries.add(paths[k]);
                        ++k;
                    }
                }
                ++j;
            }
            if (entry.getEntryKind() == 5) {
                IClasspathEntry[] requiredProjects;
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
                if (container != null && (requiredProjects = JavaRuntime.processJavaLibraryPathEntries(project, collectRequired, container.getClasspathEntries(), entries)) != null) {
                    if (req == null) {
                        req = new ArrayList();
                    }
                    int j2 = 0;
                    while (j2 < requiredProjects.length) {
                        req.add(requiredProjects[j2]);
                        ++j2;
                    }
                }
            } else if (collectRequired && entry.getEntryKind() == 2) {
                if (req == null) {
                    req = new ArrayList<IClasspathEntry>();
                }
                req.add(entry);
            }
            ++i;
        }
        if (req != null) {
            return req.toArray(new IClasspathEntry[req.size()]);
        }
        return null;
    }

    public static IClasspathAttribute newLibraryPathsAttribute(String[] paths) {
        return JavaCore.newClasspathAttribute((String)CLASSPATH_ATTR_LIBRARY_PATH_ENTRY, (String)String.join((CharSequence)"|", paths));
    }

    public static String[] getLibraryPaths(IClasspathAttribute attribute) {
        if (CLASSPATH_ATTR_LIBRARY_PATH_ENTRY.equals(attribute.getName())) {
            String value = attribute.getValue();
            return value.split("\\|");
        }
        return null;
    }

    public static IExecutionEnvironmentsManager getExecutionEnvironmentsManager() {
        return EnvironmentsManager.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeVMs() {
        VMDefinitionsContainer vmDefs = null;
        boolean setPref = false;
        boolean updateCompliance = false;
        Object object = fgVMLock;
        synchronized (object) {
            if (fgVMTypes == null) {
                try {
                    fgInitializingVMs = true;
                    JavaRuntime.initializeVMTypeExtensions();
                    try {
                        vmDefs = new VMDefinitionsContainer();
                        setPref = JavaRuntime.addPersistedVMs(vmDefs);
                        IStatus status = vmDefs.getStatus();
                        if (status != null) {
                            if (status.isMultiStatus()) {
                                MultiStatus multi = (MultiStatus)status;
                                IStatus[] children = multi.getChildren();
                                int i = 0;
                                while (i < children.length) {
                                    IStatus child = children[i];
                                    if (!child.isOK()) {
                                        LaunchingPlugin.log(child);
                                    }
                                    ++i;
                                }
                            } else if (!status.isOK()) {
                                LaunchingPlugin.log(status);
                            }
                        }
                        if (vmDefs.getValidVMList().isEmpty()) {
                            VMListener listener = new VMListener();
                            JavaRuntime.addVMInstallChangedListener(listener);
                            setPref = true;
                            VMStandin runtime = JavaRuntime.detectEclipseRuntime();
                            JavaRuntime.removeVMInstallChangedListener(listener);
                            if (!listener.isChanged()) {
                                if (runtime != null) {
                                    updateCompliance = true;
                                    vmDefs.addVM(runtime);
                                    vmDefs.setDefaultVMInstallCompositeID(JavaRuntime.getCompositeIdFromVM(runtime));
                                }
                            } else {
                                JavaRuntime.addPersistedVMs(vmDefs);
                                vmDefs.setDefaultVMInstallCompositeID(fgDefaultVMId);
                                updateCompliance = fgDefaultVMId != null;
                            }
                        }
                        JavaRuntime.addVMExtensions(vmDefs);
                        String defId = vmDefs.getDefaultVMInstallCompositeID();
                        boolean validDef = false;
                        if (defId != null) {
                            for (IVMInstall vm : vmDefs.getValidVMList()) {
                                if (!JavaRuntime.getCompositeIdFromVM(vm).equals(defId)) continue;
                                validDef = true;
                                break;
                            }
                        }
                        if (!validDef) {
                            setPref = true;
                            List<IVMInstall> list = vmDefs.getValidVMList();
                            if (!list.isEmpty()) {
                                IVMInstall vm;
                                vm = list.get(0);
                                vmDefs.setDefaultVMInstallCompositeID(JavaRuntime.getCompositeIdFromVM(vm));
                            }
                        }
                        fgDefaultVMId = vmDefs.getDefaultVMInstallCompositeID();
                        fgDefaultVMConnectorId = vmDefs.getDefaultVMInstallConnectorTypeID();
                        List<IVMInstall> vmList = vmDefs.getValidVMList();
                        for (VMStandin vMStandin : vmList) {
                            vMStandin.convertToRealVM();
                        }
                    }
                    catch (IOException e) {
                        LaunchingPlugin.log(e);
                    }
                }
                finally {
                    fgInitializingVMs = false;
                }
            }
        }
        if (vmDefs != null) {
            IVMInstallType[] installTypes = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < installTypes.length) {
                IVMInstallType type = installTypes[i];
                IVMInstall[] installs = type.getVMInstalls();
                int j = 0;
                while (j < installs.length) {
                    JavaRuntime.fireVMAdded(installs[j]);
                    ++j;
                }
                ++i;
            }
            if (setPref) {
                try {
                    String xml = vmDefs.getAsXML();
                    InstanceScope.INSTANCE.getNode(ID_PLUGIN).put(PREF_VM_XML, xml);
                }
                catch (CoreException e) {
                    LaunchingPlugin.log(e);
                }
            }
            if (updateCompliance) {
                JavaRuntime.updateCompliance(JavaRuntime.getDefaultVMInstall());
            }
        }
    }

    private static void updateCompliance(IVMInstall vm) {
        String javaVersion;
        if (LaunchingPlugin.isVMLogging()) {
            LaunchingPlugin.log("Compliance needs an update.");
        }
        if (vm instanceof IVMInstall2 && (javaVersion = ((IVMInstall2)((Object)vm)).getJavaVersion()) != null) {
            boolean isDefault;
            String compliance = null;
            compliance = javaVersion.startsWith("1.5") ? "1.5" : (javaVersion.startsWith("1.6") ? "1.6" : (javaVersion.startsWith("1.7") ? "1.7" : (javaVersion.startsWith("1.8") ? "1.8" : (javaVersion.startsWith("9") && (javaVersion.length() == "9".length() || javaVersion.charAt("9".length()) == '.') ? "9" : (javaVersion.startsWith("10") && (javaVersion.length() == "10".length() || javaVersion.charAt("10".length()) == '.') ? "10" : (javaVersion.startsWith("11") && (javaVersion.length() == "11".length() || javaVersion.charAt("11".length()) == '.') ? "11" : (javaVersion.startsWith("12") && (javaVersion.length() == "12".length() || javaVersion.charAt("12".length()) == '.') ? "12" : (javaVersion.startsWith("13") && (javaVersion.length() == "13".length() || javaVersion.charAt("13".length()) == '.') ? "13" : (javaVersion.startsWith("14") && (javaVersion.length() == "14".length() || javaVersion.charAt("14".length()) == '.') ? "14" : (javaVersion.startsWith("15") && (javaVersion.length() == "15".length() || javaVersion.charAt("15".length()) == '.') ? "15" : (javaVersion.startsWith("16") && (javaVersion.length() == "16".length() || javaVersion.charAt("16".length()) == '.') ? "16" : (javaVersion.startsWith("17") && (javaVersion.length() == "17".length() || javaVersion.charAt("17".length()) == '.') ? "17" : (javaVersion.startsWith("18") && (javaVersion.length() == "18".length() || javaVersion.charAt("18".length()) == '.') ? "18" : (javaVersion.startsWith("19") && (javaVersion.length() == "19".length() || javaVersion.charAt("19".length()) == '.') ? "19" : (javaVersion.startsWith("20") && (javaVersion.length() == "20".length() || javaVersion.charAt("20".length()) == '.') ? "20" : "20")))))))))))))));
            Hashtable options = JavaCore.getOptions();
            IEclipsePreferences bundleDefaults = BundleDefaultsScope.INSTANCE.getNode("org.eclipse.jdt.core");
            boolean bl = isDefault = JavaRuntime.equals("org.eclipse.jdt.core.compiler.compliance", options, (org.osgi.service.prefs.Preferences)bundleDefaults) && JavaRuntime.equals("org.eclipse.jdt.core.compiler.source", options, (org.osgi.service.prefs.Preferences)bundleDefaults) && JavaRuntime.equals("org.eclipse.jdt.core.compiler.codegen.targetPlatform", options, (org.osgi.service.prefs.Preferences)bundleDefaults) && JavaRuntime.equals("org.eclipse.jdt.core.compiler.problem.assertIdentifier", options, (org.osgi.service.prefs.Preferences)bundleDefaults) && JavaRuntime.equals("org.eclipse.jdt.core.compiler.problem.enumIdentifier", options, (org.osgi.service.prefs.Preferences)bundleDefaults);
            if (JavaCore.compareJavaVersions((String)compliance, (String)"10") > 0) {
                boolean bl2 = isDefault = isDefault && JavaRuntime.equals("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", options, (org.osgi.service.prefs.Preferences)bundleDefaults) && JavaRuntime.equals("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", options, (org.osgi.service.prefs.Preferences)bundleDefaults);
            }
            if (LaunchingPlugin.isVMLogging()) {
                LaunchingPlugin.log("Compliance to be updated is: " + compliance);
            }
            if (isDefault) {
                JavaCore.setComplianceOptions((String)compliance, (Map)options);
                JavaCore.setOptions((Hashtable)options);
                if (LaunchingPlugin.isVMLogging()) {
                    LaunchingPlugin.log("Compliance Options are updated.");
                }
            }
        }
    }

    public static VMStandin createVMFromDefinitionFile(File eeFile, String name, String id) throws CoreException {
        ExecutionEnvironmentDescription description = new ExecutionEnvironmentDescription(eeFile);
        IStatus status = EEVMType.validateDefinitionFile(description);
        if (status.isOK()) {
            VMStandin standin = new VMStandin(JavaRuntime.getVMInstallType("org.eclipse.jdt.launching.EEVMType"), id);
            if (name != null && name.length() > 0) {
                standin.setName(name);
            } else {
                name = description.getProperty("-Dee.name");
                if (name == null) {
                    name = eeFile.getName();
                }
                standin.setName(name);
            }
            String home = description.getProperty("-Djava.home");
            standin.setInstallLocation(new File(home));
            standin.setLibraryLocations(description.getLibraryLocations());
            standin.setVMArgs(description.getVMArguments());
            standin.setJavadocLocation(EEVMType.getJavadocLocation(description.getProperties()));
            standin.setAttribute("ATTR_EXECUTION_ENVIRONMENT_ID", description.getProperty("-Dee.class.library.level"));
            File exe = description.getExecutable();
            if (exe == null) {
                exe = description.getConsoleExecutable();
            }
            if (exe != null) {
                try {
                    standin.setAttribute("ATTR_JAVA_EXE", exe.getCanonicalPath());
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), LaunchingMessages.JavaRuntime_24, (Throwable)e));
                }
            }
            standin.setAttribute("ATTR_JAVA_VERSION", description.getProperty("-Dee.language.level"));
            standin.setAttribute("ATTR_DEFINITION_FILE", eeFile.getPath());
            standin.setAttribute("ATTR_DEBUG_ARGS", description.getProperty("-Dee.debug.args"));
            return standin;
        }
        throw new CoreException(status);
    }

    public static String getModuleCLIOptions(ILaunchConfiguration configuration) {
        StringBuilder cliOptionString = new StringBuilder();
        try {
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath(configuration);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res;
                IJavaProject jp;
                IRuntimeClasspathEntry iRuntimeClasspathEntry = iRuntimeClasspathEntryArray[n2];
                IClasspathEntry classpathEntry = iRuntimeClasspathEntry.getClasspathEntry();
                if (classpathEntry != null && classpathEntry.getEntryKind() == 2 && (jp = (IJavaProject)JavaCore.create((IResource)(res = root.findMember(classpathEntry.getPath())))).isOpen()) {
                    IClasspathEntry[] rawClasspath;
                    IClasspathEntry[] iClasspathEntryArray = rawClasspath = jp.getRawClasspath();
                    int n3 = rawClasspath.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathEntry iClasspathEntry = iClasspathEntryArray[n4];
                        if (iClasspathEntry.getEntryKind() == 5 && JRE_CONTAINER.equals(iClasspathEntry.getPath().segment(0))) {
                            String cliOptions = JavaRuntime.getModuleCLIOptions(jp, iClasspathEntry);
                            if (cliOptionString.length() > 0 && cliOptions.length() > 0) {
                                cliOptionString.append(BLANK);
                            }
                            cliOptionString.append(cliOptions);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            LaunchingPlugin.log(e);
        }
        return cliOptionString.toString().trim();
    }

    private static String getModuleCLIOptions(IJavaProject project, IClasspathEntry systemLibrary) throws JavaModelException {
        StringBuilder buf = new StringBuilder();
        IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            IClasspathAttribute[] iClasspathAttributeArray = classpathEntry.getExtraAttributes();
            int n3 = iClasspathAttributeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String optName;
                IClasspathAttribute classpathAttribute = iClasspathAttributeArray[n4];
                switch (optName = classpathAttribute.getName()) {
                    case "add-exports": 
                    case "add-opens": 
                    case "add-reads": {
                        String readModules = classpathAttribute.getValue();
                        int equalsIdx = readModules.indexOf(61);
                        if (equalsIdx != -1) {
                            String[] stringArray = readModules.split(":");
                            int n5 = stringArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                String readModule = stringArray[n6];
                                buf.append(OPTION_START).append(optName).append(BLANK).append(readModule).append(BLANK);
                                ++n6;
                            }
                            break;
                        }
                        buf.append(OPTION_START).append(optName).append(BLANK).append(readModules).append(BLANK);
                        break;
                    }
                    case "limit-modules": {
                        JavaRuntime.addLimitModules(buf, project, systemLibrary, classpathAttribute.getValue());
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return buf.toString().trim();
    }

    private static void addLimitModules(StringBuilder buf, IJavaProject prj, IClasspathEntry systemLibrary, String value) throws JavaModelException {
        boolean isUnnamed;
        Object[] modules = value.split(COMMA);
        boolean bl = isUnnamed = prj.getModuleDescription() == null;
        if (isUnnamed) {
            Map<String, IModuleDescription> allModules;
            Set<String> selectedClosure;
            HashSet<Object> selected = new HashSet<Object>(Arrays.asList(modules));
            List<IPackageFragmentRoot> allSystemRoots = Arrays.asList(prj.findUnfilteredPackageFragmentRoots(systemLibrary));
            Set<String> defaultModules = JavaRuntime.getDefaultModules(allSystemRoots);
            HashSet<String> limit = new HashSet<String>(defaultModules);
            if (limit.retainAll(selectedClosure = JavaRuntime.closure(selected, new HashSet<String>(), allModules = allSystemRoots.stream().map(r -> r.getModuleDescription()).filter(Objects::nonNull).collect(Collectors.toMap(IJavaElement::getElementName, module -> module))))) {
                if (limit.isEmpty()) {
                    throw new IllegalArgumentException("Cannot hide all modules, at least java.base is required");
                }
                buf.append(LIMIT_MODULES).append(JavaRuntime.joinedSortedList(JavaRuntime.reduceNames(limit, allModules.values()))).append(BLANK);
            }
            selectedClosure.removeAll(defaultModules);
            if (!selectedClosure.isEmpty()) {
                buf.append(ADD_MODULES).append(JavaRuntime.joinedSortedList(selectedClosure)).append(BLANK);
            }
        } else {
            Arrays.sort(modules);
            buf.append(LIMIT_MODULES).append(String.join((CharSequence)COMMA, (CharSequence[])modules)).append(BLANK);
        }
    }

    private static Set<String> closure(Collection<String> moduleNames, Set<String> collected, Map<String, IModuleDescription> allModules) {
        for (String name : moduleNames) {
            IModuleDescription module;
            if (!collected.add(name) || (module = allModules.get(name)) == null) continue;
            try {
                JavaRuntime.closure(Arrays.asList(module.getRequiredModuleNames()), collected, allModules);
            }
            catch (JavaModelException e) {
                LaunchingPlugin.log(e);
            }
        }
        return collected;
    }

    private static Collection<String> reduceNames(Collection<String> names, Collection<IModuleDescription> allModules) {
        HashMap<String, ArrayList<String>> moduleRequiredByModules = new HashMap<String, ArrayList<String>>();
        for (IModuleDescription module : allModules) {
            if (!names.contains(module.getElementName())) continue;
            try {
                String[] stringArray = module.getRequiredModuleNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String required = stringArray[n2];
                    ArrayList<String> dominators = (ArrayList<String>)moduleRequiredByModules.get(required);
                    if (dominators == null) {
                        dominators = new ArrayList<String>();
                        moduleRequiredByModules.put(required, dominators);
                    }
                    dominators.add(module.getElementName());
                    ++n2;
                }
            }
            catch (CoreException e) {
                LaunchingPlugin.log(e);
                return names;
            }
        }
        ArrayList<String> reduced = new ArrayList<String>();
        block4: for (String name : names) {
            List dominators = (List)moduleRequiredByModules.get(name);
            if (dominators != null) {
                for (String dominator : dominators) {
                    if (names.contains(dominator)) continue block4;
                }
            }
            reduced.add(name);
        }
        return reduced;
    }

    private static Set<String> getDefaultModules(List<IPackageFragmentRoot> allSystemRoots) throws JavaModelException {
        HashMap<String, String[]> moduleDescriptions = new HashMap<String, String[]>();
        for (IPackageFragmentRoot packageFragmentRoot : allSystemRoots) {
            IModuleDescription module = packageFragmentRoot.getModuleDescription();
            if (module == null) continue;
            moduleDescriptions.put(module.getElementName(), module.getRequiredModuleNames());
        }
        HashSet<String> result = new HashSet<String>();
        HashSet todo = new HashSet(JavaProject.defaultRootModules(allSystemRoots));
        while (!todo.isEmpty()) {
            HashSet more = new HashSet();
            for (String s : todo) {
                String[] requiredModules;
                if (!result.add(s) || (requiredModules = (String[])moduleDescriptions.get(s)) == null) continue;
                Collections.addAll(more, requiredModules);
            }
            todo = more;
        }
        return result;
    }

    private static String joinedSortedList(Collection<String> list) {
        Object[] limitArray = list.toArray(new String[list.size()]);
        Arrays.sort(limitArray);
        return String.join((CharSequence)COMMA, (CharSequence[])limitArray);
    }
}

