/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.osgi.util.NLS;

public class ProjectConfigurationElementSorter {
    private final List<String> sortedConfigurators;
    private final Map<String, String> incompleteConfigurators;
    private final Set<String> missingRequiredConfigurators;
    private final Set<String> allSecondaryConfigurators = new HashSet<String>();
    private final Map<String, List<String>> primaryConfigurators = new HashMap<String, List<String>>();

    /*
     * Unable to fully structure code
     */
    public ProjectConfigurationElementSorter(Collection<String> configuratorIds, Map<String, IConfigurationElement> configurators) throws CycleDetectedException {
        super();
        Assert.isNotNull(configurators, (String)"configuratorConfigElements parameter can not be null");
        fullDag = new DAG();
        requirementsDag = new DAG();
        incompletes = new HashMap<String, String>();
        missingIds = new HashSet<String>();
        for (String key : configuratorIds) {
            requirementsDag.addVertex(key);
            fullDag.addVertex(key);
            configurator = configurators.get(key);
            if (configurator == null) {
                missingIds.add(key);
                continue;
            }
            runsAfterIds = configurator.getAttribute("runsAfter");
            runsAfter = null;
            if (runsAfterIds != null) {
                runsAfter = runsAfterIds.split(",");
            } else {
                secondaryTo = configurator.getAttribute("secondaryTo");
                if (secondaryTo != null) {
                    runsAfter = new String[]{secondaryTo};
                }
            }
            if (runsAfter != null) {
                this.allSecondaryConfigurators.add(key);
                var15_22 = runsAfter;
                var14_19 = runsAfter.length;
                var13_16 = 0;
                while (var13_16 < var14_19) {
                    id = var15_22[var13_16];
                    if (!(id = id.strip()).isEmpty()) {
                        isRequired = id.endsWith("?") == false;
                        predecessorId = ProjectConfigurationElementSorter.sanitize(id);
                        if (isRequired) {
                            requirementsDag.addEdge(key, predecessorId);
                        }
                        if ((predecessor = configurators.get(predecessorId)) == null) {
                            if (isRequired) {
                                missingIds.add(predecessorId);
                                incompletes.put(key, NLS.bind((String)Messages.ProjectConfiguratorToRunAfterNotAvailable, (Object)key, (Object)predecessorId));
                            }
                        } else {
                            fullDag.addEdge(key, predecessorId);
                        }
                    }
                    ++var13_16;
                }
            }
            if ((runsBefore = configurator.getAttribute("runsBefore")) == null) continue;
            var16_25 = runsBefore.split(",");
            var15_23 = var16_25.length;
            var14_19 = 0;
            while (var14_19 < var15_23) {
                id = var16_25[var14_19];
                if (!(id = id.trim()).isEmpty()) {
                    isRequired = id.endsWith("*");
                    successorId = ProjectConfigurationElementSorter.sanitize(id);
                    if (isRequired) {
                        requirementsDag.addEdge(successorId, key);
                    }
                    if ((successor = configurators.get(successorId)) == null) {
                        if (isRequired) {
                            missingIds.add(successorId);
                            incompletes.put(key, NLS.bind((String)Messages.ProjectConfiguratorToRunBeforeNotAvailable, (Object)key, (Object)successorId));
                        }
                    } else {
                        fullDag.addEdge(successorId, key);
                    }
                }
                ++var14_19;
            }
        }
        sortedExecutions = TopologicalSorter.sort((DAG)requirementsDag);
        for (String id : sortedExecutions) {
            v0 = isIncompleteOrMissing = missingIds.contains(id) != false || incompletes.containsKey(id) != false;
            if (!isIncompleteOrMissing) continue;
            dependents = new HashSet<String>();
            ProjectConfigurationElementSorter.getDependents(id, requirementsDag, dependents);
            for (String next : dependents) {
                if (!configuratorIds.contains(next) || !missingIds.contains(next) && incompletes.containsKey(next)) continue;
                incompletes.put(next, NLS.bind((String)Messages.ProjectConfiguratorNotAvailable, (Object)id, (Object)next));
            }
        }
        sortedExecutions = TopologicalSorter.sort((DAG)fullDag);
        sortedConfiguratorsList = new ArrayList<String>(sortedExecutions.size());
        for (String id : sortedExecutions) {
            if (!configuratorIds.contains(id) || incompletes.containsKey(id) || missingIds.contains(id)) continue;
            predecessors = fullDag.getChildLabels(id);
            if (predecessors == null || predecessors.isEmpty()) ** GOTO lbl-1000
            if (!predecessors.stream().noneMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(configuratorIds))) {
                v1 = false;
            } else lbl-1000:
            // 2 sources

            {
                v1 = addAsPrimary = true;
            }
            if (addAsPrimary) {
                secondaries = new LinkedHashSet<String>();
                ProjectConfigurationElementSorter.getDependents(id, fullDag, secondaries);
                this.primaryConfigurators.put(id, new ArrayList<String>(secondaries));
                this.allSecondaryConfigurators.addAll(secondaries);
            }
            sortedConfiguratorsList.add(id);
        }
        this.sortedConfigurators = Collections.unmodifiableList(sortedConfiguratorsList);
        this.incompleteConfigurators = Collections.unmodifiableMap(incompletes);
        this.missingRequiredConfigurators = Collections.unmodifiableSet(missingIds);
    }

    public ProjectConfigurationElementSorter(Map<String, IConfigurationElement> configurators) throws CycleDetectedException {
        this(configurators.keySet(), configurators);
    }

    private static void getDependents(String id, DAG dag, Set<String> dependents) {
        List parents = dag.getParentLabels(id);
        if (parents == null || parents.isEmpty()) {
            return;
        }
        for (String parent : parents) {
            if (!dependents.add(parent)) continue;
            ProjectConfigurationElementSorter.getDependents(parent, dag, dependents);
        }
    }

    private static String sanitize(String id) {
        return id.endsWith("?") || id.endsWith("*") ? id.substring(0, id.length() - 1) : id;
    }

    public List<String> getSortedConfigurators() {
        return this.sortedConfigurators;
    }

    public Map<String, String> getIncompleteConfigurators() {
        return this.incompleteConfigurators;
    }

    public Set<String> getMissingConfigurators() {
        return this.missingRequiredConfigurators;
    }

    public List<String> getSecondaryConfigurators(String primaryConfigurator) {
        return this.primaryConfigurators.getOrDefault(primaryConfigurator, Collections.emptyList());
    }

    public boolean isRootConfigurator(String configuratorId) {
        if (configuratorId == null || this.incompleteConfigurators.containsKey(configuratorId)) {
            return false;
        }
        boolean isPrimary = this.primaryConfigurators.containsKey(configuratorId);
        boolean isSecondary = this.allSecondaryConfigurators.contains(configuratorId);
        return isPrimary && (this.primaryConfigurators.size() == 1 || !isSecondary) || !isPrimary && !isSecondary;
    }

    public String toString() {
        return "ProjectConfigurationElementSorter [" + this.getSortedConfigurators() + "]";
    }
}

