/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.CRC32;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.index.FileIndexLocation;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.index.IndexLocation;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;

public class IndexUtils {
    private static boolean resourceChangeRegistered = false;
    private static Map<IPath, Long> externalTimeStamps = null;

    public static void copyIndexesToSharedLocation() {
        String SHARED_INDEX_LOCATION = System.getProperty("jdt.core.sharedIndexLocation");
        if (JavaModelManager.getIndexManager() == null || StringUtils.isBlank((CharSequence)SHARED_INDEX_LOCATION)) {
            return;
        }
        JobHelpers.waitUntilIndexesReady();
        IndexUtils.getExternalLibTimeStamps();
        IndexUtils.registerResourceChangeListener();
        IndexUtils.copyIndexesToSharedLocation(ProjectUtils.getJavaProjects());
    }

    private static synchronized void registerResourceChangeListener() {
        if (resourceChangeRegistered) {
            return;
        }
        resourceChangeRegistered = true;
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            /*
             * WARNING - void declaration
             */
            public void resourceChanged(IResourceChangeEvent event) {
                IJavaProject[] projects = null;
                Object obj = event.getSource();
                Object object = obj;
                if (object instanceof IProject) {
                    void project;
                    IProject iProject = (IProject)object;
                    IProject cfr_ignored_0 = (IProject)object;
                    if (ProjectUtils.isJavaProject((IProject)project)) {
                        projects = new IJavaProject[]{JavaCore.create((IProject)project)};
                    }
                } else if (obj instanceof IWorkspace) {
                    projects = ProjectUtils.getJavaProjects();
                }
                if (projects != null && projects.length > 0) {
                    JavaModelManager.getIndexManager().waitForIndex(true, null);
                    IndexUtils.copyIndexesToSharedLocation(projects);
                }
            }
        }, 32);
    }

    private static void copyIndexesToSharedLocation(IJavaProject[] javaProjects) {
        HashSet<ClasspathEntry> processedEntries = new HashSet<ClasspathEntry>();
        HashSet<ClasspathEntry> deferredEntries = new HashSet<ClasspathEntry>();
        IJavaProject[] iJavaProjectArray = javaProjects;
        int n = javaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject = iJavaProjectArray[n2];
            try {
                if (javaProject != null && javaProject.exists()) {
                    IClasspathEntry[] entries;
                    IClasspathEntry[] iClasspathEntryArray = entries = ((JavaProject)javaProject).getResolvedClasspath();
                    int n3 = entries.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathEntry entry = iClasspathEntryArray[n4];
                        if (entry.getEntryKind() == 1) {
                            IndexUtils.processLibraryIndex(javaProject.getProject(), (ClasspathEntry)entry, processedEntries, deferredEntries);
                        }
                        ++n4;
                    }
                }
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException(e);
            }
            ++n2;
        }
        if (!deferredEntries.isEmpty()) {
            JobHelpers.waitUntilIndexesReady();
            processedEntries = new HashSet();
            for (ClasspathEntry entry : deferredEntries) {
                IndexUtils.processLibraryIndex(entry, processedEntries);
            }
        }
    }

    private static void processLibraryIndex(ClasspathEntry libraryEntry, Set<ClasspathEntry> processedEntries) {
        IndexUtils.processLibraryIndex(null, libraryEntry, processedEntries, null);
    }

    private static void processLibraryIndex(IProject project, ClasspathEntry libraryEntry, Set<ClasspathEntry> processedEntries, Set<ClasspathEntry> deferredEntries) {
        if (!processedEntries.add(libraryEntry)) {
            return;
        }
        IPath libraryPath = libraryEntry.getPath();
        Object libraryFile = JavaModel.getTarget((IPath)libraryPath, (boolean)true);
        boolean isExternalJar = libraryFile instanceof File;
        if (!isExternalJar) {
            return;
        }
        IndexLocation sharedIndexLocation = IndexUtils.getSharedIndexLocation(libraryEntry);
        IndexLocation localIndexLocation = IndexUtils.getLocalIndexLocation(libraryPath);
        if (sharedIndexLocation == null || Objects.equals(sharedIndexLocation, localIndexLocation)) {
            return;
        }
        long lastModifiedTime = ((File)libraryFile).lastModified();
        File localIndexFile = localIndexLocation.getIndexFile();
        IndexManager indexManager = JavaModelManager.getIndexManager();
        if (indexManager.getIndex(sharedIndexLocation) != null) {
            boolean libChanged;
            Long oldTimestamp = IndexUtils.getExternalLibTimeStamps().get(libraryPath);
            long newTimeStamp = IndexUtils.getLibTimeStamp((File)libraryFile);
            boolean bl = libChanged = oldTimestamp != null && oldTimestamp != newTimeStamp;
            if (!libChanged || sharedIndexLocation.lastModified() == lastModifiedTime) {
                try {
                    Files.deleteIfExists(localIndexFile.toPath());
                }
                catch (IOException e) {
                    JavaLanguageServerPlugin.logError(String.format("Failed to delete the local index %s: %s", localIndexFile.getName(), e.getMessage()));
                }
                return;
            }
            if (project == null || deferredEntries == null) {
                return;
            }
            indexManager.removeIndex(libraryPath);
            indexManager.indexLibrary(libraryPath, project, localIndexLocation.getUrl(), true);
            deferredEntries.add(libraryEntry);
            return;
        }
        if (lastModifiedTime > 0L && localIndexLocation.exists()) {
            File sharedIndexFile = sharedIndexLocation.getIndexFile();
            if (sharedIndexFile == null || localIndexFile == null) {
                return;
            }
            Index localIndex = indexManager.getIndex(localIndexLocation);
            if (localIndex == null || localIndex.hasChanged()) {
                return;
            }
            ReadWriteMonitor monitor = localIndex.monitor;
            if (monitor == null) {
                return;
            }
            try {
                monitor.enterRead();
                IndexUtils.copyIndexFile(localIndexFile, sharedIndexFile, lastModifiedTime);
                IndexUtils.getExternalLibTimeStamps().put(libraryPath, IndexUtils.getLibTimeStamp((File)libraryFile));
            }
            finally {
                monitor.exitRead();
            }
        }
    }

    private static boolean copyIndexFile(File from, File to, long lastModified) {
        long toFileModifiedTime = to.lastModified();
        if (toFileModifiedTime != 0L && toFileModifiedTime == lastModified) {
            return false;
        }
        File tmpFile = new File(to.getParent(), String.valueOf(to.getName()) + "." + System.currentTimeMillis());
        try {
            IndexUtils.mkdirsFor(tmpFile);
            Files.copy(from.toPath(), tmpFile.toPath(), LinkOption.NOFOLLOW_LINKS, StandardCopyOption.REPLACE_EXISTING);
            Files.deleteIfExists(to.toPath());
            boolean success = tmpFile.renameTo(to);
            to.setLastModified(lastModified);
            boolean bl = success;
            return bl;
        }
        catch (IOException e) {
            JavaLanguageServerPlugin.logError(String.format("Failed to copy the local index %s to the shared index %s: %s", from.getName(), to.getName(), e.getMessage()));
        }
        finally {
            try {
                Files.deleteIfExists(tmpFile.toPath());
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private static IndexLocation getSharedIndexLocation(ClasspathEntry libraryEntry) {
        URL indexURL = libraryEntry.getLibraryIndexLocation();
        if (indexURL == null) {
            return null;
        }
        return IndexLocation.createIndexLocation((URL)indexURL);
    }

    private static IndexLocation getLocalIndexLocation(IPath libraryPath) {
        String pathString = libraryPath.toOSString();
        CRC32 checksumCalculator = new CRC32();
        checksumCalculator.update(pathString.getBytes());
        String fileName = String.valueOf(Long.toString(checksumCalculator.getValue())) + ".index";
        IPath statePath = JavaCore.getPlugin().getStateLocation();
        return new FileIndexLocation(new File(statePath.toOSString(), fileName));
    }

    private static void mkdirsFor(File destination) {
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
    }

    private static synchronized Map<IPath, Long> getExternalLibTimeStamps() {
        if (externalTimeStamps == null) {
            HashMap<IPath, Long> timeStamps;
            block17: {
                timeStamps = new HashMap<IPath, Long>();
                File timestampsFile = IndexUtils.getExternalLibTimeStampsFile();
                FilterInputStream in = null;
                try {
                    try {
                        in = new DataInputStream(new BufferedInputStream(new FileInputStream(timestampsFile)));
                        int size = ((DataInputStream)in).readInt();
                        while (size-- > 0) {
                            String key = ((DataInputStream)in).readUTF();
                            long timestamp = ((DataInputStream)in).readLong();
                            timeStamps.put(Path.fromPortableString((String)key), timestamp);
                        }
                    }
                    catch (IOException e) {
                        if (timestampsFile.exists()) {
                            JavaLanguageServerPlugin.logException("Unable to read external time stamps", e);
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            externalTimeStamps = timeStamps;
        }
        return externalTimeStamps;
    }

    private static File getExternalLibTimeStampsFile() {
        return JavaCore.getPlugin().getStateLocation().append("externalLibsTimeStamps").toFile();
    }

    private static long getLibTimeStamp(File file) {
        return file.lastModified() + file.length();
    }
}

