/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.maven;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.microsoft.java.maven.ArtifactResult;
import com.microsoft.java.maven.BaseClassSearcher;
import com.microsoft.java.maven.NetSearcher;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ClassSearcher {
    private BaseClassSearcher mavenSearcher;
    private NetSearcher netSearcher;
    private Map<String, Integer> artifactUsageDict;
    private final int fuzzyResultThreshold = 1000;
    private final Set<String> azureSet = new HashSet<String>();
    private final String contextId;
    private final String repositoryId;
    private final String indexPath;
    private final String artifactUsagePath;
    private static Comparator<ArtifactResult> orderByRule = new Comparator<ArtifactResult>(){

        @Override
        public int compare(ArtifactResult r1, ArtifactResult r2) {
            if (r1.getKind() < r2.getKind() || r1.getKind() == r2.getKind() && r1.getUsage() > r2.getUsage() || r1.getKind() == r2.getKind() && r1.getUsage() == r2.getUsage() && r1.getClassName().toLowerCase().compareTo(r2.getClassName().toLowerCase()) < 0) {
                return -1;
            }
            if (r2.getKind() < r1.getKind() || r2.getKind() == r1.getKind() && r2.getUsage() > r1.getUsage() || r2.getKind() == r1.getKind() && r2.getUsage() == r1.getUsage() && r2.getClassName().toLowerCase().compareTo(r1.getClassName().toLowerCase()) < 0) {
                return 1;
            }
            return 0;
        }
    };

    public ClassSearcher(String contextId, String repositoryId, String indexPath, String artifactUsagePath) {
        String[] azureArtifacts = new String[]{"adal4j", "azure-mgmt-appservice", "applicationinsights-web", "azure-batch", "azure-mgmt-batchai", "azure-mgmt-cdn", "azure-mgmt-containerinstance", "azure-cognitiveservices-computervision", "azure-cognitiveservices-videosearch", "azure-cognitiveservices-parent", "azure-cognitiveservices-websearch", "azure-cognitiveservices-customimagesearch", "azure-cognitiveservices-visualsearch", "azure-cognitiveservices-newssearch", "azure-cognitiveservices-customsearch", "azure-cognitiveservices-autosuggest", "azure-cognitiveservices-spellcheck", "azure-cognitiveservices-faceapi", "azure-cognitiveservices-contentmoderator", "azure-computervision", "azure-cognitiveservices-luis-runtime", "azure-faceapi", "azure-cognitiveservices-entitysearch", "azure-cognitiveservices-imagesearch", "azure-cognitiveservices-textanalytics", "azure-cognitiveservices-language", "azure-cognitiveservices-luis-authoring", "azure-cognitiveservices-customvision-training", "azure-cognitiveservices-customvision-prediction", "azure-mgmt-containerregistry", "azure-mgmt-containerservice", "azure-documentdb", "azure-mgmt-datalake-analytics", "azure-data-lake-store-sdk", "azure-mgmt-dns", "azure-svc-mgmt", "azure-eventgrid", "azure-eventhubs", "azure-functions-java-library", "azure-client-authentication", "azure-arm-client-runtime", "azure-mgmt-hdinsight", "iot-service-client", "azure-keyvault", "azure-mgmt-mixedreality", "azure-mgmt-labservices", "azure-mgmt-monitor", "azure-mgmt-network", "azure-mgmt-privatedns", "azure-mgmt-redis", "azure-mgmt-resources", "azure-mgmt-resourcegraph", "azure-servicebus", "sf", "azure-mgmt-streamanalytics", "mssql-jdbc", "azure-storage-blob", "azure-storage-queue", "azure-mgmt-trafficmanager", "azure-mgmt-compute", "azure", "azure-core"};
        this.azureSet.addAll(Arrays.asList(azureArtifacts));
        this.contextId = contextId;
        this.repositoryId = repositoryId;
        this.indexPath = indexPath;
        this.artifactUsagePath = artifactUsagePath;
        this.constructMavenSearcher();
        this.constructNetSearcher();
    }

    private Boolean constructMavenSearcher() {
        try {
            this.artifactUsageDict = (Map)new Gson().fromJson(new JsonReader((Reader)new FileReader(this.artifactUsagePath)), new TypeToken<HashMap<String, Integer>>(){}.getType());
            this.mavenSearcher = new BaseClassSearcher(this.contextId, this.repositoryId, this.indexPath);
            return true;
        }
        catch (Exception e) {
            if (this.mavenSearcher != null) {
                this.mavenSearcher.turnOffIndexerContext();
            }
            this.mavenSearcher = null;
            this.artifactUsageDict = null;
            e.printStackTrace();
            return false;
        }
    }

    private Boolean constructNetSearcher() {
        try {
            this.netSearcher = new NetSearcher();
            return true;
        }
        catch (Exception e) {
            this.netSearcher = null;
            e.printStackTrace();
            return false;
        }
    }

    public List<ArtifactResult> searchByClassName(String className) {
        Map<Object, Object> r1;
        Map<Object, Object> map = r1 = this.mavenSearcher != null ? this.mavenSearcher.searchByClassName(className) : new HashMap();
        if (r1.size() < 5 && this.netSearcher != null) {
            Map<String, ArtifactResult> r2 = this.netSearcher.searchByClassName(className);
            r2.putAll(r1);
            r1 = r2;
        }
        ArrayList<Object> result = new ArrayList<Object>(r1.values());
        ArrayList<ArtifactResult> azureResult = new ArrayList<ArtifactResult>();
        for (ArtifactResult artifactResult : result) {
            String id = String.valueOf(artifactResult.getGroupId()) + ":" + artifactResult.getArtifactId();
            if (this.artifactUsageDict.containsKey(id)) {
                artifactResult.setUsage(this.artifactUsageDict.get(String.valueOf(artifactResult.getGroupId()) + ":" + artifactResult.getArtifactId()));
            } else {
                artifactResult.setUsage(0);
            }
            if (!this.azureSet.contains(artifactResult.getArtifactId())) continue;
            azureResult.add(artifactResult);
        }
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            ArtifactResult r = (ArtifactResult)iterator.next();
            if (r.getKind() != 2 || r.getUsage() >= 1000) continue;
            iterator.remove();
        }
        Collections.sort(result, orderByRule);
        int starNums = (int)Math.min(Math.round((double)result.size() / 5.0), 5L);
        if (!azureResult.isEmpty()) {
            ArtifactResult ar = Collections.min(azureResult, orderByRule);
            if (starNums > 1 && !result.subList(0, starNums).contains(ar)) {
                result.remove(ar);
                result.add(starNums - 1, ar);
            }
        }
        Collections.sort(result.subList(starNums, result.size()), new Comparator<ArtifactResult>(){

            @Override
            public int compare(ArtifactResult r1, ArtifactResult r2) {
                return r1.getClassName().toLowerCase().compareTo(r2.getClassName().toLowerCase());
            }
        });
        return result;
    }

    public List<ArtifactResult> searchByIdentifier(String groupId, String artifactId) {
        return this.mavenSearcher.searchByIdentifier(groupId, artifactId);
    }

    public Boolean controlIndexerContext(Boolean controlParam) {
        if (controlParam.booleanValue()) {
            return this.mavenSearcher == null ? this.constructMavenSearcher() : this.mavenSearcher.turnOnIndexerContext();
        }
        return this.mavenSearcher == null ? true : this.mavenSearcher.turnOffIndexerContext();
    }
}

