/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.text.correction;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.corext.fix.UnimplementedCodeFixCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ChangeCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.FixCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ModifierChangeCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.UnresolvedElementsSubProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ModifierCorrectionSubProcessor {
    public static final int TO_STATIC = 1;
    public static final int TO_VISIBLE = 2;
    public static final int TO_NON_PRIVATE = 3;
    public static final int TO_NON_STATIC = 4;
    public static final int TO_NON_FINAL = 5;
    public static final String KEY_MODIFIER = "modifier";

    /*
     * WARNING - void declaration
     */
    public static void addNonAccessibleReferenceProposal(IInvocationContext context, IProblemLocationCore problem, Collection<ChangeCorrectionProposal> proposals, int kind, int relevance) throws CoreException {
        String name;
        IMethodBinding bindingDecl;
        IBinding iBinding;
        IBinding iBinding2;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        IBinding binding = null;
        switch (selectedNode.getNodeType()) {
            case 42: {
                binding = ((SimpleName)selectedNode).resolveBinding();
                break;
            }
            case 40: {
                binding = ((QualifiedName)selectedNode).resolveBinding();
                break;
            }
            case 43: {
                binding = ((SimpleType)selectedNode).resolveBinding();
                break;
            }
            case 88: {
                binding = ((NameQualifiedType)selectedNode).resolveBinding();
                break;
            }
            case 32: {
                binding = ((MethodInvocation)selectedNode).getName().resolveBinding();
                break;
            }
            case 48: {
                binding = ((SuperMethodInvocation)selectedNode).getName().resolveBinding();
                break;
            }
            case 22: {
                binding = ((FieldAccess)selectedNode).getName().resolveBinding();
                break;
            }
            case 47: {
                binding = ((SuperFieldAccess)selectedNode).getName().resolveBinding();
                break;
            }
            case 14: {
                binding = ((ClassInstanceCreation)selectedNode).resolveConstructorBinding();
                break;
            }
            case 46: {
                binding = ((SuperConstructorInvocation)selectedNode).resolveConstructorBinding();
                break;
            }
            default: {
                return;
            }
        }
        ITypeBinding typeBinding = null;
        boolean isLocalVar = false;
        IBinding iBinding3 = binding;
        if (iBinding3 instanceof IVariableBinding) {
            IVariableBinding iVariableBinding = (IVariableBinding)iBinding3;
            IVariableBinding cfr_ignored_0 = (IVariableBinding)iBinding3;
            if (problem.getProblemId() == 0x1000003) {
                void variableBinding;
                binding = variableBinding.getType();
            }
        }
        if ((iBinding2 = binding) instanceof IMethodBinding) {
            IMethodBinding iMethodBinding = (IMethodBinding)iBinding2;
            IMethodBinding cfr_ignored_1 = (IMethodBinding)iBinding2;
            if (problem.getProblemId() == 0x1000003) {
                void methodBinding;
                binding = methodBinding.getReturnType();
            }
        }
        if ((iBinding = binding) instanceof IMethodBinding) {
            void methodDecl;
            IMethodBinding iMethodBinding = (IMethodBinding)iBinding;
            IMethodBinding cfr_ignored_2 = (IMethodBinding)iBinding;
            if (methodDecl.isDefaultConstructor()) {
                UnresolvedElementsSubProcessor.getConstructorProposals(context, problem, proposals);
                return;
            }
            bindingDecl = methodDecl.getMethodDeclaration();
            typeBinding = methodDecl.getDeclaringClass();
            name = BasicElementLabels.getJavaElementName((String)(String.valueOf(methodDecl.getName()) + "()"));
        } else {
            IBinding iBinding4 = binding;
            if (iBinding4 instanceof IVariableBinding) {
                void varDecl;
                IVariableBinding iVariableBinding = (IVariableBinding)iBinding4;
                IVariableBinding cfr_ignored_3 = (IVariableBinding)iBinding4;
                typeBinding = varDecl.getDeclaringClass();
                name = BasicElementLabels.getJavaElementName((String)binding.getName());
                isLocalVar = !varDecl.isField();
                bindingDecl = varDecl.getVariableDeclaration();
            } else {
                IBinding iBinding5 = binding;
                if (iBinding5 instanceof ITypeBinding) {
                    void localTypeBinding;
                    ITypeBinding iTypeBinding = (ITypeBinding)iBinding5;
                    ITypeBinding cfr_ignored_4 = (ITypeBinding)iBinding5;
                    typeBinding = localTypeBinding;
                    bindingDecl = typeBinding.getTypeDeclaration();
                    name = BasicElementLabels.getJavaElementName((String)binding.getName());
                } else {
                    return;
                }
            }
        }
        if (typeBinding != null && typeBinding.isFromSource() || isLocalVar) {
            ICompilationUnit targetCU;
            String label;
            int includedModifiers = 0;
            int excludedModifiers = 0;
            switch (kind) {
                case 2: {
                    excludedModifiers = 7;
                    includedModifiers = ModifierCorrectionSubProcessor.getNeededVisibility(selectedNode, typeBinding, binding);
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changevisibility_description, new String[]{name, ModifierCorrectionSubProcessor.getVisibilityString(includedModifiers)});
                    break;
                }
                case 1: {
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertostatic_description, name);
                    includedModifiers = 8;
                    if (bindingDecl.getKind() != 4) break;
                    excludedModifiers = 66560;
                    break;
                }
                case 4: {
                    if (typeBinding != null && typeBinding.isInterface()) {
                        return;
                    }
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertononstatic_description, name);
                    excludedModifiers = 8;
                    break;
                }
                case 3: {
                    int visibility;
                    if (cu.getParent().getElementName().equals(typeBinding.getPackage().getName())) {
                        visibility = 0;
                        excludedModifiers = 2;
                    } else {
                        visibility = 1;
                        includedModifiers = 1;
                        excludedModifiers = 7;
                    }
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changevisibility_description, new String[]{name, ModifierCorrectionSubProcessor.getVisibilityString(visibility)});
                    break;
                }
                case 5: {
                    if (typeBinding != null && typeBinding.isInterface()) {
                        return;
                    }
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertononfinal_description, name);
                    excludedModifiers = 16;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("not supported");
                }
            }
            ICompilationUnit iCompilationUnit = targetCU = isLocalVar ? cu : ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)context.getASTRoot(), (ITypeBinding)typeBinding.getTypeDeclaration());
            if (targetCU != null) {
                proposals.add(new ModifierChangeCorrectionProposal(label, targetCU, (IBinding)bindingDecl, selectedNode, includedModifiers, excludedModifiers, relevance));
            }
        }
        if (kind == 2 && bindingDecl.getKind() == 3) {
            UnresolvedElementsSubProcessor.getVariableProposals(context, problem, (IVariableBinding)bindingDecl, proposals);
        }
    }

    public static void addChangeOverriddenModifierProposal(IInvocationContext context, IProblemLocationCore problem, Collection<ChangeCorrectionProposal> proposals, int kind) throws JavaModelException {
        List methods;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        IMethodBinding method = ((MethodDeclaration)selectedNode).resolveBinding();
        ITypeBinding curr = method.getDeclaringClass();
        if (kind == 2 && problem.getProblemId() != 67109274 && !(methods = Bindings.findOverriddenMethods((IMethodBinding)method, (boolean)false, (boolean)false)).isEmpty()) {
            int includedModifiers = 0;
            for (IMethodBinding binding : methods) {
                int temp = JdtFlags.getVisibilityCode((IBinding)binding);
                includedModifiers = JdtFlags.getHigherVisibility((int)temp, (int)includedModifiers);
            }
            int excludedModifiers = 7;
            String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodvisibility_description, new String[]{ModifierCorrectionSubProcessor.getVisibilityString(includedModifiers)});
            proposals.add(new ModifierChangeCorrectionProposal(label, cu, (IBinding)method, selectedNode, includedModifiers, excludedModifiers, 8));
        }
        IMethodBinding overriddenInClass = null;
        while (overriddenInClass == null && curr.getSuperclass() != null) {
            curr = curr.getSuperclass();
            overriddenInClass = Bindings.findOverriddenMethodInType((ITypeBinding)curr, (IMethodBinding)method);
        }
        if (overriddenInClass != null) {
            IMethodBinding overriddenDecl = overriddenInClass.getMethodDeclaration();
            ICompilationUnit overriddenMethodCU = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)context.getASTRoot(), (ITypeBinding)overriddenDecl.getDeclaringClass());
            if (overriddenMethodCU != null) {
                String label;
                int includedModifiers;
                int excludedModifiers;
                IMethodBinding targetMethod = overriddenDecl;
                ICompilationUnit targetCU = overriddenMethodCU;
                switch (kind) {
                    case 2: {
                        if (JdtFlags.isPrivate((IBinding)method)) {
                            targetMethod = method;
                            targetCU = cu;
                            excludedModifiers = 7;
                            includedModifiers = JdtFlags.getVisibilityCode((IBinding)overriddenDecl);
                        } else if (JdtFlags.isPackageVisible((IBinding)method) && !overriddenDecl.getDeclaringClass().getPackage().isEqualTo((IBinding)method.getDeclaringClass().getPackage())) {
                            excludedModifiers = 2;
                            includedModifiers = 4;
                            if (JdtFlags.isProtected((IBinding)overriddenDecl)) {
                                return;
                            }
                        } else {
                            excludedModifiers = 7;
                            includedModifiers = JdtFlags.getVisibilityCode((IBinding)method);
                            if (JdtFlags.getVisibilityCode((IBinding)overriddenDecl) == JdtFlags.getVisibilityCode((IBinding)method)) {
                                return;
                            }
                        }
                        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changeoverriddenvisibility_description, new String[]{ModifierCorrectionSubProcessor.getMethodLabel(targetMethod), ModifierCorrectionSubProcessor.getVisibilityString(includedModifiers)});
                        break;
                    }
                    case 5: {
                        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodtononfinal_description, ModifierCorrectionSubProcessor.getMethodLabel(targetMethod));
                        excludedModifiers = 16;
                        includedModifiers = 0;
                        break;
                    }
                    case 4: {
                        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodtononstatic_description, ModifierCorrectionSubProcessor.getMethodLabel(targetMethod));
                        excludedModifiers = 8;
                        includedModifiers = 0;
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false, (String)"not supported");
                        return;
                    }
                }
                proposals.add(new ModifierChangeCorrectionProposal(label, targetCU, (IBinding)targetMethod, selectedNode, includedModifiers, excludedModifiers, 7));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void addRemoveInvalidModifiersProposal(IInvocationContext context, IProblemLocationCore problem, Collection<ChangeCorrectionProposal> proposals, int relevance) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        ASTNode aSTNode = selectedNode;
        if (aSTNode instanceof MethodDeclaration) {
            void methodDeclaration;
            MethodDeclaration methodDeclaration2 = (MethodDeclaration)aSTNode;
            MethodDeclaration cfr_ignored_0 = (MethodDeclaration)aSTNode;
            selectedNode = methodDeclaration.getName();
        }
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding != null) {
            IBinding iBinding;
            IMethodBinding declClass;
            IBinding iBinding2;
            String methodName = BasicElementLabels.getJavaElementName((String)binding.getName());
            String label = null;
            int problemId = problem.getProblemId();
            int excludedModifiers = 0;
            int includedModifiers = 0;
            switch (problemId) {
                case 67109225: 
                case 67109271: {
                    excludedModifiers = 8;
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodtononstatic_description, methodName);
                    break;
                }
                case 33554778: {
                    excludedModifiers = 8;
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changefieldmodifiertononstatic_description, methodName);
                    break;
                }
                case 33554777: {
                    excludedModifiers = 64;
                    label = CorrectionMessages.ModifierCorrectionSubProcessor_removevolatile_description;
                    break;
                }
                case 67109223: {
                    excludedModifiers = -1026;
                    break;
                }
                case 67109914: {
                    excludedModifiers = -68618;
                    if (!Modifier.isAbstract((int)binding.getModifiers())) break;
                    excludedModifiers |= 0x800;
                    break;
                }
                case 16777519: {
                    excludedModifiers = -3074;
                    break;
                }
                case 16777518: {
                    excludedModifiers = -3090;
                    break;
                }
                case 33554775: {
                    excludedModifiers = -26;
                    break;
                }
                case 0x1000131: 
                case 16777525: {
                    excludedModifiers = -2058;
                    break;
                }
                case 0x1000130: {
                    excludedModifiers = -3104;
                    break;
                }
                case 16777522: {
                    excludedModifiers = -3089;
                    break;
                }
                case 67109220: {
                    excludedModifiers = -17;
                    break;
                }
                case 33554774: {
                    excludedModifiers = -224;
                    break;
                }
                case 67109222: {
                    excludedModifiers = -3392;
                    break;
                }
                case 67109233: {
                    excludedModifiers = -8;
                    break;
                }
                case 67109260: {
                    excludedModifiers = -17;
                    break;
                }
                case 16777966: {
                    excludedModifiers = -2050;
                    break;
                }
                case 33555183: {
                    excludedModifiers = -1;
                    break;
                }
                case 67109624: {
                    excludedModifiers = -3;
                    break;
                }
                case 16777969: {
                    excludedModifiers = -2064;
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"not supported");
                    return;
                }
            }
            if (label == null) {
                label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_removeinvalidmodifiers_description, methodName);
            }
            proposals.add(new ModifierChangeCorrectionProposal(label, cu, binding, selectedNode, includedModifiers, excludedModifiers, relevance));
            if (problemId == 33554777) {
                proposals.add(new ModifierChangeCorrectionProposal(CorrectionMessages.ModifierCorrectionSubProcessor_removefinal_description, cu, binding, selectedNode, 0, 16, relevance + 1));
            }
            if (problemId == 33554778 && (iBinding2 = binding) instanceof IVariableBinding) {
                void variableBinding;
                IVariableBinding iVariableBinding = (IVariableBinding)iBinding2;
                IVariableBinding cfr_ignored_1 = (IVariableBinding)iBinding2;
                declClass = variableBinding.getDeclaringClass();
                if (declClass.isMember()) {
                    proposals.add(new ModifierChangeCorrectionProposal(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertostaticfinal_description, cu, binding, selectedNode, 16, 64, relevance + 1));
                    ASTNode parentType = context.getASTRoot().findDeclaringNode((IBinding)declClass);
                    if (parentType != null) {
                        proposals.add(new ModifierChangeCorrectionProposal(CorrectionMessages.ModifierCorrectionSubProcessor_addstatictoparenttype_description, cu, (IBinding)declClass, parentType, 8, 0, relevance - 1));
                    }
                }
            }
            if (problemId == 67109225 && (iBinding = binding) instanceof IMethodBinding) {
                ASTNode parentType;
                void methodBinding;
                declClass = (IMethodBinding)iBinding;
                IMethodBinding cfr_ignored_2 = (IMethodBinding)iBinding;
                ITypeBinding declClass2 = methodBinding.getDeclaringClass();
                if (declClass2.isMember() && (parentType = context.getASTRoot().findDeclaringNode((IBinding)declClass2)) != null) {
                    proposals.add(new ModifierChangeCorrectionProposal(CorrectionMessages.ModifierCorrectionSubProcessor_addstatictoparenttype_description, cu, (IBinding)declClass2, parentType, 8, 0, relevance - 1));
                }
            }
        }
    }

    private static String getMethodLabel(IMethodBinding targetMethod) {
        return BasicElementLabels.getJavaElementName((String)(String.valueOf(targetMethod.getDeclaringClass().getName()) + '.' + targetMethod.getName()));
    }

    private static String getVisibilityString(int code) {
        if (Modifier.isPublic((int)code)) {
            return "public";
        }
        if (Modifier.isProtected((int)code)) {
            return "protected";
        }
        if (Modifier.isPrivate((int)code)) {
            return "private";
        }
        return CorrectionMessages.ModifierCorrectionSubProcessor_default;
    }

    private static int getNeededVisibility(ASTNode currNode, ITypeBinding targetType, IBinding binding) {
        ITypeBinding currNodeBinding = Bindings.getBindingOfParentType((ASTNode)currNode);
        if (currNodeBinding == null) {
            return 1;
        }
        if (Bindings.isSuperType((ITypeBinding)targetType, (ITypeBinding)currNodeBinding)) {
            if (binding != null && (JdtFlags.isProtected((IBinding)binding) || binding.getKind() == 2)) {
                return 1;
            }
            return 4;
        }
        if (currNodeBinding.getPackage().getKey().equals(targetType.getPackage().getKey())) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static void addAbstractMethodProposals(IInvocationContext context, IProblemLocationCore problem, Collection<ChangeCorrectionProposal> proposals) {
        ASTRewrite rewrite;
        AST ast;
        MethodDeclaration decl;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        if (selectedNode instanceof SimpleName) {
            decl = (MethodDeclaration)selectedNode.getParent();
        } else {
            ASTNode aSTNode = selectedNode;
            if (aSTNode instanceof MethodDeclaration) {
                void methodDeclaration;
                MethodDeclaration methodDeclaration2 = (MethodDeclaration)aSTNode;
                MethodDeclaration cfr_ignored_0 = (MethodDeclaration)aSTNode;
                decl = methodDeclaration;
            } else {
                return;
            }
        }
        ASTNode parentType = ASTResolving.findParentType((ASTNode)decl);
        TypeDeclaration parentTypeDecl = null;
        boolean parentIsAbstractClass = false;
        boolean parentIsInterface = false;
        ASTNode aSTNode = parentType;
        if (aSTNode instanceof TypeDeclaration) {
            void typeDecl;
            TypeDeclaration typeDeclaration = (TypeDeclaration)aSTNode;
            TypeDeclaration cfr_ignored_1 = (TypeDeclaration)aSTNode;
            parentTypeDecl = typeDecl;
            parentIsAbstractClass = !parentTypeDecl.isInterface() && Modifier.isAbstract((int)parentTypeDecl.getModifiers());
            parentIsInterface = parentTypeDecl.isInterface();
        }
        boolean hasNoBody = decl.getBody() == null;
        int id = problem.getProblemId();
        if (id == 67109227 || id == 67109622 || id == 67109629 || parentIsAbstractClass) {
            ast = astRoot.getAST();
            rewrite = ASTRewrite.create((AST)ast);
            ModifierCorrectionSubProcessor.removeModifier(decl, rewrite, 1024);
            if (hasNoBody) {
                Expression expr;
                Block newBody = ast.newBlock();
                rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)MethodDeclaration.BODY_PROPERTY, (Object)newBody, null);
                Type returnType = decl.getReturnType2();
                if (returnType != null && (expr = ASTNodeFactory.newDefaultExpression((AST)ast, (Type)returnType, (int)decl.getExtraDimensions())) != null) {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression(expr);
                    newBody.statements().add(returnStatement);
                }
            }
            String label = CorrectionMessages.ModifierCorrectionSubProcessor_removeabstract_description;
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, "quickfix", cu, rewrite, 6);
            proposals.add(proposal);
        }
        if (!hasNoBody && id == 603979889) {
            ast = decl.getAST();
            rewrite = ASTRewrite.create((AST)ast);
            rewrite.remove((ASTNode)decl.getBody(), null);
            int excluded = parentIsInterface ? -1026 : -1030;
            ModifierRewrite.create((ASTRewrite)rewrite, (ASTNode)decl).setModifiers(0, excluded, null);
            String label = CorrectionMessages.ModifierCorrectionSubProcessor_removebody_description;
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, "quickfix", cu, rewrite, 5);
            proposals.add(proposal);
            if (JavaModelUtil.is1d8OrHigher((IJavaProject)cu.getJavaProject()) && parentIsInterface) {
                String label2 = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertostatic_description, decl.getName());
                int included = 8;
                int excluded2 = 66560;
                proposals.add(new ModifierChangeCorrectionProposal(label2, cu, (IBinding)decl.resolveBinding(), (ASTNode)decl, included, excluded2, 8));
                label2 = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertodefault_description, decl.getName());
                included = 65536;
                excluded2 = 1032;
                proposals.add(new ModifierChangeCorrectionProposal(label2, cu, (IBinding)decl.resolveBinding(), (ASTNode)decl, included, excluded2, 8));
            }
        }
        if (id == 67109227 && parentTypeDecl != null) {
            ModifierCorrectionSubProcessor.addMakeTypeAbstractProposal(context, parentTypeDecl, proposals);
        }
    }

    private static Modifier removeModifier(MethodDeclaration decl, ASTRewrite rewrite, int modifier) {
        Modifier modifierNode = ASTNodes.findModifierNode((int)modifier, (List)decl.modifiers());
        if (modifierNode != null) {
            rewrite.remove((ASTNode)modifierNode, null);
        }
        return modifierNode;
    }

    private static void addMakeTypeAbstractProposal(IInvocationContext context, TypeDeclaration parentTypeDecl, Collection<ChangeCorrectionProposal> proposals) {
        UnimplementedCodeFixCore.MakeTypeAbstractOperation operation = new UnimplementedCodeFixCore.MakeTypeAbstractOperation(parentTypeDecl);
        String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_addabstract_description, BasicElementLabels.getJavaElementName((String)parentTypeDecl.getName().getIdentifier()));
        UnimplementedCodeFixCore fix = new UnimplementedCodeFixCore(label, context.getASTRoot(), new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{operation});
        FixCorrectionProposal proposal = new FixCorrectionProposal((IProposableFix)fix, null, 5, context);
        proposals.add(proposal);
    }

    /*
     * WARNING - void declaration
     */
    public static void addAbstractTypeProposals(IInvocationContext context, IProblemLocationCore problem, Collection<ChangeCorrectionProposal> proposals) {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        TypeDeclaration parentTypeDecl = null;
        if (selectedNode instanceof SimpleName) {
            ASTNode parent = selectedNode.getParent();
            if (parent != null) {
                parentTypeDecl = (TypeDeclaration)parent;
            }
        } else {
            ASTNode aSTNode = selectedNode;
            if (aSTNode instanceof TypeDeclaration) {
                void typeDecl;
                TypeDeclaration parent = (TypeDeclaration)aSTNode;
                TypeDeclaration cfr_ignored_0 = (TypeDeclaration)aSTNode;
                parentTypeDecl = typeDecl;
            }
        }
        if (parentTypeDecl == null) {
            return;
        }
        ModifierCorrectionSubProcessor.addMakeTypeAbstractProposal(context, parentTypeDecl, proposals);
    }

    public static void installLinkedVisibilityProposals(LinkedProposalModelCore linkedProposalModel, ASTRewrite rewrite, List<IExtendedModifier> modifiers, boolean inInterface, String groupId) {
        Modifier modifier = ModifierCorrectionSubProcessor.findVisibilityModifier(modifiers);
        if (modifier != null) {
            int[] nArray;
            int selected = modifier.getKeyword().toFlagValue();
            LinkedProposalPositionGroupCore positionGroup = linkedProposalModel.getPositionGroup(groupId, true);
            positionGroup.addPosition(rewrite.track((ASTNode)modifier), false);
            positionGroup.addProposal((LinkedProposalPositionGroupCore.ProposalCore)new ModifierLinkedModeProposal(selected, 10));
            if (inInterface) {
                int[] nArray2 = new int[2];
                nArray = nArray2;
                nArray2[0] = 1;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = 1;
                nArray3[2] = 4;
                nArray = nArray3;
                nArray3[3] = 2;
            }
            int[] flagValues = nArray;
            int i = 0;
            while (i < flagValues.length) {
                if (flagValues[i] != selected) {
                    positionGroup.addProposal((LinkedProposalPositionGroupCore.ProposalCore)new ModifierLinkedModeProposal(flagValues[i], 9 - i));
                }
                ++i;
            }
        }
    }

    public static void installLinkedVisibilityProposals(LinkedProposalModelCore linkedProposalModel, ASTRewrite rewrite, List<IExtendedModifier> modifiers, boolean inInterface) {
        ModifierCorrectionSubProcessor.installLinkedVisibilityProposals(linkedProposalModel, rewrite, modifiers, inInterface, KEY_MODIFIER);
    }

    /*
     * WARNING - void declaration
     */
    private static Modifier findVisibilityModifier(List<IExtendedModifier> modifiers) {
        int i = 0;
        while (i < modifiers.size()) {
            IExtendedModifier curr = modifiers.get(i);
            IExtendedModifier iExtendedModifier = curr;
            if (iExtendedModifier instanceof Modifier) {
                void modifier;
                Modifier cfr_ignored_0 = (Modifier)iExtendedModifier;
                Modifier cfr_ignored_1 = (Modifier)iExtendedModifier;
                Modifier.ModifierKeyword keyword = modifier.getKeyword();
                if (keyword == Modifier.ModifierKeyword.PUBLIC_KEYWORD || keyword == Modifier.ModifierKeyword.PROTECTED_KEYWORD || keyword == Modifier.ModifierKeyword.PRIVATE_KEYWORD) {
                    return modifier;
                }
            }
            ++i;
        }
        return null;
    }

    public static void addSealedMissingModifierProposal(IInvocationContext context, IProblemLocationCore problem, Collection<ChangeCorrectionProposal> proposals) {
        String label;
        if (proposals == null) {
            return;
        }
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        if (!(((SimpleName)selectedNode).getParent() instanceof TypeDeclaration)) {
            return;
        }
        TypeDeclaration typeDecl = (TypeDeclaration)((SimpleName)selectedNode).getParent();
        boolean isInterface = typeDecl.isInterface();
        ICompilationUnit cu = context.getCompilationUnit();
        ITypeBinding typeDeclBinding = typeDecl.resolveBinding();
        int relevance = 5;
        if (!isInterface) {
            label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifierto_final_description, typeDecl.getName());
            proposals.add(new ModifierChangeCorrectionProposal(label, cu, (IBinding)typeDeclBinding, (ASTNode)typeDecl, 16, 0, relevance));
        }
        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifierto_sealed_description, typeDecl.getName());
        proposals.add(new ModifierChangeCorrectionProposal(label, cu, (IBinding)typeDeclBinding, (ASTNode)typeDecl, 512, 0, relevance));
        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifierto_nonsealed_description, typeDecl.getName());
        proposals.add(new ModifierChangeCorrectionProposal(label, cu, (IBinding)typeDeclBinding, (ASTNode)typeDecl, 4096, 0, relevance));
    }

    private static class ModifierLinkedModeProposal
    extends LinkedProposalPositionGroupCore.ProposalCore {
        private final int fModifier;

        public ModifierLinkedModeProposal(int modifier, int relevance) {
            super(null, relevance);
            this.fModifier = modifier;
        }

        public String getAdditionalProposalInfo() {
            return this.getDisplayString();
        }

        public String getDisplayString() {
            if (this.fModifier == 0) {
                return CorrectionMessages.ModifierCorrectionSubProcessor_default_visibility_label;
            }
            return Modifier.ModifierKeyword.fromFlagValue((int)this.fModifier).toString();
        }

        public TextEdit computeEdits(int offset, LinkedPosition currentPosition, char trigger, int stateMask, LinkedModeModel model) throws CoreException {
            try {
                IDocument document = currentPosition.getDocument();
                MultiTextEdit edit = new MultiTextEdit();
                int documentLen = document.getLength();
                if (this.fModifier == 0) {
                    int end;
                    int k = end = currentPosition.offset + currentPosition.length;
                    while (k < documentLen && IndentManipulation.isIndentChar((char)document.getChar(k))) {
                        ++k;
                    }
                    edit.addChild((TextEdit)new ReplaceEdit(end, k - end, new String()));
                    edit.addChild((TextEdit)new ReplaceEdit(currentPosition.offset, currentPosition.length, new String()));
                } else {
                    edit.addChild((TextEdit)new ReplaceEdit(currentPosition.offset, currentPosition.length, Modifier.ModifierKeyword.fromFlagValue((int)this.fModifier).toString()));
                    int end = currentPosition.offset + currentPosition.length;
                    if (end < documentLen && !Character.isWhitespace(document.getChar(end))) {
                        edit.addChild((TextEdit)new ReplaceEdit(end, 0, String.valueOf(' ')));
                    }
                }
                return edit;
            }
            catch (BadLocationException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", 4, e.getMessage(), (Throwable)e));
            }
        }
    }
}

