/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.InlayHintFilter;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;

public class InlayHintFilterManager {
    private boolean initialized;
    private final List<InlayHintFilter> exclusions = new ArrayList<InlayHintFilter>();

    private InlayHintFilterManager() {
    }

    public static InlayHintFilterManager instance() {
        return InstanceHolder.instance;
    }

    public boolean match(IMethod method) {
        this.initializeIfNeeded();
        for (InlayHintFilter methodFilter : this.exclusions) {
            if (!methodFilter.match(method)) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.exclusions.clear();
        this.initialized = false;
    }

    private synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.initializeFromPreference();
        this.initialized = true;
    }

    private void initializeFromPreference() {
        JavaLanguageServerPlugin.getInstance();
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferencesManager == null) {
            return;
        }
        List<String> exclusionList = preferencesManager.getPreferences().getInlayHintsExclusionList();
        if (exclusionList != null) {
            this.exclusions.clear();
            exclusionList.forEach(this::addFilter);
        }
    }

    private void addFilter(String methodPattern) {
        InlayHintFilter filter = new InlayHintFilter(methodPattern);
        if (filter.isValid()) {
            this.exclusions.add(filter);
        }
    }

    private void initializeIfNeeded() {
        if (this.initialized) {
            return;
        }
        this.initialize();
    }

    private static class InstanceHolder {
        public static InlayHintFilterManager instance = new InlayHintFilterManager();

        private InstanceHolder() {
        }
    }
}

