/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;

public class FoldingRangeHandler {
    private static final Pattern REGION_START_PATTERN = Pattern.compile("^//\\s*#?region|^//\\s+<editor-fold.*>");
    private static final Pattern REGION_END_PATTERN = Pattern.compile("^//\\s*#?endregion|^//\\s+</editor-fold>");
    private static IScanner fScanner;

    private static IScanner getScanner() {
        if (fScanner == null) {
            fScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)true);
        }
        return fScanner;
    }

    public List<FoldingRange> foldingRange(FoldingRangeRequestParams params, IProgressMonitor monitor) {
        ITypeRoot unit;
        ArrayList<FoldingRange> $;
        block3: {
            ArrayList<FoldingRange> arrayList;
            $ = new ArrayList<FoldingRange>();
            unit = null;
            try {
                JavaLanguageServerPlugin.getInstance();
                PreferenceManager preferenceManager = JavaLanguageServerPlugin.getPreferencesManager();
                boolean returnCompilationUnit = preferenceManager == null ? false : preferenceManager.isClientSupportsClassFileContent() && preferenceManager.getPreferences().isIncludeDecompiledSources();
                unit = JDTUtils.resolveTypeRoot(params.getTextDocument().getUri(), returnCompilationUnit, monitor);
                if (unit != null && (monitor == null || !monitor.isCanceled())) break block3;
                arrayList = $;
            }
            catch (Throwable throwable) {
                JDTUtils.discardClassFileWorkingCopy(unit);
                throw throwable;
            }
            JDTUtils.discardClassFileWorkingCopy(unit);
            return arrayList;
        }
        this.computeFoldingRanges($, unit, monitor);
        ArrayList<FoldingRange> arrayList = $;
        JDTUtils.discardClassFileWorkingCopy(unit);
        return arrayList;
    }

    private void computeFoldingRanges(List<FoldingRange> foldingRanges, ITypeRoot unit, IProgressMonitor monitor) {
        try {
            ISourceRange range = unit.getSourceRange();
            if (!SourceRange.isAvailable((ISourceRange)range)) {
                return;
            }
            String contents = unit.getSource();
            if (StringUtils.isBlank((CharSequence)contents)) {
                return;
            }
            int shift = range.getOffset();
            IScanner scanner = FoldingRangeHandler.getScanner();
            scanner.setSource(contents.toCharArray());
            scanner.resetTo(shift, shift + range.getLength());
            int start = shift;
            int token = 0;
            int classFileImportStart = -1;
            int classFileImportEnd = -1;
            Stack<Integer> regionStarts = new Stack<Integer>();
            while (token != 158) {
                start = scanner.getCurrentTokenStartPosition();
                switch (token) {
                    case 1002: 
                    case 1003: {
                        int end = scanner.getCurrentTokenEndPosition();
                        FoldingRange commentFoldingRange = new FoldingRange(scanner.getLineNumber(start) - 1, scanner.getLineNumber(end) - 1);
                        commentFoldingRange.setKind("comment");
                        foldingRanges.add(commentFoldingRange);
                        break;
                    }
                    case 1001: {
                        String currentSource = String.valueOf(scanner.getCurrentTokenSource());
                        if (REGION_START_PATTERN.matcher(currentSource).lookingAt()) {
                            regionStarts.push(start);
                            break;
                        }
                        if (!REGION_END_PATTERN.matcher(currentSource).lookingAt() || regionStarts.size() <= 0) break;
                        FoldingRange regionFolding = new FoldingRange(scanner.getLineNumber(((Integer)regionStarts.pop()).intValue()) - 1, scanner.getLineNumber(start) - 1);
                        regionFolding.setKind("region");
                        foldingRanges.add(regionFolding);
                        break;
                    }
                    case 191: {
                        classFileImportStart = classFileImportStart == -1 ? start : classFileImportStart;
                        classFileImportEnd = scanner.getCurrentTokenEndPosition();
                    }
                }
                token = this.getNextToken(scanner);
            }
            if (unit.getElementType() == 6 && classFileImportStart != -1) {
                FoldingRange importFoldingRange = new FoldingRange(scanner.getLineNumber(classFileImportStart) - 1, scanner.getLineNumber(classFileImportEnd) - 1);
                importFoldingRange.setKind("imports");
                foldingRanges.add(importFoldingRange);
            }
            this.computeTypeRootRanges(foldingRanges, unit, scanner);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problem with folding range for " + unit.getPath().toPortableString(), e);
            monitor.setCanceled(true);
        }
    }

    private int getNextToken(IScanner scanner) {
        int token = 0;
        while (token == 0) {
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
        }
        return token;
    }

    /*
     * WARNING - void declaration
     */
    private void computeTypeRootRanges(List<FoldingRange> foldingRanges, ITypeRoot unit, IScanner scanner) throws CoreException {
        if (unit.hasChildren()) {
            IJavaElement[] iJavaElementArray = unit.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                IJavaElement iJavaElement = child;
                if (iJavaElement instanceof IImportContainer) {
                    void importContainer;
                    IImportContainer cfr_ignored_0 = (IImportContainer)iJavaElement;
                    IImportContainer cfr_ignored_1 = (IImportContainer)iJavaElement;
                    IType importRange = importContainer.getSourceRange();
                    FoldingRange importFoldingRange = new FoldingRange(scanner.getLineNumber(importRange.getOffset()) - 1, scanner.getLineNumber(importRange.getOffset() + importRange.getLength()) - 1);
                    importFoldingRange.setKind("imports");
                    foldingRanges.add(importFoldingRange);
                } else {
                    IJavaElement iJavaElement2 = child;
                    if (iJavaElement2 instanceof IType) {
                        void type;
                        IType cfr_ignored_2 = (IType)iJavaElement2;
                        IType cfr_ignored_3 = (IType)iJavaElement2;
                        this.computeTypeRanges(foldingRanges, (IType)type, scanner);
                    }
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void computeTypeRanges(List<FoldingRange> foldingRanges, IType unit, IScanner scanner) throws CoreException {
        IJavaElement[] children;
        ISourceRange typeRange = unit.getSourceRange();
        foldingRanges.add(new FoldingRange(scanner.getLineNumber(unit.getNameRange().getOffset()) - 1, scanner.getLineNumber(typeRange.getOffset() + typeRange.getLength()) - 1));
        IJavaElement[] iJavaElementArray = children = unit.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement c = iJavaElementArray[n2];
            if (c instanceof IMethod || c instanceof IInitializer) {
                this.computeMethodRanges(foldingRanges, (IMember)c, scanner);
            } else {
                IJavaElement iJavaElement = c;
                if (iJavaElement instanceof IType) {
                    void type;
                    IType cfr_ignored_0 = (IType)iJavaElement;
                    IType cfr_ignored_1 = (IType)iJavaElement;
                    this.computeTypeRanges(foldingRanges, (IType)type, scanner);
                }
            }
            ++n2;
        }
    }

    private void computeMethodRanges(List<FoldingRange> foldingRanges, IMember member, IScanner scanner) throws CoreException {
        ISourceRange sourceRange = member.getSourceRange();
        int shift = sourceRange.getOffset();
        scanner.resetTo(shift, shift + sourceRange.getLength());
        ISourceRange nameRange = member.getNameRange();
        int nameStart = nameRange != null ? nameRange.getOffset() : sourceRange.getOffset();
        foldingRanges.add(new FoldingRange(scanner.getLineNumber(nameStart) - 1, scanner.getLineNumber(shift + sourceRange.getLength()) - 1));
        int start = shift;
        int token = 0;
        Stack<Integer> leftParens = null;
        int prevCaseLine = -1;
        HashMap<Integer, Integer> candidates = new HashMap<Integer, Integer>();
        while (token != 158) {
            start = scanner.getCurrentTokenStartPosition();
            switch (token) {
                case 110: {
                    int originalStartLine;
                    if (leftParens == null) {
                        leftParens = new Stack<Integer>();
                        break;
                    }
                    int startLine = scanner.getLineNumber(start) - 1;
                    if (candidates.containsKey(startLine) && (originalStartLine = ((Integer)candidates.remove(startLine)).intValue()) < startLine - 1) {
                        candidates.put(startLine - 1, originalStartLine);
                    }
                    leftParens.push(startLine);
                    break;
                }
                case 95: {
                    int endPos = scanner.getCurrentTokenEndPosition();
                    if (leftParens == null || leftParens.size() <= 0) break;
                    int endLine = scanner.getLineNumber(endPos) - 1;
                    int startLine = (Integer)leftParens.pop();
                    if (startLine < endLine) {
                        candidates.put(endLine, startLine);
                    }
                    if (startLine >= prevCaseLine) break;
                    if (endLine - 1 > prevCaseLine) {
                        candidates.put(endLine - 1, prevCaseLine);
                    }
                    prevCaseLine = -1;
                    break;
                }
                case 211: 
                case 212: {
                    int currentLine = scanner.getLineNumber(start) - 1;
                    if (prevCaseLine != -1 && currentLine - 1 >= prevCaseLine) {
                        candidates.put(scanner.getLineNumber(start) - 2, prevCaseLine);
                    }
                    prevCaseLine = currentLine;
                    break;
                }
            }
            token = this.getNextToken(scanner);
        }
        for (Map.Entry entry : candidates.entrySet()) {
            foldingRanges.add(new FoldingRange(((Integer)entry.getValue()).intValue(), ((Integer)entry.getKey()).intValue()));
        }
    }
}

