/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.hover.JavaElementLabels;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolTag;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class DocumentSymbolHandler {
    private static Range DEFAULT_RANGE = new Range(new Position(0, 0), new Position(0, 0));
    private PreferenceManager preferenceManager;
    private static IScanner fScanner;

    public DocumentSymbolHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<Either<SymbolInformation, DocumentSymbol>> documentSymbol(DocumentSymbolParams params, IProgressMonitor monitor) {
        ITypeRoot unit = JDTUtils.resolveTypeRoot(params.getTextDocument().getUri());
        if (unit == null || !unit.exists()) {
            return Collections.emptyList();
        }
        if (this.preferenceManager.getClientPreferences().isHierarchicalDocumentSymbolSupported()) {
            List<DocumentSymbol> symbols = this.getHierarchicalOutline(unit, monitor);
            return symbols.stream().map(Either::forRight).collect(Collectors.toList());
        }
        SymbolInformation[] elements = this.getOutline(unit, monitor);
        return Arrays.asList(elements).stream().map(Either::forLeft).collect(Collectors.toList());
    }

    private SymbolInformation[] getOutline(ITypeRoot unit, IProgressMonitor monitor) {
        try {
            IJavaElement[] elements = unit.getChildren();
            ArrayList<SymbolInformation> symbols = new ArrayList<SymbolInformation>(elements.length);
            this.collectChildren(unit, elements, symbols, monitor);
            return symbols.toArray(new SymbolInformation[symbols.size()]);
        }
        catch (JavaModelException e) {
            if (!unit.exists()) {
                JavaLanguageServerPlugin.logError("Problem getting outline for " + unit.getElementName() + ": File not found.");
            } else {
                JavaLanguageServerPlugin.logException("Problem getting outline for " + unit.getElementName(), e);
            }
            return new SymbolInformation[0];
        }
    }

    /*
     * WARNING - void declaration
     */
    private void collectChildren(ITypeRoot unit, IJavaElement[] elements, ArrayList<SymbolInformation> symbols, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                Location location;
                IJavaElement element;
                block13: {
                    void method;
                    int type;
                    element = iJavaElementArray[n2];
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IJavaElement iJavaElement = element;
                    if (iJavaElement instanceof IParent) {
                        void parent;
                        IParent cfr_ignored_0 = (IParent)iJavaElement;
                        IParent cfr_ignored_1 = (IParent)iJavaElement;
                        this.collectChildren(unit, this.filter(parent.getChildren()), symbols, monitor);
                    }
                    if ((type = element.getElementType()) != 7 && type != 8 && type != 9) break block12;
                    IJavaElement iJavaElement2 = element;
                    if (!(iJavaElement2 instanceof SourceMethod)) break block13;
                    SourceMethod cfr_ignored_2 = (SourceMethod)iJavaElement2;
                    SourceMethod cfr_ignored_3 = (SourceMethod)iJavaElement2;
                    if (JDTUtils.isGenerated((IMember)method)) break block12;
                }
                if ((location = JDTUtils.toLocation(element)) != null) {
                    SymbolInformation si = new SymbolInformation();
                    String name = JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_DEFAULT);
                    si.setName(name == null ? element.getElementName() : name);
                    si.setKind(DocumentSymbolHandler.mapKind(element));
                    if (JDTUtils.isDeprecated(element)) {
                        if (this.preferenceManager.getClientPreferences().isSymbolTagSupported()) {
                            si.setTags(List.of(SymbolTag.Deprecated));
                        } else {
                            si.setDeprecated(Boolean.valueOf(true));
                        }
                    }
                    if (element.getParent() != null) {
                        si.setContainerName(element.getParent().getElementName());
                    }
                    location.setUri(ResourceUtils.toClientUri(location.getUri()));
                    si.setLocation(location);
                    if (!symbols.contains(si)) {
                        symbols.add(si);
                    }
                }
            }
            ++n2;
        }
    }

    private List<DocumentSymbol> getHierarchicalOutline(ITypeRoot unit, IProgressMonitor monitor) {
        try {
            IJavaElement[] children = unit.getChildren();
            Stream<IJavaElement> childrenStream = Stream.of(this.filter(children));
            if (unit instanceof IClassFile) {
                childrenStream = Stream.concat(Stream.of(unit.getParent()), childrenStream);
                ISourceRange sourceRange = unit.getSourceRange();
                if (sourceRange != null) {
                    int shift = sourceRange.getOffset();
                    IScanner scanner = DocumentSymbolHandler.getScanner();
                    scanner.setSource(unit.getSource().toCharArray());
                    scanner.resetTo(shift, shift + sourceRange.getLength());
                }
            }
            return childrenStream.map(child -> this.toDocumentSymbol((IJavaElement)child, unit, monitor)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (OperationCanceledException e) {
            JavaLanguageServerPlugin.logInfo("User abort while collecting the document symbols.");
        }
        catch (JavaModelException e) {
            if (!unit.exists()) {
                JavaLanguageServerPlugin.logError("Problem getting outline for " + unit.getElementName() + ": File not found.");
            }
            JavaLanguageServerPlugin.logException("Problem getting outline for " + unit.getElementName(), e);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private DocumentSymbol toDocumentSymbol(IJavaElement unit, ITypeRoot root, IProgressMonitor monitor) {
        int type = unit.getElementType();
        if (type != 7 && type != 8 && type != 9 && type != 11 && type != 5 && type != 4) {
            return null;
        }
        IJavaElement iJavaElement = unit;
        if (iJavaElement instanceof SourceMethod) {
            void method;
            SourceMethod sourceMethod = (SourceMethod)iJavaElement;
            SourceMethod cfr_ignored_0 = (SourceMethod)iJavaElement;
            if (JDTUtils.isGenerated((IMember)method)) {
                return null;
            }
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException("User abort");
        }
        DocumentSymbol symbol = new DocumentSymbol();
        try {
            IScanner scanner;
            String name = this.getName(unit);
            symbol.setName(name);
            if (type == 4) {
                scanner = DocumentSymbolHandler.getScanner();
                int token = 0;
                int packageStart = -1;
                int packageEnd = -1;
                while (token != 158) {
                    switch (token) {
                        case 214: {
                            packageStart = scanner.getCurrentTokenStartPosition();
                            packageEnd = scanner.getCurrentTokenEndPosition();
                        }
                    }
                    token = this.getNextToken(scanner);
                }
                Range packageRange = JDTUtils.toRange((IOpenable)root, packageStart, packageEnd);
                symbol.setRange(packageRange);
                symbol.setSelectionRange(packageRange);
            } else {
                symbol.setRange(this.getRange(unit));
                symbol.setSelectionRange(this.getSelectionRange(unit));
            }
            symbol.setKind(DocumentSymbolHandler.mapKind(unit));
            if (JDTUtils.isDeprecated(unit)) {
                if (this.preferenceManager.getClientPreferences().isSymbolTagSupported()) {
                    symbol.setTags(List.of(SymbolTag.Deprecated));
                } else {
                    symbol.setDeprecated(Boolean.valueOf(true));
                }
            }
            symbol.setDetail(this.getDetail(unit, name));
            IJavaElement iJavaElement2 = unit;
            if (iJavaElement2 instanceof IParent) {
                void parent;
                scanner = (IParent)iJavaElement2;
                IParent cfr_ignored_1 = (IParent)iJavaElement2;
                IJavaElement[] children = this.filter(parent.getChildren());
                symbol.setChildren(Stream.of(children).map(child -> this.toDocumentSymbol((IJavaElement)child, null, monitor)).filter(Objects::nonNull).collect(Collectors.toList()));
            }
        }
        catch (JavaModelException e) {
            Exceptions.sneakyThrow((Throwable)e);
        }
        return symbol;
    }

    private String getName(IJavaElement element) {
        String name = JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_DEFAULT);
        return name == null ? element.getElementName() : name;
    }

    private Range getRange(IJavaElement element) throws JavaModelException {
        Location location = JDTUtils.toLocation(element, JDTUtils.LocationType.FULL_RANGE);
        return location == null ? DEFAULT_RANGE : location.getRange();
    }

    private Range getSelectionRange(IJavaElement element) throws JavaModelException {
        Location location = JDTUtils.toLocation(element);
        return location == null ? DEFAULT_RANGE : location.getRange();
    }

    private String getDetail(IJavaElement element, String name) {
        String nameWithDetails = JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_DEFAULT | 0x20L | 0x10000000000L);
        if (nameWithDetails != null && nameWithDetails.startsWith(name)) {
            return nameWithDetails.substring(name.length());
        }
        return "";
    }

    private IJavaElement[] filter(IJavaElement[] elements) {
        return (IJavaElement[])Stream.of(elements).filter(e -> !this.isInitializer((IJavaElement)e) && !this.isSyntheticElement((IJavaElement)e)).toArray(IJavaElement[]::new);
    }

    private boolean isInitializer(IJavaElement element) {
        String name;
        return element.getElementType() == 9 && (name = element.getElementName()) != null && name.indexOf(60) >= 0;
    }

    private boolean isSyntheticElement(IJavaElement element) {
        if (!(element instanceof IMember)) {
            return false;
        }
        IMember member = (IMember)element;
        if (!member.isBinary()) {
            return false;
        }
        try {
            return Flags.isSynthetic((int)member.getFlags());
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static SymbolKind mapKind(IJavaElement element) {
        switch (element.getElementType()) {
            case 7: {
                try {
                    IType type = (IType)element;
                    if (type.isInterface()) {
                        return SymbolKind.Interface;
                    }
                    if (type.isEnum()) {
                        return SymbolKind.Enum;
                    }
                }
                catch (JavaModelException type) {
                    // empty catch block
                }
                return SymbolKind.Class;
            }
            case 16: {
                return SymbolKind.Property;
            }
            case 5: 
            case 6: {
                return SymbolKind.File;
            }
            case 8: {
                IField field = (IField)element;
                try {
                    if (field.isEnumConstant()) {
                        return SymbolKind.EnumMember;
                    }
                    int flags = field.getFlags();
                    if (Flags.isStatic((int)flags) && Flags.isFinal((int)flags)) {
                        return SymbolKind.Constant;
                    }
                }
                catch (JavaModelException flags) {
                    // empty catch block
                }
                return SymbolKind.Field;
            }
            case 12: 
            case 13: 
            case 17: {
                return SymbolKind.Module;
            }
            case 10: {
                return SymbolKind.Constructor;
            }
            case 14: {
                return SymbolKind.Variable;
            }
            case 15: {
                return SymbolKind.TypeParameter;
            }
            case 9: {
                try {
                    IJavaElement iJavaElement = element;
                    if (iJavaElement instanceof IMethod) {
                        void method;
                        IMethod flags = (IMethod)iJavaElement;
                        IMethod cfr_ignored_0 = (IMethod)iJavaElement;
                        if (method.isConstructor()) {
                            return SymbolKind.Constructor;
                        }
                    }
                    return SymbolKind.Method;
                }
                catch (JavaModelException e) {
                    return SymbolKind.Method;
                }
            }
            case 4: 
            case 11: {
                return SymbolKind.Package;
            }
        }
        return SymbolKind.String;
    }

    private static IScanner getScanner() {
        if (fScanner == null) {
            fScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)true);
        }
        return fScanner;
    }

    private int getNextToken(IScanner scanner) {
        int token = 0;
        while (token == 0) {
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
        }
        return token;
    }
}

