/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.util.Arrays;
import org.eclipse.jdt.core.CompletionProposal;

public class CompletionProposalUtils {
    private static final char SEMICOLON = ';';

    private CompletionProposalUtils() {
    }

    public static boolean isImportCompletion(CompletionProposal proposal) {
        char[] completion = proposal.getCompletion();
        if (completion.length == 0) {
            return false;
        }
        char last = completion[completion.length - 1];
        return last == ';' || last == '.';
    }

    public static CompletionProposal getRequiredTypeProposal(CompletionProposal proposal) {
        if (proposal.getKind() != 26 && proposal.getKind() != 27 && proposal.getKind() != 1) {
            return null;
        }
        CompletionProposal requiredProposal = null;
        CompletionProposal[] requiredProposals = proposal.getRequiredProposals();
        if (requiredProposals != null) {
            requiredProposal = Arrays.stream(requiredProposals).filter(p -> p.getKind() == 9).findFirst().orElse(null);
        }
        return requiredProposal;
    }
}

