"use strict";
/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var TheiaBlueprintContribution_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TheiaBlueprintContribution = exports.BlueprintCommands = exports.BlueprintMenus = void 0;
const inversify_1 = require("@theia/core/shared/inversify");
const common_frontend_contribution_1 = require("@theia/core/lib/browser/common-frontend-contribution");
const window_service_1 = require("@theia/core/lib/browser/window/window-service");
var BlueprintMenus;
(function (BlueprintMenus) {
    BlueprintMenus.BLUEPRINT_HELP = [...common_frontend_contribution_1.CommonMenus.HELP, 'blueprint'];
})(BlueprintMenus = exports.BlueprintMenus || (exports.BlueprintMenus = {}));
var BlueprintCommands;
(function (BlueprintCommands) {
    BlueprintCommands.CATEGORY = 'Blueprint';
    BlueprintCommands.REPORT_ISSUE = {
        id: 'blueprint:report-issue',
        category: BlueprintCommands.CATEGORY,
        label: 'Report Issue'
    };
    BlueprintCommands.DOCUMENTATION = {
        id: 'blueprint:documentation',
        category: BlueprintCommands.CATEGORY,
        label: 'Documentation'
    };
})(BlueprintCommands = exports.BlueprintCommands || (exports.BlueprintCommands = {}));
let TheiaBlueprintContribution = TheiaBlueprintContribution_1 = class TheiaBlueprintContribution {
    registerCommands(commandRegistry) {
        commandRegistry.registerCommand(BlueprintCommands.REPORT_ISSUE, {
            execute: () => this.windowService.openNewWindow(TheiaBlueprintContribution_1.REPORT_ISSUE_URL, { external: true })
        });
        commandRegistry.registerCommand(BlueprintCommands.DOCUMENTATION, {
            execute: () => this.windowService.openNewWindow(TheiaBlueprintContribution_1.DOCUMENTATION_URL, { external: true })
        });
    }
    registerMenus(menus) {
        menus.registerMenuAction(BlueprintMenus.BLUEPRINT_HELP, {
            commandId: BlueprintCommands.REPORT_ISSUE.id,
            label: BlueprintCommands.REPORT_ISSUE.label,
            order: '1'
        });
        menus.registerMenuAction(BlueprintMenus.BLUEPRINT_HELP, {
            commandId: BlueprintCommands.DOCUMENTATION.id,
            label: BlueprintCommands.DOCUMENTATION.label,
            order: '2'
        });
    }
};
TheiaBlueprintContribution.REPORT_ISSUE_URL = 'https://github.com/eclipse-theia/theia-blueprint/issues/new?assignees=&labels=&template=bug_report.md';
TheiaBlueprintContribution.DOCUMENTATION_URL = 'https://theia-ide.org/docs/blueprint_documentation';
__decorate([
    (0, inversify_1.inject)(window_service_1.WindowService),
    __metadata("design:type", Object)
], TheiaBlueprintContribution.prototype, "windowService", void 0);
TheiaBlueprintContribution = TheiaBlueprintContribution_1 = __decorate([
    (0, inversify_1.injectable)()
], TheiaBlueprintContribution);
exports.TheiaBlueprintContribution = TheiaBlueprintContribution;
//# sourceMappingURL=theia-blueprint-contribution.js.map