"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InMemoryUserDataProfilesService = exports.UserDataProfilesService = exports.toUserDataProfile = exports.EXTENSIONS_RESOURCE_NAME = exports.reviveProfile = exports.IUserDataProfilesService = exports.PROFILES_ENABLEMENT_CONFIG = exports.isUserDataProfile = void 0;
const hash_1 = require("../../../base/common/hash");
const event_1 = require("../../../base/common/event");
const lifecycle_1 = require("../../../base/common/lifecycle");
const resources_1 = require("../../../base/common/resources");
const types_1 = require("../../../base/common/types");
const uri_1 = require("../../../base/common/uri");
const nls_1 = require("../../../nls");
const environment_1 = require("../../environment/common/environment");
const files_1 = require("../../files/common/files");
const instantiation_1 = require("../../instantiation/common/instantiation");
const log_1 = require("../../log/common/log");
const workspace_1 = require("../../workspace/common/workspace");
const map_1 = require("../../../base/common/map");
const uriIdentity_1 = require("../../uriIdentity/common/uriIdentity");
const async_1 = require("../../../base/common/async");
const uuid_1 = require("../../../base/common/uuid");
const strings_1 = require("../../../base/common/strings");
function isUserDataProfile(thing) {
    const candidate = thing;
    return !!(candidate && typeof candidate === 'object'
        && typeof candidate.id === 'string'
        && typeof candidate.isDefault === 'boolean'
        && typeof candidate.name === 'string'
        && uri_1.URI.isUri(candidate.location)
        && uri_1.URI.isUri(candidate.globalStorageHome)
        && uri_1.URI.isUri(candidate.settingsResource)
        && uri_1.URI.isUri(candidate.keybindingsResource)
        && uri_1.URI.isUri(candidate.tasksResource)
        && uri_1.URI.isUri(candidate.snippetsHome)
        && ((0, types_1.isUndefined)(candidate.extensionsResource) || uri_1.URI.isUri(candidate.extensionsResource)));
}
exports.isUserDataProfile = isUserDataProfile;
exports.PROFILES_ENABLEMENT_CONFIG = 'workbench.experimental.settingsProfiles.enabled';
exports.IUserDataProfilesService = (0, instantiation_1.createDecorator)('IUserDataProfilesService');
function reviveProfile(profile, scheme) {
    var _a;
    return {
        id: profile.id,
        isDefault: profile.isDefault,
        name: profile.name,
        shortName: profile.shortName,
        location: uri_1.URI.revive(profile.location).with({ scheme }),
        globalStorageHome: uri_1.URI.revive(profile.globalStorageHome).with({ scheme }),
        settingsResource: uri_1.URI.revive(profile.settingsResource).with({ scheme }),
        keybindingsResource: uri_1.URI.revive(profile.keybindingsResource).with({ scheme }),
        tasksResource: uri_1.URI.revive(profile.tasksResource).with({ scheme }),
        snippetsHome: uri_1.URI.revive(profile.snippetsHome).with({ scheme }),
        extensionsResource: (_a = uri_1.URI.revive(profile.extensionsResource)) === null || _a === void 0 ? void 0 : _a.with({ scheme }),
        useDefaultFlags: profile.useDefaultFlags,
        isTransient: profile.isTransient,
    };
}
exports.reviveProfile = reviveProfile;
exports.EXTENSIONS_RESOURCE_NAME = 'extensions.json';
function toUserDataProfile(id, name, location, options) {
    return {
        id,
        name,
        location,
        isDefault: false,
        shortName: options === null || options === void 0 ? void 0 : options.shortName,
        globalStorageHome: (0, resources_1.joinPath)(location, 'globalStorage'),
        settingsResource: (0, resources_1.joinPath)(location, 'settings.json'),
        keybindingsResource: (0, resources_1.joinPath)(location, 'keybindings.json'),
        tasksResource: (0, resources_1.joinPath)(location, 'tasks.json'),
        snippetsHome: (0, resources_1.joinPath)(location, 'snippets'),
        extensionsResource: (0, resources_1.joinPath)(location, exports.EXTENSIONS_RESOURCE_NAME),
        useDefaultFlags: options === null || options === void 0 ? void 0 : options.useDefaultFlags,
        isTransient: options === null || options === void 0 ? void 0 : options.transient
    };
}
exports.toUserDataProfile = toUserDataProfile;
let UserDataProfilesService = class UserDataProfilesService extends lifecycle_1.Disposable {
    get defaultProfile() { return this.profiles[0]; }
    get profiles() { return [...this.profilesObject.profiles, ...this.transientProfilesObject.profiles]; }
    constructor(environmentService, fileService, uriIdentityService, logService) {
        super();
        this.environmentService = environmentService;
        this.fileService = fileService;
        this.uriIdentityService = uriIdentityService;
        this.logService = logService;
        this.enabled = false;
        this.defaultProfileShouldIncludeExtensionsResourceAlways = false;
        this._onDidChangeProfiles = this._register(new event_1.Emitter());
        this.onDidChangeProfiles = this._onDidChangeProfiles.event;
        this._onWillCreateProfile = this._register(new event_1.Emitter());
        this.onWillCreateProfile = this._onWillCreateProfile.event;
        this._onWillRemoveProfile = this._register(new event_1.Emitter());
        this.onWillRemoveProfile = this._onWillRemoveProfile.event;
        this._onDidResetWorkspaces = this._register(new event_1.Emitter());
        this.onDidResetWorkspaces = this._onDidResetWorkspaces.event;
        this.profileCreationPromises = new Map();
        this.transientProfilesObject = {
            profiles: [],
            workspaces: new map_1.ResourceMap()
        };
        this.profilesHome = (0, resources_1.joinPath)(this.environmentService.userRoamingDataHome, 'profiles');
    }
    setEnablement(enabled) {
        if (this.enabled !== enabled) {
            this._profilesObject = undefined;
            this.enabled = enabled;
        }
    }
    get profilesObject() {
        if (!this._profilesObject) {
            const profiles = this.enabled ? this.getStoredProfiles().map(storedProfile => toUserDataProfile((0, resources_1.basename)(storedProfile.location), storedProfile.name, storedProfile.location, { shortName: storedProfile.shortName, useDefaultFlags: storedProfile.useDefaultFlags })) : [];
            let emptyWindow;
            const workspaces = new map_1.ResourceMap();
            const defaultProfile = toUserDataProfile((0, hash_1.hash)(this.environmentService.userRoamingDataHome.path).toString(16), (0, nls_1.localize)('defaultProfile', "Default"), this.environmentService.userRoamingDataHome);
            profiles.unshift(Object.assign(Object.assign({}, defaultProfile), { isDefault: true, extensionsResource: this.defaultProfileShouldIncludeExtensionsResourceAlways || profiles.length > 0 || this.transientProfilesObject.profiles.length > 0 ? defaultProfile.extensionsResource : undefined }));
            if (profiles.length) {
                const profileAssicaitions = this.getStoredProfileAssociations();
                if (profileAssicaitions.workspaces) {
                    for (const [workspacePath, profilePath] of Object.entries(profileAssicaitions.workspaces)) {
                        const workspace = uri_1.URI.parse(workspacePath);
                        const profileLocation = uri_1.URI.parse(profilePath);
                        const profile = profiles.find(p => this.uriIdentityService.extUri.isEqual(p.location, profileLocation));
                        if (profile) {
                            workspaces.set(workspace, profile);
                        }
                    }
                }
                if (profileAssicaitions.emptyWindow) {
                    const emptyWindowProfileLocation = uri_1.URI.parse(profileAssicaitions.emptyWindow);
                    emptyWindow = profiles.find(p => this.uriIdentityService.extUri.isEqual(p.location, emptyWindowProfileLocation));
                }
            }
            this._profilesObject = { profiles, workspaces, emptyWindow };
        }
        return this._profilesObject;
    }
    createTransientProfile(workspaceIdentifier) {
        return __awaiter(this, void 0, void 0, function* () {
            const namePrefix = `Temp`;
            const nameRegEx = new RegExp(`${(0, strings_1.escapeRegExpCharacters)(namePrefix)}\\s(\\d+)`);
            let nameIndex = 0;
            for (const profile of this.profiles) {
                const matches = nameRegEx.exec(profile.name);
                const index = matches ? parseInt(matches[1]) : 0;
                nameIndex = index > nameIndex ? index : nameIndex;
            }
            const name = `${namePrefix} ${nameIndex + 1}`;
            return this.createProfile((0, hash_1.hash)((0, uuid_1.generateUuid)()).toString(16), name, { transient: true }, workspaceIdentifier);
        });
    }
    createNamedProfile(name, options, workspaceIdentifier) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.createProfile((0, hash_1.hash)((0, uuid_1.generateUuid)()).toString(16), name, options, workspaceIdentifier);
        });
    }
    createProfile(id, name, options, workspaceIdentifier) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.enabled) {
                throw new Error(`Settings Profiles are disabled. Enable them via the '${exports.PROFILES_ENABLEMENT_CONFIG}' setting.`);
            }
            const profile = yield this.doCreateProfile(id, name, options);
            if (workspaceIdentifier) {
                yield this.setProfileForWorkspace(workspaceIdentifier, profile);
            }
            return profile;
        });
    }
    doCreateProfile(id, name, options) {
        return __awaiter(this, void 0, void 0, function* () {
            let profileCreationPromise = this.profileCreationPromises.get(name);
            if (!profileCreationPromise) {
                profileCreationPromise = (() => __awaiter(this, void 0, void 0, function* () {
                    try {
                        const existing = this.profiles.find(p => p.name === name || p.id === id);
                        if (existing) {
                            return existing;
                        }
                        const profile = toUserDataProfile(id, name, (0, resources_1.joinPath)(this.profilesHome, id), options);
                        yield this.fileService.createFolder(profile.location);
                        const joiners = [];
                        this._onWillCreateProfile.fire({
                            profile,
                            join(promise) {
                                joiners.push(promise);
                            }
                        });
                        yield async_1.Promises.settled(joiners);
                        this.updateProfiles([profile], [], []);
                        return profile;
                    }
                    finally {
                        this.profileCreationPromises.delete(name);
                    }
                }))();
                this.profileCreationPromises.set(name, profileCreationPromise);
            }
            return profileCreationPromise;
        });
    }
    updateProfile(profileToUpdate, options) {
        var _a, _b, _c, _d;
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.enabled) {
                throw new Error(`Settings Profiles are disabled. Enable them via the '${exports.PROFILES_ENABLEMENT_CONFIG}' setting.`);
            }
            let profile = this.profiles.find(p => p.id === profileToUpdate.id);
            if (!profile) {
                throw new Error(`Profile '${profileToUpdate.name}' does not exist`);
            }
            profile = toUserDataProfile(profile.id, (_a = options.name) !== null && _a !== void 0 ? _a : profile.name, profile.location, { shortName: (_b = options.shortName) !== null && _b !== void 0 ? _b : profile.shortName, transient: (_c = options.transient) !== null && _c !== void 0 ? _c : profile.isTransient, useDefaultFlags: (_d = options.useDefaultFlags) !== null && _d !== void 0 ? _d : profile.useDefaultFlags });
            this.updateProfiles([], [], [profile]);
            return profile;
        });
    }
    removeProfile(profileToRemove) {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.enabled) {
                throw new Error(`Settings Profiles are disabled. Enable them via the '${exports.PROFILES_ENABLEMENT_CONFIG}' setting.`);
            }
            if (profileToRemove.isDefault) {
                throw new Error('Cannot remove default profile');
            }
            const profile = this.profiles.find(p => p.id === profileToRemove.id);
            if (!profile) {
                throw new Error(`Profile '${profileToRemove.name}' does not exist`);
            }
            const joiners = [];
            this._onWillRemoveProfile.fire({
                profile,
                join(promise) {
                    joiners.push(promise);
                }
            });
            try {
                yield Promise.allSettled(joiners);
            }
            catch (error) {
                this.logService.error(error);
            }
            if (profile.id === ((_a = this.profilesObject.emptyWindow) === null || _a === void 0 ? void 0 : _a.id)) {
                this.profilesObject.emptyWindow = undefined;
            }
            for (const workspace of [...this.profilesObject.workspaces.keys()]) {
                if (profile.id === ((_b = this.profilesObject.workspaces.get(workspace)) === null || _b === void 0 ? void 0 : _b.id)) {
                    this.profilesObject.workspaces.delete(workspace);
                }
            }
            this.updateStoredProfileAssociations();
            this.updateProfiles([], [profile], []);
            try {
                if (this.profiles.length === 1) {
                    yield this.fileService.del(this.profilesHome, { recursive: true });
                }
                else {
                    yield this.fileService.del(profile.location, { recursive: true });
                }
            }
            catch (error) {
                this.logService.error(error);
            }
        });
    }
    getOrSetProfileForWorkspace(workspaceIdentifier, profileToSet = this.defaultProfile) {
        if (!this.enabled) {
            return this.defaultProfile;
        }
        let profile = this.getProfileForWorkspace(workspaceIdentifier);
        if (!profile) {
            profile = profileToSet;
            // Associate the profile to workspace only if there are user profiles
            // If there are no profiles, workspaces are associated to default profile by default
            if (this.profiles.length > 1) {
                this.setProfileForWorkspaceSync(workspaceIdentifier, profile);
            }
        }
        return profile;
    }
    setProfileForWorkspace(workspaceIdentifier, profileToSet) {
        return __awaiter(this, void 0, void 0, function* () {
            this.setProfileForWorkspaceSync(workspaceIdentifier, profileToSet);
        });
    }
    setProfileForWorkspaceSync(workspaceIdentifier, profileToSet) {
        if (!this.enabled) {
            throw new Error(`Settings Profiles are disabled. Enable them via the '${exports.PROFILES_ENABLEMENT_CONFIG}' setting.`);
        }
        const profile = this.profiles.find(p => p.id === profileToSet.id);
        if (!profile) {
            throw new Error(`Profile '${profileToSet.name}' does not exist`);
        }
        this.updateWorkspaceAssociation(workspaceIdentifier, profile);
    }
    unsetWorkspace(workspaceIdentifier, transient) {
        if (!this.enabled) {
            throw new Error(`Settings Profiles are disabled. Enable them via the '${exports.PROFILES_ENABLEMENT_CONFIG}' setting.`);
        }
        this.updateWorkspaceAssociation(workspaceIdentifier, undefined, transient);
    }
    resetWorkspaces() {
        return __awaiter(this, void 0, void 0, function* () {
            this.transientProfilesObject.workspaces.clear();
            this.transientProfilesObject.emptyWindow = undefined;
            this.profilesObject.workspaces.clear();
            this.profilesObject.emptyWindow = undefined;
            this.updateStoredProfileAssociations();
            this._onDidResetWorkspaces.fire();
        });
    }
    cleanUp() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.enabled) {
                return;
            }
            if (yield this.fileService.exists(this.profilesHome)) {
                const stat = yield this.fileService.resolve(this.profilesHome);
                yield Promise.all((stat.children || [])
                    .filter(child => child.isDirectory && this.profiles.every(p => !this.uriIdentityService.extUri.isEqual(p.location, child.resource)))
                    .map(child => this.fileService.del(child.resource, { recursive: true })));
            }
        });
    }
    cleanUpTransientProfiles() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.enabled) {
                return;
            }
            const unAssociatedTransientProfiles = this.transientProfilesObject.profiles.filter(p => !this.isProfileAssociatedToWorkspace(p));
            yield Promise.allSettled(unAssociatedTransientProfiles.map(p => this.removeProfile(p)));
        });
    }
    getProfileForWorkspace(workspaceIdentifier) {
        var _a, _b;
        const workspace = this.getWorkspace(workspaceIdentifier);
        return uri_1.URI.isUri(workspace) ? (_a = this.transientProfilesObject.workspaces.get(workspace)) !== null && _a !== void 0 ? _a : this.profilesObject.workspaces.get(workspace) : (_b = this.transientProfilesObject.emptyWindow) !== null && _b !== void 0 ? _b : this.profilesObject.emptyWindow;
    }
    getWorkspace(workspaceIdentifier) {
        if ((0, workspace_1.isSingleFolderWorkspaceIdentifier)(workspaceIdentifier)) {
            return workspaceIdentifier.uri;
        }
        if ((0, workspace_1.isWorkspaceIdentifier)(workspaceIdentifier)) {
            return workspaceIdentifier.configPath;
        }
        return 'empty-window';
    }
    isProfileAssociatedToWorkspace(profile) {
        var _a, _b;
        if (this.uriIdentityService.extUri.isEqual((_a = this.transientProfilesObject.emptyWindow) === null || _a === void 0 ? void 0 : _a.location, profile.location)) {
            return true;
        }
        if ([...this.transientProfilesObject.workspaces.values()].some(workspaceProfile => this.uriIdentityService.extUri.isEqual(workspaceProfile.location, profile.location))) {
            return true;
        }
        if (this.uriIdentityService.extUri.isEqual((_b = this.profilesObject.emptyWindow) === null || _b === void 0 ? void 0 : _b.location, profile.location)) {
            return true;
        }
        if ([...this.profilesObject.workspaces.values()].some(workspaceProfile => this.uriIdentityService.extUri.isEqual(workspaceProfile.location, profile.location))) {
            return true;
        }
        return false;
    }
    updateProfiles(added, removed, updated) {
        var _a;
        const allProfiles = [...this.profiles, ...added];
        const storedProfiles = [];
        this.transientProfilesObject.profiles = [];
        for (let profile of allProfiles) {
            if (profile.isDefault) {
                continue;
            }
            if (removed.some(p => profile.id === p.id)) {
                continue;
            }
            profile = (_a = updated.find(p => profile.id === p.id)) !== null && _a !== void 0 ? _a : profile;
            if (profile.isTransient) {
                this.transientProfilesObject.profiles.push(profile);
            }
            else {
                storedProfiles.push({ location: profile.location, name: profile.name, shortName: profile.shortName, useDefaultFlags: profile.useDefaultFlags });
            }
        }
        this.saveStoredProfiles(storedProfiles);
        this._profilesObject = undefined;
        this.triggerProfilesChanges(added, removed, updated);
    }
    triggerProfilesChanges(added, removed, updated) {
        this._onDidChangeProfiles.fire({ added, removed, updated, all: this.profiles });
    }
    updateWorkspaceAssociation(workspaceIdentifier, newProfile, transient) {
        // Force transient if the new profile to associate is transient
        transient = (newProfile === null || newProfile === void 0 ? void 0 : newProfile.isTransient) ? true : transient;
        if (!transient) {
            // Unset the transiet workspace association if any
            this.updateWorkspaceAssociation(workspaceIdentifier, undefined, true);
        }
        const workspace = this.getWorkspace(workspaceIdentifier);
        const profilesObject = transient ? this.transientProfilesObject : this.profilesObject;
        // Folder or Multiroot workspace
        if (uri_1.URI.isUri(workspace)) {
            profilesObject.workspaces.delete(workspace);
            if (newProfile) {
                profilesObject.workspaces.set(workspace, newProfile);
            }
        }
        // Empty Window
        else {
            profilesObject.emptyWindow = newProfile;
        }
        if (!transient) {
            this.updateStoredProfileAssociations();
        }
    }
    updateStoredProfileAssociations() {
        var _a;
        const workspaces = {};
        for (const [workspace, profile] of this.profilesObject.workspaces.entries()) {
            workspaces[workspace.toString()] = profile.location.toString();
        }
        const emptyWindow = (_a = this.profilesObject.emptyWindow) === null || _a === void 0 ? void 0 : _a.location.toString();
        this.saveStoredProfileAssociations({ workspaces, emptyWindow });
        this._profilesObject = undefined;
    }
    getStoredProfiles() { return []; }
    saveStoredProfiles(storedProfiles) { throw new Error('not implemented'); }
    getStoredProfileAssociations() { return {}; }
    saveStoredProfileAssociations(storedProfileAssociations) { throw new Error('not implemented'); }
};
UserDataProfilesService.PROFILES_KEY = 'userDataProfiles';
UserDataProfilesService.PROFILE_ASSOCIATIONS_KEY = 'profileAssociations';
UserDataProfilesService = __decorate([
    __param(0, environment_1.IEnvironmentService),
    __param(1, files_1.IFileService),
    __param(2, uriIdentity_1.IUriIdentityService),
    __param(3, log_1.ILogService)
], UserDataProfilesService);
exports.UserDataProfilesService = UserDataProfilesService;
class InMemoryUserDataProfilesService extends UserDataProfilesService {
    constructor() {
        super(...arguments);
        this.storedProfiles = [];
        this.storedProfileAssociations = {};
    }
    getStoredProfiles() { return this.storedProfiles; }
    saveStoredProfiles(storedProfiles) { this.storedProfiles = storedProfiles; }
    getStoredProfileAssociations() { return this.storedProfileAssociations; }
    saveStoredProfileAssociations(storedProfileAssociations) { this.storedProfileAssociations = storedProfileAssociations; }
}
exports.InMemoryUserDataProfilesService = InMemoryUserDataProfilesService;
//# sourceMappingURL=userDataProfile.js.map