"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.commitInlineSuggestionAction = void 0;
const editorExtensions_1 = require("../../../browser/editorExtensions");
const editorContextKeys_1 = require("../../../common/editorContextKeys");
const hoverTypes_1 = require("../../hover/browser/hoverTypes");
const consts_1 = require("./consts");
const ghostTextController_1 = require("./ghostTextController");
const ghostTextHoverParticipant_1 = require("./ghostTextHoverParticipant");
const contextkey_1 = require("../../../../platform/contextkey/common/contextkey");
const keybindingsRegistry_1 = require("../../../../platform/keybinding/common/keybindingsRegistry");
(0, editorExtensions_1.registerEditorContribution)(ghostTextController_1.GhostTextController.ID, ghostTextController_1.GhostTextController);
(0, editorExtensions_1.registerEditorAction)(ghostTextController_1.TriggerInlineSuggestionAction);
(0, editorExtensions_1.registerEditorAction)(ghostTextController_1.ShowNextInlineSuggestionAction);
(0, editorExtensions_1.registerEditorAction)(ghostTextController_1.ShowPreviousInlineSuggestionAction);
hoverTypes_1.HoverParticipantRegistry.register(ghostTextHoverParticipant_1.InlineCompletionsHoverParticipant);
const GhostTextCommand = editorExtensions_1.EditorCommand.bindToContribution(ghostTextController_1.GhostTextController.get);
exports.commitInlineSuggestionAction = new GhostTextCommand({
    id: consts_1.inlineSuggestCommitId,
    precondition: ghostTextController_1.GhostTextController.inlineSuggestionVisible,
    handler(x) {
        x.commit();
        x.editor.focus();
    }
});
(0, editorExtensions_1.registerEditorCommand)(exports.commitInlineSuggestionAction);
keybindingsRegistry_1.KeybindingsRegistry.registerKeybindingRule({
    primary: 2 /* KeyCode.Tab */,
    weight: 200,
    id: exports.commitInlineSuggestionAction.id,
    when: contextkey_1.ContextKeyExpr.and(exports.commitInlineSuggestionAction.precondition, editorContextKeys_1.EditorContextKeys.tabMovesFocus.toNegated(), ghostTextController_1.GhostTextController.inlineSuggestionHasIndentationLessThanTabSize),
});
(0, editorExtensions_1.registerEditorCommand)(new GhostTextCommand({
    id: 'editor.action.inlineSuggest.hide',
    precondition: ghostTextController_1.GhostTextController.inlineSuggestionVisible,
    kbOpts: {
        weight: 100,
        primary: 9 /* KeyCode.Escape */,
    },
    handler(x) {
        x.hide();
    }
}));
//# sourceMappingURL=ghostText.contribution.js.map