"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CopyPasteController = void 0;
const dnd_1 = require("../../../../base/browser/dnd");
const dom_1 = require("../../../../base/browser/dom");
const async_1 = require("../../../../base/common/async");
const dataTransfer_1 = require("../../../../base/common/dataTransfer");
const lifecycle_1 = require("../../../../base/common/lifecycle");
const mime_1 = require("../../../../base/common/mime");
const uuid_1 = require("../../../../base/common/uuid");
const dnd_2 = require("../../../browser/dnd");
const bulkEditService_1 = require("../../../browser/services/bulkEditService");
const range_1 = require("../../../common/core/range");
const selection_1 = require("../../../common/core/selection");
const languageFeatures_1 = require("../../../common/services/languageFeatures");
const editorState_1 = require("../../editorState/browser/editorState");
const snippetParser_1 = require("../../snippet/browser/snippetParser");
const nls_1 = require("../../../../nls");
const clipboardService_1 = require("../../../../platform/clipboard/common/clipboardService");
const configuration_1 = require("../../../../platform/configuration/common/configuration");
const progress_1 = require("../../../../platform/progress/common/progress");
const vscodeClipboardMime = 'application/vnd.code.copyMetadata';
let CopyPasteController = class CopyPasteController extends lifecycle_1.Disposable {
    static get(editor) {
        return editor.getContribution(CopyPasteController.ID);
    }
    constructor(editor, _bulkEditService, _clipboardService, _configurationService, _languageFeaturesService, _progressService) {
        super();
        this._bulkEditService = _bulkEditService;
        this._clipboardService = _clipboardService;
        this._configurationService = _configurationService;
        this._languageFeaturesService = _languageFeaturesService;
        this._progressService = _progressService;
        this._editor = editor;
        const container = editor.getContainerDomNode();
        this._register((0, dom_1.addDisposableListener)(container, 'copy', e => this.handleCopy(e)));
        this._register((0, dom_1.addDisposableListener)(container, 'cut', e => this.handleCopy(e)));
        this._register((0, dom_1.addDisposableListener)(container, 'paste', e => this.handlePaste(e), true));
    }
    arePasteActionsEnabled(model) {
        return this._configurationService.getValue('editor.experimental.pasteActions.enabled', {
            resource: model.uri
        });
    }
    handleCopy(e) {
        var _a;
        if (!e.clipboardData || !this._editor.hasTextFocus()) {
            return;
        }
        const model = this._editor.getModel();
        const selections = this._editor.getSelections();
        if (!model || !(selections === null || selections === void 0 ? void 0 : selections.length)) {
            return;
        }
        if (!this.arePasteActionsEnabled(model)) {
            return;
        }
        const ranges = [...selections];
        const primarySelection = selections[0];
        const wasFromEmptySelection = primarySelection.isEmpty();
        if (wasFromEmptySelection) {
            if (!this._editor.getOption(33 /* EditorOption.emptySelectionClipboard */)) {
                return;
            }
            ranges[0] = new range_1.Range(primarySelection.startLineNumber, 0, primarySelection.startLineNumber, model.getLineLength(primarySelection.startLineNumber));
        }
        const providers = this._languageFeaturesService.documentPasteEditProvider.ordered(model).filter(x => !!x.prepareDocumentPaste);
        if (!providers.length) {
            this.setCopyMetadata(e.clipboardData, { wasFromEmptySelection });
            return;
        }
        const dataTransfer = (0, dnd_2.toVSDataTransfer)(e.clipboardData);
        // Save off a handle pointing to data that VS Code maintains.
        const handle = (0, uuid_1.generateUuid)();
        this.setCopyMetadata(e.clipboardData, {
            id: handle,
            wasFromEmptySelection,
        });
        const promise = (0, async_1.createCancelablePromise)((token) => __awaiter(this, void 0, void 0, function* () {
            const results = yield Promise.all(providers.map(provider => {
                return provider.prepareDocumentPaste(model, ranges, dataTransfer, token);
            }));
            for (const result of results) {
                result === null || result === void 0 ? void 0 : result.forEach((value, key) => {
                    dataTransfer.replace(key, value);
                });
            }
            return dataTransfer;
        }));
        (_a = this._currentClipboardItem) === null || _a === void 0 ? void 0 : _a.dataTransferPromise.cancel();
        this._currentClipboardItem = { handle: handle, dataTransferPromise: promise };
    }
    setCopyMetadata(dataTransfer, metadata) {
        dataTransfer.setData(vscodeClipboardMime, JSON.stringify(metadata));
    }
    handlePaste(e) {
        var _a, _b, _c, _d;
        return __awaiter(this, void 0, void 0, function* () {
            if (!e.clipboardData || !this._editor.hasTextFocus()) {
                return;
            }
            const selections = this._editor.getSelections();
            if (!(selections === null || selections === void 0 ? void 0 : selections.length) || !this._editor.hasModel()) {
                return;
            }
            const model = this._editor.getModel();
            if (!this.arePasteActionsEnabled(model)) {
                return;
            }
            let metadata;
            const rawMetadata = (_a = e.clipboardData) === null || _a === void 0 ? void 0 : _a.getData(vscodeClipboardMime);
            if (rawMetadata && typeof rawMetadata === 'string') {
                metadata = JSON.parse(rawMetadata);
            }
            const providers = this._languageFeaturesService.documentPasteEditProvider.ordered(model);
            if (!providers.length) {
                return;
            }
            e.preventDefault();
            e.stopImmediatePropagation();
            const tokenSource = new editorState_1.EditorStateCancellationTokenSource(this._editor, 1 /* CodeEditorStateFlag.Value */ | 2 /* CodeEditorStateFlag.Selection */);
            try {
                const dataTransfer = (0, dnd_2.toVSDataTransfer)(e.clipboardData);
                if ((metadata === null || metadata === void 0 ? void 0 : metadata.id) && ((_b = this._currentClipboardItem) === null || _b === void 0 ? void 0 : _b.handle) === metadata.id) {
                    const toMergeDataTransfer = yield this._currentClipboardItem.dataTransferPromise;
                    if (tokenSource.token.isCancellationRequested) {
                        return;
                    }
                    toMergeDataTransfer.forEach((value, key) => {
                        dataTransfer.replace(key, value);
                    });
                }
                if (!dataTransfer.has(mime_1.Mimes.uriList)) {
                    const resources = yield this._clipboardService.readResources();
                    if (tokenSource.token.isCancellationRequested) {
                        return;
                    }
                    if (resources.length) {
                        dataTransfer.append(mime_1.Mimes.uriList, (0, dataTransfer_1.createStringDataTransferItem)(dnd_2.UriList.create(resources)));
                    }
                }
                dataTransfer.delete(vscodeClipboardMime);
                const providerEdit = yield this._progressService.withProgress({
                    location: 15 /* ProgressLocation.Notification */,
                    delay: 750,
                    title: (0, nls_1.localize)('pasteProgressTitle', "Running paste handlers..."),
                    cancellable: true,
                }, () => {
                    return this.getProviderPasteEdit(providers, dataTransfer, model, selections, tokenSource.token);
                }, () => {
                    return tokenSource.cancel();
                });
                if (tokenSource.token.isCancellationRequested) {
                    return;
                }
                if (providerEdit) {
                    const snippet = typeof providerEdit.insertText === 'string' ? snippetParser_1.SnippetParser.escape(providerEdit.insertText) : providerEdit.insertText.snippet;
                    const combinedWorkspaceEdit = {
                        edits: [
                            new bulkEditService_1.ResourceTextEdit(model.uri, {
                                range: selection_1.Selection.liftSelection(this._editor.getSelection()),
                                text: snippet,
                                insertAsSnippet: true,
                            }),
                            ...((_d = (_c = providerEdit.additionalEdit) === null || _c === void 0 ? void 0 : _c.edits) !== null && _d !== void 0 ? _d : [])
                        ]
                    };
                    yield this._bulkEditService.apply(combinedWorkspaceEdit, { editor: this._editor });
                    return;
                }
                yield this.applyDefaultPasteHandler(dataTransfer, metadata, tokenSource.token);
            }
            finally {
                tokenSource.dispose();
            }
        });
    }
    getProviderPasteEdit(providers, dataTransfer, model, selections, token) {
        return (0, async_1.raceCancellation)((() => __awaiter(this, void 0, void 0, function* () {
            for (const provider of providers) {
                if (token.isCancellationRequested) {
                    return;
                }
                if (!isSupportedProvider(provider, dataTransfer)) {
                    continue;
                }
                const edit = yield provider.provideDocumentPasteEdits(model, selections, dataTransfer, token);
                if (edit) {
                    return edit;
                }
            }
            return undefined;
        }))(), token);
    }
    applyDefaultPasteHandler(dataTransfer, metadata, token) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const textDataTransfer = (_a = dataTransfer.get(mime_1.Mimes.text)) !== null && _a !== void 0 ? _a : dataTransfer.get('text');
            if (!textDataTransfer) {
                return;
            }
            const text = yield textDataTransfer.asString();
            if (token.isCancellationRequested) {
                return;
            }
            this._editor.trigger('keyboard', "paste" /* Handler.Paste */, {
                text: text,
                pasteOnNewLine: metadata === null || metadata === void 0 ? void 0 : metadata.wasFromEmptySelection,
                multicursorText: null
            });
        });
    }
};
CopyPasteController.ID = 'editor.contrib.copyPasteActionController';
CopyPasteController = __decorate([
    __param(1, bulkEditService_1.IBulkEditService),
    __param(2, clipboardService_1.IClipboardService),
    __param(3, configuration_1.IConfigurationService),
    __param(4, languageFeatures_1.ILanguageFeaturesService),
    __param(5, progress_1.IProgressService)
], CopyPasteController);
exports.CopyPasteController = CopyPasteController;
function isSupportedProvider(provider, dataTransfer) {
    return provider.pasteMimeTypes.some(type => {
        if (type.toLowerCase() === dnd_1.DataTransfers.FILES.toLowerCase()) {
            return [...dataTransfer.values()].some(item => item.asFile());
        }
        return dataTransfer.has(type);
    });
}
//# sourceMappingURL=copyPasteController.js.map