/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.maven;

import com.microsoft.java.maven.PosInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.Position;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class GetPosHandler
extends DefaultHandler {
    private Locator locator;
    private PosInfo posInfo = new PosInfo();
    private static final int LINE_OFFSET = 1;
    private static final int COLUMN_OFFSET = 1;
    private static final int DEPENDENCIES_LENGTH = 15;
    private static final int PROJECT_LENGTH = 10;
    private String targetDependency;
    List<String> dependenciesList = new ArrayList<String>();
    String groupId;
    String artifactId;
    Stack<String> nodes = new Stack();

    GetPosHandler() {
    }

    public PosInfo getPosInfo() {
        return this.posInfo;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.nodes.push(qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String content = new String(ch, start, length);
        if (this.isInArtifactIdNode()) {
            this.groupId = content;
        } else if (this.isInGroupIdNode()) {
            this.artifactId = content;
        }
    }

    private boolean isInDependencyNode() {
        return this.nodes.contains("dependency");
    }

    private boolean isInGroupIdNode() {
        return this.isInDependencyNode() && "groupId".equals(this.nodes.peek());
    }

    private boolean isInArtifactIdNode() {
        return this.isInDependencyNode() && "artifactId".equals(this.nodes.peek());
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String top = null;
        while (!this.nodes.empty() && !StringUtils.equals(top, (CharSequence)qName)) {
            top = this.nodes.pop();
        }
        switch (qName) {
            case "dependencies": {
                if (this.nodes.empty() || !"project".equals(this.nodes.peek())) break;
                this.posInfo.alreadyHasDependencies = true;
                this.posInfo.pos = new Position(this.locator.getLineNumber() - 1, this.locator.getColumnNumber() - 1 - 15);
                break;
            }
            case "project": {
                if (this.posInfo.pos != null) break;
                this.posInfo.pos = new Position(this.locator.getLineNumber() - 1, this.locator.getColumnNumber() - 1 - 10);
                break;
            }
            case "dependency": {
                this.dependenciesList.add(String.valueOf(this.groupId) + ":" + this.artifactId);
                this.artifactId = "";
                this.groupId = "";
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.dependenciesList.contains(this.targetDependency)) {
            this.posInfo.needAddDependency = false;
        }
    }

    public void setTargetDependency(String targetDependency) {
        this.targetDependency = targetDependency;
    }
}

