/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.model.Build;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.jdt.IClassifierClasspathProvider;
import org.eclipse.m2e.jdt.internal.ModuleSupport;

public abstract class AbstractClassifierClasspathProvider
implements IClassifierClasspathProvider,
IExecutableExtension {
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private String id;
    private String name;

    protected void addTestFolder(Set<IRuntimeClasspathEntry> runtimeClasspath, IMavenProjectFacade mavenProjectFacade, IProgressMonitor monitor, int classpathProperty) throws CoreException {
        Build build = mavenProjectFacade.getMavenProject(monitor).getBuild();
        LinkedHashSet<IPath> allTestClasses = new LinkedHashSet<IPath>();
        allTestClasses.add(mavenProjectFacade.getProjectRelativePath(build.getTestOutputDirectory()));
        this.addFolders(runtimeClasspath, mavenProjectFacade.getProject(), allTestClasses, classpathProperty);
    }

    protected void addMainFolder(Set<IRuntimeClasspathEntry> runtimeClasspath, IMavenProjectFacade mavenProjectFacade, IProgressMonitor monitor, int classpathProperty) throws CoreException {
        Build build = mavenProjectFacade.getMavenProject(monitor).getBuild();
        LinkedHashSet<IPath> allClasses = new LinkedHashSet<IPath>();
        allClasses.add(mavenProjectFacade.getProjectRelativePath(build.getOutputDirectory()));
        this.addFolders(runtimeClasspath, mavenProjectFacade.getProject(), allClasses, classpathProperty);
    }

    protected void addFolders(Set<IRuntimeClasspathEntry> runtimeClasspath, IProject project, Set<IPath> folders, int classpathProperty) {
        for (IPath folder : folders) {
            IResource member = project.findMember(folder);
            if (!(member instanceof IFolder var8_8)) continue;
            runtimeClasspath.add(ModuleSupport.createRuntimeClasspathEntry((IFolder)folderMember, classpathProperty, project));
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.id = config.getAttribute(ATTR_ID);
        this.name = config.getAttribute(ATTR_NAME);
    }

    public String toString() {
        return this.getName();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }
}

