/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.buildship.core.BuildConfiguration;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.SynchronizationResult;
import org.eclipse.buildship.core.WrapperGradleDistribution;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.DefaultGradleBuild;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ls.core.internal.AbstractProjectImporter;
import org.eclipse.jdt.ls.core.internal.EventNotification;
import org.eclipse.jdt.ls.core.internal.EventType;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.BasicFileDetector;
import org.eclipse.jdt.ls.core.internal.managers.GradleBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.GradleUtils;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jdt.ls.internal.gradle.checksums.ValidationResult;
import org.eclipse.jdt.ls.internal.gradle.checksums.WrapperValidator;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.build.GradleEnvironment;

public class GradleProjectImporter
extends AbstractProjectImporter {
    public static final String GRADLE_HOME = "GRADLE_HOME";
    public static final String GRADLE_USER_HOME = "GRADLE_USER_HOME";
    public static final String BUILD_GRADLE_DESCRIPTOR = "build.gradle";
    public static final String BUILD_GRADLE_KTS_DESCRIPTOR = "build.gradle.kts";
    public static final String SETTINGS_GRADLE_DESCRIPTOR = "settings.gradle";
    public static final String SETTINGS_GRADLE_KTS_DESCRIPTOR = "settings.gradle.kts";
    public static final String GRADLE_WRAPPER_PROPERTIES_DESCRIPTOR = "gradle/wrapper/gradle-wrapper.properties";
    public static final GradleDistribution DEFAULT_DISTRIBUTION = GradleDistribution.forVersion((String)GradleVersion.current().getVersion());
    public static final String IMPORTING_GRADLE_PROJECTS = "Importing Gradle project(s)";
    public static final String COMPATIBILITY_MARKER_ID = "org.eclipse.jdt.ls.core.gradlecompatibilityerrormarker";
    public static final String GRADLE_UPGRADE_WRAPPER_MARKER_ID = "org.eclipse.jdt.ls.core.gradleupgradewrappermarker";
    public static final String GRADLE_INVALID_TYPE_CODE_MESSAGE = "Exact exceptions are not shown due to an outdated Gradle version, please consider to update your Gradle version to " + GradleUtils.INVALID_TYPE_FIXED_VERSION + " and above.";
    public static final String GRADLE_MARKER_COLUMN_START = "gradleColumnStart";
    public static final String GRADLE_MARKER_COLUMN_END = "gradleColumnEnd";
    private static final int GRADLE_RELATED = 524288;
    private static final int INVALID_TYPE_CODE_ID = 524289;
    public static final String GRADLE_WRAPPER_CHEKSUM_WARNING_TEMPLATE = "Security Warning! The gradle wrapper '@wrapper@' could be malicious. If you trust it, please add \n`{\"sha256\": \"@checksum@\",\n\"allowed\": true}`\n to the `java.imports.gradle.wrapper.checksums` preference." + "".replaceAll("\n", System.lineSeparator());

    @Override
    public boolean applies(IProgressMonitor monitor) throws CoreException {
        if (this.rootFolder == null) {
            return false;
        }
        Preferences preferences = GradleProjectImporter.getPreferences();
        if (!preferences.isImportGradleEnabled()) {
            return false;
        }
        if (this.directories == null) {
            BasicFileDetector gradleDetector = new BasicFileDetector(this.rootFolder.toPath(), BUILD_GRADLE_DESCRIPTOR, SETTINGS_GRADLE_DESCRIPTOR, BUILD_GRADLE_KTS_DESCRIPTOR, SETTINGS_GRADLE_KTS_DESCRIPTOR).includeNested(false).addExclusions("**/build").addExclusions("**/bin");
            IProject[] iProjectArray = ProjectUtils.getAllProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (!ProjectUtils.isGradleProject(project)) {
                    String path = project.getLocation().toOSString();
                    gradleDetector.addExclusions(path);
                }
                ++n2;
            }
            this.directories = gradleDetector.scan(monitor);
        }
        return !this.directories.isEmpty();
    }

    @Override
    public boolean applies(Collection<IPath> buildFiles, IProgressMonitor monitor) {
        if (!GradleProjectImporter.getPreferences().isImportGradleEnabled()) {
            return false;
        }
        Collection<Path> configurationDirs = this.findProjectPathByConfigurationName(buildFiles, Arrays.asList(BUILD_GRADLE_DESCRIPTOR, SETTINGS_GRADLE_DESCRIPTOR, BUILD_GRADLE_KTS_DESCRIPTOR, SETTINGS_GRADLE_KTS_DESCRIPTOR), false);
        if (configurationDirs == null || configurationDirs.isEmpty()) {
            return false;
        }
        HashSet<Path> noneGradleProjectPaths = new HashSet<Path>();
        IProject[] iProjectArray = ProjectUtils.getAllProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!ProjectUtils.isGradleProject(project)) {
                noneGradleProjectPaths.add(project.getLocation().toFile().toPath());
            }
            ++n2;
        }
        this.directories = configurationDirs.stream().filter(d -> {
            boolean folderIsImported = noneGradleProjectPaths.stream().anyMatch(path2 -> path2.compareTo((Path)d) == 0);
            return !folderIsImported;
        }).collect(Collectors.toList());
        return !this.directories.isEmpty();
    }

    @Override
    public void importToWorkspace(IProgressMonitor monitor) throws CoreException {
        Status gradleStatus;
        Iterator<Object> status;
        if (!this.applies(monitor)) {
            return;
        }
        int projectSize = this.directories.size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(projectSize + 1));
        subMonitor.setTaskName(IMPORTING_GRADLE_PROJECTS);
        JavaLanguageServerPlugin.logInfo(IMPORTING_GRADLE_PROJECTS);
        subMonitor.worked(1);
        MultiStatus compatibilityStatus = new MultiStatus("org.eclipse.jdt.ls.core", -1, "Compatibility issue occurs when importing Gradle projects", null);
        MultiStatus gradleUpgradeWrapperStatus = new MultiStatus("org.eclipse.jdt.ls.core", -1, "Gradle upgrade wrapper", null);
        for (Path directory : this.directories) {
            IStatus importStatus = this.importDir(directory, (IProgressMonitor)subMonitor.newChild(1));
            if (GradleProjectImporter.isFailedStatus(importStatus) && importStatus instanceof GradleCompatibilityStatus) {
                compatibilityStatus.add(importStatus);
                continue;
            }
            if (!GradleUtils.hasGradleInvalidTypeCodeException(importStatus, directory, monitor)) continue;
            gradleUpgradeWrapperStatus.add((IStatus)new GradleUpgradeWrapperStatus(importStatus, GRADLE_INVALID_TYPE_CODE_MESSAGE, directory.toUri().toString()));
        }
        ProjectUtils.getGradleProjects().forEach(project -> {
            File buildFile = project.getFile(BUILD_GRADLE_DESCRIPTOR).getLocation().toFile();
            File settingsFile = project.getFile(SETTINGS_GRADLE_DESCRIPTOR).getLocation().toFile();
            File buildKtsFile = project.getFile(BUILD_GRADLE_KTS_DESCRIPTOR).getLocation().toFile();
            File settingsKtsFile = project.getFile(SETTINGS_GRADLE_KTS_DESCRIPTOR).getLocation().toFile();
            try {
                if (buildFile.exists()) {
                    JavaLanguageServerPlugin.getDigestStore().updateDigest(buildFile.toPath());
                } else if (buildKtsFile.exists()) {
                    JavaLanguageServerPlugin.getDigestStore().updateDigest(buildKtsFile.toPath());
                }
                if (settingsFile.exists()) {
                    JavaLanguageServerPlugin.getDigestStore().updateDigest(settingsFile.toPath());
                } else if (settingsKtsFile.exists()) {
                    JavaLanguageServerPlugin.getDigestStore().updateDigest(settingsKtsFile.toPath());
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Failed to update digest for gradle build file", e);
            }
        });
        for (IProject gradleProject : ProjectUtils.getGradleProjects()) {
            gradleProject.deleteMarkers(COMPATIBILITY_MARKER_ID, true, 0);
            gradleProject.deleteMarkers(GRADLE_UPGRADE_WRAPPER_MARKER_ID, true, 2);
        }
        Iterator<Object> iterator = compatibilityStatus.getChildren();
        if (((IStatus[])iterator).length != 0) {
            status = iterator[0];
            gradleStatus = (GradleCompatibilityStatus)((Object)status);
            for (IProject gradleProject : ProjectUtils.getGradleProjects()) {
                if (!URIUtil.sameURI((URI)URI.create(JDTUtils.getFileURI((IResource)gradleProject)), (URI)URI.create(gradleStatus.getProjectUri()))) continue;
                ResourceUtils.createErrorMarker((IResource)gradleProject, (IStatus)gradleStatus, COMPATIBILITY_MARKER_ID);
            }
            if (JavaLanguageServerPlugin.getProjectsManager() != null && JavaLanguageServerPlugin.getProjectsManager().getConnection() != null) {
                GradleCompatibilityInfo info = new GradleCompatibilityInfo(gradleStatus.getProjectUri(), gradleStatus.getMessage(), gradleStatus.getHighestJavaVersion(), GradleVersion.current().getVersion());
                EventNotification notification = new EventNotification().withType(EventType.IncompatibleGradleJdkIssue).withData(info);
                JavaLanguageServerPlugin.getProjectsManager().getConnection().sendEventNotification(notification);
            }
        }
        if (((IStatus[])(iterator = gradleUpgradeWrapperStatus.getChildren())).length != 0) {
            status = iterator[0];
            gradleStatus = (GradleUpgradeWrapperStatus)((Object)status);
            block10: for (IProject gradleProject : ProjectUtils.getGradleProjects()) {
                IFile wrapperProperties;
                if (!URIUtil.sameURI((URI)URI.create(JDTUtils.getFileURI((IResource)gradleProject)), (URI)URI.create(gradleStatus.getProjectUri())) || !(wrapperProperties = gradleProject.getFile(GRADLE_WRAPPER_PROPERTIES_DESCRIPTOR)).exists()) continue;
                try {
                    Throwable throwable = null;
                    Object var13_15 = null;
                    try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(wrapperProperties.getContents()));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (!line.contains("distributionUrl")) continue;
                            IMarker marker = ResourceUtils.createWarningMarker(GRADLE_UPGRADE_WRAPPER_MARKER_ID, (IResource)wrapperProperties, GRADLE_INVALID_TYPE_CODE_MESSAGE, 524289, reader.getLineNumber());
                            marker.setAttribute(GRADLE_MARKER_COLUMN_START, 0);
                            marker.setAttribute(GRADLE_MARKER_COLUMN_END, line.length());
                            UpgradeGradleWrapperInfo info = new UpgradeGradleWrapperInfo(gradleStatus.getProjectUri(), GRADLE_INVALID_TYPE_CODE_MESSAGE, GradleVersion.current().getVersion());
                            EventNotification notification = new EventNotification().withType(EventType.UpgradeGradleWrapper).withData(info);
                            JavaLanguageServerPlugin.getProjectsManager().getConnection().sendEventNotification(notification);
                            continue block10;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        GradleUtils.synchronizeAnnotationProcessingConfiguration((IProgressMonitor)subMonitor);
        subMonitor.done();
    }

    private IStatus importDir(Path projectFolder, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return this.startSynchronization(projectFolder, monitor);
    }

    public static GradleDistribution getGradleDistribution(Path rootFolder) {
        File gradleHomeFile;
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        Preferences preferences = GradleProjectImporter.getPreferences();
        if (preferencesManager != null && preferences.isGradleWrapperEnabled() && Files.exists(rootFolder.resolve("gradlew"), new LinkOption[0])) {
            WrapperValidator validator = new WrapperValidator();
            try {
                ProjectsManager pm;
                ValidationResult result = validator.checkWrapper(rootFolder.toFile().getAbsolutePath());
                if (result.isValid()) {
                    WrapperGradleDistribution gradleDistribution = GradleDistribution.fromBuild();
                    return gradleDistribution;
                }
                if (!WrapperValidator.contains(result.getChecksum()) && (pm = JavaLanguageServerPlugin.getProjectsManager()) != null && pm.getConnection() != null) {
                    if (preferencesManager.getClientPreferences().isGradleChecksumWrapperPromptSupport()) {
                        String id = "gradle/checksum/prompt";
                        ExecuteCommandParams params = new ExecuteCommandParams(id, Arrays.asList(result.getWrapperJar(), result.getChecksum()));
                        pm.getConnection().sendNotification(params);
                    } else {
                        String message = GRADLE_WRAPPER_CHEKSUM_WARNING_TEMPLATE.replaceAll("@wrapper@", result.getWrapperJar()).replaceAll("@checksum@", result.getChecksum());
                        pm.getConnection().showMessage(new MessageParams(MessageType.Error, message));
                    }
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)preferences.getGradleVersion())) {
            List versions = CorePlugin.publishedGradleVersions().getVersions();
            GradleVersion gradleVersion = null;
            String versionString = preferences.getGradleVersion();
            GradleVersion requiredVersion = GradleVersion.version((String)versionString);
            for (GradleVersion version : versions) {
                if (version.compareTo(requiredVersion) != 0) continue;
                gradleVersion = version;
            }
            if (gradleVersion != null) {
                return GradleDistribution.forVersion((String)gradleVersion.getVersion());
            }
            JavaLanguageServerPlugin.logInfo("Invalid gradle version" + versionString);
        }
        if ((gradleHomeFile = GradleProjectImporter.getGradleHomeFile()) != null) {
            return GradleDistribution.forLocalInstallation((File)gradleHomeFile);
        }
        return DEFAULT_DISTRIBUTION;
    }

    public static File getGradleHomeFile() {
        Map<String, String> env = System.getenv();
        Properties sysprops = System.getProperties();
        return GradleProjectImporter.getGradleHomeFile(env, sysprops);
    }

    public static File getGradleHomeFile(Map<String, String> env, Properties sysprops) {
        File gradleHomeFile;
        Preferences preferences = GradleProjectImporter.getPreferences();
        if (StringUtils.isNotBlank((CharSequence)preferences.getGradleHome())) {
            return new File(preferences.getGradleHome());
        }
        String gradleHome = env.get(GRADLE_HOME);
        if (gradleHome == null || !new File(gradleHome).isDirectory()) {
            gradleHome = sysprops.getProperty(GRADLE_HOME);
        }
        if (gradleHome != null && (gradleHomeFile = new File(gradleHome)).isDirectory()) {
            return gradleHomeFile;
        }
        return null;
    }

    public static File getGradleUserHomeFile() {
        Preferences preferences = GradleProjectImporter.getPreferences();
        if (StringUtils.isNotBlank((CharSequence)preferences.getGradleUserHome())) {
            return new File(preferences.getGradleUserHome());
        }
        String gradleUserHome = System.getenv().get(GRADLE_USER_HOME);
        if (gradleUserHome == null) {
            gradleUserHome = System.getProperties().getProperty(GRADLE_USER_HOME);
        }
        return gradleUserHome == null || gradleUserHome.isEmpty() ? null : new File(gradleUserHome);
    }

    public static File getGradleJavaHomeFile() {
        File file;
        Preferences preferences = GradleProjectImporter.getPreferences();
        if (StringUtils.isNotBlank((CharSequence)preferences.getGradleJavaHome()) && (file = new File(preferences.getGradleJavaHome())).isDirectory()) {
            return file;
        }
        return null;
    }

    protected IStatus startSynchronization(Path projectFolder, IProgressMonitor monitor) {
        File location = projectFolder.toFile();
        boolean shouldSynchronize = GradleProjectImporter.shouldSynchronize(location);
        if (shouldSynchronize) {
            BuildConfiguration build = GradleProjectImporter.getBuildConfiguration(projectFolder);
            GradleBuild gradleBuild = GradleCore.getWorkspace().createBuild(build);
            SynchronizationResult result = gradleBuild.synchronize(monitor);
            IStatus resultStatus = result.getStatus();
            if (GradleProjectImporter.isFailedStatus(resultStatus)) {
                try {
                    String javaVersion;
                    BuildEnvironment environment = (BuildEnvironment)gradleBuild.withConnection(connection -> (BuildEnvironment)connection.getModel(BuildEnvironment.class), monitor);
                    GradleEnvironment gradleEnvironment = environment.getGradle();
                    String gradleVersion = gradleEnvironment.getGradleVersion();
                    File javaHome = GradleProjectImporter.getJavaHome(GradleProjectImporter.getPreferences());
                    if (javaHome == null) {
                        javaVersion = System.getProperty("java.version");
                    } else {
                        StandardVMType type = new StandardVMType();
                        javaVersion = type.readReleaseVersion(javaHome);
                    }
                    if (GradleUtils.isIncompatible(GradleVersion.version((String)gradleVersion), javaVersion)) {
                        Path projectName = projectFolder.getName(projectFolder.getNameCount() - 1);
                        String message = String.format("Can't use Java %s and Gradle %s to import Gradle project %s.", javaVersion, gradleVersion, projectName.toString());
                        String highestJavaVersion = GradleUtils.getHighestSupportedJava(GradleVersion.version((String)gradleVersion));
                        return new GradleCompatibilityStatus(resultStatus, message, projectFolder.toUri().toString(), highestJavaVersion);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return resultStatus;
        }
        return Status.OK_STATUS;
    }

    public static BuildConfiguration getBuildConfiguration(Path rootFolder) {
        GradleDistribution distribution = GradleProjectImporter.getGradleDistribution(rootFolder);
        Preferences preferences = GradleProjectImporter.getPreferences();
        File javaHome = GradleProjectImporter.getJavaHome(preferences);
        File gradleUserHome = GradleProjectImporter.getGradleUserHomeFile();
        ArrayList<String> gradleArguments = new ArrayList<String>();
        gradleArguments.addAll(GradleProjectImporter.getGradleInitScriptArgs());
        gradleArguments.addAll(preferences.getGradleArguments());
        List<String> gradleJvmArguments = preferences.getGradleJvmArguments();
        boolean offlineMode = preferences.isImportGradleOfflineEnabled();
        boolean autoSync = preferences.getUpdateBuildConfigurationStatus().equals((Object)Preferences.FeatureStatus.automatic);
        boolean overrideWorkspaceConfiguration = !(distribution instanceof WrapperGradleDistribution) || offlineMode || gradleArguments != null && !gradleArguments.isEmpty() || gradleJvmArguments != null && !gradleJvmArguments.isEmpty() || gradleUserHome != null || javaHome != null || autoSync;
        BuildConfiguration build = BuildConfiguration.forRootProjectDirectory((File)rootFolder.toFile()).overrideWorkspaceConfiguration(overrideWorkspaceConfiguration).gradleDistribution(distribution).javaHome(javaHome).arguments(gradleArguments).gradleUserHome(gradleUserHome).jvmArguments(gradleJvmArguments).offlineMode(offlineMode).autoSync(autoSync).build();
        return build;
    }

    static boolean useDefaultVM() {
        File javaHome = GradleProjectImporter.getGradleJavaHomeFile();
        if (javaHome == null) {
            IVMInstall javaDefaultRuntime = JavaRuntime.getDefaultVMInstall();
            return javaDefaultRuntime != null && javaDefaultRuntime.getVMRunner("run") != null;
        }
        return false;
    }

    private static File getJavaHome(Preferences preferences) {
        File javaHome = GradleProjectImporter.getGradleJavaHomeFile();
        if (javaHome == null) {
            String javaHomeStr;
            IVMInstall javaDefaultRuntime = JavaRuntime.getDefaultVMInstall();
            javaHome = javaDefaultRuntime != null && javaDefaultRuntime.getVMRunner("run") != null ? javaDefaultRuntime.getInstallLocation() : ((javaHomeStr = preferences.getJavaHome()) == null ? null : new File(javaHomeStr));
        }
        return javaHome;
    }

    public static boolean shouldSynchronize(File location) {
        for (IProject project : ProjectUtils.getGradleProjects()) {
            File projectDir;
            File file = projectDir = project.getLocation() == null ? null : project.getLocation().toFile();
            if (!location.equals(projectDir)) continue;
            boolean shouldSynchronize = GradleProjectImporter.checkGradlePersistence(project, projectDir);
            if (shouldSynchronize) {
                JavaLanguageServerPlugin.logInfo(String.valueOf(project.getName()) + " was modified since last time the workspace was opened, must be synchronized");
            }
            return shouldSynchronize;
        }
        JavaLanguageServerPlugin.logInfo("No previous Gradle project at " + location + ", it must be synchronized");
        return true;
    }

    private static boolean checkGradlePersistence(IProject project, File projectDir) {
        File persistentFile;
        if (ProjectUtils.isJavaProject(project) && !project.getFile(".classpath").exists()) {
            return true;
        }
        boolean shouldSynchronize = true;
        PersistentModel model = CorePlugin.modelPersistence().loadModel(project);
        if (model.isPresent() && (persistentFile = CorePlugin.getInstance().getStateLocation().append("project-preferences").append(project.getName()).toFile()).exists()) {
            final long modified = persistentFile.lastModified();
            if (projectDir.exists()) {
                File[] files = projectDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        if (name != null && GradleBuildSupport.GRADLE_FILE_EXT.matcher(name).matches()) {
                            return new File(dir, name).lastModified() > modified;
                        }
                        return false;
                    }
                });
                shouldSynchronize = files != null && files.length > 0;
            }
        }
        return shouldSynchronize;
    }

    public static String upgradeGradleVersion(String projectUri, String gradleVersion, IProgressMonitor monitor) {
        Properties properties;
        File propertiesFile;
        GradleBuild gradleBuild;
        Path projectFolder;
        block19: {
            String newDistributionUrl = String.format("https://services.gradle.org/distributions/gradle-%s-bin.zip", gradleVersion);
            projectFolder = Paths.get(URI.create(projectUri));
            IProject project = ProjectUtils.getProjectFromUri(projectUri);
            Optional build = GradleCore.getWorkspace().getBuild(project);
            gradleBuild = null;
            if (!build.isEmpty() && (gradleBuild = (GradleBuild)build.get()) instanceof DefaultGradleBuild) {
                projectFolder = ((DefaultGradleBuild)gradleBuild).getBuildConfig().getRootProjectDirectory().toPath();
            }
            propertiesFile = projectFolder.resolve("gradle").resolve("wrapper").resolve("gradle-wrapper.properties").toFile();
            properties = new Properties();
            if (propertiesFile.exists()) {
                try {
                    Throwable throwable = null;
                    Object var11_15 = null;
                    try (FileInputStream stream = new FileInputStream(propertiesFile);){
                        properties.load(stream);
                        properties.setProperty("distributionUrl", newDistributionUrl);
                        break block19;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    return null;
                }
            }
            properties.setProperty("distributionBase", GRADLE_USER_HOME);
            properties.setProperty("distributionPath", "wrapper/dists");
            properties.setProperty("distributionUrl", newDistributionUrl);
            properties.setProperty("zipStoreBase", GRADLE_USER_HOME);
            properties.setProperty("zipStorePath", "wrapper/dists");
        }
        if (monitor.isCanceled()) {
            return null;
        }
        try {
            properties.store(new FileOutputStream(propertiesFile), null);
        }
        catch (Exception e) {
            return null;
        }
        try {
            if (gradleBuild == null) {
                gradleBuild = GradleCore.getWorkspace().createBuild(GradleProjectImporter.getBuildConfiguration(projectFolder));
            }
            gradleBuild.withConnection(connection -> {
                connection.newBuild().forTasks(new String[]{"wrapper"}).run();
                return null;
            }, monitor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return propertiesFile.getAbsolutePath();
    }

    private static List<String> getGradleInitScriptArgs() {
        LinkedList<String> args = new LinkedList<String>();
        File initScript = GradleUtils.getGradleInitScript("/gradle/init/init.gradle");
        GradleProjectImporter.addInitScriptToArgs(initScript, args);
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferencesManager == null) {
            return args;
        }
        if (preferencesManager.getPreferences().isProtobufSupportEnabled()) {
            File protobufInitScript = GradleUtils.getGradleInitScript("/gradle/protobuf/init.gradle");
            GradleProjectImporter.addInitScriptToArgs(protobufInitScript, args);
        }
        if (preferencesManager.getPreferences().isAndroidSupportEnabled()) {
            File androidInitScript = GradleUtils.getGradleInitScript("/gradle/android/init.gradle");
            GradleProjectImporter.addInitScriptToArgs(androidInitScript, args);
        }
        return args;
    }

    private static void addInitScriptToArgs(File initScript, List<String> args) {
        if (initScript != null && initScript.exists() && initScript.length() > 0L) {
            args.add("--init-script");
            args.add(initScript.getAbsolutePath());
        }
    }

    @Override
    public void reset() {
    }

    public static boolean isFailedStatus(IStatus status) {
        return status != null && !status.isOK() && status.getException() != null;
    }

    private class GradleCompatibilityInfo {
        private String projectUri;
        private String message;
        private String highestJavaVersion;
        private String recommendedGradleVersion;

        public GradleCompatibilityInfo(String projectPath, String message, String highestJavaVersion, String recommendedGradleVersion) {
            this.projectUri = projectPath;
            this.message = message;
            this.highestJavaVersion = highestJavaVersion;
            this.recommendedGradleVersion = recommendedGradleVersion;
        }
    }

    public class GradleCompatibilityStatus
    extends Status {
        private String projectUri;
        private String highestJavaVersion;

        public GradleCompatibilityStatus(IStatus status, String message, String projectUri, String highestJavaVersion) {
            super(status.getSeverity(), status.getPlugin(), status.getCode(), message, status.getException());
            this.projectUri = projectUri;
            this.highestJavaVersion = highestJavaVersion;
        }

        public String getProjectUri() {
            return this.projectUri;
        }

        public String getHighestJavaVersion() {
            return this.highestJavaVersion;
        }
    }

    public class GradleUpgradeWrapperStatus
    extends Status {
        private String projectUri;

        public GradleUpgradeWrapperStatus(IStatus status, String message, String projectUri) {
            super(status.getSeverity(), status.getPlugin(), status.getCode(), message, status.getException());
            this.projectUri = projectUri;
        }

        public String getProjectUri() {
            return this.projectUri;
        }
    }

    private class UpgradeGradleWrapperInfo {
        private String projectUri;
        private String message;
        private String recommendedGradleVersion;

        public UpgradeGradleWrapperInfo(String projectUri, String message, String recommendedGradleVersion) {
            this.projectUri = projectUri;
            this.message = message;
            this.recommendedGradleVersion = recommendedGradleVersion;
        }
    }
}

